/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service;

import com.axelor.apps.account.service.config.AccountConfigService;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.PriceList;
import com.axelor.apps.base.db.TradingName;
import com.axelor.apps.base.service.PartnerService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.repo.SaleOrderRepository;
import com.axelor.apps.sale.service.app.AppSaleService;
import com.axelor.apps.sale.service.saleorder.SaleOrderComputeService;
import com.axelor.apps.sale.service.saleorder.SaleOrderCreateServiceImpl;
import com.axelor.apps.sale.service.saleorder.SaleOrderService;
import com.axelor.apps.stock.db.StockLocation;
import com.axelor.apps.stock.service.StockLocationService;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import com.axelor.team.db.Team;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.time.LocalDate;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaleOrderCreateServiceSupplychainImpl
extends SaleOrderCreateServiceImpl {
    private final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected AccountConfigService accountConfigService;
    protected SaleOrderRepository saleOrderRepository;
    protected AppBaseService appBaseService;

    @Inject
    public SaleOrderCreateServiceSupplychainImpl(PartnerService partnerService, SaleOrderRepository saleOrderRepo, AppSaleService appSaleService, AppBaseService appBaseService, SaleOrderService saleOrderService, SaleOrderComputeService saleOrderComputeService, AccountConfigService accountConfigService, SaleOrderRepository saleOrderRepository) {
        super(partnerService, saleOrderRepo, appSaleService, saleOrderService, saleOrderComputeService);
        this.accountConfigService = accountConfigService;
        this.saleOrderRepository = saleOrderRepository;
        this.appBaseService = appBaseService;
    }

    public SaleOrder createSaleOrder(User salespersonUser, Company company, Partner contactPartner, Currency currency, LocalDate deliveryDate, String internalReference, String externalReference, PriceList priceList, Partner clientPartner, Team team, TradingName tradingName) throws AxelorException {
        if (!((AppSaleService)Beans.get(AppSaleService.class)).isApp("supplychain")) {
            return super.createSaleOrder(salespersonUser, company, contactPartner, currency, deliveryDate, internalReference, externalReference, priceList, clientPartner, team, tradingName);
        }
        return this.createSaleOrder(salespersonUser, company, contactPartner, currency, deliveryDate, internalReference, externalReference, null, priceList, clientPartner, team, tradingName);
    }

    public SaleOrder createSaleOrder(User salespersonUser, Company company, Partner contactPartner, Currency currency, LocalDate deliveryDate, String internalReference, String externalReference, StockLocation stockLocation, PriceList priceList, Partner clientPartner, Team team, TradingName tradingName) throws AxelorException {
        this.logger.debug("Cr\u00e9ation d'une commande fournisseur : Soci\u00e9t\u00e9 = {},  Reference externe = {}, Client = {}", new Object[]{company.getName(), externalReference, clientPartner.getFullName()});
        SaleOrder saleOrder = super.createSaleOrder(salespersonUser, company, contactPartner, currency, deliveryDate, internalReference, externalReference, priceList, clientPartner, team, tradingName);
        if (stockLocation == null) {
            stockLocation = ((StockLocationService)Beans.get(StockLocationService.class)).getPickupDefaultStockLocation(company);
        }
        saleOrder.setStockLocation(stockLocation);
        saleOrder.setPaymentMode(clientPartner.getInPaymentMode());
        saleOrder.setPaymentCondition(clientPartner.getPaymentCondition());
        if (saleOrder.getPaymentMode() == null) {
            saleOrder.setPaymentMode(this.accountConfigService.getAccountConfig(company).getInPaymentMode());
        }
        if (saleOrder.getPaymentCondition() == null) {
            saleOrder.setPaymentCondition(this.accountConfigService.getAccountConfig(company).getDefPaymentCondition());
        }
        saleOrder.setShipmentMode(clientPartner.getShipmentMode());
        saleOrder.setFreightCarrierMode(clientPartner.getFreightCarrierMode());
        return saleOrder;
    }

    @Transactional(rollbackOn={Exception.class})
    public SaleOrder mergeSaleOrders(List<SaleOrder> saleOrderList, Currency currency, Partner clientPartner, Company company, StockLocation stockLocation, Partner contactPartner, PriceList priceList, Team team) throws AxelorException {
        String numSeq = "";
        String externalRef = "";
        for (SaleOrder saleOrderLocal : saleOrderList) {
            if (!numSeq.isEmpty()) {
                numSeq = numSeq + "-";
            }
            numSeq = numSeq + saleOrderLocal.getSaleOrderSeq();
            if (!externalRef.isEmpty()) {
                externalRef = externalRef + "|";
            }
            if (saleOrderLocal.getExternalReference() == null) continue;
            externalRef = externalRef + saleOrderLocal.getExternalReference();
        }
        SaleOrder saleOrderMerged = this.createSaleOrder(AuthUtils.getUser(), company, contactPartner, currency, null, numSeq, externalRef, stockLocation, priceList, clientPartner, team, null);
        super.attachToNewSaleOrder(saleOrderList, saleOrderMerged);
        this.saleOrderComputeService.computeSaleOrder(saleOrderMerged);
        this.saleOrderRepository.save((Model)((Object)saleOrderMerged));
        super.removeOldSaleOrders(saleOrderList);
        return saleOrderMerged;
    }
}

