/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service;

import com.axelor.apps.account.db.Account;
import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoiceLine;
import com.axelor.apps.account.db.PaymentCondition;
import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.account.db.TaxLine;
import com.axelor.apps.account.db.repo.InvoiceRepository;
import com.axelor.apps.account.service.FiscalPositionAccountService;
import com.axelor.apps.account.service.app.AppAccountService;
import com.axelor.apps.account.service.config.AccountConfigService;
import com.axelor.apps.account.service.invoice.InvoiceService;
import com.axelor.apps.account.service.invoice.generator.InvoiceGenerator;
import com.axelor.apps.account.service.invoice.generator.InvoiceLineGenerator;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.PriceList;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.apps.sale.db.SaleOrderLineTax;
import com.axelor.apps.sale.db.repo.SaleOrderRepository;
import com.axelor.apps.sale.service.saleorder.SaleOrderComputeService;
import com.axelor.apps.sale.service.saleorder.SaleOrderLineService;
import com.axelor.apps.sale.service.saleorder.SaleOrderWorkflowServiceImpl;
import com.axelor.apps.stock.db.repo.StockMoveRepository;
import com.axelor.apps.supplychain.db.Timetable;
import com.axelor.apps.supplychain.db.repo.TimetableRepository;
import com.axelor.apps.supplychain.service.SaleOrderInvoiceService;
import com.axelor.apps.supplychain.service.app.AppSupplychainService;
import com.axelor.apps.supplychain.service.invoice.generator.InvoiceGeneratorSupplyChain;
import com.axelor.apps.supplychain.service.invoice.generator.InvoiceLineGeneratorSupplyChain;
import com.axelor.apps.tool.StringTool;
import com.axelor.common.ObjectUtils;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.db.Query;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.persistence.TypedQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaleOrderInvoiceServiceImpl
implements SaleOrderInvoiceService {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected AppBaseService appBaseService;
    protected AppSupplychainService appSupplychainService;
    protected SaleOrderRepository saleOrderRepo;
    protected InvoiceRepository invoiceRepo;
    protected InvoiceService invoiceService;
    protected SaleOrderLineService saleOrderLineService;
    protected StockMoveRepository stockMoveRepository;
    protected SaleOrderWorkflowServiceImpl saleOrderWorkflowServiceImpl;

    @Inject
    public SaleOrderInvoiceServiceImpl(AppBaseService appBaseService, AppSupplychainService appSupplychainService, SaleOrderRepository saleOrderRepo, InvoiceRepository invoiceRepo, InvoiceService invoiceService, SaleOrderLineService saleOrderLineService, StockMoveRepository stockMoveRepository, SaleOrderWorkflowServiceImpl saleOrderWorkflowServiceImpl) {
        this.appBaseService = appBaseService;
        this.appSupplychainService = appSupplychainService;
        this.saleOrderRepo = saleOrderRepo;
        this.invoiceRepo = invoiceRepo;
        this.invoiceService = invoiceService;
        this.stockMoveRepository = stockMoveRepository;
        this.saleOrderLineService = saleOrderLineService;
        this.saleOrderWorkflowServiceImpl = saleOrderWorkflowServiceImpl;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public Invoice generateInvoice(SaleOrder saleOrder, int operationSelect, BigDecimal amount, boolean isPercent, Map<Long, BigDecimal> qtyToInvoiceMap, List<Long> timetableIdList) throws AxelorException {
        Invoice invoice;
        switch (operationSelect) {
            case 1: {
                invoice = this.generateInvoice(saleOrder);
                break;
            }
            case 2: {
                invoice = this.generateInvoiceFromLines(saleOrder, qtyToInvoiceMap, isPercent);
                break;
            }
            case 3: {
                invoice = this.generateAdvancePayment(saleOrder, amount, isPercent);
                break;
            }
            case 4: {
                BigDecimal percentSum = BigDecimal.ZERO;
                TimetableRepository timetableRepo = (TimetableRepository)((Object)Beans.get(TimetableRepository.class));
                ArrayList<Timetable> timetableList = new ArrayList<Timetable>();
                if (timetableIdList == null || timetableIdList.isEmpty()) {
                    throw new AxelorException((Model)((Object)saleOrder), 5, I18n.get((String)"There are no selected timetables to invoice"));
                }
                for (Long timetableId : timetableIdList) {
                    Timetable timetable = (Timetable)((Object)timetableRepo.find(timetableId));
                    timetableList.add(timetable);
                    percentSum = percentSum.add(timetable.getPercentage());
                }
                invoice = this.generateInvoiceFromLines(saleOrder, this.generateQtyToInvoiceMap(saleOrder, percentSum), true);
                if (timetableList.isEmpty()) break;
                for (Timetable timetable : timetableList) {
                    timetable.setInvoice(invoice);
                    timetableRepo.save((Model)((Object)timetable));
                }
                break;
            }
            default: {
                return null;
            }
        }
        invoice.setSaleOrder(saleOrder);
        if (!Strings.isNullOrEmpty((String)saleOrder.getInvoiceComments())) {
            invoice.setNote(saleOrder.getInvoiceComments());
        }
        if (ObjectUtils.isEmpty((Object)invoice.getProformaComments()) && !Strings.isNullOrEmpty((String)saleOrder.getProformaComments())) {
            invoice.setProformaComments(saleOrder.getProformaComments());
        }
        if (invoice.getOperationSubTypeSelect() != 2) {
            invoice.setAdvancePaymentInvoiceSet(this.invoiceService.getDefaultAdvancePaymentInvoice(invoice));
        }
        invoice.setPartnerTaxNbr(saleOrder.getClientPartner().getTaxNbr());
        invoice = (Invoice)((Object)this.invoiceRepo.save((Model)((Object)invoice)));
        return invoice;
    }

    private Map<Long, BigDecimal> generateQtyToInvoiceMap(SaleOrder saleOrder, BigDecimal percentage) {
        HashMap<Long, BigDecimal> map = new HashMap<Long, BigDecimal>();
        for (SaleOrderLine soLine : saleOrder.getSaleOrderLineList()) {
            map.put(soLine.getId(), percentage);
        }
        return map;
    }

    @Override
    public BigDecimal computeAmountToInvoicePercent(SaleOrder saleOrder, BigDecimal amount, boolean isPercent) throws AxelorException {
        BigDecimal total = ((SaleOrderComputeService)Beans.get(SaleOrderComputeService.class)).getTotalSaleOrderPrice(saleOrder);
        if (total.compareTo(BigDecimal.ZERO) == 0) {
            if (amount.compareTo(BigDecimal.ZERO) == 0) {
                return BigDecimal.ZERO;
            }
            throw new AxelorException((Model)((Object)saleOrder), 5, I18n.get((String)"The amount to invoice is superior than the amount in the sale order"));
        }
        if (!isPercent) {
            amount = amount.multiply(new BigDecimal("100")).divide(total, 4, RoundingMode.HALF_EVEN);
        }
        if (amount.compareTo(new BigDecimal("100")) > 0) {
            throw new AxelorException((Model)((Object)saleOrder), 5, I18n.get((String)"The amount to invoice is superior than the amount in the sale order"));
        }
        return amount;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public Invoice generateAdvancePayment(SaleOrder saleOrder, BigDecimal amountToInvoice, boolean isPercent) throws AxelorException {
        List<SaleOrderLineTax> taxLineList = saleOrder.getSaleOrderLineTaxList();
        AccountConfigService accountConfigService = (AccountConfigService)Beans.get(AccountConfigService.class);
        BigDecimal percentToInvoice = this.computeAmountToInvoicePercent(saleOrder, amountToInvoice, isPercent);
        Product invoicingProduct = accountConfigService.getAccountConfig(saleOrder.getCompany()).getAdvancePaymentProduct();
        Account advancePaymentAccount = accountConfigService.getAccountConfig(saleOrder.getCompany()).getAdvancePaymentAccount();
        if (invoicingProduct == null) {
            throw new AxelorException((Model)((Object)saleOrder), 4, I18n.get((String)"Please configure the advance payment product"));
        }
        if (advancePaymentAccount == null) {
            throw new AxelorException((Model)((Object)saleOrder), 4, I18n.get((String)"You must configure an advance payment account for the company %s"), new Object[]{saleOrder.getCompany().getName()});
        }
        Invoice invoice = this.createInvoiceAndLines(saleOrder, taxLineList, invoicingProduct, percentToInvoice, 2, advancePaymentAccount);
        if (invoice.getInvoiceLineList() != null) {
            invoice.getInvoiceLineList().forEach(invoiceLine -> invoiceLine.setSaleOrderLine(null));
        }
        return (Invoice)((Object)this.invoiceRepo.save((Model)((Object)invoice)));
    }

    public Invoice createInvoiceAndLines(SaleOrder saleOrder, List<SaleOrderLineTax> taxLineList, Product invoicingProduct, BigDecimal percentToInvoice, int operationSubTypeSelect, Account partnerAccount) throws AxelorException {
        InvoiceGenerator invoiceGenerator = this.createInvoiceGenerator(saleOrder);
        Invoice invoice = invoiceGenerator.generate();
        List<InvoiceLine> invoiceLinesList = taxLineList != null && !taxLineList.isEmpty() ? this.createInvoiceLinesFromTax(invoice, taxLineList, invoicingProduct, percentToInvoice) : this.createInvoiceLinesFromSO(invoice, saleOrder, invoicingProduct, percentToInvoice);
        invoiceGenerator.populate(invoice, invoiceLinesList);
        invoice.setAddressStr(saleOrder.getMainInvoicingAddressStr());
        invoice.setOperationSubTypeSelect(operationSubTypeSelect);
        if (partnerAccount != null) {
            Partner partner = invoice.getPartner();
            if (partner != null) {
                partnerAccount = ((FiscalPositionAccountService)Beans.get(FiscalPositionAccountService.class)).getAccount(partner.getFiscalPosition(), partnerAccount);
            }
            invoice.setPartnerAccount(partnerAccount);
        }
        return invoice;
    }

    @Override
    public List<InvoiceLine> createInvoiceLinesFromTax(Invoice invoice, List<SaleOrderLineTax> taxLineList, Product invoicingProduct, BigDecimal percentToInvoice) throws AxelorException {
        ArrayList<InvoiceLine> createdInvoiceLineList = new ArrayList<InvoiceLine>();
        if (taxLineList != null) {
            for (SaleOrderLineTax saleOrderLineTax : taxLineList) {
                BigDecimal lineAmountToInvoice = percentToInvoice.multiply(saleOrderLineTax.getExTaxBase()).divide(new BigDecimal("100"), 4, 6);
                TaxLine taxLine = saleOrderLineTax.getTaxLine();
                BigDecimal lineAmountToInvoiceInclTax = taxLine != null ? lineAmountToInvoice.add(lineAmountToInvoice.multiply(taxLine.getValue())) : lineAmountToInvoice;
                InvoiceLineGenerator invoiceLineGenerator = new InvoiceLineGenerator(invoice, invoicingProduct, invoicingProduct.getName(), lineAmountToInvoice, lineAmountToInvoiceInclTax, invoice.getInAti() != false ? lineAmountToInvoiceInclTax : lineAmountToInvoice, invoicingProduct.getDescription(), BigDecimal.ONE, invoicingProduct.getUnit(), taxLine, 0, BigDecimal.ZERO, 0, lineAmountToInvoice, null, false){

                    public List<InvoiceLine> creates() throws AxelorException {
                        InvoiceLine invoiceLine = this.createInvoiceLine();
                        ArrayList<InvoiceLine> invoiceLines = new ArrayList<InvoiceLine>();
                        invoiceLines.add(invoiceLine);
                        return invoiceLines;
                    }
                };
                List invoiceOneLineList = invoiceLineGenerator.creates();
                for (InvoiceLine invoiceLine : invoiceOneLineList) {
                    SaleOrderLine saleOrderLine = saleOrderLineTax.getSaleOrder().getSaleOrderLineList().get(0);
                    invoiceLine.setSaleOrderLine(saleOrderLine);
                }
                createdInvoiceLineList.addAll(invoiceOneLineList);
            }
        }
        return createdInvoiceLineList;
    }

    protected List<InvoiceLine> createInvoiceLinesFromSO(Invoice invoice, SaleOrder saleOrder, Product invoicingProduct, BigDecimal percentToInvoice) throws AxelorException {
        ArrayList<InvoiceLine> invoiceLineList = new ArrayList<InvoiceLine>();
        BigDecimal lineAmountToInvoice = percentToInvoice.multiply(saleOrder.getInTaxTotal()).divide(new BigDecimal("100"), 4, 6);
        InvoiceLineGenerator invoiceLineGenerator = new InvoiceLineGenerator(invoice, invoicingProduct, invoicingProduct.getName(), lineAmountToInvoice, lineAmountToInvoice, lineAmountToInvoice, invoicingProduct.getDescription(), BigDecimal.ONE, invoicingProduct.getUnit(), null, 0, BigDecimal.ZERO, 0, lineAmountToInvoice, null, false){

            public List<InvoiceLine> creates() throws AxelorException {
                InvoiceLine invoiceLine = this.createInvoiceLine();
                ArrayList<InvoiceLine> invoiceLines = new ArrayList<InvoiceLine>();
                invoiceLines.add(invoiceLine);
                return invoiceLines;
            }
        };
        List invoiceOneLineList = invoiceLineGenerator.creates();
        invoiceLineList.addAll(invoiceOneLineList);
        return invoiceLineList;
    }

    @Override
    public Invoice generateInvoiceFromLines(SaleOrder saleOrder, Map<Long, BigDecimal> qtyToInvoiceMap, boolean isPercent) throws AxelorException {
        if (qtyToInvoiceMap.isEmpty()) {
            throw new AxelorException((Model)((Object)saleOrder), 5, I18n.get((String)"There are no lines to invoice"));
        }
        for (SaleOrderLine saleOrderLine : saleOrder.getSaleOrderLineList()) {
            Long SOrderId = saleOrderLine.getId();
            if (!qtyToInvoiceMap.containsKey(SOrderId)) continue;
            if (isPercent) {
                BigDecimal percent = qtyToInvoiceMap.get(SOrderId);
                BigDecimal realQty = saleOrderLine.getQty().multiply(percent).divide(new BigDecimal("100"), this.appBaseService.getNbDecimalDigitForQty(), RoundingMode.HALF_EVEN);
                qtyToInvoiceMap.put(SOrderId, realQty);
            }
            if (qtyToInvoiceMap.get(SOrderId).compareTo(saleOrderLine.getQty()) <= 0) continue;
            throw new AxelorException((Model)((Object)saleOrder), 5, I18n.get((String)"The quantity to invoice is greater than the quantity in the sale order"));
        }
        return this.generateInvoice(saleOrder, saleOrder.getSaleOrderLineList(), qtyToInvoiceMap);
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public Invoice generateInvoice(SaleOrder saleOrder) throws AxelorException {
        Invoice invoice = this.createInvoice(saleOrder);
        invoice.setDeliveryAddress(saleOrder.getDeliveryAddress());
        invoice.setDeliveryAddressStr(saleOrder.getDeliveryAddressStr());
        this.invoiceRepo.save((Model)((Object)invoice));
        this.saleOrderRepo.save((Model)((Object)this.fillSaleOrder(saleOrder, invoice)));
        return invoice;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public Invoice generateInvoice(SaleOrder saleOrder, List<SaleOrderLine> saleOrderLinesSelected) throws AxelorException {
        Invoice invoice = this.createInvoice(saleOrder, saleOrderLinesSelected);
        this.invoiceRepo.save((Model)((Object)invoice));
        this.saleOrderRepo.save((Model)((Object)this.fillSaleOrder(saleOrder, invoice)));
        return invoice;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public Invoice generateInvoice(SaleOrder saleOrder, List<SaleOrderLine> saleOrderLinesSelected, Map<Long, BigDecimal> qtyToInvoiceMap) throws AxelorException {
        Invoice invoice = this.createInvoice(saleOrder, saleOrderLinesSelected, qtyToInvoiceMap);
        invoice.setDeliveryAddress(saleOrder.getDeliveryAddress());
        invoice.setDeliveryAddressStr(saleOrder.getDeliveryAddressStr());
        this.invoiceRepo.save((Model)((Object)invoice));
        this.saleOrderRepo.save((Model)((Object)this.fillSaleOrder(saleOrder, invoice)));
        return invoice;
    }

    public BigDecimal computeInTaxTotalInvoiced(Invoice invoice) {
        BigDecimal total = BigDecimal.ZERO;
        if (invoice.getStatusSelect() == 3) {
            if (invoice.getOperationTypeSelect() == 3) {
                total = total.add(invoice.getInTaxTotal());
            }
            if (invoice.getOperationTypeSelect() == 4) {
                total = total.subtract(invoice.getInTaxTotal());
            }
        }
        if (invoice.getRefundInvoiceList() != null) {
            for (Invoice refund : invoice.getRefundInvoiceList()) {
                total = total.add(this.computeInTaxTotalInvoiced(refund));
            }
        }
        return total;
    }

    @Override
    public SaleOrder fillSaleOrder(SaleOrder saleOrder, Invoice invoice) {
        saleOrder.setOrderDate(this.appSupplychainService.getTodayDate(invoice.getCompany()));
        return saleOrder;
    }

    @Override
    public Invoice createInvoice(SaleOrder saleOrder) throws AxelorException {
        return this.createInvoice(saleOrder, saleOrder.getSaleOrderLineList());
    }

    @Override
    public Invoice createInvoice(SaleOrder saleOrder, List<SaleOrderLine> saleOrderLineList) throws AxelorException {
        HashMap<Long, BigDecimal> qtyToInvoiceMap = new HashMap<Long, BigDecimal>();
        for (SaleOrderLine saleOrderLine : saleOrderLineList) {
            qtyToInvoiceMap.put(saleOrderLine.getId(), saleOrderLine.getQty());
        }
        return this.createInvoice(saleOrder, saleOrderLineList, qtyToInvoiceMap);
    }

    @Override
    public Invoice createInvoice(SaleOrder saleOrder, List<SaleOrderLine> saleOrderLineList, Map<Long, BigDecimal> qtyToInvoiceMap) throws AxelorException {
        InvoiceGenerator invoiceGenerator = this.createInvoiceGenerator(saleOrder);
        Invoice invoice = invoiceGenerator.generate();
        invoiceGenerator.populate(invoice, this.createInvoiceLines(invoice, saleOrderLineList, qtyToInvoiceMap));
        invoice.setAddressStr(saleOrder.getMainInvoicingAddressStr());
        return invoice;
    }

    @Override
    public InvoiceGenerator createInvoiceGenerator(SaleOrder saleOrder) throws AxelorException {
        return this.createInvoiceGenerator(saleOrder, false);
    }

    @Override
    public InvoiceGenerator createInvoiceGenerator(SaleOrder saleOrder, boolean isRefund) throws AxelorException {
        if (saleOrder.getCurrency() == null) {
            throw new AxelorException((Model)((Object)saleOrder), 4, I18n.get((String)"Please, select a currency for the order %s"), new Object[]{saleOrder.getSaleOrderSeq()});
        }
        return new InvoiceGeneratorSupplyChain(saleOrder, isRefund){

            public Invoice generate() throws AxelorException {
                Invoice invoice = super.createInvoiceHeader();
                invoice.setHeadOfficeAddress(this.saleOrder.getClientPartner().getHeadOfficeAddress());
                return invoice;
            }
        };
    }

    @Override
    public List<InvoiceLine> createInvoiceLines(Invoice invoice, List<SaleOrderLine> saleOrderLineList, Map<Long, BigDecimal> qtyToInvoiceMap) throws AxelorException {
        ArrayList<InvoiceLine> invoiceLineList = new ArrayList<InvoiceLine>();
        for (SaleOrderLine saleOrderLine : saleOrderLineList) {
            if (!qtyToInvoiceMap.containsKey(saleOrderLine.getId())) continue;
            List<InvoiceLine> invoiceLines = this.createInvoiceLine(invoice, saleOrderLine, qtyToInvoiceMap.get(saleOrderLine.getId()));
            invoiceLineList.addAll(invoiceLines);
            saleOrderLine.setInvoiced(true);
        }
        return invoiceLineList;
    }

    @Override
    public List<InvoiceLine> createInvoiceLine(Invoice invoice, SaleOrderLine saleOrderLine, BigDecimal qtyToInvoice) throws AxelorException {
        Product product = saleOrderLine.getProduct();
        InvoiceLineGeneratorSupplyChain invoiceLineGenerator = new InvoiceLineGeneratorSupplyChain(invoice, product, saleOrderLine.getProductName(), saleOrderLine.getDescription(), qtyToInvoice, saleOrderLine.getUnit(), saleOrderLine.getSequence(), false, saleOrderLine, null, null){

            public List<InvoiceLine> creates() throws AxelorException {
                InvoiceLine invoiceLine = this.createInvoiceLine();
                ArrayList<InvoiceLine> invoiceLines = new ArrayList<InvoiceLine>();
                invoiceLines.add(invoiceLine);
                return invoiceLines;
            }
        };
        return invoiceLineGenerator.creates();
    }

    @Override
    public void update(SaleOrder saleOrder, Long currentInvoiceId, boolean excludeCurrentInvoice) throws AxelorException {
        this.update(saleOrder, currentInvoiceId, excludeCurrentInvoice, false);
    }

    protected void update(SaleOrder saleOrder, Long currentInvoiceId, boolean excludeCurrentInvoice, boolean checkInvoicedAmount) throws AxelorException {
        BigDecimal amountInvoiced = this.getInvoicedAmount(saleOrder, currentInvoiceId, excludeCurrentInvoice);
        if (checkInvoicedAmount && amountInvoiced.compareTo(saleOrder.getExTaxTotal()) > 0) {
            throw new AxelorException((Model)((Object)saleOrder), 5, I18n.get((String)"The sale order %s invoiced amount cannot be greater than its total amount."), new Object[]{saleOrder.getSaleOrderSeq()});
        }
        saleOrder.setAmountInvoiced(amountInvoiced);
        if (this.appSupplychainService.getAppSupplychain().getCompleteSaleOrderOnInvoicing().booleanValue() && amountInvoiced.compareTo(saleOrder.getExTaxTotal()) == 0) {
            this.saleOrderWorkflowServiceImpl.completeSaleOrder(saleOrder);
        }
    }

    @Override
    public BigDecimal getInvoicedAmount(SaleOrder saleOrder) {
        return this.getInvoicedAmount(saleOrder, null, true);
    }

    @Override
    public BigDecimal getInvoicedAmount(SaleOrder saleOrder, Long currentInvoiceId, boolean excludeCurrentInvoice) {
        BigDecimal invoicedAmount = BigDecimal.ZERO;
        BigDecimal saleAmount = this.getAmountVentilated(saleOrder, currentInvoiceId, excludeCurrentInvoice, 3);
        BigDecimal refundAmount = this.getAmountVentilated(saleOrder, currentInvoiceId, excludeCurrentInvoice, 4);
        if (saleAmount != null) {
            invoicedAmount = invoicedAmount.add(saleAmount);
        }
        if (refundAmount != null) {
            invoicedAmount = invoicedAmount.subtract(refundAmount);
        }
        if (!saleOrder.getCurrency().equals((Object)saleOrder.getCompany().getCurrency()) && saleOrder.getCompanyExTaxTotal().compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal rate = invoicedAmount.divide(saleOrder.getCompanyExTaxTotal(), 4, RoundingMode.HALF_UP);
            invoicedAmount = saleOrder.getExTaxTotal().multiply(rate);
        }
        this.log.debug("Compute the invoiced amount ({}) of the sale order : {}", (Object)invoicedAmount, (Object)saleOrder.getSaleOrderSeq());
        return invoicedAmount;
    }

    @Override
    public List<Invoice> getInvoices(SaleOrder saleOrder) {
        return this.invoiceRepo.all().filter("self.saleOrder.id = ? OR (self.saleOrder.id IS NULL AND EXISTS(SELECT 1 FROM self.invoiceLineList inli WHERE inli.saleOrderLine.id IN (?)))", new Object[]{saleOrder.getId(), saleOrder.getSaleOrderLineList().stream().map(SaleOrderLine::getId).collect(Collectors.toList())}).fetch();
    }

    private BigDecimal getAmountVentilated(SaleOrder saleOrder, Long currentInvoiceId, boolean excludeCurrentInvoice, int invoiceOperationTypeSelect) {
        BigDecimal invoicedAmount;
        boolean invoiceIsNotAdvancePayment;
        String query = "SELECT SUM(self.companyExTaxTotal) FROM InvoiceLine as self";
        query = query + " WHERE self.saleOrderLine.saleOrder.id = :saleOrderId";
        query = query + " AND self.invoice.operationTypeSelect = :invoiceOperationTypeSelect AND self.invoice.statusSelect = :statusVentilated";
        boolean bl = invoiceIsNotAdvancePayment = currentInvoiceId != null && ((Invoice)((Object)this.invoiceRepo.find(currentInvoiceId))).getOperationSubTypeSelect() != 2;
        if (invoiceIsNotAdvancePayment) {
            query = excludeCurrentInvoice ? query + " AND self.invoice.id <> :invoiceId" : query + " OR (self.invoice.id = :invoiceId AND self.invoice.operationTypeSelect = :invoiceOperationTypeSelect) ";
        }
        TypedQuery q = JPA.em().createQuery(query, BigDecimal.class);
        q.setParameter("saleOrderId", (Object)saleOrder.getId());
        q.setParameter("statusVentilated", (Object)3);
        q.setParameter("invoiceOperationTypeSelect", (Object)invoiceOperationTypeSelect);
        if (invoiceIsNotAdvancePayment) {
            q.setParameter("invoiceId", (Object)currentInvoiceId);
        }
        if ((invoicedAmount = (BigDecimal)q.getSingleResult()) != null) {
            return invoicedAmount;
        }
        return BigDecimal.ZERO;
    }

    @Override
    @Transactional
    public Invoice mergeInvoice(List<Invoice> invoiceList, Company company, Currency currency, Partner partner, Partner contactPartner, PriceList priceList, PaymentMode paymentMode, PaymentCondition paymentCondition, SaleOrder saleOrder) throws AxelorException {
        this.log.debug("service supplychain 1 (saleOrder) {}", (Object)saleOrder);
        if (saleOrder != null) {
            String numSeq = "";
            String externalRef = "";
            for (Invoice invoiceLocal : invoiceList) {
                if (!numSeq.isEmpty()) {
                    numSeq = numSeq + "-";
                }
                if (invoiceLocal.getInternalReference() != null) {
                    numSeq = numSeq + invoiceLocal.getInternalReference();
                }
                if (!externalRef.isEmpty()) {
                    externalRef = externalRef + "|";
                }
                if (invoiceLocal.getExternalReference() == null) continue;
                externalRef = externalRef + invoiceLocal.getExternalReference();
            }
            InvoiceGenerator invoiceGenerator = this.createInvoiceGenerator(saleOrder);
            Invoice invoiceMerged = invoiceGenerator.generate();
            invoiceMerged.setExternalReference(externalRef);
            invoiceMerged.setInternalReference(numSeq);
            if (paymentMode != null) {
                invoiceMerged.setPaymentMode(paymentMode);
            }
            if (paymentCondition != null) {
                invoiceMerged.setPaymentCondition(paymentCondition);
            }
            List invoiceLines = this.invoiceService.getInvoiceLinesFromInvoiceList(invoiceList);
            invoiceGenerator.populate(invoiceMerged, invoiceLines);
            this.invoiceService.setInvoiceForInvoiceLines(invoiceLines, invoiceMerged);
            invoiceMerged.setSaleOrder(null);
            this.invoiceRepo.save((Model)((Object)invoiceMerged));
            this.swapStockMoveInvoices(invoiceList, invoiceMerged);
            this.invoiceService.deleteOldInvoices(invoiceList);
            return invoiceMerged;
        }
        Invoice invoiceMerged = this.invoiceService.mergeInvoice(invoiceList, company, currency, partner, contactPartner, priceList, paymentMode, paymentCondition);
        this.swapStockMoveInvoices(invoiceList, invoiceMerged);
        this.invoiceService.deleteOldInvoices(invoiceList);
        return invoiceMerged;
    }

    @Transactional
    public void swapStockMoveInvoices(List<Invoice> invoiceList, Invoice newInvoice) {
        Query stockMoveQuery = this.stockMoveRepository.all().filter("self.invoiceSet.id in (" + StringTool.getIdListString(invoiceList) + ")");
        stockMoveQuery.fetch().forEach(stockMove -> {
            if (stockMove.getInvoiceSet() != null) {
                stockMove.getInvoiceSet().add(newInvoice);
            } else {
                HashSet<Invoice> invoiceSet = new HashSet<Invoice>();
                invoiceSet.add(newInvoice);
                stockMove.setInvoiceSet(invoiceSet);
            }
            this.stockMoveRepository.save((Model)((Object)stockMove));
        });
    }

    @Override
    public BigDecimal getInTaxInvoicedAmount(SaleOrder saleOrder) {
        BigDecimal exTaxTotal = saleOrder.getExTaxTotal();
        BigDecimal inTaxTotal = saleOrder.getInTaxTotal();
        BigDecimal exTaxAmountInvoiced = saleOrder.getAmountInvoiced();
        if (exTaxTotal.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return inTaxTotal.multiply(exTaxAmountInvoiced).divide(exTaxTotal, 2, 6);
    }

    @Override
    public List<Integer> getInvoicingWizardOperationDomain(SaleOrder saleOrder) {
        boolean manageAdvanceInvoice = ((AppAccountService)Beans.get(AppAccountService.class)).getAppAccount().getManageAdvancePaymentInvoice();
        boolean allowTimetableInvoicing = ((AppSupplychainService)Beans.get(AppSupplychainService.class)).getAppSupplychain().getAllowTimetableInvoicing();
        BigDecimal amountInvoiced = saleOrder.getAmountInvoiced();
        BigDecimal exTaxTotal = saleOrder.getExTaxTotal();
        Invoice invoice = (Invoice)((Object)Query.of(Invoice.class).filter(" self.saleOrder.id = :saleOrderId AND self.statusSelect != :invoiceStatus").bind("saleOrderId", (Object)saleOrder.getId()).bind("invoiceStatus", (Object)4).fetchOne());
        ArrayList<Integer> operationSelectList = new ArrayList<Integer>();
        operationSelectList.add(0);
        if (exTaxTotal.compareTo(BigDecimal.ZERO) != 0) {
            operationSelectList.add(2);
        }
        if (manageAdvanceInvoice && exTaxTotal.compareTo(BigDecimal.ZERO) != 0) {
            operationSelectList.add(3);
        }
        if (allowTimetableInvoicing) {
            operationSelectList.add(4);
        }
        if (invoice == null && amountInvoiced.compareTo(BigDecimal.ZERO) == 0 || exTaxTotal.compareTo(BigDecimal.ZERO) == 0) {
            operationSelectList.add(1);
        }
        return operationSelectList;
    }

    @Override
    public void displayErrorMessageIfSaleOrderIsInvoiceable(SaleOrder saleOrder, BigDecimal amountToInvoice, boolean isPercent) throws AxelorException {
        List invoices = Query.of(Invoice.class).filter(" self.saleOrder.id = :saleOrderId AND self.statusSelect != :invoiceStatus AND self.operationTypeSelect = :operationTypeSelect").bind("saleOrderId", (Object)saleOrder.getId()).bind("invoiceStatus", (Object)4).bind("operationTypeSelect", (Object)3).fetch();
        if (isPercent) {
            amountToInvoice = amountToInvoice.multiply(saleOrder.getExTaxTotal()).divide(new BigDecimal("100"), 2, 6);
        }
        BigDecimal sumInvoices = this.computeSumInvoices(invoices);
        if ((sumInvoices = sumInvoices.add(amountToInvoice)).compareTo(saleOrder.getExTaxTotal()) > 0) {
            throw new AxelorException((Model)((Object)saleOrder), 5, I18n.get((String)"The sale order %s invoiced amount cannot be greater than its total amount."), new Object[]{saleOrder.getSaleOrderSeq()});
        }
    }

    @Override
    public void displayErrorMessageBtnGenerateInvoice(SaleOrder saleOrder) throws AxelorException {
        List invoices = Query.of(Invoice.class).filter(" self.saleOrder.id = :saleOrderId AND self.operationSubTypeSelect = :operationSubTypeSelect AND self.statusSelect != :invoiceStatus").bind("saleOrderId", (Object)saleOrder.getId()).bind("operationSubTypeSelect", (Object)1).bind("invoiceStatus", (Object)4).fetch();
        BigDecimal sumInvoices = this.computeSumInvoices(invoices);
        if (sumInvoices.compareTo(saleOrder.getExTaxTotal()) > 0) {
            throw new AxelorException((Model)((Object)saleOrder), 5, I18n.get((String)"All invoices have been generated for this sale order."));
        }
    }

    protected BigDecimal computeSumInvoices(List<Invoice> invoices) {
        BigDecimal sumInvoices = BigDecimal.ZERO;
        for (Invoice invoice : invoices) {
            if (invoice.getOperationTypeSelect() == 4 || invoice.getOperationTypeSelect() == 2) {
                sumInvoices = sumInvoices.subtract(invoice.getExTaxTotal());
                continue;
            }
            sumInvoices = sumInvoices.add(invoice.getExTaxTotal());
        }
        return sumInvoices;
    }
}

