/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service;

import com.axelor.apps.account.db.AnalyticDistributionTemplate;
import com.axelor.apps.account.db.AnalyticMoveLine;
import com.axelor.apps.account.service.AnalyticMoveLineService;
import com.axelor.apps.account.service.app.AppAccountService;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.purchase.db.SupplierCatalog;
import com.axelor.apps.purchase.service.app.AppPurchaseService;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.apps.sale.service.saleorder.SaleOrderLineServiceImpl;
import com.axelor.apps.stock.db.StockLocation;
import com.axelor.apps.stock.db.StockLocationLine;
import com.axelor.apps.stock.db.repo.StockLocationRepository;
import com.axelor.apps.stock.service.StockLocationLineService;
import com.axelor.apps.stock.service.StockLocationService;
import com.axelor.apps.supplychain.service.SaleOrderLineServiceSupplyChain;
import com.axelor.apps.supplychain.service.app.AppSupplychainService;
import com.axelor.apps.tool.StringTool;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.common.ObjectUtils;
import com.axelor.common.StringUtils;
import com.axelor.db.JPA;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.Query;

public class SaleOrderLineServiceSupplyChainImpl
extends SaleOrderLineServiceImpl
implements SaleOrderLineServiceSupplyChain {
    @Inject
    protected AppAccountService appAccountService;
    @Inject
    protected AnalyticMoveLineService analyticMoveLineService;

    public void computeProductInformation(SaleOrderLine saleOrderLine, SaleOrder saleOrder) throws AxelorException {
        super.computeProductInformation(saleOrderLine, saleOrder);
        saleOrderLine.setSaleSupplySelect(saleOrderLine.getProduct().getSaleSupplySelect());
        if (((AppAccountService)Beans.get(AppAccountService.class)).isApp("supplychain")) {
            saleOrderLine.setSaleSupplySelect(saleOrderLine.getProduct().getSaleSupplySelect());
            this.getAndComputeAnalyticDistribution(saleOrderLine, saleOrder);
        }
    }

    public SaleOrderLine getAndComputeAnalyticDistribution(SaleOrderLine saleOrderLine, SaleOrder saleOrder) {
        if (this.appAccountService.getAppAccount().getAnalyticDistributionTypeSelect() == 1) {
            return saleOrderLine;
        }
        AnalyticDistributionTemplate analyticDistributionTemplate = this.analyticMoveLineService.getAnalyticDistributionTemplate(saleOrder.getClientPartner(), saleOrderLine.getProduct(), saleOrder.getCompany());
        saleOrderLine.setAnalyticDistributionTemplate(analyticDistributionTemplate);
        if (saleOrderLine.getAnalyticMoveLineList() != null) {
            saleOrderLine.getAnalyticMoveLineList().clear();
        }
        this.computeAnalyticDistribution(saleOrderLine);
        return saleOrderLine;
    }

    @Override
    public SaleOrderLine computeAnalyticDistribution(SaleOrderLine saleOrderLine) {
        List<AnalyticMoveLine> analyticMoveLineList = saleOrderLine.getAnalyticMoveLineList();
        if (analyticMoveLineList == null || analyticMoveLineList.isEmpty()) {
            this.createAnalyticDistributionWithTemplate(saleOrderLine);
        }
        if (analyticMoveLineList != null) {
            LocalDate date = this.appAccountService.getTodayDate(saleOrderLine.getSaleOrder() != null ? saleOrderLine.getSaleOrder().getCompany() : (Company)Optional.ofNullable(AuthUtils.getUser()).map(User::getActiveCompany).orElse(null));
            for (AnalyticMoveLine analyticMoveLine : analyticMoveLineList) {
                this.analyticMoveLineService.updateAnalyticMoveLine(analyticMoveLine, saleOrderLine.getCompanyExTaxTotal(), date);
            }
        }
        return saleOrderLine;
    }

    @Override
    public SaleOrderLine createAnalyticDistributionWithTemplate(SaleOrderLine saleOrderLine) {
        List analyticMoveLineList = this.analyticMoveLineService.generateLines(saleOrderLine.getAnalyticDistributionTemplate(), saleOrderLine.getCompanyExTaxTotal(), 1, this.appAccountService.getTodayDate(saleOrderLine.getSaleOrder() != null ? saleOrderLine.getSaleOrder().getCompany() : (Company)Optional.ofNullable(AuthUtils.getUser()).map(User::getActiveCompany).orElse(null)));
        saleOrderLine.setAnalyticMoveLineList(analyticMoveLineList);
        return saleOrderLine;
    }

    public BigDecimal getAvailableStock(SaleOrder saleOrder, SaleOrderLine saleOrderLine) {
        if (!((AppAccountService)Beans.get(AppAccountService.class)).isApp("supplychain")) {
            return super.getAvailableStock(saleOrder, saleOrderLine);
        }
        StockLocationLine stockLocationLine = ((StockLocationLineService)Beans.get(StockLocationLineService.class)).getStockLocationLine(saleOrder.getStockLocation(), saleOrderLine.getProduct());
        if (stockLocationLine == null) {
            return BigDecimal.ZERO;
        }
        return stockLocationLine.getCurrentQty().subtract(stockLocationLine.getReservedQty());
    }

    public BigDecimal getAllocatedStock(SaleOrder saleOrder, SaleOrderLine saleOrderLine) {
        if (!((AppAccountService)Beans.get(AppAccountService.class)).isApp("supplychain")) {
            return super.getAllocatedStock(saleOrder, saleOrderLine);
        }
        StockLocationLine stockLocationLine = ((StockLocationLineService)Beans.get(StockLocationLineService.class)).getStockLocationLine(saleOrder.getStockLocation(), saleOrderLine.getProduct());
        if (stockLocationLine == null) {
            return BigDecimal.ZERO;
        }
        return stockLocationLine.getReservedQty();
    }

    @Override
    public BigDecimal computeUndeliveredQty(SaleOrderLine saleOrderLine) {
        Preconditions.checkNotNull((Object)((Object)saleOrderLine));
        BigDecimal undeliveryQty = saleOrderLine.getQty().subtract(saleOrderLine.getDeliveredQty());
        if (undeliveryQty.signum() > 0) {
            return undeliveryQty;
        }
        return BigDecimal.ZERO;
    }

    @Override
    public List<Long> getSupplierPartnerList(SaleOrderLine saleOrderLine) {
        Product product = saleOrderLine.getProduct();
        if (!((AppPurchaseService)Beans.get(AppPurchaseService.class)).getAppPurchase().getManageSupplierCatalog().booleanValue() || product == null || product.getSupplierCatalogList() == null) {
            return new ArrayList<Long>();
        }
        return product.getSupplierCatalogList().stream().map(SupplierCatalog::getSupplierPartner).filter(Objects::nonNull).map(Partner::getId).collect(Collectors.toList());
    }

    @Override
    public void updateDeliveryStates(List<SaleOrderLine> saleOrderLineList) {
        if (ObjectUtils.isEmpty(saleOrderLineList)) {
            return;
        }
        for (SaleOrderLine saleOrderLine : saleOrderLineList) {
            this.updateDeliveryState(saleOrderLine);
        }
    }

    @Override
    public void updateDeliveryState(SaleOrderLine saleOrderLine) {
        if (saleOrderLine.getDeliveredQty().signum() == 0) {
            saleOrderLine.setDeliveryState(1);
        } else if (saleOrderLine.getDeliveredQty().compareTo(saleOrderLine.getQty()) < 0) {
            saleOrderLine.setDeliveryState(2);
        } else {
            saleOrderLine.setDeliveryState(3);
        }
    }

    @Override
    public String getSaleOrderLineListForAProduct(Long productId, Long companyId, Long stockLocationId) {
        List<Integer> statusList = new ArrayList<Integer>();
        statusList.add(3);
        String status = ((AppSupplychainService)Beans.get(AppSupplychainService.class)).getAppSupplychain().getsOFilterOnStockDetailStatusSelect();
        if (!StringUtils.isBlank((CharSequence)status)) {
            statusList = StringTool.getIntegerList((String)status);
        }
        String statusListQuery = statusList.stream().map(String::valueOf).collect(Collectors.joining(","));
        String query = "self.product.id = " + productId + " AND self.deliveryState != " + 3 + " AND self.saleOrder.statusSelect IN (" + statusListQuery + ")";
        if (companyId != 0L) {
            query = query + " AND self.saleOrder.company.id = " + companyId;
            if (stockLocationId != 0L) {
                StockLocation stockLocation = (StockLocation)((Object)((StockLocationRepository)((Object)Beans.get(StockLocationRepository.class))).find(stockLocationId));
                List stockLocationList = ((StockLocationService)Beans.get(StockLocationService.class)).getAllLocationAndSubLocation(stockLocation, false);
                if (!stockLocationList.isEmpty() && stockLocation.getCompany().getId() == companyId) {
                    query = query + " AND self.saleOrder.stockLocation.id IN (" + StringTool.getIdListString((Collection)stockLocationList) + ") ";
                }
            }
        }
        return query;
    }

    @Override
    public BigDecimal checkInvoicedOrDeliveredOrderQty(SaleOrderLine saleOrderLine) {
        BigDecimal qty = saleOrderLine.getQty();
        BigDecimal deliveredQty = saleOrderLine.getDeliveredQty();
        BigDecimal invoicedQty = BigDecimal.ZERO;
        Query query = JPA.em().createQuery("SELECT SUM(self.qty) FROM InvoiceLine self WHERE self.invoice.statusSelect = :statusSelect AND self.saleOrderLine.id = :saleOrderLineId");
        query.setParameter("statusSelect", (Object)3);
        query.setParameter("saleOrderLineId", (Object)saleOrderLine.getId());
        invoicedQty = (BigDecimal)query.getSingleResult();
        if (invoicedQty != null && qty.compareTo(invoicedQty) == -1 && invoicedQty.compareTo(deliveredQty) > 0) {
            return invoicedQty;
        }
        if (deliveredQty.compareTo(BigDecimal.ZERO) > 0 && qty.compareTo(deliveredQty) == -1) {
            return deliveredQty;
        }
        return qty;
    }
}

