/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service;

import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.service.PartnerPriceListService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.apps.purchase.db.repo.PurchaseOrderRepository;
import com.axelor.apps.purchase.service.config.PurchaseConfigService;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.apps.stock.service.StockLocationService;
import com.axelor.apps.supplychain.service.PurchaseOrderLineServiceSupplyChain;
import com.axelor.apps.supplychain.service.PurchaseOrderLineServiceSupplychainImpl;
import com.axelor.apps.supplychain.service.PurchaseOrderServiceSupplychainImpl;
import com.axelor.apps.supplychain.service.SaleOrderPurchaseService;
import com.axelor.auth.AuthUtils;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaleOrderPurchaseServiceImpl
implements SaleOrderPurchaseService {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected PurchaseOrderServiceSupplychainImpl purchaseOrderServiceSupplychainImpl;
    protected PurchaseOrderLineServiceSupplyChain purchaseOrderLineServiceSupplychain;

    @Inject
    public SaleOrderPurchaseServiceImpl(PurchaseOrderServiceSupplychainImpl purchaseOrderServiceSupplychainImpl, PurchaseOrderLineServiceSupplychainImpl purchaseOrderLineServiceSupplychain) {
        this.purchaseOrderServiceSupplychainImpl = purchaseOrderServiceSupplychainImpl;
        this.purchaseOrderLineServiceSupplychain = purchaseOrderLineServiceSupplychain;
    }

    @Override
    public void createPurchaseOrders(SaleOrder saleOrder) throws AxelorException {
        Map<Partner, List<SaleOrderLine>> saleOrderLinesBySupplierPartner = this.splitBySupplierPartner(saleOrder.getSaleOrderLineList());
        for (Partner supplierPartner : saleOrderLinesBySupplierPartner.keySet()) {
            this.createPurchaseOrder(supplierPartner, saleOrderLinesBySupplierPartner.get((Object)supplierPartner), saleOrder);
        }
    }

    @Override
    public Map<Partner, List<SaleOrderLine>> splitBySupplierPartner(List<SaleOrderLine> saleOrderLineList) throws AxelorException {
        HashMap<Partner, List<SaleOrderLine>> saleOrderLinesBySupplierPartner = new HashMap<Partner, List<SaleOrderLine>>();
        for (SaleOrderLine saleOrderLine : saleOrderLineList) {
            if (saleOrderLine.getSaleSupplySelect() != 2) continue;
            Partner supplierPartner = saleOrderLine.getSupplierPartner();
            if (supplierPartner == null) {
                throw new AxelorException((Model)((Object)saleOrderLine), 4, I18n.get((String)"Please, select a supplier for the line %s"), new Object[]{saleOrderLine.getProductName()});
            }
            if (!saleOrderLinesBySupplierPartner.containsKey((Object)supplierPartner)) {
                saleOrderLinesBySupplierPartner.put(supplierPartner, new ArrayList());
            }
            ((List)saleOrderLinesBySupplierPartner.get((Object)supplierPartner)).add(saleOrderLine);
        }
        return saleOrderLinesBySupplierPartner;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public PurchaseOrder createPurchaseOrder(Partner supplierPartner, List<SaleOrderLine> saleOrderLineList, SaleOrder saleOrder) throws AxelorException {
        LOG.debug("Cr\u00e9ation d'une commande fournisseur pour le devis client : {}", (Object)saleOrder.getSaleOrderSeq());
        PurchaseOrder purchaseOrder = this.purchaseOrderServiceSupplychainImpl.createPurchaseOrder(AuthUtils.getUser(), saleOrder.getCompany(), supplierPartner.getContactPartnerSet().size() == 1 ? supplierPartner.getContactPartnerSet().iterator().next() : null, supplierPartner.getCurrency(), null, saleOrder.getSaleOrderSeq(), saleOrder.getExternalReference(), saleOrder.getDirectOrderLocation() != false ? saleOrder.getStockLocation() : ((StockLocationService)Beans.get(StockLocationService.class)).getDefaultReceiptStockLocation(saleOrder.getCompany()), ((AppBaseService)Beans.get(AppBaseService.class)).getTodayDate(saleOrder.getCompany()), ((PartnerPriceListService)Beans.get(PartnerPriceListService.class)).getDefaultPriceList(supplierPartner, 2), supplierPartner, saleOrder.getTradingName());
        purchaseOrder.setGeneratedSaleOrderId(saleOrder.getId());
        Integer atiChoice = ((PurchaseConfigService)Beans.get(PurchaseConfigService.class)).getPurchaseConfig(saleOrder.getCompany()).getPurchaseOrderInAtiSelect();
        if (atiChoice == 2 || atiChoice == 4) {
            purchaseOrder.setInAti(true);
        } else {
            purchaseOrder.setInAti(false);
        }
        for (SaleOrderLine saleOrderLine : saleOrderLineList) {
            purchaseOrder.addPurchaseOrderLineListItem(this.purchaseOrderLineServiceSupplychain.createPurchaseOrderLine(purchaseOrder, saleOrderLine));
        }
        this.purchaseOrderServiceSupplychainImpl.computePurchaseOrder(purchaseOrder);
        purchaseOrder.setNotes(supplierPartner.getPurchaseOrderComments());
        ((PurchaseOrderRepository)((Object)Beans.get(PurchaseOrderRepository.class))).save((Model)((Object)purchaseOrder));
        return purchaseOrder;
    }
}

