/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service;

import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.apps.stock.db.StockMoveLine;
import com.axelor.apps.stock.db.repo.StockMoveLineRepository;
import com.axelor.apps.supplychain.service.ReservedQtyService;
import com.axelor.apps.supplychain.service.SaleOrderReservedQtyService;
import com.axelor.exception.AxelorException;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class SaleOrderReservedQtyServiceImpl
implements SaleOrderReservedQtyService {
    protected ReservedQtyService reservedQtyService;
    protected StockMoveLineRepository stockMoveLineRepository;

    @Inject
    public SaleOrderReservedQtyServiceImpl(ReservedQtyService reservedQtyService, StockMoveLineRepository stockMoveLineRepository) {
        this.reservedQtyService = reservedQtyService;
        this.stockMoveLineRepository = stockMoveLineRepository;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void allocateAll(SaleOrder saleOrder) throws AxelorException {
        for (SaleOrderLine saleOrderLine : this.getNonDeliveredLines(saleOrder)) {
            this.reservedQtyService.allocateAll(saleOrderLine);
        }
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void deallocateAll(SaleOrder saleOrder) throws AxelorException {
        for (SaleOrderLine saleOrderLine : this.getNonDeliveredLines(saleOrder)) {
            this.reservedQtyService.updateReservedQty(saleOrderLine, BigDecimal.ZERO);
        }
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void reserveAll(SaleOrder saleOrder) throws AxelorException {
        for (SaleOrderLine saleOrderLine : this.getNonDeliveredLines(saleOrder)) {
            this.reservedQtyService.requestQty(saleOrderLine);
        }
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void cancelReservation(SaleOrder saleOrder) throws AxelorException {
        for (SaleOrderLine saleOrderLine : this.getNonDeliveredLines(saleOrder)) {
            this.reservedQtyService.cancelReservation(saleOrderLine);
        }
    }

    protected List<SaleOrderLine> getNonDeliveredLines(SaleOrder saleOrder) {
        List<Object> saleOrderLineList = saleOrder.getSaleOrderLineList() == null ? new ArrayList() : saleOrder.getSaleOrderLineList();
        return saleOrderLineList.stream().filter(saleOrderLine -> this.getPlannedStockMoveLine((SaleOrderLine)((Object)saleOrderLine)) != null).collect(Collectors.toList());
    }

    protected StockMoveLine getPlannedStockMoveLine(SaleOrderLine saleOrderLine) {
        return (StockMoveLine)((Object)this.stockMoveLineRepository.all().filter("self.saleOrderLine = :saleOrderLine AND self.stockMove.statusSelect = :planned").bind("saleOrderLine", (Object)saleOrderLine).bind("planned", (Object)2).fetchOne());
    }
}

