/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service;

import com.axelor.apps.base.db.AppSupplychain;
import com.axelor.apps.base.db.CancelReason;
import com.axelor.apps.base.db.repo.PartnerRepository;
import com.axelor.apps.base.service.administration.SequenceService;
import com.axelor.apps.base.service.user.UserService;
import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.apps.purchase.db.repo.PurchaseOrderRepository;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.repo.SaleOrderRepository;
import com.axelor.apps.sale.exception.BlockedSaleOrderException;
import com.axelor.apps.sale.service.app.AppSaleService;
import com.axelor.apps.sale.service.saleorder.SaleOrderWorkflowServiceImpl;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.apps.stock.db.repo.StockMoveRepository;
import com.axelor.apps.supplychain.service.AccountingSituationSupplychainService;
import com.axelor.apps.supplychain.service.IntercoService;
import com.axelor.apps.supplychain.service.SaleOrderPurchaseService;
import com.axelor.apps.supplychain.service.SaleOrderStockService;
import com.axelor.apps.supplychain.service.app.AppSupplychainService;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaleOrderWorkflowServiceSupplychainImpl
extends SaleOrderWorkflowServiceImpl {
    private final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected SaleOrderStockService saleOrderStockService;
    protected SaleOrderPurchaseService saleOrderPurchaseService;
    protected AppSupplychain appSupplychain;
    protected AccountingSituationSupplychainService accountingSituationSupplychainService;

    @Inject
    public SaleOrderWorkflowServiceSupplychainImpl(SequenceService sequenceService, PartnerRepository partnerRepo, SaleOrderRepository saleOrderRepo, AppSaleService appSaleService, UserService userService, SaleOrderStockService saleOrderStockService, SaleOrderPurchaseService saleOrderPurchaseService, AppSupplychainService appSupplychainService, AccountingSituationSupplychainService accountingSituationSupplychainService) {
        super(sequenceService, partnerRepo, saleOrderRepo, appSaleService, userService);
        this.saleOrderStockService = saleOrderStockService;
        this.saleOrderPurchaseService = saleOrderPurchaseService;
        this.appSupplychain = appSupplychainService.getAppSupplychain();
        this.accountingSituationSupplychainService = accountingSituationSupplychainService;
    }

    @Transactional(rollbackOn={Exception.class})
    public void confirmSaleOrder(SaleOrder saleOrder) throws AxelorException {
        super.confirmSaleOrder(saleOrder);
        if (!((AppSupplychainService)Beans.get(AppSupplychainService.class)).isApp("supplychain")) {
            return;
        }
        if (this.appSupplychain.getPurchaseOrderGenerationAuto().booleanValue()) {
            this.saleOrderPurchaseService.createPurchaseOrders(saleOrder);
        }
        if (this.appSupplychain.getCustomerStockMoveGenerationAuto().booleanValue()) {
            this.saleOrderStockService.createStocksMovesFromSaleOrder(saleOrder);
        }
        int intercoSaleCreatingStatus = ((AppSupplychainService)Beans.get(AppSupplychainService.class)).getAppSupplychain().getIntercoSaleCreatingStatusSelect();
        if (saleOrder.getInterco().booleanValue() && intercoSaleCreatingStatus == 3) {
            ((IntercoService)Beans.get(IntercoService.class)).generateIntercoPurchaseFromSale(saleOrder);
        }
    }

    @Transactional
    public void cancelSaleOrder(SaleOrder saleOrder, CancelReason cancelReason, String cancelReasonStr) {
        super.cancelSaleOrder(saleOrder, cancelReason, cancelReasonStr);
        if (!((AppSupplychainService)Beans.get(AppSupplychainService.class)).isApp("supplychain")) {
            return;
        }
        try {
            this.accountingSituationSupplychainService.updateUsedCredit(saleOrder.getClientPartner());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Transactional(rollbackOn={AxelorException.class, RuntimeException.class}, ignore={BlockedSaleOrderException.class})
    public void finalizeQuotation(SaleOrder saleOrder) throws AxelorException {
        if (!((AppSupplychainService)Beans.get(AppSupplychainService.class)).isApp("supplychain")) {
            super.finalizeQuotation(saleOrder);
            return;
        }
        this.accountingSituationSupplychainService.updateCustomerCreditFromSaleOrder(saleOrder);
        super.finalizeQuotation(saleOrder);
        int intercoSaleCreatingStatus = ((AppSupplychainService)Beans.get(AppSupplychainService.class)).getAppSupplychain().getIntercoSaleCreatingStatusSelect();
        if (saleOrder.getInterco().booleanValue() && intercoSaleCreatingStatus == 2) {
            ((IntercoService)Beans.get(IntercoService.class)).generateIntercoPurchaseFromSale(saleOrder);
        }
        if (saleOrder.getCreatedByInterco().booleanValue()) {
            this.fillIntercompanyPurchaseOrderCounterpart(saleOrder);
        }
    }

    protected void fillIntercompanyPurchaseOrderCounterpart(SaleOrder saleOrder) {
        PurchaseOrder purchaseOrder = (PurchaseOrder)((Object)((PurchaseOrderRepository)((Object)Beans.get(PurchaseOrderRepository.class))).all().filter("self.purchaseOrderSeq = :purchaseOrderSeq").bind("purchaseOrderSeq", (Object)saleOrder.getExternalReference()).fetchOne());
        if (purchaseOrder != null) {
            purchaseOrder.setExternalReference(saleOrder.getSaleOrderSeq());
        }
    }

    @Transactional(rollbackOn={AxelorException.class, RuntimeException.class})
    public void completeSaleOrder(SaleOrder saleOrder) throws AxelorException {
        if (!((AppSupplychainService)Beans.get(AppSupplychainService.class)).isApp("supplychain")) {
            super.completeSaleOrder(saleOrder);
            return;
        }
        List stockMoves = ((StockMoveRepository)((Object)Beans.get(StockMoveRepository.class))).all().filter("self.originId = ? AND self.originTypeSelect = ?", new Object[]{saleOrder.getId(), "com.axelor.apps.sale.db.SaleOrder"}).fetch();
        if (!stockMoves.isEmpty()) {
            for (StockMove stockMove : stockMoves) {
                if (stockMove.getStatusSelect() != 1 && stockMove.getStatusSelect() != 2) continue;
                throw new AxelorException(5, I18n.get((String)"There is at least one draft or planned stock move for this sale order."));
            }
        }
        super.completeSaleOrder(saleOrder);
    }
}

