/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service;

import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.stock.db.StockLocation;
import com.axelor.apps.stock.db.StockLocationLine;
import com.axelor.apps.stock.db.TrackingNumber;
import com.axelor.apps.stock.db.repo.StockLocationLineRepository;
import com.axelor.apps.stock.db.repo.StockMoveLineRepository;
import com.axelor.apps.stock.db.repo.WapHistoryRepository;
import com.axelor.apps.stock.service.StockLocationLineService;
import com.axelor.apps.stock.service.StockLocationLineServiceImpl;
import com.axelor.apps.stock.service.StockRulesService;
import com.axelor.apps.supplychain.service.ReservedQtyService;
import com.axelor.apps.supplychain.service.app.AppSupplychainService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.servlet.RequestScoped;
import java.math.BigDecimal;

@RequestScoped
public class StockLocationLineServiceSupplychainImpl
extends StockLocationLineServiceImpl {
    protected AppSupplychainService appSupplychainService;

    @Inject
    public StockLocationLineServiceSupplychainImpl(StockLocationLineRepository stockLocationLineRepo, StockRulesService stockRulesService, StockMoveLineRepository stockMoveLineRepository, AppBaseService appBaseService, WapHistoryRepository wapHistoryRepo, AppSupplychainService appSupplychainService) {
        super(stockLocationLineRepo, stockRulesService, stockMoveLineRepository, appBaseService, wapHistoryRepo);
        this.appSupplychainService = appSupplychainService;
    }

    public void checkIfEnoughStock(StockLocation stockLocation, Product product, BigDecimal qty) throws AxelorException {
        StockLocationLine stockLocationLine;
        super.checkIfEnoughStock(stockLocation, product, qty);
        AppSupplychainService appSupplychainService = (AppSupplychainService)Beans.get(AppSupplychainService.class);
        if (!appSupplychainService.isApp("supplychain")) {
            return;
        }
        if (appSupplychainService.getAppSupplychain().getManageStockReservation().booleanValue() && product.getStockManaged().booleanValue() && (stockLocationLine = this.getStockLocationLine(stockLocation, product)) != null && stockLocationLine.getCurrentQty().subtract(stockLocationLine.getReservedQty()).compareTo(qty) < 0) {
            throw new AxelorException((Model)((Object)stockLocationLine), 4, I18n.get((String)"Not enough quantity are available for reservation for product %s (%s)"), new Object[]{stockLocationLine.getProduct().getName(), stockLocationLine.getProduct().getCode()});
        }
    }

    public BigDecimal getAvailableQty(StockLocation stockLocation, Product product) {
        if (!((AppSupplychainService)Beans.get(AppSupplychainService.class)).isApp("supplychain")) {
            return super.getAvailableQty(stockLocation, product);
        }
        StockLocationLine stockLocationLine = this.getStockLocationLine(stockLocation, product);
        BigDecimal availableQty = BigDecimal.ZERO;
        if (stockLocationLine != null) {
            availableQty = stockLocationLine.getCurrentQty().subtract(stockLocationLine.getReservedQty());
        }
        return availableQty;
    }

    public BigDecimal getTrackingNumberAvailableQty(StockLocation stockLocation, TrackingNumber trackingNumber) {
        if (!this.appSupplychainService.isApp("supplychain") || !this.appSupplychainService.getAppSupplychain().getManageStockReservation().booleanValue()) {
            return super.getTrackingNumberAvailableQty(stockLocation, trackingNumber);
        }
        StockLocationLine detailStockLocationLine = ((StockLocationLineService)Beans.get(StockLocationLineService.class)).getDetailLocationLine(stockLocation, trackingNumber.getProduct(), trackingNumber);
        BigDecimal availableQty = BigDecimal.ZERO;
        if (detailStockLocationLine != null) {
            availableQty = detailStockLocationLine.getCurrentQty().subtract(detailStockLocationLine.getReservedQty());
        }
        return availableQty;
    }

    public StockLocationLine updateLocationFromProduct(StockLocationLine stockLocationLine, Product product) throws AxelorException {
        stockLocationLine = super.updateLocationFromProduct(stockLocationLine, product);
        if (((AppSupplychainService)Beans.get(AppSupplychainService.class)).isApp("supplychain")) {
            ((ReservedQtyService)Beans.get(ReservedQtyService.class)).updateRequestedReservedQty(stockLocationLine);
        }
        return stockLocationLine;
    }
}

