/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoiceLine;
import com.axelor.apps.account.db.repo.InvoiceLineRepository;
import com.axelor.apps.account.db.repo.InvoiceRepository;
import com.axelor.apps.account.service.invoice.InvoiceService;
import com.axelor.apps.account.service.invoice.InvoiceToolService;
import com.axelor.apps.account.service.invoice.generator.InvoiceGenerator;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.service.AddressService;
import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.apps.purchase.db.PurchaseOrderLine;
import com.axelor.apps.purchase.db.repo.PurchaseOrderRepository;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.apps.sale.db.repo.SaleOrderRepository;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.apps.stock.db.StockMoveLine;
import com.axelor.apps.stock.db.repo.StockMoveLineRepository;
import com.axelor.apps.supplychain.db.SupplyChainConfig;
import com.axelor.apps.supplychain.service.PurchaseOrderInvoiceService;
import com.axelor.apps.supplychain.service.SaleOrderInvoiceService;
import com.axelor.apps.supplychain.service.StockMoveInvoiceService;
import com.axelor.apps.supplychain.service.StockMoveLineServiceSupplychain;
import com.axelor.apps.supplychain.service.config.SupplyChainConfigService;
import com.axelor.apps.supplychain.service.invoice.generator.InvoiceGeneratorSupplyChain;
import com.axelor.apps.supplychain.service.invoice.generator.InvoiceLineGeneratorSupplyChain;
import com.axelor.apps.tool.StringTool;
import com.axelor.common.ObjectUtils;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class StockMoveInvoiceServiceImpl
implements StockMoveInvoiceService {
    private SaleOrderInvoiceService saleOrderInvoiceService;
    private PurchaseOrderInvoiceService purchaseOrderInvoiceService;
    private StockMoveLineServiceSupplychain stockMoveLineServiceSupplychain;
    private InvoiceRepository invoiceRepository;
    private SaleOrderRepository saleOrderRepo;
    private PurchaseOrderRepository purchaseOrderRepo;
    private StockMoveLineRepository stockMoveLineRepository;
    private InvoiceLineRepository invoiceLineRepository;
    private SupplyChainConfigService supplyChainConfigService;

    @Inject
    public StockMoveInvoiceServiceImpl(SaleOrderInvoiceService saleOrderInvoiceService, PurchaseOrderInvoiceService purchaseOrderInvoiceService, StockMoveLineServiceSupplychain stockMoveLineServiceSupplychain, InvoiceRepository invoiceRepository, SaleOrderRepository saleOrderRepo, PurchaseOrderRepository purchaseOrderRepo, StockMoveLineRepository stockMoveLineRepository, InvoiceLineRepository invoiceLineRepository, SupplyChainConfigService supplyChainConfigService) {
        this.saleOrderInvoiceService = saleOrderInvoiceService;
        this.purchaseOrderInvoiceService = purchaseOrderInvoiceService;
        this.stockMoveLineServiceSupplychain = stockMoveLineServiceSupplychain;
        this.invoiceRepository = invoiceRepository;
        this.saleOrderRepo = saleOrderRepo;
        this.purchaseOrderRepo = purchaseOrderRepo;
        this.stockMoveLineRepository = stockMoveLineRepository;
        this.invoiceLineRepository = invoiceLineRepository;
        this.supplyChainConfigService = supplyChainConfigService;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public Invoice createInvoice(StockMove stockMove, Integer operationSelect, List<Map<String, Object>> stockMoveLineListContext) throws AxelorException {
        HashMap<Long, BigDecimal> qtyToInvoiceMap = new HashMap<Long, BigDecimal>();
        if (operationSelect == 2) {
            for (Map<String, Object> map : stockMoveLineListContext) {
                if (map.get("qtyToInvoice") == null) continue;
                BigDecimal qtyToInvoiceItem = new BigDecimal(map.get("qtyToInvoice").toString());
                BigDecimal remainingQty = new BigDecimal(map.get("remainingQty").toString());
                if (qtyToInvoiceItem.compareTo(BigDecimal.ZERO) == 0) continue;
                if (qtyToInvoiceItem.compareTo(remainingQty) > 0) {
                    qtyToInvoiceItem = remainingQty;
                }
                Long stockMoveLineId = Long.parseLong(map.get("stockMoveLineId").toString());
                StockMoveLine stockMoveLine = (StockMoveLine)((Object)this.stockMoveLineRepository.find(stockMoveLineId));
                qtyToInvoiceMap.put(stockMoveLine.getId(), qtyToInvoiceItem);
            }
        } else {
            qtyToInvoiceMap = null;
        }
        Long origin = stockMove.getOriginId();
        Invoice invoice = "com.axelor.apps.sale.db.SaleOrder".equals(stockMove.getOriginTypeSelect()) ? this.createInvoiceFromSaleOrder(stockMove, (SaleOrder)((Object)this.saleOrderRepo.find(origin)), qtyToInvoiceMap) : ("com.axelor.apps.purchase.db.PurchaseOrder".equals(stockMove.getOriginTypeSelect()) ? this.createInvoiceFromPurchaseOrder(stockMove, (PurchaseOrder)((Object)this.purchaseOrderRepo.find(origin)), qtyToInvoiceMap) : this.createInvoiceFromOrderlessStockMove(stockMove, qtyToInvoiceMap));
        return invoice;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public Invoice createInvoiceFromSaleOrder(StockMove stockMove, SaleOrder saleOrder, Map<Long, BigDecimal> qtyToInvoiceMap) throws AxelorException {
        if (!this.supplyChainConfigService.getSupplyChainConfig(stockMove.getCompany()).getActivateOutStockMovePartialInvoicing().booleanValue() && this.computeNonCanceledInvoiceQty(stockMove).signum() > 0) {
            throw new AxelorException(5, I18n.get((String)"Stock move %s has already been invoiced."), new Object[]{stockMove.getStockMoveSeq()});
        }
        InvoiceGenerator invoiceGenerator = this.saleOrderInvoiceService.createInvoiceGenerator(saleOrder, stockMove.getIsReversion());
        Invoice invoice = invoiceGenerator.generate();
        this.checkSplitSalePartiallyInvoicedStockMoveLines(stockMove, stockMove.getStockMoveLineList());
        invoiceGenerator.populate(invoice, this.createInvoiceLines(invoice, stockMove, stockMove.getStockMoveLineList(), qtyToInvoiceMap));
        if (invoice != null) {
            Set<StockMove> stockMoveSet;
            if (invoice.getInvoiceLineList() == null || invoice.getInvoiceLineList().isEmpty()) {
                return null;
            }
            invoice.setSaleOrder(saleOrder);
            this.extendInternalReference(stockMove, invoice);
            invoice.setDeliveryAddress(stockMove.getToAddress());
            invoice.setDeliveryAddressStr(stockMove.getToAddressStr());
            invoice.setAddressStr(saleOrder.getMainInvoicingAddressStr());
            if (invoice.getOperationSubTypeSelect() != 2) {
                invoice.setAdvancePaymentInvoiceSet(((InvoiceService)Beans.get(InvoiceService.class)).getDefaultAdvancePaymentInvoice(invoice));
            }
            invoice.setPartnerTaxNbr(saleOrder.getClientPartner().getTaxNbr());
            if (!Strings.isNullOrEmpty((String)saleOrder.getInvoiceComments())) {
                invoice.setNote(saleOrder.getInvoiceComments());
            }
            if (ObjectUtils.isEmpty((Object)invoice.getProformaComments()) && !Strings.isNullOrEmpty((String)saleOrder.getProformaComments())) {
                invoice.setProformaComments(saleOrder.getProformaComments());
            }
            if ((stockMoveSet = invoice.getStockMoveSet()) == null) {
                stockMoveSet = new HashSet<StockMove>();
                invoice.setStockMoveSet(stockMoveSet);
            }
            stockMoveSet.add(stockMove);
            this.invoiceRepository.save((Model)((Object)invoice));
        }
        return invoice;
    }

    @Override
    public void checkSplitSalePartiallyInvoicedStockMoveLines(StockMove stockMove, List<StockMoveLine> stockMoveLineList) throws AxelorException {
        SupplyChainConfig supplyChainConfig = this.supplyChainConfigService.getSupplyChainConfig(stockMove.getCompany());
        if (stockMoveLineList != null && supplyChainConfig.getActivateOutStockMovePartialInvoicing().booleanValue()) {
            for (SaleOrderLine saleOrderLine : stockMoveLineList.stream().map(StockMoveLine::getSaleOrderLine).filter(Objects::nonNull).collect(Collectors.toList())) {
                if (stockMoveLineList.stream().filter(stockMoveLine -> saleOrderLine.equals((Object)stockMoveLine.getSaleOrderLine())).count() <= 1L) continue;
                throw new AxelorException(5, I18n.get((String)"Partial invoicing of outgoing stock move with tracking number activated is not supported."));
            }
        }
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public Invoice createInvoiceFromPurchaseOrder(StockMove stockMove, PurchaseOrder purchaseOrder, Map<Long, BigDecimal> qtyToInvoiceMap) throws AxelorException {
        if (!this.supplyChainConfigService.getSupplyChainConfig(stockMove.getCompany()).getActivateIncStockMovePartialInvoicing().booleanValue() && this.computeNonCanceledInvoiceQty(stockMove).signum() > 0) {
            throw new AxelorException(5, I18n.get((String)"Stock move %s has already been invoiced."));
        }
        InvoiceGenerator invoiceGenerator = this.purchaseOrderInvoiceService.createInvoiceGenerator(purchaseOrder, stockMove.getIsReversion());
        Invoice invoice = invoiceGenerator.generate();
        invoiceGenerator.populate(invoice, this.createInvoiceLines(invoice, stockMove, stockMove.getStockMoveLineList(), qtyToInvoiceMap));
        if (invoice != null) {
            if (invoice.getInvoiceLineList() == null || invoice.getInvoiceLineList().isEmpty()) {
                return null;
            }
            this.extendInternalReference(stockMove, invoice);
            invoice.setAddressStr(((AddressService)Beans.get(AddressService.class)).computeAddressStr(invoice.getAddress()));
            if (invoice != null) {
                Set<StockMove> stockMoveSet = invoice.getStockMoveSet();
                if (stockMoveSet == null) {
                    stockMoveSet = new HashSet<StockMove>();
                    invoice.setStockMoveSet(stockMoveSet);
                }
                stockMoveSet.add(stockMove);
            }
            this.invoiceRepository.save((Model)((Object)invoice));
        }
        return invoice;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Transactional(rollbackOn={Exception.class})
    public Invoice createInvoiceFromOrderlessStockMove(StockMove stockMove, Map<Long, BigDecimal> qtyToInvoiceMap) throws AxelorException {
        int invoiceOperationType;
        int stockMoveType = stockMove.getTypeSelect();
        if (stockMove.getIsReversion().booleanValue()) {
            if (stockMoveType == 3) {
                invoiceOperationType = 4;
            } else {
                if (stockMoveType != 2) return null;
                invoiceOperationType = 2;
            }
        } else if (stockMoveType == 3) {
            invoiceOperationType = 1;
        } else {
            if (stockMoveType != 2) return null;
            invoiceOperationType = 3;
        }
        InvoiceGeneratorSupplyChain invoiceGenerator = new InvoiceGeneratorSupplyChain(stockMove, invoiceOperationType){

            public Invoice generate() throws AxelorException {
                return super.createInvoiceHeader();
            }
        };
        Invoice invoice = invoiceGenerator.generate();
        invoiceGenerator.populate(invoice, this.createInvoiceLines(invoice, stockMove, stockMove.getStockMoveLineList(), qtyToInvoiceMap));
        if (invoice == null) return invoice;
        this.extendInternalReference(stockMove, invoice);
        invoice.setAddressStr(((AddressService)Beans.get(AddressService.class)).computeAddressStr(invoice.getAddress()));
        if (stockMoveType == 2) {
            invoice.setHeadOfficeAddress(stockMove.getPartner().getHeadOfficeAddress());
        }
        this.invoiceRepository.save((Model)((Object)invoice));
        if (invoice != null) {
            Set<StockMove> stockMoveSet = invoice.getStockMoveSet();
            if (stockMoveSet == null) {
                stockMoveSet = new HashSet<StockMove>();
                invoice.setStockMoveSet(stockMoveSet);
            }
            stockMoveSet.add(stockMove);
        }
        this.invoiceRepository.save((Model)((Object)invoice));
        return invoice;
    }

    @Override
    public Invoice extendInternalReference(StockMove stockMove, Invoice invoice) {
        invoice.setInternalReference(StringTool.cutTooLongString((String)(stockMove.getStockMoveSeq() + ":" + invoice.getInternalReference())));
        return invoice;
    }

    @Override
    public List<InvoiceLine> createInvoiceLines(Invoice invoice, StockMove stockMove, List<StockMoveLine> stockMoveLineList, Map<Long, BigDecimal> qtyToInvoiceMap) throws AxelorException {
        ArrayList<InvoiceLine> invoiceLineList = new ArrayList<InvoiceLine>();
        List<StockMoveLine> stockMoveLineToInvoiceList = "com.axelor.apps.purchase.db.PurchaseOrder".equals(stockMove.getOriginTypeSelect()) && this.supplyChainConfigService.getSupplyChainConfig(invoice.getCompany()).getActivateIncStockMovePartialInvoicing() != false || "com.axelor.apps.sale.db.SaleOrder".equals(stockMove.getOriginTypeSelect()) && this.supplyChainConfigService.getSupplyChainConfig(invoice.getCompany()).getActivateOutStockMovePartialInvoicing() != false ? stockMoveLineList : this.getConsolidatedStockMoveLineList(stockMoveLineList);
        for (StockMoveLine stockMoveLine : stockMoveLineToInvoiceList) {
            Long id = stockMoveLine.getId();
            InvoiceLine invoiceLineCreated = qtyToInvoiceMap != null ? this.createInvoiceLine(invoice, stockMoveLine, qtyToInvoiceMap.get(id)) : this.createInvoiceLine(invoice, stockMoveLine, stockMoveLine.getRealQty().subtract(this.computeNonCanceledInvoiceQty(stockMoveLine)));
            if (invoiceLineCreated == null) continue;
            invoiceLineList.add(invoiceLineCreated);
        }
        return invoiceLineList;
    }

    @Override
    public InvoiceLine createInvoiceLine(Invoice invoice, StockMoveLine stockMoveLine, BigDecimal qty) throws AxelorException {
        Product product = stockMoveLine.getProduct();
        boolean isTitleLine = false;
        int sequence = 0;
        SaleOrderLine saleOrderLine = stockMoveLine.getSaleOrderLine();
        PurchaseOrderLine purchaseOrderLine = stockMoveLine.getPurchaseOrderLine();
        if (saleOrderLine != null) {
            sequence = saleOrderLine.getSequence();
        } else if (purchaseOrderLine != null) {
            if (purchaseOrderLine.getIsTitleLine().booleanValue()) {
                isTitleLine = true;
            }
            sequence = purchaseOrderLine.getSequence();
        }
        if (!(qty != null && qty.signum() != 0 && stockMoveLine.getRealQty().signum() != 0 || isTitleLine)) {
            return null;
        }
        if (product == null && !isTitleLine) {
            throw new AxelorException(4, I18n.get((String)"Incorrect product in the stock move %s"), new Object[]{stockMoveLine.getStockMove().getStockMoveSeq()});
        }
        InvoiceLineGeneratorSupplyChain invoiceLineGenerator = new InvoiceLineGeneratorSupplyChain(invoice, product, stockMoveLine.getProductName(), stockMoveLine.getDescription(), qty, stockMoveLine.getUnit(), sequence, false, stockMoveLine.getSaleOrderLine(), stockMoveLine.getPurchaseOrderLine(), stockMoveLine){

            public List<InvoiceLine> creates() throws AxelorException {
                InvoiceLine invoiceLine = this.createInvoiceLine();
                ArrayList<InvoiceLine> invoiceLines = new ArrayList<InvoiceLine>();
                invoiceLines.add(invoiceLine);
                return invoiceLines;
            }
        };
        List invoiceLines = invoiceLineGenerator.creates();
        InvoiceLine invoiceLine = null;
        if (invoiceLines != null && !invoiceLines.isEmpty()) {
            invoiceLine = (InvoiceLine)((Object)invoiceLines.get(0));
            if (!stockMoveLine.getIsMergedStockMoveLine().booleanValue()) {
                invoiceLine.setStockMoveLine(stockMoveLine);
            } else {
                StockMoveLine nonConsolidatedStockMoveLine = null;
                StockMove stockMove = stockMoveLine.getStockMove();
                if (saleOrderLine != null) {
                    nonConsolidatedStockMoveLine = (StockMoveLine)((Object)this.stockMoveLineRepository.all().filter("self.saleOrderLine.id = :saleOrderLineId AND self.stockMove.id = :stockMoveId AND self.id != :stockMoveLineId").bind("saleOrderLineId", (Object)saleOrderLine.getId()).bind("stockMoveId", (Object)stockMove.getId()).bind("stockMoveLineId", (Object)stockMoveLine.getId()).order("id").fetchOne());
                } else if (purchaseOrderLine != null) {
                    nonConsolidatedStockMoveLine = (StockMoveLine)((Object)this.stockMoveLineRepository.all().filter("self.purchaseOrderLine.id = :purchaseOrderLineId AND self.stockMove.id = :stockMoveId AND self.id != :stockMoveLineId").bind("purchaseOrderLineId", (Object)purchaseOrderLine.getId()).bind("stockMoveId", (Object)stockMove.getId()).bind("stockMoveLineId", (Object)stockMoveLine.getId()).order("id").fetchOne());
                }
                invoiceLine.setStockMoveLine(nonConsolidatedStockMoveLine);
                this.deleteConsolidatedStockMoveLine(stockMoveLine);
            }
        }
        return invoiceLine;
    }

    protected void deleteConsolidatedStockMoveLine(StockMoveLine stockMoveLine) {
        if (stockMoveLine.getStockMove() != null && stockMoveLine.getStockMove().getStockMoveLineList() != null) {
            stockMoveLine.getStockMove().getStockMoveLineList().remove((Object)stockMoveLine);
        }
        this.stockMoveLineRepository.remove((Model)((Object)stockMoveLine));
    }

    private List<StockMoveLine> getConsolidatedStockMoveLineList(List<StockMoveLine> stockMoveLineList) throws AxelorException {
        LinkedHashMap<SaleOrderLine, ArrayList<StockMoveLine>> stockMoveLineSaleMap = new LinkedHashMap<SaleOrderLine, ArrayList<StockMoveLine>>();
        LinkedHashMap<PurchaseOrderLine, ArrayList<StockMoveLine>> stockMoveLinePurchaseMap = new LinkedHashMap<PurchaseOrderLine, ArrayList<StockMoveLine>>();
        ArrayList<StockMoveLine> resultList = new ArrayList<StockMoveLine>();
        for (StockMoveLine stockMoveLine : stockMoveLineList) {
            List<StockMoveLine> list;
            if (stockMoveLine.getSaleOrderLine() != null) {
                list = (ArrayList<StockMoveLine>)stockMoveLineSaleMap.get((Object)stockMoveLine.getSaleOrderLine());
                if (list == null) {
                    list = new ArrayList<StockMoveLine>();
                    stockMoveLineSaleMap.put(stockMoveLine.getSaleOrderLine(), (ArrayList<StockMoveLine>)list);
                }
                list.add(stockMoveLine);
                continue;
            }
            if (stockMoveLine.getPurchaseOrderLine() != null) {
                list = (List)stockMoveLinePurchaseMap.get((Object)stockMoveLine.getPurchaseOrderLine());
                if (list == null) {
                    list = new ArrayList();
                    stockMoveLinePurchaseMap.put(stockMoveLine.getPurchaseOrderLine(), (ArrayList<StockMoveLine>)list);
                }
                list.add(stockMoveLine);
                continue;
            }
            resultList.add(stockMoveLine);
        }
        for (List stockMoveLines : stockMoveLineSaleMap.values()) {
            resultList.add(this.stockMoveLineServiceSupplychain.getMergedStockMoveLine(stockMoveLines));
        }
        for (List stockMoveLines : stockMoveLinePurchaseMap.values()) {
            resultList.add(this.stockMoveLineServiceSupplychain.getMergedStockMoveLine(stockMoveLines));
        }
        return resultList;
    }

    @Override
    public List<Map<String, Object>> getStockMoveLinesToInvoice(StockMove stockMove) throws AxelorException {
        ArrayList<Map<String, Object>> stockMoveLines = new ArrayList<Map<String, Object>>();
        for (StockMoveLine stockMoveLine : stockMove.getStockMoveLineList()) {
            BigDecimal qty = stockMoveLine.getRealQty().subtract(this.computeNonCanceledInvoiceQty(stockMoveLine));
            if (qty.compareTo(BigDecimal.ZERO) == 0) continue;
            HashMap<String, Object> stockMoveLineMap = new HashMap<String, Object>();
            stockMoveLineMap.put("productCode", stockMoveLine.getProduct() != null ? stockMoveLine.getProduct().getCode() : null);
            stockMoveLineMap.put("productName", stockMoveLine.getProductName());
            stockMoveLineMap.put("remainingQty", qty);
            stockMoveLineMap.put("realQty", stockMoveLine.getRealQty());
            stockMoveLineMap.put("qtyInvoiced", this.computeNonCanceledInvoiceQty(stockMoveLine));
            stockMoveLineMap.put("qtyToInvoice", BigDecimal.ZERO);
            stockMoveLineMap.put("invoiceAll", false);
            stockMoveLineMap.put("stockMoveLineId", stockMoveLine.getId());
            stockMoveLines.add(stockMoveLineMap);
        }
        return stockMoveLines;
    }

    @Override
    public BigDecimal computeNonCanceledInvoiceQty(StockMove stockMove) throws AxelorException {
        if (stockMove.getStockMoveLineList() == null) {
            return BigDecimal.ZERO;
        }
        BigDecimal nonCanceledInvoiceQtySum = BigDecimal.ZERO;
        for (StockMoveLine stockMoveLine : stockMove.getStockMoveLineList()) {
            nonCanceledInvoiceQtySum = nonCanceledInvoiceQtySum.add(this.computeNonCanceledInvoiceQty(stockMoveLine));
        }
        return nonCanceledInvoiceQtySum;
    }

    @Override
    public BigDecimal computeNonCanceledInvoiceQty(StockMoveLine stockMoveLine) throws AxelorException {
        List nonCanceledInvoiceLineList = this.invoiceLineRepository.all().filter("self.invoice.statusSelect != :invoiceCanceled AND self.stockMoveLine.id = :stockMoveLineId").bind("invoiceCanceled", (Object)4).bind("stockMoveLineId", (Object)stockMoveLine.getId()).fetch();
        BigDecimal nonCanceledInvoiceQty = BigDecimal.ZERO;
        for (InvoiceLine invoiceLine : nonCanceledInvoiceLineList) {
            if (this.isInvoiceRefundingStockMove(stockMoveLine.getStockMove(), invoiceLine.getInvoice())) {
                nonCanceledInvoiceQty = nonCanceledInvoiceQty.subtract(invoiceLine.getQty());
                continue;
            }
            nonCanceledInvoiceQty = nonCanceledInvoiceQty.add(invoiceLine.getQty());
        }
        return nonCanceledInvoiceQty;
    }

    @Override
    public void computeStockMoveInvoicingStatus(StockMove stockMove) {
        int invoicingStatus = 0;
        if (stockMove.getStockMoveLineList() != null && stockMove.getInvoiceSet() != null && !stockMove.getInvoiceSet().isEmpty()) {
            BigDecimal totalInvoicedQty = stockMove.getStockMoveLineList().stream().map(StockMoveLine::getQtyInvoiced).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            BigDecimal totalRealQty = stockMove.getStockMoveLineList().stream().map(StockMoveLine::getRealQty).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            if (totalInvoicedQty.signum() == 0 && totalRealQty.signum() == 0) {
                invoicingStatus = 2;
            } else if (totalInvoicedQty.signum() > 0 && totalRealQty.compareTo(totalInvoicedQty) > 0) {
                invoicingStatus = 1;
            } else if (totalRealQty.compareTo(totalInvoicedQty) == 0) {
                invoicingStatus = 2;
            }
        }
        stockMove.setInvoicingStatusSelect(invoicingStatus);
    }

    @Override
    public boolean isInvoiceRefundingStockMove(StockMove stockMove, Invoice invoice) throws AxelorException {
        boolean isReversionStockMove;
        boolean isRefundInvoice = InvoiceToolService.isRefund((Invoice)invoice);
        return isRefundInvoice != (isReversionStockMove = stockMove.getIsReversion().booleanValue());
    }
}

