/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service;

import com.axelor.apps.base.db.AppSupplychain;
import com.axelor.apps.base.db.repo.ProductRepository;
import com.axelor.apps.base.service.UnitConversionService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.apps.purchase.db.PurchaseOrderLine;
import com.axelor.apps.purchase.db.repo.PurchaseOrderRepository;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.apps.sale.db.repo.SaleOrderRepository;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.apps.stock.db.StockMoveLine;
import com.axelor.apps.stock.db.TrackingNumber;
import com.axelor.apps.stock.db.repo.StockMoveLineRepository;
import com.axelor.apps.stock.db.repo.StockMoveRepository;
import com.axelor.apps.stock.service.PartnerProductQualityRatingService;
import com.axelor.apps.stock.service.StockMoveLineService;
import com.axelor.apps.stock.service.StockMoveServiceImpl;
import com.axelor.apps.stock.service.StockMoveToolService;
import com.axelor.apps.supplychain.service.PurchaseOrderStockService;
import com.axelor.apps.supplychain.service.ReservedQtyService;
import com.axelor.apps.supplychain.service.SaleOrderStockService;
import com.axelor.apps.supplychain.service.StockMoveLineServiceSupplychain;
import com.axelor.apps.supplychain.service.StockMoveServiceSupplychain;
import com.axelor.apps.supplychain.service.app.AppSupplychainService;
import com.axelor.common.ObjectUtils;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.persistence.Query;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StockMoveServiceSupplychainImpl
extends StockMoveServiceImpl
implements StockMoveServiceSupplychain {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected AppSupplychainService appSupplyChainService;
    protected PurchaseOrderRepository purchaseOrderRepo;
    protected SaleOrderRepository saleOrderRepo;
    protected UnitConversionService unitConversionService;
    protected ReservedQtyService reservedQtyService;
    @Inject
    private StockMoveLineServiceSupplychain stockMoveLineServiceSupplychain;

    @Inject
    public StockMoveServiceSupplychainImpl(StockMoveLineService stockMoveLineService, StockMoveToolService stockMoveToolService, StockMoveLineRepository stockMoveLineRepository, AppBaseService appBaseService, StockMoveRepository stockMoveRepository, PartnerProductQualityRatingService partnerProductQualityRatingService, AppSupplychainService appSupplyChainService, PurchaseOrderRepository purchaseOrderRepo, SaleOrderRepository saleOrderRepo, UnitConversionService unitConversionService, ReservedQtyService reservedQtyService, ProductRepository productRepository) {
        super(stockMoveLineService, stockMoveToolService, stockMoveLineRepository, appBaseService, stockMoveRepository, partnerProductQualityRatingService, productRepository);
        this.appSupplyChainService = appSupplyChainService;
        this.purchaseOrderRepo = purchaseOrderRepo;
        this.saleOrderRepo = saleOrderRepo;
        this.unitConversionService = unitConversionService;
        this.reservedQtyService = reservedQtyService;
    }

    @Transactional(rollbackOn={Exception.class})
    public String realize(StockMove stockMove, boolean check) throws AxelorException {
        if (!((AppSupplychainService)Beans.get(AppSupplychainService.class)).isApp("supplychain")) {
            return super.realize(stockMove, check);
        }
        LOG.debug("R\u00e9alisation du mouvement de stock : {} ", (Object)stockMove.getStockMoveSeq());
        String newStockSeq = super.realize(stockMove, check);
        AppSupplychain appSupplychain = this.appSupplyChainService.getAppSupplychain();
        if ("com.axelor.apps.sale.db.SaleOrder".equals(stockMove.getOriginTypeSelect())) {
            this.updateSaleOrderLinesDeliveryState(stockMove, stockMove.getIsReversion() == false);
            SaleOrder saleOrder = (SaleOrder)((Object)this.saleOrderRepo.find(stockMove.getOriginId()));
            if (newStockSeq != null) {
                saleOrder.setDeliveryState(2);
            } else {
                ((SaleOrderStockService)Beans.get(SaleOrderStockService.class)).updateDeliveryState(saleOrder);
                if (appSupplychain.getTerminateSaleOrderOnDelivery().booleanValue()) {
                    this.terminateOrConfirmSaleOrderStatus(saleOrder);
                }
            }
            ((SaleOrderRepository)((Object)Beans.get(SaleOrderRepository.class))).save((Model)((Object)saleOrder));
        } else if ("com.axelor.apps.purchase.db.PurchaseOrder".equals(stockMove.getOriginTypeSelect())) {
            this.updatePurchaseOrderLines(stockMove, stockMove.getIsReversion() == false);
            PurchaseOrder purchaseOrder = (PurchaseOrder)((Object)this.purchaseOrderRepo.find(stockMove.getOriginId()));
            if (newStockSeq != null) {
                purchaseOrder.setReceiptState(2);
            } else {
                ((PurchaseOrderStockService)Beans.get(PurchaseOrderStockService.class)).updateReceiptState(purchaseOrder);
                if (appSupplychain.getTerminatePurchaseOrderOnReceipt().booleanValue()) {
                    this.finishOrValidatePurchaseOrderStatus(purchaseOrder);
                }
            }
            ((PurchaseOrderRepository)((Object)Beans.get(PurchaseOrderRepository.class))).save((Model)((Object)purchaseOrder));
        }
        if (this.appSupplyChainService.getAppSupplychain().getManageStockReservation().booleanValue()) {
            ((ReservedQtyService)Beans.get(ReservedQtyService.class)).updateReservedQuantity(stockMove, 3);
        }
        this.detachNonDeliveredStockMoveLines(stockMove);
        List trackingNumberIds = stockMove.getStockMoveLineList().stream().map(StockMoveLine::getTrackingNumber).filter(Objects::nonNull).map(TrackingNumber::getId).filter(Objects::nonNull).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(trackingNumberIds)) {
            Query update = JPA.em().createQuery("UPDATE FixedAsset self SET self.stockLocation = :stockLocation WHERE self.trackingNumber.id IN (:trackingNumber)");
            update.setParameter("stockLocation", (Object)stockMove.getToStockLocation());
            update.setParameter("trackingNumber", trackingNumberIds);
            update.executeUpdate();
        }
        return newStockSeq;
    }

    @Override
    public void detachNonDeliveredStockMoveLines(StockMove stockMove) {
        if (stockMove.getStockMoveLineList() == null) {
            return;
        }
        stockMove.getStockMoveLineList().stream().filter(line -> line.getRealQty().signum() == 0).forEach(line -> line.setSaleOrderLine(null));
    }

    @Transactional(rollbackOn={Exception.class})
    public void cancel(StockMove stockMove) throws AxelorException {
        if (!((AppSupplychainService)Beans.get(AppSupplychainService.class)).isApp("supplychain")) {
            super.cancel(stockMove);
            return;
        }
        if (stockMove.getStatusSelect() == 3) {
            if ("com.axelor.apps.sale.db.SaleOrder".equals(stockMove.getOriginTypeSelect())) {
                this.updateSaleOrderOnCancel(stockMove);
            }
            if ("com.axelor.apps.purchase.db.PurchaseOrder".equals(stockMove.getOriginTypeSelect())) {
                this.updatePurchaseOrderOnCancel(stockMove);
            }
        }
        super.cancel(stockMove);
        if (this.appSupplyChainService.getAppSupplychain().getManageStockReservation().booleanValue()) {
            ((ReservedQtyService)Beans.get(ReservedQtyService.class)).updateReservedQuantity(stockMove, 4);
        }
    }

    @Transactional(rollbackOn={Exception.class})
    public void plan(StockMove stockMove) throws AxelorException {
        super.plan(stockMove);
        AppSupplychainService appSupplychainService = (AppSupplychainService)Beans.get(AppSupplychainService.class);
        if (appSupplychainService.getAppSupplychain().getManageStockReservation().booleanValue() && appSupplychainService.isApp("supplychain")) {
            ((ReservedQtyService)Beans.get(ReservedQtyService.class)).updateReservedQuantity(stockMove, 2);
        }
    }

    @Transactional(rollbackOn={Exception.class})
    public void updateSaleOrderOnCancel(StockMove stockMove) throws AxelorException {
        SaleOrder so = (SaleOrder)((Object)this.saleOrderRepo.find(stockMove.getOriginId()));
        this.updateSaleOrderLinesDeliveryState(stockMove, stockMove.getIsReversion());
        ((SaleOrderStockService)Beans.get(SaleOrderStockService.class)).updateDeliveryState(so);
        if (((AppSupplychainService)Beans.get(AppSupplychainService.class)).getAppSupplychain().getTerminateSaleOrderOnDelivery().booleanValue()) {
            this.terminateOrConfirmSaleOrderStatus(so);
        }
    }

    protected void terminateOrConfirmSaleOrderStatus(SaleOrder saleOrder) {
        if (saleOrder.getDeliveryState() == 3) {
            saleOrder.setStatusSelect(4);
        } else {
            saleOrder.setStatusSelect(3);
        }
    }

    protected void updateSaleOrderLinesDeliveryState(StockMove stockMove, boolean qtyWasDelivered) throws AxelorException {
        for (StockMoveLine stockMoveLine : stockMove.getStockMoveLineList()) {
            if (stockMoveLine.getSaleOrderLine() == null) continue;
            SaleOrderLine saleOrderLine = stockMoveLine.getSaleOrderLine();
            BigDecimal realQty = this.unitConversionService.convert(stockMoveLine.getUnit(), saleOrderLine.getUnit(), stockMoveLine.getRealQty(), stockMoveLine.getRealQty().scale(), saleOrderLine.getProduct());
            if (stockMove.getTypeSelect() != 1) {
                if (qtyWasDelivered) {
                    saleOrderLine.setDeliveredQty(saleOrderLine.getDeliveredQty().add(realQty));
                } else {
                    saleOrderLine.setDeliveredQty(saleOrderLine.getDeliveredQty().subtract(realQty));
                }
            }
            if (saleOrderLine.getDeliveredQty().signum() == 0) {
                saleOrderLine.setDeliveryState(1);
                continue;
            }
            if (saleOrderLine.getDeliveredQty().compareTo(saleOrderLine.getQty()) < 0) {
                saleOrderLine.setDeliveryState(2);
                continue;
            }
            saleOrderLine.setDeliveryState(3);
        }
    }

    @Transactional(rollbackOn={Exception.class})
    public void updatePurchaseOrderOnCancel(StockMove stockMove) throws AxelorException {
        PurchaseOrder po = (PurchaseOrder)((Object)this.purchaseOrderRepo.find(stockMove.getOriginId()));
        this.updatePurchaseOrderLines(stockMove, stockMove.getIsReversion());
        ((PurchaseOrderStockService)Beans.get(PurchaseOrderStockService.class)).updateReceiptState(po);
        if (((AppSupplychainService)Beans.get(AppSupplychainService.class)).getAppSupplychain().getTerminatePurchaseOrderOnReceipt().booleanValue()) {
            this.finishOrValidatePurchaseOrderStatus(po);
        }
    }

    protected void finishOrValidatePurchaseOrderStatus(PurchaseOrder purchaseOrder) {
        if (purchaseOrder.getReceiptState() == 3) {
            purchaseOrder.setStatusSelect(4);
        } else {
            purchaseOrder.setStatusSelect(3);
        }
    }

    protected void updatePurchaseOrderLines(StockMove stockMove, boolean qtyWasReceived) throws AxelorException {
        for (StockMoveLine stockMoveLine : stockMove.getStockMoveLineList()) {
            if (stockMoveLine.getPurchaseOrderLine() == null) continue;
            PurchaseOrderLine purchaseOrderLine = stockMoveLine.getPurchaseOrderLine();
            BigDecimal realQty = this.unitConversionService.convert(stockMoveLine.getUnit(), purchaseOrderLine.getUnit(), stockMoveLine.getRealQty(), stockMoveLine.getRealQty().scale(), purchaseOrderLine.getProduct());
            if (qtyWasReceived) {
                purchaseOrderLine.setReceivedQty(purchaseOrderLine.getReceivedQty().add(realQty));
            } else {
                purchaseOrderLine.setReceivedQty(purchaseOrderLine.getReceivedQty().subtract(realQty));
            }
            if (purchaseOrderLine.getReceivedQty().signum() == 0) {
                purchaseOrderLine.setReceiptState(1);
                continue;
            }
            if (purchaseOrderLine.getReceivedQty().compareTo(purchaseOrderLine.getQty()) < 0) {
                purchaseOrderLine.setReceiptState(2);
                continue;
            }
            purchaseOrderLine.setReceiptState(3);
        }
    }

    protected StockMoveLine copySplittedStockMoveLine(StockMoveLine stockMoveLine) throws AxelorException {
        StockMoveLine newStockMoveLine = super.copySplittedStockMoveLine(stockMoveLine);
        AppSupplychainService appSupplychainService = (AppSupplychainService)Beans.get(AppSupplychainService.class);
        if (appSupplychainService.getAppSupplychain().getManageStockReservation().booleanValue() && appSupplychainService.isApp("supplychain")) {
            BigDecimal requestedReservedQty = stockMoveLine.getRequestedReservedQty().subtract(stockMoveLine.getRealQty()).max(BigDecimal.ZERO);
            newStockMoveLine.setRequestedReservedQty(requestedReservedQty);
            newStockMoveLine.setReservedQty(BigDecimal.ZERO);
            this.reservedQtyService.deallocateStockMoveLineAfterSplit(stockMoveLine, stockMoveLine.getReservedQty());
            stockMoveLine.setReservedQty(BigDecimal.ZERO);
        }
        return newStockMoveLine;
    }

    @Transactional(rollbackOn={Exception.class})
    public StockMove splitInto2(StockMove originalStockMove, List<StockMoveLine> modifiedStockMoveLines) throws AxelorException {
        StockMove newStockMove = super.splitInto2(originalStockMove, modifiedStockMoveLines);
        newStockMove.setOrigin(originalStockMove.getOrigin());
        newStockMove.setOriginTypeSelect(originalStockMove.getOriginTypeSelect());
        newStockMove.setOriginId(originalStockMove.getOriginId());
        return newStockMove;
    }

    protected StockMoveLine createSplitStockMoveLine(StockMove originalStockMove, StockMoveLine originalStockMoveLine, StockMoveLine modifiedStockMoveLine) {
        StockMoveLine newStockMoveLine = super.createSplitStockMoveLine(originalStockMove, originalStockMoveLine, modifiedStockMoveLine);
        if (originalStockMoveLine.getQty().compareTo(originalStockMoveLine.getRequestedReservedQty()) < 0) {
            newStockMoveLine.setRequestedReservedQty(originalStockMoveLine.getRequestedReservedQty().subtract(originalStockMoveLine.getQty()));
            originalStockMoveLine.setRequestedReservedQty(originalStockMoveLine.getQty());
        }
        newStockMoveLine.setPurchaseOrderLine(originalStockMoveLine.getPurchaseOrderLine());
        newStockMoveLine.setSaleOrderLine(originalStockMoveLine.getSaleOrderLine());
        return newStockMoveLine;
    }

    @Override
    public void verifyProductStock(StockMove stockMove) throws AxelorException {
        AppSupplychain appSupplychain = this.appSupplyChainService.getAppSupplychain();
        if (stockMove.getAvailabilityRequest().booleanValue() && stockMove.getStockMoveLineList() != null && appSupplychain.getIsVerifyProductStock().booleanValue() && stockMove.getFromStockLocation() != null) {
            StringJoiner notAvailableProducts = new StringJoiner(",");
            int counter = 1;
            for (StockMoveLine stockMoveLine : stockMove.getStockMoveLineList()) {
                boolean isAvailableProduct = this.stockMoveLineServiceSupplychain.isAvailableProduct(stockMove, stockMoveLine);
                if (isAvailableProduct || counter > 10) continue;
                notAvailableProducts.add(stockMoveLine.getProduct().getFullName());
                ++counter;
            }
            if (!Strings.isNullOrEmpty((String)notAvailableProducts.toString())) {
                throw new AxelorException(4, String.format(I18n.get((String)"Product stock for %s is not enough for availability request"), notAvailableProducts.toString()));
            }
        }
    }

    @Transactional(rollbackOn={Exception.class})
    public Optional<StockMove> generateReversion(StockMove stockMove) throws AxelorException {
        List<StockMoveLine> stockMoveLineList;
        Optional newStockMove = super.generateReversion(stockMove);
        List<StockMoveLine> list = stockMoveLineList = newStockMove.isPresent() ? ((StockMove)((Object)newStockMove.get())).getStockMoveLineList() : null;
        if (stockMoveLineList != null && !stockMoveLineList.isEmpty()) {
            for (StockMoveLine stockMoveLine : stockMoveLineList) {
                stockMoveLine.setQtyInvoiced(BigDecimal.ZERO);
            }
        }
        return newStockMove;
    }

    @Override
    public boolean isAllocatedStockMoveLineRemoved(StockMove stockMove) {
        StockMove storedStockMove = (StockMove)((Object)((StockMoveRepository)((Object)Beans.get(StockMoveRepository.class))).find(stockMove.getId()));
        Boolean isAllocatedStockMoveLineRemoved = false;
        if (ObjectUtils.notEmpty((Object)((Object)storedStockMove))) {
            List<StockMoveLine> stockMoveLineList = stockMove.getStockMoveLineList();
            List<StockMoveLine> storedStockMoveLineList = storedStockMove.getStockMoveLineList();
            if (stockMoveLineList != null && storedStockMoveLineList != null) {
                for (StockMoveLine stockMoveLine : storedStockMoveLineList) {
                    if (((StockMoveLineServiceSupplychain)Beans.get(StockMoveLineServiceSupplychain.class)).isAllocatedStockMoveLine(stockMoveLine) && !stockMoveLineList.contains((Object)stockMoveLine)) {
                        stockMoveLineList.add(stockMoveLine);
                        isAllocatedStockMoveLineRemoved = true;
                    }
                    if (!isAllocatedStockMoveLineRemoved.booleanValue()) continue;
                    stockMove.setStockMoveLineList(stockMoveLineList);
                }
            }
        }
        return isAllocatedStockMoveLineRemoved;
    }
}

