/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.service.PartnerPriceListService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.message.db.Template;
import com.axelor.apps.message.db.repo.MessageRepository;
import com.axelor.apps.message.db.repo.TemplateRepository;
import com.axelor.apps.message.service.TemplateMessageService;
import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.apps.purchase.db.SupplierCatalog;
import com.axelor.apps.purchase.db.repo.PurchaseOrderRepository;
import com.axelor.apps.purchase.service.PurchaseOrderLineService;
import com.axelor.apps.purchase.service.app.AppPurchaseService;
import com.axelor.apps.stock.db.StockConfig;
import com.axelor.apps.stock.db.StockLocation;
import com.axelor.apps.stock.db.StockLocationLine;
import com.axelor.apps.stock.db.StockRules;
import com.axelor.apps.stock.db.repo.StockConfigRepository;
import com.axelor.apps.stock.db.repo.StockRulesRepository;
import com.axelor.apps.stock.service.StockRulesServiceImpl;
import com.axelor.apps.supplychain.service.PurchaseOrderServiceSupplychainImpl;
import com.axelor.apps.supplychain.service.app.AppSupplychainService;
import com.axelor.auth.AuthUtils;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import javax.mail.MessagingException;

public class StockRulesServiceSupplychainImpl
extends StockRulesServiceImpl {
    protected PurchaseOrderLineService purchaseOrderLineService;
    protected PurchaseOrderRepository purchaseOrderRepo;
    protected TemplateRepository templateRepo;
    protected TemplateMessageService templateMessageService;
    protected MessageRepository messageRepo;
    protected StockConfigRepository stockConfigRepo;

    @Inject
    public StockRulesServiceSupplychainImpl(StockRulesRepository stockRuleRepo, PurchaseOrderLineService purchaseOrderLineService, PurchaseOrderRepository purchaseOrderRepo, TemplateRepository templateRepo, TemplateMessageService templateMessageService, MessageRepository messageRepo, StockConfigRepository stockConfigRepo) {
        super(stockRuleRepo);
        this.purchaseOrderLineService = purchaseOrderLineService;
        this.purchaseOrderRepo = purchaseOrderRepo;
        this.templateRepo = templateRepo;
        this.templateMessageService = templateMessageService;
        this.messageRepo = messageRepo;
        this.stockConfigRepo = stockConfigRepo;
    }

    @Transactional(rollbackOn={Exception.class})
    public void generatePurchaseOrder(Product product, BigDecimal qty, StockLocationLine stockLocationLine, int type) throws AxelorException {
        if (!((AppSupplychainService)Beans.get(AppSupplychainService.class)).isApp("supplychain")) {
            super.generatePurchaseOrder(product, qty, stockLocationLine, type);
            return;
        }
        StockLocation stockLocation = stockLocationLine.getStockLocation();
        if (stockLocation == null) {
            return;
        }
        StockRules stockRules = this.getStockRules(product, stockLocation, type, 2);
        if (stockRules == null) {
            return;
        }
        if (this.useMinStockRules(stockLocationLine, stockRules, qty, type)) {
            if (stockRules.getOrderAlertSelect().equals(1)) {
                this.generateAndSendMessage(stockRules);
            } else if (stockRules.getOrderAlertSelect().equals(2)) {
                BigDecimal minReorderQty = this.getDefaultSupplierMinQty(product);
                BigDecimal qtyToOrder = this.getQtyToOrder(qty, stockLocationLine, type, stockRules, minReorderQty);
                Partner supplierPartner = product.getDefaultSupplierPartner();
                if (supplierPartner != null) {
                    Company company = stockLocation.getCompany();
                    LocalDate today = ((AppBaseService)Beans.get(AppBaseService.class)).getTodayDate(company);
                    PurchaseOrderServiceSupplychainImpl purchaseOrderServiceSupplychainImpl = (PurchaseOrderServiceSupplychainImpl)Beans.get(PurchaseOrderServiceSupplychainImpl.class);
                    PurchaseOrder purchaseOrder = (PurchaseOrder)((Object)this.purchaseOrderRepo.save((Model)((Object)purchaseOrderServiceSupplychainImpl.createPurchaseOrder(AuthUtils.getUser(), company, null, supplierPartner.getCurrency(), today.plusDays(supplierPartner.getDeliveryDelay().intValue()), stockRules.getName(), null, stockLocation, today, ((PartnerPriceListService)Beans.get(PartnerPriceListService.class)).getDefaultPriceList(supplierPartner, 2), supplierPartner, null))));
                    purchaseOrder.addPurchaseOrderLineListItem(this.purchaseOrderLineService.createPurchaseOrderLine(purchaseOrder, product, null, null, qtyToOrder, product.getUnit()));
                    purchaseOrderServiceSupplychainImpl.computePurchaseOrder(purchaseOrder);
                    this.purchaseOrderRepo.save((Model)((Object)purchaseOrder));
                    if (stockRules.getAlert().booleanValue()) {
                        this.generateAndSendMessage(stockRules);
                    }
                }
            }
        }
    }

    public void generateAndSendMessage(StockRules stockRules) throws AxelorException {
        Template template = stockRules.getStockRuleMessageTemplate();
        if (template == null) {
            StockConfig stockConfig = (StockConfig)((Object)this.stockConfigRepo.all().filter("self.company = ?1 AND self.stockRuleMessageTemplate IS NOT NULL", new Object[]{stockRules.getStockLocation().getCompany()}).fetchOne());
            template = stockConfig != null ? stockConfig.getStockRuleMessageTemplate() : (Template)((Object)this.templateRepo.all().filter("self.metaModel.fullName = ?1 AND self.isSystem != true", new Object[]{StockRules.class.getName()}).fetchOne());
        }
        if (template != null) {
            try {
                this.templateMessageService.generateAndSendMessage((Model)stockRules, template);
            }
            catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException | MessagingException e) {
                throw new AxelorException(e, 4);
            }
        }
    }

    private BigDecimal getDefaultSupplierMinQty(Product product) {
        Partner defaultSupplierPartner = product.getDefaultSupplierPartner();
        if (((AppPurchaseService)Beans.get(AppPurchaseService.class)).getAppPurchase().getManageSupplierCatalog().booleanValue()) {
            List<SupplierCatalog> supplierCatalogList = product.getSupplierCatalogList();
            if (defaultSupplierPartner != null && supplierCatalogList != null) {
                for (SupplierCatalog supplierCatalog : supplierCatalogList) {
                    if (!supplierCatalog.getSupplierPartner().equals((Object)defaultSupplierPartner)) continue;
                    return supplierCatalog.getMinQty();
                }
            }
        }
        return BigDecimal.ZERO;
    }
}

