/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.PaymentCondition;
import com.axelor.apps.account.db.repo.InvoiceRepository;
import com.axelor.apps.account.service.invoice.InvoiceToolService;
import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.supplychain.db.Timetable;
import com.axelor.apps.supplychain.db.TimetableTemplate;
import com.axelor.apps.supplychain.db.TimetableTemplateLine;
import com.axelor.apps.supplychain.db.repo.TimetableRepository;
import com.axelor.apps.supplychain.service.PurchaseOrderInvoiceServiceImpl;
import com.axelor.apps.supplychain.service.SaleOrderInvoiceService;
import com.axelor.apps.supplychain.service.TimetableService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class TimetableServiceImpl
implements TimetableService {
    @Inject
    SaleOrderInvoiceService saleOrderInvoiceService;

    @Override
    @Transactional(rollbackOn={Exception.class})
    public Invoice generateInvoice(Timetable timetable) throws AxelorException {
        Invoice invoice = this.createInvoice(timetable);
        ((InvoiceRepository)((Object)Beans.get(InvoiceRepository.class))).save((Model)((Object)invoice));
        timetable.setInvoice(invoice);
        ((TimetableRepository)((Object)Beans.get(TimetableRepository.class))).save((Model)((Object)timetable));
        return invoice;
    }

    @Override
    public Invoice createInvoice(Timetable timetable) throws AxelorException {
        SaleOrder saleOrder = timetable.getSaleOrder();
        PurchaseOrder purchaseOrder = timetable.getPurchaseOrder();
        if (saleOrder != null) {
            if (saleOrder.getCurrency() == null) {
                throw new AxelorException((Model)((Object)timetable), 4, I18n.get((String)"Please, select a currency for the order %s"), new Object[]{saleOrder.getSaleOrderSeq()});
            }
            ArrayList<Long> timetableId = new ArrayList<Long>();
            timetableId.add(timetable.getId());
            Invoice invoice = this.saleOrderInvoiceService.generateInvoice(saleOrder, 4, BigDecimal.ZERO, true, null, timetableId);
            return invoice;
        }
        if (purchaseOrder != null) {
            if (purchaseOrder.getCurrency() == null) {
                throw new AxelorException((Model)((Object)timetable), 4, I18n.get((String)"Please, select a currency for the order %s"), new Object[]{purchaseOrder.getPurchaseOrderSeq()});
            }
            ArrayList<Long> timetableId = new ArrayList<Long>();
            timetableId.add(timetable.getId());
            return ((PurchaseOrderInvoiceServiceImpl)Beans.get(PurchaseOrderInvoiceServiceImpl.class)).generateInvoiceFromTimetableForPurchaseOrder(purchaseOrder, timetableId);
        }
        return null;
    }

    @Override
    public List<Timetable> applyTemplate(TimetableTemplate template, BigDecimal exTaxTotal, LocalDate computationDate) {
        ArrayList<Timetable> timetables = new ArrayList<Timetable>();
        for (TimetableTemplateLine templateLine : template.getTimetableTemplateLineList()) {
            Timetable timetable = new Timetable();
            timetable.setEstimatedDate(InvoiceToolService.getDueDate((PaymentCondition)templateLine.getPaymentCondition(), (LocalDate)computationDate));
            timetable.setPercentage(templateLine.getPercentage());
            timetable.setAmount(exTaxTotal.multiply(templateLine.getPercentage()).divide(BigDecimal.valueOf(100L)));
            timetables.add(timetable);
        }
        timetables.sort(Comparator.comparing(Timetable::getEstimatedDate));
        return timetables;
    }
}

