/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service.batch;

import com.axelor.apps.account.db.Move;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.apps.stock.db.repo.StockMoveRepository;
import com.axelor.apps.supplychain.db.SupplychainBatch;
import com.axelor.apps.supplychain.service.AccountingCutOffService;
import com.axelor.apps.supplychain.service.batch.BatchStrategy;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.time.LocalDate;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchAccountingCutOff
extends BatchStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected static final int FETCH_LIMIT = 1;
    protected AccountingCutOffService cutOffService;
    protected StockMoveRepository stockMoveRepository;

    @Inject
    public BatchAccountingCutOff(AccountingCutOffService cutOffService, StockMoveRepository stockMoveRepository) {
        this.cutOffService = cutOffService;
        this.stockMoveRepository = stockMoveRepository;
    }

    protected void process() {
        List<StockMove> stockMoveList;
        int offset = 0;
        SupplychainBatch supplychainBatch = this.batch.getSupplychainBatch();
        LocalDate moveDate = supplychainBatch.getMoveDate();
        LocalDate reverseMoveDate = supplychainBatch.getReverseMoveDate();
        boolean recoveredTax = supplychainBatch.getRecoveredTax();
        boolean ati = supplychainBatch.getAti();
        String moveDescription = supplychainBatch.getMoveDescription();
        int accountingCutOffTypeSelect = supplychainBatch.getAccountingCutOffTypeSelect();
        this.updateBatch(moveDate, accountingCutOffTypeSelect);
        Company company = supplychainBatch.getCompany();
        boolean includeNotStockManagedProduct = supplychainBatch.getIncludeNotStockManagedProduct();
        if (accountingCutOffTypeSelect == 0) {
            return;
        }
        while (!(stockMoveList = this.cutOffService.getStockMoves(company, accountingCutOffTypeSelect, moveDate, 1, offset)).isEmpty()) {
            this.findBatch();
            for (StockMove stockMove : stockMoveList) {
                ++offset;
                try {
                    List<Move> moveList = this.cutOffService.generateCutOffMoves(stockMove, moveDate, reverseMoveDate, accountingCutOffTypeSelect, recoveredTax, ati, moveDescription, includeNotStockManagedProduct);
                    if (moveList == null || moveList.isEmpty()) continue;
                    this.updateStockMove(stockMove);
                    for (Move move : moveList) {
                        this.updateAccountMove(move, false);
                    }
                }
                catch (AxelorException e) {
                    TraceBackService.trace((AxelorException)new AxelorException((Throwable)e, e.getCategory(), I18n.get((String)"StockMove") + " %s", new Object[]{stockMove.getStockMoveSeq()}), (String)"invoice", (long)this.batch.getId());
                    this.incrementAnomaly();
                    break;
                }
                catch (Exception e) {
                    TraceBackService.trace((Throwable)new Exception(String.format(I18n.get((String)"StockMove") + " %s", stockMove.getStockMoveSeq()), e), (String)"invoice", (long)this.batch.getId());
                    this.incrementAnomaly();
                    LOG.error("Anomaly generated for the stock move {}", (Object)stockMove.getStockMoveSeq());
                    break;
                }
            }
            JPA.clear();
        }
    }

    @Transactional
    public void updateBatch(LocalDate moveDate, int accountingCutOffTypeSelect) {
        this.batch.setMoveDate(moveDate);
        this.batch.setAccountingCutOffTypeSelect(accountingCutOffTypeSelect);
        this.batchRepo.save((Model)((Object)this.batch));
    }

    protected void stop() {
        String comment = I18n.get((String)"Accounting cut off generation report :") + " ";
        comment = comment + String.format("\t* %s " + I18n.get((String)"Stock move(s) processed") + "\n", this.batch.getDone());
        comment = comment + String.format("\t" + I18n.get((String)"* %s anomaly(ies)"), this.batch.getAnomaly());
        super.stop();
        this.addComment(comment);
    }
}

