/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service.batch;

import com.axelor.apps.base.db.repo.BlockingRepository;
import com.axelor.apps.base.service.BlockingService;
import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.apps.purchase.db.repo.PurchaseOrderRepository;
import com.axelor.apps.supplychain.db.SupplychainBatch;
import com.axelor.apps.supplychain.service.PurchaseOrderInvoiceService;
import com.axelor.apps.supplychain.service.batch.BatchOrderInvoicing;
import com.axelor.apps.tool.StringTool;
import com.axelor.db.JPA;
import com.axelor.db.Query;
import com.axelor.exception.service.TraceBackService;
import com.axelor.inject.Beans;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

public class BatchOrderInvoicingPurchase
extends BatchOrderInvoicing {
    protected void process() {
        List purchaseOrderList;
        SupplychainBatch supplychainBatch = this.batch.getSupplychainBatch();
        ArrayList<String> filterList = new ArrayList<String>();
        Query query = ((PurchaseOrderRepository)((Object)Beans.get(PurchaseOrderRepository.class))).all();
        if (supplychainBatch.getCompany() != null) {
            filterList.add("self.company = :company");
            query.bind("company", (Object)supplychainBatch.getCompany());
        }
        if (supplychainBatch.getSalespersonOrBuyerSet() != null && !supplychainBatch.getSalespersonOrBuyerSet().isEmpty()) {
            filterList.add("self.buyerUser IN (:buyerSet)");
            query.bind("buyerSet", supplychainBatch.getSalespersonOrBuyerSet());
        }
        if (supplychainBatch.getTeam() != null) {
            filterList.add("self.buyerUser IS NOT NULL AND self.buyerUser.activeTeam = :team");
            query.bind("team", (Object)supplychainBatch.getTeam());
        }
        if (!Strings.isNullOrEmpty((String)supplychainBatch.getDeliveryOrReceiptState())) {
            List receiptStateList = StringTool.getIntegerList((String)supplychainBatch.getDeliveryOrReceiptState());
            filterList.add("self.receiptState IN (:receiptStateList)");
            query.bind("receiptStateList", (Object)receiptStateList);
        }
        if (!Strings.isNullOrEmpty((String)supplychainBatch.getStatusSelect())) {
            List statusSelectList = StringTool.getIntegerList((String)supplychainBatch.getStatusSelect());
            filterList.add("self.statusSelect IN (:statusSelectList)");
            query.bind("statusSelectList", (Object)statusSelectList);
        }
        if (supplychainBatch.getOrderUpToDate() != null) {
            filterList.add("self.orderDate <= :orderUpToDate");
            query.bind("orderUpToDate", (Object)supplychainBatch.getOrderUpToDate());
        }
        filterList.add("self.amountInvoiced < self.exTaxTotal");
        filterList.add("NOT EXISTS (SELECT 1 FROM Invoice invoice WHERE invoice.statusSelect != :invoiceStatusSelect AND (invoice.purchaseOrder = self OR invoice.purchaseOrder IS NULL AND EXISTS (SELECT 1 FROM invoice.invoiceLineList invoiceLine WHERE invoiceLine.purchaseOrderLine MEMBER OF self.purchaseOrderLineList)))");
        filterList.add("self.supplierPartner.id NOT IN (" + ((BlockingService)Beans.get(BlockingService.class)).listOfBlockedPartner(supplychainBatch.getCompany(), BlockingRepository.INVOICING_BLOCKING.intValue()) + ")");
        query.bind("invoiceStatusSelect", (Object)4);
        ArrayList anomalyList = Lists.newArrayList((Object[])new Long[]{0L});
        filterList.add("self.id NOT IN (:anomalyList)");
        query.bind("anomalyList", (Object)anomalyList);
        String filter = filterList.stream().map(item -> String.format("(%s)", item)).collect(Collectors.joining(" AND "));
        query.filter(filter);
        PurchaseOrderInvoiceService purchaseOrderInvoiceService = (PurchaseOrderInvoiceService)Beans.get(PurchaseOrderInvoiceService.class);
        HashSet<Long> treatedSet = new HashSet<Long>();
        while (!(purchaseOrderList = query.fetch(10)).isEmpty()) {
            for (PurchaseOrder purchaseOrder : purchaseOrderList) {
                if (treatedSet.contains(purchaseOrder.getId())) {
                    throw new IllegalArgumentException("Invoice generation error");
                }
                treatedSet.add(purchaseOrder.getId());
                try {
                    purchaseOrderInvoiceService.generateInvoice(purchaseOrder);
                    this.incrementDone();
                }
                catch (Exception e) {
                    this.incrementAnomaly();
                    anomalyList.add(purchaseOrder.getId());
                    query.bind("anomalyList", (Object)anomalyList);
                    TraceBackService.trace((Throwable)e, (String)"invoice", (long)this.batch.getId());
                    e.printStackTrace();
                    break;
                }
            }
            JPA.clear();
        }
    }
}

