/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service.batch;

import com.axelor.apps.base.db.repo.BlockingRepository;
import com.axelor.apps.base.service.BlockingService;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.repo.SaleOrderRepository;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.apps.supplychain.db.SupplychainBatch;
import com.axelor.apps.supplychain.service.StockMoveInvoiceService;
import com.axelor.apps.supplychain.service.batch.BatchStrategy;
import com.axelor.db.JPA;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.TypedQuery;

public class BatchOutgoingStockMoveInvoicing
extends BatchStrategy {
    private StockMoveInvoiceService stockMoveInvoiceService;

    @Inject
    public BatchOutgoingStockMoveInvoicing(StockMoveInvoiceService stockMoveInvoiceService) {
        this.stockMoveInvoiceService = stockMoveInvoiceService;
    }

    protected void process() {
        List stockMoveList;
        SupplychainBatch supplychainBatch = this.batch.getSupplychainBatch();
        ArrayList anomalyList = Lists.newArrayList((Object[])new Long[]{0L});
        SaleOrderRepository saleRepo = (SaleOrderRepository)((Object)Beans.get(SaleOrderRepository.class));
        TypedQuery query = JPA.em().createQuery("SELECT self FROM StockMove self WHERE self.statusSelect = :statusSelect AND self.originTypeSelect LIKE :typeSaleOrder AND (SELECT count(invoice.id) FROM Invoice invoice WHERE invoice.statusSelect != :invoiceStatusCanceled AND invoice MEMBER OF self.invoiceSet) = 0AND self.id NOT IN (:anomalyList) AND self.partner.id NOT IN (" + ((BlockingService)Beans.get(BlockingService.class)).listOfBlockedPartner(supplychainBatch.getCompany(), BlockingRepository.INVOICING_BLOCKING.intValue()) + ") AND :batch NOT MEMBER OF self.batchSet ORDER BY self.id", StockMove.class).setParameter("statusSelect", (Object)3).setParameter("typeSaleOrder", (Object)"com.axelor.apps.sale.db.SaleOrder").setParameter("invoiceStatusCanceled", (Object)4).setParameter("anomalyList", (Object)anomalyList).setParameter("batch", (Object)this.batch).setMaxResults(10);
        while (!(stockMoveList = query.getResultList()).isEmpty()) {
            for (StockMove stockMove : stockMoveList) {
                try {
                    this.stockMoveInvoiceService.createInvoiceFromSaleOrder(stockMove, (SaleOrder)((Object)saleRepo.find(stockMove.getOriginId())), null);
                    this.updateStockMove(stockMove);
                }
                catch (Exception e) {
                    this.incrementAnomaly();
                    anomalyList.add(stockMove.getId());
                    query.setParameter("anomalyList", (Object)anomalyList);
                    TraceBackService.trace((Throwable)e, (String)"invoice", (long)this.batch.getId());
                    break;
                }
            }
            JPA.clear();
        }
    }

    protected void stop() {
        StringBuilder sb = new StringBuilder();
        sb.append(I18n.get((String)"Outgoing stock move invoicing report:"));
        sb.append(String.format(I18n.get((String)"%d outgoing stock move processed successfully,", (String)"%d outgoing stock moves processed successfully,", (int)this.batch.getDone()), this.batch.getDone()));
        sb.append(String.format(I18n.get((String)"%d anomaly.", (String)"%d anomalies.", (int)this.batch.getAnomaly()), this.batch.getAnomaly()));
        this.addComment(sb.toString());
        super.stop();
    }
}

