/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service.declarationofexchanges;

import com.axelor.app.AppSettings;
import com.axelor.apps.supplychain.db.DeclarationOfExchanges;
import com.axelor.apps.tool.StringTool;
import com.axelor.db.Model;
import com.axelor.dms.db.DMSFile;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.MetaFiles;
import com.axelor.meta.db.MetaFile;
import com.google.common.collect.ImmutableMap;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.lang3.tuple.Pair;

public abstract class DeclarationOfExchangesExporter {
    protected final Map<String, ThrowableSupplier<String, AxelorException>> exportFuncMap = ImmutableMap.of((Object)"csv", this::exportToCSV, (Object)"pdf", this::exportToPDF);
    protected final DeclarationOfExchanges declarationOfExchanges;
    protected final ResourceBundle bundle;
    protected final String name;
    protected List<String> columnHeadersList;

    public DeclarationOfExchangesExporter(DeclarationOfExchanges declarationOfExchanges, ResourceBundle bundle, String name, List<String> columnHeadersList) {
        this.declarationOfExchanges = declarationOfExchanges;
        this.bundle = bundle;
        this.name = name;
        this.columnHeadersList = columnHeadersList;
    }

    public Pair<Path, String> export() throws AxelorException {
        Path path = Paths.get(this.exportFuncMap.getOrDefault(this.declarationOfExchanges.getFormatSelect(), this::exportToUnsupported).get(), new String[0]);
        return Pair.of((Object)path, (Object)this.getTitle());
    }

    protected abstract String exportToCSV() throws AxelorException;

    protected abstract String exportToPDF() throws AxelorException;

    protected String exportToUnsupported() {
        throw new UnsupportedOperationException(String.format("Unsupported format: %s", this.declarationOfExchanges.getFormatSelect()));
    }

    protected String getTranslatedName() {
        return this.getTranslation(this.name);
    }

    protected String[] getTranslatedHeaders() {
        String[] headers = new String[this.columnHeadersList.size()];
        for (int i = 0; i < this.columnHeadersList.size(); ++i) {
            headers[i] = this.getTranslation(this.columnHeadersList.get(i));
        }
        return headers;
    }

    protected String getExportDir() {
        AppSettings appSettings = AppSettings.get();
        String exportDir = appSettings.get("data.export.dir");
        if (exportDir == null) {
            throw new IllegalArgumentException(I18n.get((String)"Export directory is not configured."));
        }
        return exportDir;
    }

    protected String getTitle() {
        String translatedName = this.getTranslatedName();
        return String.format("%s %s", translatedName, this.declarationOfExchanges.getPeriod().getName());
    }

    protected String getFileName() {
        String title = this.getTitle();
        String filename = String.format("%s.%s", title, this.declarationOfExchanges.getFormatSelect());
        return StringTool.getFilename((String)filename);
    }

    protected Path getFilePath() {
        String fileName = this.getFileName();
        return Paths.get(this.getExportDir(), fileName);
    }

    protected String getTranslation(String text) {
        return this.bundle.getString(text);
    }

    protected String attach(String path) {
        DMSFile dmsFile;
        try (FileInputStream is = new FileInputStream(path);){
            dmsFile = ((MetaFiles)Beans.get(MetaFiles.class)).attach((InputStream)is, this.getFileName(), (Model)((Object)this.declarationOfExchanges));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        MetaFile metaFile = dmsFile.getMetaFile();
        return String.format("ws/rest/com.axelor.meta.db.MetaFile/%d/content/download?v=%d/%s", metaFile.getId(), metaFile.getVersion(), path);
    }

    @FunctionalInterface
    private static interface ThrowableSupplier<T, E extends Throwable> {
        public T get() throws E;
    }
}

