/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service.declarationofexchanges;

import com.axelor.apps.ReportFactory;
import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.base.db.Address;
import com.axelor.apps.base.db.Period;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.report.engine.ReportSettings;
import com.axelor.apps.stock.db.ModeOfTransport;
import com.axelor.apps.stock.db.NatureOfTransaction;
import com.axelor.apps.stock.db.Regime;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.apps.stock.db.StockMoveLine;
import com.axelor.apps.stock.db.repo.StockMoveLineRepository;
import com.axelor.apps.stock.service.StockMoveToolService;
import com.axelor.apps.supplychain.db.DeclarationOfExchanges;
import com.axelor.apps.supplychain.service.declarationofexchanges.DeclarationOfExchangesExporter;
import com.axelor.apps.tool.file.CsvTool;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.common.StringUtils;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.common.io.MoreFiles;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;

public class DeclarationOfExchangesExporterGoods
extends DeclarationOfExchangesExporter {
    protected static final String NAME_GOODS = "Declaration of exchanges of goods";
    protected static final String LINE_NUM = "Line number";
    protected static final String NOMENCLATURE = "Nomenclature";
    protected static final String SRC_DST_COUNTRY = "Source or destination country";
    protected static final String FISC_VAL = "Fiscal value";
    protected static final String REGIME = "Regime";
    protected static final String MASS = "Net mass";
    protected static final String UNITS = "Supplementary unit";
    protected static final String NAT_TRANS = "Nature of transaction";
    protected static final String TRANSP = "Mode of transport";
    protected static final String DEPT = "Department";
    protected static final String COUNTRY_ORIG = "Country of origin";
    protected static final String ACQUIRER = "Acquirer";
    protected static final String PRODUCT_CODE = "Product code";
    protected static final String PRODUCT_NAME = "Product name";
    protected static final String PARTNER_SEQ = "Partner";
    protected static final String INVOICE = "Invoice";
    protected StockMoveToolService stockMoveToolService = (StockMoveToolService)Beans.get(StockMoveToolService.class);

    public DeclarationOfExchangesExporterGoods(DeclarationOfExchanges declarationOfExchanges, ResourceBundle bundle) {
        super(declarationOfExchanges, bundle, NAME_GOODS, new ArrayList<String>(Arrays.asList(LINE_NUM, NOMENCLATURE, SRC_DST_COUNTRY, FISC_VAL, REGIME, MASS, UNITS, NAT_TRANS, TRANSP, DEPT, COUNTRY_ORIG, ACQUIRER, PRODUCT_CODE, PRODUCT_NAME, PARTNER_SEQ, INVOICE)));
    }

    @Override
    public String exportToCSV() throws AxelorException {
        Path path = this.getFilePath();
        Period period = this.declarationOfExchanges.getPeriod();
        List stockMoveLines = ((StockMoveLineRepository)((Object)Beans.get(StockMoveLineRepository.class))).findForDeclarationOfExchanges(period.getFromDate(), period.getToDate(), this.declarationOfExchanges.getProductTypeSelect(), this.declarationOfExchanges.getStockMoveTypeSelect(), this.declarationOfExchanges.getCountry(), this.declarationOfExchanges.getCompany()).fetch();
        ArrayList<String[]> dataList = new ArrayList<String[]>(stockMoveLines.size());
        int lineNum = 1;
        for (StockMoveLine stockMoveLine : stockMoveLines) {
            String[] data = this.exportLineToCsv(stockMoveLine, lineNum);
            if (data == null || data.length == 0) continue;
            dataList.add(data);
            ++lineNum;
        }
        try {
            MoreFiles.createParentDirectories((Path)path, (FileAttribute[])new FileAttribute[0]);
            CsvTool.csvWriter((String)path.getParent().toString(), (String)path.getFileName().toString(), (char)';', (String[])this.getTranslatedHeaders(), dataList);
        }
        catch (IOException e) {
            throw new AxelorException((Throwable)e, 4, e.getLocalizedMessage());
        }
        return this.attach(path.toString());
    }

    protected String[] exportLineToCsv(StockMoveLine stockMoveLine, int lineNum) throws AxelorException {
        String dept;
        String srcDstCountry;
        ModeOfTransport modeOfTransport;
        BigDecimal fiscalValue;
        String[] data = new String[this.columnHeadersList.size()];
        StockMove stockMove = stockMoveLine.getStockMove();
        String customsCode = stockMoveLine.getCustomsCode();
        Product product = stockMoveLine.getProduct();
        if (StringUtils.isBlank((CharSequence)customsCode)) {
            if (product == null) {
                customsCode = I18n.get((String)"Product is missing.");
            }
            if (product != null && product.getCustomsCodeNomenclature() != null) {
                customsCode = product.getCustomsCodeNomenclature().getCode();
            }
            if (StringUtils.isBlank((CharSequence)customsCode)) {
                customsCode = String.format(I18n.get((String)"Customs code nomenclature is missing on product %s."), product.getCode());
            }
        }
        if ((fiscalValue = stockMoveLine.getCompanyUnitPriceUntaxed().multiply(stockMoveLine.getRealQty()).setScale(0, RoundingMode.HALF_UP)).compareTo(BigDecimal.ZERO) <= 0) {
            return new String[0];
        }
        Regime regime = stockMoveLine.getRegime();
        if (regime == null) {
            if (stockMove.getTypeSelect() == 2) {
                regime = Regime.EXONERATED_SHIPMENT_AND_TRANSFER;
            } else if (stockMove.getTypeSelect() == 3) {
                regime = Regime.INTRACOMMUNITY_ACQUISITION_TAXABLE_IN_FRANCE;
            }
        }
        BigDecimal totalNetMass = stockMoveLine.getTotalNetMass().setScale(0, RoundingMode.HALF_UP);
        BigInteger supplementaryUnit = stockMoveLine.getRealQty().setScale(0, RoundingMode.CEILING).toBigInteger();
        NatureOfTransaction natTrans = stockMoveLine.getNatureOfTransaction();
        if (natTrans == null) {
            NatureOfTransaction natureOfTransaction = natTrans = stockMove.getIsReversion() != false ? NatureOfTransaction.RETURN_OF_GOODS : NatureOfTransaction.FIRM_PURCHASE_OR_SALE;
        }
        if ((modeOfTransport = stockMove.getModeOfTransport()) == null) {
            modeOfTransport = ModeOfTransport.CONSIGNMENTS_BY_POST;
        }
        try {
            Address partnerAddress = this.stockMoveToolService.getPartnerAddress(stockMoveLine.getStockMove());
            srcDstCountry = partnerAddress.getAddressL7Country().getAlpha2Code();
        }
        catch (AxelorException e) {
            srcDstCountry = e.getMessage();
        }
        try {
            Address companyAddress = this.stockMoveToolService.getCompanyAddress(stockMoveLine.getStockMove());
            dept = companyAddress.getCity().getDepartment().getCode();
        }
        catch (AxelorException e) {
            dept = e.getMessage();
        }
        String countryOrigCode = stockMoveLine.getCountryOfOrigin() != null ? stockMoveLine.getCountryOfOrigin().getAlpha2Code() : (stockMove.getTypeSelect() == 3 ? srcDstCountry : "");
        String taxNbr = stockMove.getTypeSelect() == 2 && stockMoveLine.getRegime() != Regime.OTHER_EXPEDITIONS ? (stockMove.getPartner() == null ? String.format(I18n.get((String)"Partner is missing on stock move %s."), stockMove.getName()) : (StringUtils.isBlank((CharSequence)stockMove.getPartner().getTaxNbr()) ? String.format(I18n.get((String)"Tax number is missing on partner %s."), stockMove.getPartner().getName()) : stockMove.getPartner().getTaxNbr())) : "";
        String partnerSeq = "";
        if (stockMove.getPartner() != null) {
            partnerSeq = stockMove.getPartner().getPartnerSeq();
        }
        String productCode = "";
        String productName = "";
        if (product != null) {
            productCode = product.getCode();
            productName = product.getName();
        }
        String invoiceId = "";
        Set<Invoice> invoiceSet = stockMove.getInvoiceSet();
        if (invoiceSet != null) {
            for (Invoice invoice : invoiceSet) {
                if (invoice.getStatusSelect() != 3) continue;
                invoiceId = invoiceId + invoice.getInvoiceId() + "|";
            }
            if (invoiceId != null && !invoiceId.isEmpty()) {
                invoiceId = invoiceId.substring(0, invoiceId.length() - 1);
            }
        }
        data[this.columnHeadersList.indexOf((Object)LINE_NUM)] = String.valueOf(lineNum);
        data[this.columnHeadersList.indexOf((Object)NOMENCLATURE)] = customsCode;
        data[this.columnHeadersList.indexOf((Object)SRC_DST_COUNTRY)] = srcDstCountry;
        data[this.columnHeadersList.indexOf((Object)FISC_VAL)] = String.valueOf(fiscalValue);
        data[this.columnHeadersList.indexOf((Object)REGIME)] = String.valueOf(regime.getValue());
        data[this.columnHeadersList.indexOf((Object)MASS)] = String.valueOf(totalNetMass);
        data[this.columnHeadersList.indexOf((Object)UNITS)] = String.valueOf(supplementaryUnit);
        data[this.columnHeadersList.indexOf((Object)NAT_TRANS)] = String.valueOf(natTrans.getValue());
        data[this.columnHeadersList.indexOf((Object)TRANSP)] = String.valueOf(modeOfTransport.getValue());
        data[this.columnHeadersList.indexOf((Object)DEPT)] = dept;
        data[this.columnHeadersList.indexOf((Object)COUNTRY_ORIG)] = countryOrigCode;
        data[this.columnHeadersList.indexOf((Object)ACQUIRER)] = taxNbr;
        data[this.columnHeadersList.indexOf((Object)PRODUCT_CODE)] = productCode;
        data[this.columnHeadersList.indexOf((Object)PRODUCT_NAME)] = productName;
        data[this.columnHeadersList.indexOf((Object)PARTNER_SEQ)] = partnerSeq;
        data[this.columnHeadersList.indexOf((Object)INVOICE)] = invoiceId;
        return data;
    }

    @Override
    protected String exportToPDF() throws AxelorException {
        return ReportFactory.createReport((String)"DeclarationOfExchangesOfGoods.rptdesign", (String)this.getTitle()).addParam("DeclarationOfExchangesId", (Object)this.declarationOfExchanges.getId()).addParam("UserId", Optional.ofNullable(AuthUtils.getUser()).map(User::getId).orElse(null)).addParam("Locale", (Object)ReportSettings.getPrintingLocale()).addFormat(this.declarationOfExchanges.getFormatSelect()).toAttach((Model)((Object)this.declarationOfExchanges)).generate().getFileLink();
    }
}

