/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service.declarationofexchanges;

import com.axelor.apps.ReportFactory;
import com.axelor.apps.base.db.Period;
import com.axelor.apps.report.engine.ReportSettings;
import com.axelor.apps.stock.db.Regime;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.apps.stock.db.StockMoveLine;
import com.axelor.apps.stock.db.repo.StockMoveLineRepository;
import com.axelor.apps.supplychain.db.DeclarationOfExchanges;
import com.axelor.apps.supplychain.service.declarationofexchanges.DeclarationOfExchangesExporter;
import com.axelor.apps.tool.file.CsvTool;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.common.StringUtils;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.common.io.MoreFiles;
import com.google.inject.Inject;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;

public class DeclarationOfExchangesExporterServices
extends DeclarationOfExchangesExporter {
    private static final String NAME_SERVICES = "European declaration of services";
    protected static final String LINE_NUM = "Line number";
    protected static final String FISC_VAL = "Fiscal value";
    protected static final String TAKER = "Taker";

    @Inject
    public DeclarationOfExchangesExporterServices(DeclarationOfExchanges declarationOfExchanges, ResourceBundle bundle) {
        super(declarationOfExchanges, bundle, NAME_SERVICES, new ArrayList<String>(Arrays.asList(LINE_NUM, FISC_VAL, TAKER)));
    }

    @Override
    protected String exportToCSV() throws AxelorException {
        Path path = this.getFilePath();
        Period period = this.declarationOfExchanges.getPeriod();
        List stockMoveLines = ((StockMoveLineRepository)((Object)Beans.get(StockMoveLineRepository.class))).findForDeclarationOfExchanges(period.getFromDate(), period.getToDate(), this.declarationOfExchanges.getProductTypeSelect(), this.declarationOfExchanges.getStockMoveTypeSelect(), this.declarationOfExchanges.getCountry(), this.declarationOfExchanges.getCompany()).fetch();
        ArrayList<String[]> dataList = new ArrayList<String[]>(stockMoveLines.size());
        int lineNum = 1;
        for (StockMoveLine stockMoveLine : stockMoveLines) {
            String taxNbr;
            String[] data = new String[this.columnHeadersList.size()];
            StockMove stockMove = stockMoveLine.getStockMove();
            BigDecimal fiscalValue = stockMoveLine.getUnitPriceUntaxed().multiply(stockMoveLine.getRealQty()).setScale(0, RoundingMode.HALF_UP);
            if (stockMove.getTypeSelect() == 2 && stockMoveLine.getRegime() != Regime.OTHER_EXPEDITIONS) {
                String string;
                if (stockMove.getPartner() == null) {
                    string = String.format(I18n.get((String)"Partner is missing on stock move %s."), stockMove.getName());
                }
                if (StringUtils.isBlank((CharSequence)stockMove.getPartner().getTaxNbr())) {
                    string = String.format(I18n.get((String)"Tax number is missing on partner %s."), stockMove.getPartner().getName());
                }
                taxNbr = stockMove.getPartner().getTaxNbr();
            } else {
                taxNbr = "";
            }
            data[this.columnHeadersList.indexOf((Object)LINE_NUM)] = String.valueOf(lineNum++);
            data[this.columnHeadersList.indexOf((Object)FISC_VAL)] = String.valueOf(fiscalValue);
            data[this.columnHeadersList.indexOf((Object)TAKER)] = taxNbr;
            dataList.add(data);
        }
        try {
            MoreFiles.createParentDirectories((Path)path, (FileAttribute[])new FileAttribute[0]);
            CsvTool.csvWriter((String)path.getParent().toString(), (String)path.getFileName().toString(), (char)';', (String[])this.getTranslatedHeaders(), dataList);
        }
        catch (IOException e) {
            throw new AxelorException((Throwable)e, 4, e.getLocalizedMessage());
        }
        return this.attach(path.toString());
    }

    @Override
    protected String exportToPDF() throws AxelorException {
        return ReportFactory.createReport((String)"DeclarationOfServices.rptdesign", (String)this.getTitle()).addParam("DeclarationOfExchangesId", (Object)this.declarationOfExchanges.getId()).addParam("UserId", Optional.ofNullable(AuthUtils.getUser()).map(User::getId).orElse(null)).addParam("Locale", (Object)ReportSettings.getPrintingLocale()).addParam("Timezone", this.declarationOfExchanges.getCompany() != null ? this.declarationOfExchanges.getCompany().getTimezone() : null).addFormat(this.declarationOfExchanges.getFormatSelect()).toAttach((Model)((Object)this.declarationOfExchanges)).generate().getFileLink();
    }
}

