/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service.declarationofexchanges;

import com.axelor.apps.base.db.EconomicArea;
import com.axelor.apps.stock.service.app.AppStockService;
import com.axelor.apps.stock.service.config.StockConfigService;
import com.axelor.apps.supplychain.db.DeclarationOfExchanges;
import com.axelor.apps.supplychain.service.declarationofexchanges.DeclarationOfExchangesExporter;
import com.axelor.apps.supplychain.service.declarationofexchanges.DeclarationOfExchangesExporterGoods;
import com.axelor.apps.supplychain.service.declarationofexchanges.DeclarationOfExchangesExporterServices;
import com.axelor.apps.supplychain.service.declarationofexchanges.DeclarationOfExchangesService;
import com.axelor.auth.AuthUtils;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.lang3.tuple.Pair;

public class DeclarationOfExchangesServiceImpl
implements DeclarationOfExchangesService {
    protected Map<String, Map<String, Class<? extends DeclarationOfExchangesExporter>>> exportServiceClassMap;
    protected StockConfigService stockConfigService;

    @Inject
    public DeclarationOfExchangesServiceImpl(StockConfigService stockConfigService) {
        this.stockConfigService = stockConfigService;
    }

    @Override
    public Pair<Path, String> export(DeclarationOfExchanges declarationOfExchanges) throws AxelorException {
        DeclarationOfExchangesExporter exporter;
        if (declarationOfExchanges.getCountry().getEconomicArea() == null) {
            throw new AxelorException((Model)((Object)declarationOfExchanges.getCountry()), 4, I18n.get((String)"No economic area is configured for %s."), new Object[]{declarationOfExchanges.getCountry().getName()});
        }
        Map<String, Class<? extends DeclarationOfExchangesExporter>> map = null;
        EconomicArea economicArea = ((AppStockService)Beans.get(AppStockService.class)).getAppStock().getEconomicArea();
        if (economicArea == null) {
            throw new AxelorException((Model)((Object)declarationOfExchanges), 4, I18n.get((String)"Please set an economic are in AppStock."));
        }
        this.exportServiceClassMap = this.getExportServiceClassMap(economicArea);
        map = this.exportServiceClassMap.get(declarationOfExchanges.getCountry().getEconomicArea().getCode());
        if (map == null) {
            throw new AxelorException((Model)((Object)declarationOfExchanges), 4, I18n.get((String)"Declaration of exchanges for %s is not supported."), new Object[]{declarationOfExchanges.getCountry().getEconomicArea().getName()});
        }
        Class<? extends DeclarationOfExchangesExporter> exportServiceClass = map.get(declarationOfExchanges.getProductTypeSelect());
        String languageCode = AuthUtils.getUser().getLanguage();
        ResourceBundle bundle = I18n.getBundle((Locale)new Locale(languageCode));
        if (exportServiceClass == null) {
            throw new UnsupportedOperationException(String.format(I18n.get((String)"Unsupported product type: %s"), declarationOfExchanges.getProductTypeSelect()));
        }
        try {
            exporter = exportServiceClass.getConstructor(DeclarationOfExchanges.class, ResourceBundle.class).newInstance(new Object[]{declarationOfExchanges, bundle});
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new AxelorException((Throwable)e, (Model)((Object)declarationOfExchanges), 5, e.getLocalizedMessage());
        }
        return exporter.export();
    }

    @Override
    public Map<String, Map<String, Class<? extends DeclarationOfExchangesExporter>>> getExportServiceClassMap(EconomicArea economicArea) {
        return ImmutableMap.of((Object)economicArea.getCode(), (Object)ImmutableMap.of((Object)"storable", DeclarationOfExchangesExporterGoods.class, (Object)"service", DeclarationOfExchangesExporterServices.class));
    }
}

