/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service.invoice.generator;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.service.invoice.generator.InvoiceGenerator;
import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.apps.supplychain.service.app.AppSupplychainService;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;

public abstract class InvoiceGeneratorSupplyChain
extends InvoiceGenerator {
    protected SaleOrder saleOrder;
    protected PurchaseOrder purchaseOrder;

    protected InvoiceGeneratorSupplyChain(SaleOrder saleOrder) throws AxelorException {
        this(saleOrder, false);
    }

    protected InvoiceGeneratorSupplyChain(SaleOrder saleOrder, boolean isRefund) throws AxelorException {
        super(isRefund ? 4 : 3, saleOrder.getCompany(), saleOrder.getPaymentCondition(), isRefund ? saleOrder.getClientPartner().getOutPaymentMode() : saleOrder.getPaymentMode(), saleOrder.getMainInvoicingAddress(), saleOrder.getClientPartner(), saleOrder.getContactPartner(), saleOrder.getCurrency(), saleOrder.getPriceList(), saleOrder.getSaleOrderSeq(), saleOrder.getExternalReference(), saleOrder.getInAti(), saleOrder.getCompanyBankDetails(), saleOrder.getTradingName());
        this.saleOrder = saleOrder;
    }

    protected InvoiceGeneratorSupplyChain(PurchaseOrder purchaseOrder) throws AxelorException {
        this(purchaseOrder, false);
    }

    protected InvoiceGeneratorSupplyChain(PurchaseOrder purchaseOrder, boolean isRefund) throws AxelorException {
        super(isRefund ? 2 : 1, purchaseOrder.getCompany(), purchaseOrder.getPaymentCondition(), isRefund ? purchaseOrder.getSupplierPartner().getInPaymentMode() : purchaseOrder.getPaymentMode(), null, purchaseOrder.getSupplierPartner(), purchaseOrder.getContactPartner(), purchaseOrder.getCurrency(), purchaseOrder.getPriceList(), purchaseOrder.getPurchaseOrderSeq(), purchaseOrder.getExternalReference(), purchaseOrder.getInAti(), purchaseOrder.getCompanyBankDetails(), purchaseOrder.getTradingName());
        this.purchaseOrder = purchaseOrder;
    }

    protected InvoiceGeneratorSupplyChain(StockMove stockMove, int invoiceOperationType) throws AxelorException {
        super(invoiceOperationType, stockMove.getCompany(), stockMove.getPartner(), null, null, stockMove.getStockMoveSeq(), stockMove.getTrackingNumber(), null, stockMove.getTradingName());
    }

    protected Invoice createInvoiceHeader() throws AxelorException {
        Invoice invoice = super.createInvoiceHeader();
        if (!((AppSupplychainService)Beans.get(AppSupplychainService.class)).isApp("supplychain")) {
            return invoice;
        }
        if (this.saleOrder != null) {
            invoice.setPrintingSettings(this.saleOrder.getPrintingSettings());
        } else if (this.purchaseOrder != null) {
            invoice.setPrintingSettings(this.purchaseOrder.getPrintingSettings());
        }
        return invoice;
    }
}

