/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service.workflow;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoiceLine;
import com.axelor.apps.account.db.repo.InvoicePaymentRepository;
import com.axelor.apps.account.db.repo.InvoiceRepository;
import com.axelor.apps.account.service.config.AccountConfigService;
import com.axelor.apps.account.service.invoice.InvoiceToolService;
import com.axelor.apps.account.service.invoice.workflow.ventilate.WorkflowVentilationServiceImpl;
import com.axelor.apps.account.service.payment.invoice.payment.InvoicePaymentCreateService;
import com.axelor.apps.base.db.Unit;
import com.axelor.apps.base.service.UnitConversionService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.apps.purchase.db.PurchaseOrderLine;
import com.axelor.apps.purchase.db.repo.PurchaseOrderRepository;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.apps.sale.db.repo.SaleOrderRepository;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.apps.stock.db.StockMoveLine;
import com.axelor.apps.stock.db.repo.StockMoveLineRepository;
import com.axelor.apps.supplychain.db.SupplyChainConfig;
import com.axelor.apps.supplychain.service.AccountingSituationSupplychainService;
import com.axelor.apps.supplychain.service.PurchaseOrderInvoiceService;
import com.axelor.apps.supplychain.service.SaleOrderInvoiceService;
import com.axelor.apps.supplychain.service.StockMoveInvoiceService;
import com.axelor.apps.supplychain.service.app.AppSupplychainService;
import com.axelor.apps.supplychain.service.config.SupplyChainConfigService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowVentilationServiceSupplychainImpl
extends WorkflowVentilationServiceImpl {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private SaleOrderInvoiceService saleOrderInvoiceService;
    private PurchaseOrderInvoiceService purchaseOrderInvoiceService;
    private SaleOrderRepository saleOrderRepository;
    private PurchaseOrderRepository purchaseOrderRepository;
    private AccountingSituationSupplychainService accountingSituationSupplychainService;
    private AppSupplychainService appSupplychainService;
    private StockMoveInvoiceService stockMoveInvoiceService;
    private UnitConversionService unitConversionService;
    private AppBaseService appBaseService;
    private SupplyChainConfigService supplyChainConfigService;
    private StockMoveLineRepository stockMoveLineRepository;

    @Inject
    public WorkflowVentilationServiceSupplychainImpl(AccountConfigService accountConfigService, InvoicePaymentRepository invoicePaymentRepo, InvoicePaymentCreateService invoicePaymentCreateService, SaleOrderInvoiceService saleOrderInvoiceService, PurchaseOrderInvoiceService purchaseOrderInvoiceService, SaleOrderRepository saleOrderRepository, PurchaseOrderRepository purchaseOrderRepository, AccountingSituationSupplychainService accountingSituationSupplychainService, AppSupplychainService appSupplychainService, StockMoveInvoiceService stockMoveInvoiceService, UnitConversionService unitConversionService, AppBaseService appBaseService, SupplyChainConfigService supplyChainConfigService, StockMoveLineRepository stockMoveLineRepository) {
        super(accountConfigService, invoicePaymentRepo, invoicePaymentCreateService);
        this.saleOrderInvoiceService = saleOrderInvoiceService;
        this.purchaseOrderInvoiceService = purchaseOrderInvoiceService;
        this.saleOrderRepository = saleOrderRepository;
        this.purchaseOrderRepository = purchaseOrderRepository;
        this.accountingSituationSupplychainService = accountingSituationSupplychainService;
        this.appSupplychainService = appSupplychainService;
        this.stockMoveInvoiceService = stockMoveInvoiceService;
        this.unitConversionService = unitConversionService;
        this.appBaseService = appBaseService;
        this.supplyChainConfigService = supplyChainConfigService;
        this.stockMoveLineRepository = stockMoveLineRepository;
    }

    public void afterVentilation(Invoice invoice) throws AxelorException {
        super.afterVentilation(invoice);
        if (InvoiceToolService.isPurchase((Invoice)invoice)) {
            this.purchaseOrderProcess(invoice);
        } else {
            this.saleOrderProcess(invoice);
        }
        if (invoice.getInterco().booleanValue() || invoice.getCreatedByInterco().booleanValue()) {
            this.updateIntercoReference(invoice);
        }
        if (invoice.getStockMoveSet() != null && !invoice.getStockMoveSet().isEmpty()) {
            this.stockMoveProcess(invoice);
        }
    }

    protected void updateIntercoReference(Invoice invoice) {
        Invoice intercoInvoice = (Invoice)((Object)((InvoiceRepository)((Object)Beans.get(InvoiceRepository.class))).all().filter("self.invoiceId = :invoiceId").bind("invoiceId", (Object)invoice.getExternalReference()).fetchOne());
        if (intercoInvoice != null) {
            intercoInvoice.setExternalReference(invoice.getInvoiceId());
        }
    }

    private void saleOrderProcess(Invoice invoice) throws AxelorException {
        HashSet<SaleOrder> saleOrderSet = new HashSet<SaleOrder>();
        for (InvoiceLine invoiceLine : invoice.getInvoiceLineList()) {
            SaleOrder saleOrder = null;
            saleOrder = this.saleOrderLineProcess(invoice, invoiceLine);
            if (saleOrder == null) continue;
            saleOrderSet.add(saleOrder);
        }
        for (SaleOrder saleOrder : saleOrderSet) {
            this.log.debug("Update the invoiced amount of the sale order : {}", (Object)saleOrder.getSaleOrderSeq());
            this.saleOrderInvoiceService.update(saleOrder, invoice.getId(), false);
            this.saleOrderRepository.save((Model)((Object)saleOrder));
            this.accountingSituationSupplychainService.updateUsedCredit(saleOrder.getClientPartner());
            if (saleOrder.getAmountInvoiced().compareTo(saleOrder.getExTaxTotal()) != 0 || invoice.getOperationSubTypeSelect() == 6) continue;
            invoice.setOperationSubTypeSelect(3);
        }
    }

    private SaleOrder saleOrderLineProcess(Invoice invoice, InvoiceLine invoiceLine) throws AxelorException {
        SaleOrderLine saleOrderLine = invoiceLine.getSaleOrderLine();
        if (saleOrderLine == null) {
            return null;
        }
        SaleOrder saleOrder = saleOrderLine.getSaleOrder();
        BigDecimal invoicedAmountToAdd = invoiceLine.getExTaxTotal();
        if (InvoiceToolService.isRefund((Invoice)invoiceLine.getInvoice())) {
            invoicedAmountToAdd = invoicedAmountToAdd.negate();
        }
        if (!invoice.getCurrency().equals((Object)saleOrder.getCurrency()) && saleOrderLine.getCompanyExTaxTotal().compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal currentCompanyInvoicedAmount = invoiceLine.getCompanyExTaxTotal();
            BigDecimal rate = currentCompanyInvoicedAmount.divide(saleOrderLine.getCompanyExTaxTotal(), 4, RoundingMode.HALF_UP);
            invoicedAmountToAdd = rate.multiply(saleOrderLine.getExTaxTotal());
        }
        saleOrderLine.setAmountInvoiced(saleOrderLine.getAmountInvoiced().add(invoicedAmountToAdd));
        return saleOrder;
    }

    private void purchaseOrderProcess(Invoice invoice) throws AxelorException {
        HashSet<PurchaseOrder> purchaseOrderSet = new HashSet<PurchaseOrder>();
        for (InvoiceLine invoiceLine : invoice.getInvoiceLineList()) {
            PurchaseOrder purchaseOrder = null;
            purchaseOrder = this.purchaseOrderLineProcess(invoice, invoiceLine);
            if (purchaseOrder == null) continue;
            purchaseOrderSet.add(purchaseOrder);
        }
        for (PurchaseOrder purchaseOrder : purchaseOrderSet) {
            this.log.debug("Update the invoiced amount of the purchase order : {}", (Object)purchaseOrder.getPurchaseOrderSeq());
            purchaseOrder.setAmountInvoiced(this.purchaseOrderInvoiceService.getInvoicedAmount(purchaseOrder, invoice.getId(), false));
            this.purchaseOrderRepository.save((Model)((Object)purchaseOrder));
        }
    }

    private PurchaseOrder purchaseOrderLineProcess(Invoice invoice, InvoiceLine invoiceLine) throws AxelorException {
        PurchaseOrderLine purchaseOrderLine = invoiceLine.getPurchaseOrderLine();
        if (purchaseOrderLine == null) {
            return null;
        }
        PurchaseOrder purchaseOrder = purchaseOrderLine.getPurchaseOrder();
        BigDecimal invoicedAmountToAdd = invoiceLine.getExTaxTotal();
        if (InvoiceToolService.isRefund((Invoice)invoiceLine.getInvoice())) {
            invoicedAmountToAdd = invoicedAmountToAdd.negate();
        }
        if (!invoice.getCurrency().equals((Object)purchaseOrder.getCurrency()) && purchaseOrderLine.getCompanyExTaxTotal().compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal currentCompanyInvoicedAmount = invoiceLine.getCompanyExTaxTotal();
            BigDecimal rate = currentCompanyInvoicedAmount.divide(purchaseOrderLine.getCompanyExTaxTotal(), 4, RoundingMode.HALF_UP);
            invoicedAmountToAdd = rate.multiply(purchaseOrderLine.getExTaxTotal());
        }
        purchaseOrderLine.setAmountInvoiced(purchaseOrderLine.getAmountInvoiced().add(invoicedAmountToAdd));
        return purchaseOrder;
    }

    private void stockMoveProcess(Invoice invoice) throws AxelorException {
        for (InvoiceLine invoiceLine : invoice.getInvoiceLineList()) {
            StockMoveLine stockMoveLine = invoiceLine.getStockMoveLine();
            if (stockMoveLine == null) continue;
            if (this.isStockMoveInvoicingPartiallyActivated(invoice, stockMoveLine)) {
                BigDecimal qty = stockMoveLine.getQtyInvoiced();
                StockMove stockMove = stockMoveLine.getStockMove();
                qty = this.stockMoveInvoiceService.isInvoiceRefundingStockMove(stockMove, invoice) ? qty.subtract(invoiceLine.getQty()) : qty.add(invoiceLine.getQty());
                BigDecimal qtyToCompare = qty;
                Unit movUnit = stockMoveLine.getUnit();
                Unit invUnit = invoiceLine.getUnit();
                try {
                    qtyToCompare = this.unitConversionService.convert(invUnit, movUnit, qty, this.appBaseService.getNbDecimalDigitForQty(), null);
                }
                catch (AxelorException e) {
                    throw new AxelorException(5, I18n.get((String)"The invoice's unit is different and inconvertible into the stock move's unit.") + "\n" + e.getMessage());
                }
                if (stockMoveLine.getRealQty().compareTo(qtyToCompare) >= 0) {
                    stockMoveLine.setQtyInvoiced(qty);
                    continue;
                }
                throw new AxelorException(5, I18n.get((String)"The quantity to invoice is greater than the quantity in the stock move"));
            }
            boolean invoiceIsRefund = this.stockMoveInvoiceService.isInvoiceRefundingStockMove(stockMoveLine.getStockMove(), invoice);
            stockMoveLine.setQtyInvoiced(invoiceIsRefund ? BigDecimal.ZERO : stockMoveLine.getRealQty());
            if (stockMoveLine.getSaleOrderLine() != null) {
                this.stockMoveLineRepository.all().filter("self.saleOrderLine.id = :saleOrderLineId AND self.stockMove.id = :stockMoveId").bind("saleOrderLineId", (Object)stockMoveLine.getSaleOrderLine().getId()).bind("stockMoveId", (Object)stockMoveLine.getStockMove().getId()).fetch().forEach(stockMvLine -> stockMvLine.setQtyInvoiced(invoiceIsRefund ? BigDecimal.ZERO : stockMvLine.getRealQty()));
            }
            if (stockMoveLine.getPurchaseOrderLine() == null) continue;
            this.stockMoveLineRepository.all().filter("self.purchaseOrderLine.id = :purchaseOrderLineId AND self.stockMove.id = :stockMoveId").bind("purchaseOrderLineId", (Object)stockMoveLine.getPurchaseOrderLine().getId()).bind("stockMoveId", (Object)stockMoveLine.getStockMove().getId()).fetch().forEach(stockMvLine -> stockMvLine.setQtyInvoiced(invoiceIsRefund ? BigDecimal.ZERO : stockMvLine.getRealQty()));
        }
        for (StockMove stockMove : invoice.getStockMoveSet()) {
            this.stockMoveInvoiceService.computeStockMoveInvoicingStatus(stockMove);
        }
    }

    private boolean isStockMoveInvoicingPartiallyActivated(Invoice invoice, StockMoveLine stockMoveLine) throws AxelorException {
        SupplyChainConfig supplyChainConfig = this.supplyChainConfigService.getSupplyChainConfig(invoice.getCompany());
        return stockMoveLine.getSaleOrderLine() != null && supplyChainConfig.getActivateOutStockMovePartialInvoicing() != false || stockMoveLine.getPurchaseOrderLine() != null && supplyChainConfig.getActivateIncStockMovePartialInvoicing() != false;
    }
}

