/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.web;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoiceLine;
import com.axelor.apps.account.service.invoice.InvoiceLineService;
import com.axelor.apps.account.service.invoice.generator.line.InvoiceLineManagement;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.supplychain.service.InvoiceLineSupplychainService;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.rpc.Context;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;

public class InvoiceLineController {
    public List<InvoiceLine> updateQty(List<InvoiceLine> invoiceLines, BigDecimal oldKitQty, BigDecimal newKitQty, Invoice invoice) throws AxelorException {
        block7: {
            BigDecimal qty = BigDecimal.ZERO;
            BigDecimal exTaxTotal = BigDecimal.ZERO;
            BigDecimal companyExTaxTotal = BigDecimal.ZERO;
            BigDecimal inTaxTotal = BigDecimal.ZERO;
            BigDecimal companyInTaxTotal = BigDecimal.ZERO;
            BigDecimal priceDiscounted = BigDecimal.ZERO;
            BigDecimal taxRate = BigDecimal.ZERO;
            AppBaseService appBaseService = (AppBaseService)Beans.get(AppBaseService.class);
            InvoiceLineService invoiceLineService = (InvoiceLineService)Beans.get(InvoiceLineService.class);
            int scale = appBaseService.getNbDecimalDigitForQty();
            if (invoiceLines == null) break block7;
            if (newKitQty.compareTo(BigDecimal.ZERO) != 0) {
                for (InvoiceLine line : invoiceLines) {
                    qty = line.getQty().divide(oldKitQty, scale, RoundingMode.HALF_EVEN).multiply(newKitQty).setScale(scale, RoundingMode.HALF_EVEN);
                    priceDiscounted = invoiceLineService.computeDiscount(line, invoice.getInAti());
                    if (line.getTaxLine() != null) {
                        taxRate = line.getTaxLine().getValue();
                    }
                    if (!invoice.getInAti().booleanValue()) {
                        exTaxTotal = InvoiceLineManagement.computeAmount((BigDecimal)qty, (BigDecimal)priceDiscounted);
                        inTaxTotal = exTaxTotal.add(exTaxTotal.multiply(taxRate));
                    } else {
                        inTaxTotal = InvoiceLineManagement.computeAmount((BigDecimal)qty, (BigDecimal)priceDiscounted);
                        exTaxTotal = inTaxTotal.divide(taxRate.add(BigDecimal.ONE), 2, 4);
                    }
                    companyExTaxTotal = invoiceLineService.getCompanyExTaxTotal(exTaxTotal, invoice);
                    companyInTaxTotal = invoiceLineService.getCompanyExTaxTotal(inTaxTotal, invoice);
                    line.setQty(qty);
                    line.setExTaxTotal(exTaxTotal);
                    line.setCompanyExTaxTotal(companyExTaxTotal);
                    line.setInTaxTotal(inTaxTotal);
                    line.setCompanyInTaxTotal(companyInTaxTotal);
                    line.setPriceDiscounted(priceDiscounted);
                    line.setTaxRate(taxRate);
                }
            } else {
                for (InvoiceLine line : invoiceLines) {
                    line.setQty(qty);
                }
            }
        }
        return invoiceLines;
    }

    public Invoice getInvoice(Context context) {
        Context parentContext = context.getParent();
        Invoice invoice = (Invoice)((Object)parentContext.asType(Invoice.class));
        if (!parentContext.getContextClass().toString().equals(Invoice.class.toString())) {
            InvoiceLine invoiceLine = (InvoiceLine)((Object)context.asType(InvoiceLine.class));
            invoice = invoiceLine.getInvoice();
        }
        return invoice;
    }

    public void computeBudgetDistributionSumAmount(ActionRequest request, ActionResponse response) {
        InvoiceLine invoiceLine = (InvoiceLine)((Object)request.getContext().asType(InvoiceLine.class));
        Invoice invoice = (Invoice)((Object)request.getContext().getParent().asType(Invoice.class));
        ((InvoiceLineSupplychainService)((Object)Beans.get(InvoiceLineSupplychainService.class))).computeBudgetDistributionSumAmount(invoiceLine, invoice);
        response.setValue("budgetDistributionSumAmount", (Object)invoiceLine.getBudgetDistributionSumAmount());
        response.setValue("budgetDistributionList", invoiceLine.getBudgetDistributionList());
    }
}

