/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.web;

import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.repo.ProductRepository;
import com.axelor.apps.purchase.db.PurchaseOrderLine;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.apps.stock.db.StockLocationLine;
import com.axelor.apps.stock.service.StockLocationLineService;
import com.axelor.apps.supplychain.db.MrpLine;
import com.axelor.apps.supplychain.service.ProjectedStockService;
import com.axelor.apps.supplychain.service.PurchaseOrderStockService;
import com.axelor.apps.supplychain.service.SaleOrderLineServiceSupplyChain;
import com.axelor.db.mapper.Mapper;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.rpc.Context;
import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ProjectedStockController {
    public static final String VIEW_AVAILABLE_STOCK_QTY_TITLE = "%s stock location";
    public static final String VIEW_SOL_OF_PRODUCT_TITLE = "%s sale order";
    public static final String VIEW_POL_OF_PRODUCT_TITLE = "%s purchase order";
    public static final String VIEW_REQUESTED_RESERVED_QTY_TITLE = "%s requested reserved";

    public void showStockAvailableProduct(ActionRequest request, ActionResponse response) {
        Map<String, Long> mapId = ((ProjectedStockService)Beans.get(ProjectedStockService.class)).getProductIdCompanyIdStockLocationIdFromContext(request.getContext());
        if (mapId == null || mapId.get("productId") == 0L) {
            return;
        }
        Long productId = mapId.get("productId");
        Long companyId = mapId.get("companyId");
        Long stockLocationId = mapId.get("stockLocationId");
        String domain = ((StockLocationLineService)Beans.get(StockLocationLineService.class)).getAvailableStockForAProduct(productId, companyId, stockLocationId);
        Product product = (Product)((Object)((ProductRepository)((Object)Beans.get(ProductRepository.class))).find(mapId.get("productId")));
        String title = I18n.get((String)VIEW_AVAILABLE_STOCK_QTY_TITLE);
        title = String.format(title, product.getName());
        response.setView(ActionView.define((String)title).model(StockLocationLine.class.getName()).add("grid", "stock-location-line-grid").add("form", "stock-location-line-form").domain(domain).param("popup", "true").param("popup-save", "false").param("popup.maximized", "true").map());
    }

    public void showSaleOrderOfProduct(ActionRequest request, ActionResponse response) {
        Map<String, Long> mapId = ((ProjectedStockService)Beans.get(ProjectedStockService.class)).getProductIdCompanyIdStockLocationIdFromContext(request.getContext());
        if (mapId == null || mapId.get("productId") == 0L) {
            return;
        }
        Long productId = mapId.get("productId");
        Long companyId = mapId.get("companyId");
        Long stockLocationId = mapId.get("stockLocationId");
        String domain = ((SaleOrderLineServiceSupplyChain)Beans.get(SaleOrderLineServiceSupplyChain.class)).getSaleOrderLineListForAProduct(productId, companyId, stockLocationId);
        Product product = (Product)((Object)((ProductRepository)((Object)Beans.get(ProductRepository.class))).find(mapId.get("productId")));
        String title = I18n.get((String)VIEW_SOL_OF_PRODUCT_TITLE);
        title = String.format(title, product.getName());
        response.setView(ActionView.define((String)title).model(SaleOrderLine.class.getName()).add("grid", "sale-order-line-menu-grid").add("form", "sale-order-line-all-form").domain(domain).param("popup", "true").param("popup-save", "false").param("popup.maximized", "true").map());
    }

    public void showPurchaseOrderOfProduct(ActionRequest request, ActionResponse response) {
        Map<String, Long> mapId = ((ProjectedStockService)Beans.get(ProjectedStockService.class)).getProductIdCompanyIdStockLocationIdFromContext(request.getContext());
        if (mapId == null || mapId.get("productId") == 0L) {
            return;
        }
        Long productId = mapId.get("productId");
        Long companyId = mapId.get("companyId");
        Long stockLocationId = mapId.get("stockLocationId");
        String domain = ((PurchaseOrderStockService)Beans.get(PurchaseOrderStockService.class)).getPurchaseOrderLineListForAProduct(productId, companyId, stockLocationId);
        Product product = (Product)((Object)((ProductRepository)((Object)Beans.get(ProductRepository.class))).find(mapId.get("productId")));
        String title = I18n.get((String)VIEW_POL_OF_PRODUCT_TITLE);
        title = String.format(title, product.getName());
        response.setView(ActionView.define((String)title).model(PurchaseOrderLine.class.getName()).add("grid", "purchase-order-line-menu-grid").add("form", "purchase-order-line-all-form").domain(domain).param("popup", "true").param("popup-save", "false").param("popup.maximized", "true").map());
    }

    public void showStockRequestedReservedQuantityOfProduct(ActionRequest request, ActionResponse response) {
        Map<String, Long> mapId = ((ProjectedStockService)Beans.get(ProjectedStockService.class)).getProductIdCompanyIdStockLocationIdFromContext(request.getContext());
        if (mapId == null || mapId.get("productId") == 0L) {
            return;
        }
        Long productId = mapId.get("productId");
        Long companyId = mapId.get("companyId");
        Long stockLocationId = mapId.get("stockLocationId");
        String domain = ((StockLocationLineService)Beans.get(StockLocationLineService.class)).getRequestedReservedQtyForAProduct(productId, companyId, stockLocationId);
        Product product = (Product)((Object)((ProductRepository)((Object)Beans.get(ProductRepository.class))).find(mapId.get("productId")));
        String title = I18n.get((String)VIEW_REQUESTED_RESERVED_QTY_TITLE);
        title = String.format(title, product.getName());
        response.setView(ActionView.define((String)title).model(StockLocationLine.class.getName()).add("grid", "stock-location-line-grid").add("form", "stock-location-line-form").domain(domain).param("popup", "true").param("popup-save", "false").param("popup.maximized", "true").map());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showProjectedStock(ActionRequest request, ActionResponse response) {
        try {
            ProjectedStockService projectedStockService = (ProjectedStockService)Beans.get(ProjectedStockService.class);
            Map<String, Long> mapId = projectedStockService.getProductIdCompanyIdStockLocationIdFromContext(request.getContext());
            if (mapId == null || mapId.get("productId") == 0L) {
                return;
            }
            ArrayList<MrpLine> mrpLineList = new ArrayList<MrpLine>();
            try {
                mrpLineList.addAll(projectedStockService.createProjectedStock(mapId.get("productId"), mapId.get("companyId"), mapId.get("stockLocationId")));
                response.setView(ActionView.define((String)I18n.get((String)"Projected stock")).model(MrpLine.class.getName()).add("form", "projected-stock-form").param("popup", "true").param("popup-save", "false").param("popup.maximized", "true").context("_mrpLineList", mrpLineList).map());
            }
            catch (Exception e) {
                TraceBackService.trace((ActionResponse)response, (Throwable)e);
            }
            finally {
                projectedStockService.removeMrpAndMrpLine(mrpLineList);
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void showChartProjectedStock(ActionRequest request, ActionResponse response) {
        Context context = request.getContext();
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>();
        Collection contextMrpLineList = (Collection)context.get((Object)"_mrpLineListToProject");
        List mrpLineList = contextMrpLineList.stream().map(map -> (MrpLine)((Object)((Object)Mapper.toBean(MrpLine.class, (Map)map)))).collect(Collectors.toList());
        if (!mrpLineList.isEmpty()) {
            ArrayList<MrpLine> mrpLineLastList = new ArrayList<MrpLine>();
            MrpLine lastMrpLine = (MrpLine)((Object)mrpLineList.get(0));
            for (int i = 1; i < mrpLineList.size(); ++i) {
                MrpLine mrpLine = (MrpLine)((Object)mrpLineList.get(i));
                if (mrpLine.getMaturityDate().isAfter(lastMrpLine.getMaturityDate())) {
                    mrpLineLastList.add(lastMrpLine);
                }
                lastMrpLine = mrpLine;
            }
            mrpLineLastList.add(lastMrpLine);
            lastMrpLine = (MrpLine)((Object)mrpLineList.get(0));
            LocalDate mrpDate = lastMrpLine.getMaturityDate();
            for (MrpLine mrpLine : mrpLineLastList) {
                mrpDate = this.addInterElementForProjectedStockChart(dataList, lastMrpLine, mrpDate, mrpLine);
                HashMap<String, Comparable<ChronoLocalDate>> dataMap = new HashMap<String, Comparable<ChronoLocalDate>>();
                dataMap.put("name", mrpLine.getMaturityDate());
                dataMap.put("cumulativeQty", mrpLine.getCumulativeQty());
                dataList.add(dataMap);
                lastMrpLine = mrpLine;
            }
        }
        response.setData(dataList);
    }

    private LocalDate addInterElementForProjectedStockChart(List<Map<String, Object>> dataList, MrpLine lastMrpLine, LocalDate mrpDate, MrpLine mrpLine) {
        while (mrpDate.isBefore(mrpLine.getMaturityDate())) {
            mrpDate = mrpDate.plusDays(1L);
            HashMap<String, Comparable<ChronoLocalDate>> dataMapDate = new HashMap<String, Comparable<ChronoLocalDate>>();
            dataMapDate.put("name", mrpDate);
            dataMapDate.put("cumulativeQty", lastMrpLine.getCumulativeQty());
            dataList.add(dataMapDate);
        }
        return mrpDate;
    }
}

