/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.web;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.apps.purchase.db.repo.PurchaseOrderRepository;
import com.axelor.apps.supplychain.service.PurchaseOrderInvoiceService;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.inject.Singleton;

@Singleton
public class PurchaseOrderInvoiceController {
    public void generateInvoice(ActionRequest request, ActionResponse response) {
        PurchaseOrder purchaseOrder = (PurchaseOrder)((Object)request.getContext().asType(PurchaseOrder.class));
        purchaseOrder = (PurchaseOrder)((Object)((PurchaseOrderRepository)((Object)Beans.get(PurchaseOrderRepository.class))).find(purchaseOrder.getId()));
        try {
            Invoice invoice = ((PurchaseOrderInvoiceService)Beans.get(PurchaseOrderInvoiceService.class)).generateInvoice(purchaseOrder);
            if (invoice != null) {
                response.setReload(true);
                response.setView(ActionView.define((String)I18n.get((String)"Invoice created")).model(Invoice.class.getName()).add("form", "invoice-form").add("grid", "invoice-grid").param("search-filters", "customer-invoices-filters").domain("self.purchaseOrder.id = " + String.valueOf(invoice.getId())).context("_showRecord", (Object)String.valueOf(invoice.getId())).map());
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }
}

