/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.web;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.PriceList;
import com.axelor.apps.base.db.Wizard;
import com.axelor.apps.base.service.BlockingService;
import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.apps.sale.db.repo.SaleOrderRepository;
import com.axelor.apps.stock.db.StockLocation;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.apps.stock.db.repo.StockMoveRepository;
import com.axelor.apps.stock.service.StockLocationService;
import com.axelor.apps.supplychain.service.SaleOrderCreateServiceSupplychainImpl;
import com.axelor.apps.supplychain.service.SaleOrderInvoiceService;
import com.axelor.apps.supplychain.service.SaleOrderPurchaseService;
import com.axelor.apps.supplychain.service.SaleOrderReservedQtyService;
import com.axelor.apps.supplychain.service.SaleOrderServiceSupplychainImpl;
import com.axelor.apps.supplychain.service.SaleOrderStockService;
import com.axelor.apps.supplychain.service.SaleOrderSupplychainService;
import com.axelor.apps.supplychain.service.app.AppSupplychainService;
import com.axelor.db.JPA;
import com.axelor.db.mapper.Mapper;
import com.axelor.exception.AxelorException;
import com.axelor.exception.ResponseMessageType;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.rpc.Context;
import com.axelor.team.db.Team;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.inject.Singleton;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@Singleton
public class SaleOrderController {
    private final String SO_LINES_WIZARD_QTY_TO_INVOICE_FIELD = "qtyToInvoice";

    public void createStockMove(ActionRequest request, ActionResponse response) {
        SaleOrder saleOrder = (SaleOrder)((Object)request.getContext().asType(SaleOrder.class));
        try {
            if (saleOrder.getId() != null) {
                SaleOrderStockService saleOrderStockService = (SaleOrderStockService)Beans.get(SaleOrderStockService.class);
                List<Long> stockMoveList = saleOrderStockService.createStocksMovesFromSaleOrder((SaleOrder)((Object)((SaleOrderRepository)((Object)Beans.get(SaleOrderRepository.class))).find(saleOrder.getId())));
                if (stockMoveList != null && stockMoveList.size() == 1) {
                    response.setView(ActionView.define((String)I18n.get((String)"Stock move")).model(StockMove.class.getName()).add("form", "stock-move-form").add("grid", "stock-move-grid").param("search-filters", "internal-stock-move-filters").param("forceEdit", "true").domain("self.id = " + stockMoveList.get(0)).context("_showRecord", (Object)String.valueOf(stockMoveList.get(0))).context("_userType", (Object)"Salesperson").map());
                    ((TraceBackService)Beans.get(TraceBackService.class)).findLastMessageTraceBack(((StockMoveRepository)((Object)Beans.get(StockMoveRepository.class))).find(stockMoveList.get(0))).ifPresent(traceback -> response.setNotify(String.format(I18n.get((String)"Error when sending email: %s"), traceback.getMessage())));
                } else if (stockMoveList != null && stockMoveList.size() > 1) {
                    response.setView(ActionView.define((String)I18n.get((String)"Stock move")).model(StockMove.class.getName()).add("grid", "stock-move-grid").add("form", "stock-move-form").param("search-filters", "internal-stock-move-filters").domain("self.id in (" + Joiner.on((String)",").join(stockMoveList) + ")").context("_userType", (Object)"Salesperson").map());
                    TraceBackService traceBackService = (TraceBackService)Beans.get(TraceBackService.class);
                    StockMoveRepository stockMoveRepository = (StockMoveRepository)((Object)Beans.get(StockMoveRepository.class));
                    stockMoveList.stream().map(arg_0 -> ((StockMoveRepository)stockMoveRepository).find(arg_0)).map(arg_0 -> ((TraceBackService)traceBackService).findLastMessageTraceBack(arg_0)).filter(Optional::isPresent).map(Optional::get).findAny().ifPresent(traceback -> response.setNotify(String.format(I18n.get((String)"Error when sending email: %s"), traceback.getMessage())));
                } else {
                    response.setFlash(I18n.get((String)"No delivery stock move to generate for this sale order"));
                }
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void getStockLocation(ActionRequest request, ActionResponse response) {
        StockLocation stockLocation;
        SaleOrder saleOrder = (SaleOrder)((Object)request.getContext().asType(SaleOrder.class));
        if (saleOrder != null && saleOrder.getCompany() != null && (stockLocation = ((StockLocationService)Beans.get(StockLocationService.class)).getPickupDefaultStockLocation(saleOrder.getCompany())) != null) {
            response.setValue("stockLocation", (Object)stockLocation);
        }
    }

    public void generatePurchaseOrdersFromSelectedSOLines(ActionRequest request, ActionResponse response) {
        SaleOrder saleOrder = (SaleOrder)((Object)request.getContext().asType(SaleOrder.class));
        try {
            if (saleOrder.getId() != null) {
                Partner supplierPartner = null;
                List<Long> saleOrderLineIdSelected = new ArrayList();
                Boolean isDirectOrderLocation = false;
                Map<String, Object> values = this.getSelectedId(request, response, saleOrder);
                supplierPartner = (Partner)((Object)values.get("supplierPartner"));
                saleOrderLineIdSelected = (List)values.get("saleOrderLineIdSelected");
                isDirectOrderLocation = (Boolean)values.get("isDirectOrderLocation");
                if (supplierPartner == null) {
                    saleOrderLineIdSelected = new ArrayList();
                    for (SaleOrderLine saleOrderLine : saleOrder.getSaleOrderLineList()) {
                        if (!saleOrderLine.isSelected()) continue;
                        if (supplierPartner == null) {
                            supplierPartner = saleOrderLine.getSupplierPartner();
                        }
                        saleOrderLineIdSelected.add(saleOrderLine.getId());
                    }
                    if (saleOrderLineIdSelected.isEmpty()) {
                        response.setFlash(I18n.get((String)"At least one sale order line must be selected"));
                    } else {
                        response.setView(ActionView.define((String)"SaleOrder").model(SaleOrder.class.getName()).add("form", "sale-order-generate-po-select-supplierpartner-form").param("popup", "true").param("show-toolbar", "false").param("show-confirm", "false").param("popup-save", "false").param("forceEdit", "true").context("_showRecord", (Object)String.valueOf(saleOrder.getId())).context("supplierPartnerId", (Object)(supplierPartner != null ? supplierPartner.getId() : 0L)).context("saleOrderLineIdSelected", (Object)Joiner.on((String)",").join(saleOrderLineIdSelected)).map());
                    }
                } else {
                    List saleOrderLinesSelected = JPA.all(SaleOrderLine.class).filter("self.id IN (:saleOderLineIdList)").bind("saleOderLineIdList", saleOrderLineIdSelected).fetch();
                    PurchaseOrder purchaseOrder = ((SaleOrderPurchaseService)Beans.get(SaleOrderPurchaseService.class)).createPurchaseOrder(supplierPartner, saleOrderLinesSelected, (SaleOrder)((Object)((SaleOrderRepository)((Object)Beans.get(SaleOrderRepository.class))).find(saleOrder.getId())));
                    response.setView(ActionView.define((String)I18n.get((String)"Purchase order")).model(PurchaseOrder.class.getName()).add("form", "purchase-order-form").param("forceEdit", "true").context("_showRecord", (Object)String.valueOf(purchaseOrder.getId())).map());
                    if (!isDirectOrderLocation.booleanValue()) {
                        response.setCanClose(true);
                    }
                }
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    private Map<String, Object> getSelectedId(ActionRequest request, ActionResponse response, SaleOrder saleOrder) throws AxelorException {
        Partner supplierPartner = null;
        ArrayList<Long> saleOrderLineIdSelected = new ArrayList<Long>();
        HashMap<String, Object> values = new HashMap<String, Object>();
        Boolean isDirectOrderLocation = false;
        if (saleOrder.getDirectOrderLocation().booleanValue() && saleOrder.getStockLocation() != null && saleOrder.getStockLocation().getPartner() != null && saleOrder.getStockLocation().getPartner().getIsSupplier().booleanValue()) {
            values.put("supplierPartner", (Object)saleOrder.getStockLocation().getPartner());
            for (SaleOrderLine saleOrderLine : saleOrder.getSaleOrderLineList()) {
                if (!saleOrderLine.isSelected()) continue;
                saleOrderLineIdSelected.add(saleOrderLine.getId());
            }
            values.put("saleOrderLineIdSelected", saleOrderLineIdSelected);
            isDirectOrderLocation = true;
            values.put("isDirectOrderLocation", isDirectOrderLocation);
            if (saleOrderLineIdSelected.isEmpty()) {
                throw new AxelorException(3, I18n.get((String)"At least one sale order line must be selected"));
            }
        } else if (request.getContext().get((Object)"supplierPartnerSelect") != null) {
            supplierPartner = (Partner)((Object)JPA.em().find(Partner.class, (Object)new Long(((Integer)((Map)request.getContext().get((Object)"supplierPartnerSelect")).get("id")).intValue())));
            values.put("supplierPartner", (Object)supplierPartner);
            String saleOrderLineIdSelectedStr = (String)request.getContext().get((Object)"saleOrderLineIdSelected");
            for (String saleOrderId : saleOrderLineIdSelectedStr.split(",")) {
                saleOrderLineIdSelected.add(new Long(saleOrderId));
            }
            values.put("saleOrderLineIdSelected", saleOrderLineIdSelected);
            values.put("isDirectOrderLocation", isDirectOrderLocation);
        }
        return values;
    }

    public void generateInvoice(ActionRequest request, ActionResponse response) {
        Context context = request.getContext();
        try {
            Invoice invoice;
            ArrayList uninvoicedTimetablesList;
            SaleOrder saleOrder = (SaleOrder)((Object)context.asType(SaleOrder.class));
            int operationSelect = Integer.parseInt(context.get((Object)"operationSelect").toString());
            boolean isPercent = (Boolean)context.getOrDefault((Object)"isPercent", (Object)false);
            BigDecimal amountToInvoice = new BigDecimal(context.getOrDefault((Object)"amountToInvoice", (Object)"0").toString());
            SaleOrderInvoiceService saleOrderInvoiceService = (SaleOrderInvoiceService)Beans.get(SaleOrderInvoiceService.class);
            saleOrderInvoiceService.displayErrorMessageIfSaleOrderIsInvoiceable(saleOrder, amountToInvoice, isPercent);
            HashMap<Long, BigDecimal> qtyToInvoiceMap = new HashMap<Long, BigDecimal>();
            List saleOrderLineListContext = (List)request.getRawContext().get("saleOrderLineList");
            for (Map map : saleOrderLineListContext) {
                Object qtyToInvoiceItem;
                if (map.get("qtyToInvoice") == null || ((BigDecimal)(qtyToInvoiceItem = new BigDecimal(map.get("qtyToInvoice").toString()))).compareTo(BigDecimal.ZERO) == 0) continue;
                Long soLineId = (long)((Integer)map.get("id"));
                qtyToInvoiceMap.put(soLineId, (BigDecimal)qtyToInvoiceItem);
            }
            ArrayList<Long> timetableIdList = new ArrayList<Long>();
            ArrayList arrayList = uninvoicedTimetablesList = context.get((Object)"uninvoicedTimetablesList") != null ? (ArrayList)context.get((Object)"uninvoicedTimetablesList") : null;
            if (uninvoicedTimetablesList != null && !uninvoicedTimetablesList.isEmpty()) {
                for (LinkedHashMap timetable : uninvoicedTimetablesList) {
                    if (timetable.get("toInvoice") == null || !((Boolean)timetable.get("toInvoice")).booleanValue()) continue;
                    timetableIdList.add(Long.parseLong(timetable.get("id").toString()));
                }
            }
            if ((invoice = saleOrderInvoiceService.generateInvoice(saleOrder = (SaleOrder)((Object)((SaleOrderRepository)((Object)Beans.get(SaleOrderRepository.class))).find(saleOrder.getId())), operationSelect, amountToInvoice, isPercent, qtyToInvoiceMap, timetableIdList)) != null) {
                response.setCanClose(true);
                response.setView(ActionView.define((String)I18n.get((String)"Invoice generated")).model(Invoice.class.getName()).add("form", "invoice-form").add("grid", "invoice-grid").param("search-filters", "customer-invoices-filters").context("_showRecord", (Object)String.valueOf(invoice.getId())).context("_operationTypeSelect", (Object)3).context("todayDate", (Object)((AppSupplychainService)Beans.get(AppSupplychainService.class)).getTodayDate(saleOrder.getCompany())).map());
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void mergeSaleOrder(ActionRequest request, ActionResponse response) {
        ArrayList<SaleOrder> saleOrderList = new ArrayList<SaleOrder>();
        ArrayList<Long> saleOrderIdList = new ArrayList<Long>();
        boolean fromPopup = false;
        String lineToMerge = request.getContext().get((Object)"saleQuotationToMerge") != null ? "saleQuotationToMerge" : "saleOrderToMerge";
        if (request.getContext().get((Object)lineToMerge) != null) {
            if (request.getContext().get((Object)lineToMerge) instanceof List) {
                List saleOrderMap = (List)request.getContext().get((Object)lineToMerge);
                for (Map map : saleOrderMap) {
                    saleOrderIdList.add(new Long(((Integer)map.get("id")).intValue()));
                }
            } else {
                String saleOrderIdListStr = (String)request.getContext().get((Object)lineToMerge);
                for (String saleOrderId : saleOrderIdListStr.split(",")) {
                    saleOrderIdList.add(new Long(saleOrderId));
                }
                fromPopup = true;
            }
        }
        Currency commonCurrency = null;
        Partner commonClientPartner = null;
        Company commonCompany = null;
        Partner commonContactPartner = null;
        Team commonTeam = null;
        boolean existTeamDiff = false;
        boolean existContactPartnerDiff = false;
        PriceList commonPriceList = null;
        boolean existPriceListDiff = false;
        StockLocation commonLocation = null;
        boolean existLocationDiff = false;
        int count = 1;
        for (Long saleOrderId : saleOrderIdList) {
            SaleOrder saleOrderTemp = (SaleOrder)((Object)JPA.em().find(SaleOrder.class, (Object)saleOrderId));
            saleOrderList.add(saleOrderTemp);
            if (count == 1) {
                commonCurrency = saleOrderTemp.getCurrency();
                commonClientPartner = saleOrderTemp.getClientPartner();
                commonCompany = saleOrderTemp.getCompany();
                commonContactPartner = saleOrderTemp.getContactPartner();
                commonTeam = saleOrderTemp.getTeam();
                commonPriceList = saleOrderTemp.getPriceList();
                commonLocation = saleOrderTemp.getStockLocation();
            } else {
                if (commonCurrency != null && !commonCurrency.equals((Object)saleOrderTemp.getCurrency())) {
                    commonCurrency = null;
                }
                if (commonClientPartner != null && !commonClientPartner.equals((Object)saleOrderTemp.getClientPartner())) {
                    commonClientPartner = null;
                }
                if (commonCompany != null && !commonCompany.equals((Object)saleOrderTemp.getCompany())) {
                    commonCompany = null;
                }
                if (commonContactPartner != null && !commonContactPartner.equals((Object)saleOrderTemp.getContactPartner())) {
                    commonContactPartner = null;
                    existContactPartnerDiff = true;
                }
                if (commonTeam != null && !commonTeam.equals((Object)saleOrderTemp.getTeam())) {
                    commonTeam = null;
                    existTeamDiff = true;
                }
                if (commonPriceList != null && !commonPriceList.equals((Object)saleOrderTemp.getPriceList())) {
                    commonPriceList = null;
                    existPriceListDiff = true;
                }
                if (commonLocation != null && !commonLocation.equals((Object)saleOrderTemp.getStockLocation())) {
                    commonLocation = null;
                    existLocationDiff = true;
                }
            }
            ++count;
        }
        StringBuilder fieldErrors = new StringBuilder();
        if (commonCurrency == null) {
            fieldErrors.append(I18n.get((String)"The currency is required and must be the same for all sale orders"));
        }
        if (commonClientPartner == null) {
            if (fieldErrors.length() > 0) {
                fieldErrors.append("<br/>");
            }
            fieldErrors.append(I18n.get((String)"The client Partner is required and must be the same for all sale orders"));
        }
        if (commonCompany == null) {
            if (fieldErrors.length() > 0) {
                fieldErrors.append("<br/>");
            }
            fieldErrors.append(I18n.get((String)"The company is required and must be the same for all sale orders"));
        }
        if (fieldErrors.length() > 0) {
            response.setFlash(fieldErrors.toString());
            return;
        }
        if (request.getContext().get((Object)"priceList") != null) {
            commonPriceList = (PriceList)JPA.em().find(PriceList.class, (Object)new Long(((Integer)((Map)request.getContext().get((Object)"priceList")).get("id")).intValue()));
        }
        if (request.getContext().get((Object)"contactPartner") != null) {
            commonContactPartner = (Partner)((Object)JPA.em().find(Partner.class, (Object)new Long(((Integer)((Map)request.getContext().get((Object)"contactPartner")).get("id")).intValue())));
        }
        if (request.getContext().get((Object)"team") != null) {
            commonTeam = (Team)((Object)JPA.em().find(Team.class, (Object)new Long(((Integer)((Map)request.getContext().get((Object)"team")).get("id")).intValue())));
        }
        if (request.getContext().get((Object)"stockLocation") != null) {
            commonLocation = (StockLocation)((Object)JPA.em().find(StockLocation.class, (Object)new Long(((Integer)((Map)request.getContext().get((Object)"stockLocation")).get("id")).intValue())));
        }
        if (!fromPopup && (existContactPartnerDiff || existPriceListDiff || existTeamDiff)) {
            ActionView.ActionViewBuilder confirmView = ActionView.define((String)"Confirm merge sale order").model(Wizard.class.getName()).add("form", "sale-order-merge-confirm-form").param("popup", "true").param("show-toolbar", "false").param("show-confirm", "false").param("popup-save", "false").param("forceEdit", "true");
            if (existPriceListDiff) {
                confirmView.context("contextPriceListToCheck", (Object)"true");
            }
            if (existContactPartnerDiff) {
                confirmView.context("contextContactPartnerToCheck", (Object)"true");
                confirmView.context("contextPartnerId", (Object)commonClientPartner.getId().toString());
            }
            if (existTeamDiff) {
                confirmView.context("contextTeamToCheck", (Object)"true");
            }
            if (existLocationDiff) {
                confirmView.context("contextLocationToCheck", (Object)"true");
            }
            confirmView.context(lineToMerge, (Object)Joiner.on((String)",").join(saleOrderIdList));
            response.setView(confirmView.map());
            return;
        }
        try {
            SaleOrder saleOrder = ((SaleOrderCreateServiceSupplychainImpl)((Object)Beans.get(SaleOrderCreateServiceSupplychainImpl.class))).mergeSaleOrders(saleOrderList, commonCurrency, commonClientPartner, commonCompany, commonLocation, commonContactPartner, commonPriceList, commonTeam);
            if (saleOrder != null) {
                response.setView(ActionView.define((String)"Sale order").model(SaleOrder.class.getName()).add("grid", "sale-order-grid").add("form", "sale-order-form").param("search-filters", "sale-order-filters").param("forceEdit", "true").context("_showRecord", (Object)String.valueOf(saleOrder.getId())).map());
                response.setCanClose(true);
            }
        }
        catch (Exception e) {
            response.setFlash(e.getLocalizedMessage());
        }
    }

    public void updateAmountToBeSpreadOverTheTimetable(ActionRequest request, ActionResponse response) {
        SaleOrder saleOrder = (SaleOrder)((Object)request.getContext().asType(SaleOrder.class));
        ((SaleOrderServiceSupplychainImpl)Beans.get(SaleOrderServiceSupplychainImpl.class)).updateAmountToBeSpreadOverTheTimetable(saleOrder);
        response.setValue("amountToBeSpreadOverTheTimetable", (Object)saleOrder.getAmountToBeSpreadOverTheTimetable());
    }

    public void onSave(ActionRequest request, ActionResponse response) {
        try {
            SaleOrder saleOrderView = (SaleOrder)((Object)request.getContext().asType(SaleOrder.class));
            if (saleOrderView.getOrderBeingEdited().booleanValue()) {
                SaleOrder saleOrder = (SaleOrder)((Object)((SaleOrderRepository)((Object)Beans.get(SaleOrderRepository.class))).find(saleOrderView.getId()));
                ((SaleOrderServiceSupplychainImpl)Beans.get(SaleOrderServiceSupplychainImpl.class)).checkModifiedConfirmedOrder(saleOrder, saleOrderView);
                response.setValues((Object)saleOrderView);
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e, (ResponseMessageType)ResponseMessageType.ERROR);
        }
    }

    public void changeWizardOperationDomain(ActionRequest request, ActionResponse response) {
        SaleOrder saleOrder = (SaleOrder)((Object)request.getContext().asType(SaleOrder.class));
        List<Integer> operationSelectValues = ((SaleOrderInvoiceService)Beans.get(SaleOrderInvoiceService.class)).getInvoicingWizardOperationDomain(saleOrder);
        if (operationSelectValues.contains(1)) {
            response.setAttr("operationSelect", "value", (Object)1);
        }
        response.setAttr("operationSelect", "selection-in", operationSelectValues);
    }

    public void supplierPartnerSelectDomain(ActionRequest request, ActionResponse response) {
        SaleOrder saleOrder = (SaleOrder)((Object)request.getContext().asType(SaleOrder.class));
        String domain = "self.isContact = false AND self.isSupplier = true";
        String blockedPartnerQuery = ((BlockingService)Beans.get(BlockingService.class)).listOfBlockedPartner(saleOrder.getCompany(), 6);
        if (!Strings.isNullOrEmpty((String)blockedPartnerQuery)) {
            domain = domain + String.format(" AND self.id NOT in (%s)", blockedPartnerQuery);
        }
        if (saleOrder.getCompany() != null) {
            domain = domain + " AND " + saleOrder.getCompany().getId() + " in (SELECT id FROM self.companySet)";
        }
        response.setAttr("supplierPartnerSelect", "domain", (Object)domain);
    }

    public void setNextInvoicingStartPeriodDate(ActionRequest request, ActionResponse response) {
        SaleOrder saleOrder = (SaleOrder)((Object)request.getContext().asType(SaleOrder.class));
        ChronoUnit temporalUnit = ChronoUnit.MONTHS;
        if (saleOrder.getPeriodicityTypeSelect() != null && saleOrder.getNextInvoicingStartPeriodDate() != null) {
            LocalDate invoicingPeriodStartDate = saleOrder.getNextInvoicingStartPeriodDate();
            if (saleOrder.getPeriodicityTypeSelect() == 1) {
                temporalUnit = ChronoUnit.DAYS;
            }
            LocalDate subscriptionToDate = invoicingPeriodStartDate.plus(saleOrder.getNumberOfPeriods().intValue(), temporalUnit);
            subscriptionToDate = subscriptionToDate.minusDays(1L);
            response.setValue("nextInvoicingEndPeriodDate", (Object)subscriptionToDate);
        }
    }

    public void fillDefaultValueWizard(ActionRequest request, ActionResponse response) {
        try {
            SaleOrder saleOrder = (SaleOrder)((Object)request.getContext().asType(SaleOrder.class));
            ArrayList<Map> saleOrderLineList = new ArrayList<Map>();
            for (SaleOrderLine saleOrderLine : saleOrder.getSaleOrderLineList()) {
                Map saleOrderLineMap = Mapper.toMap((Object)((Object)saleOrderLine));
                saleOrderLineMap.put("qtyToInvoice", BigDecimal.ZERO);
                saleOrderLineList.add(saleOrderLineMap);
            }
            response.setValue("amountToInvoice", (Object)BigDecimal.ZERO);
            response.setValue("saleOrderLineList", saleOrderLineList);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void fillSaleOrderLinesEstimatedDate(ActionRequest request, ActionResponse response) {
        SaleOrder saleOrder = (SaleOrder)((Object)request.getContext().asType(SaleOrder.class));
        List<SaleOrderLine> saleOrderLineList = saleOrder.getSaleOrderLineList();
        if (saleOrderLineList != null) {
            for (SaleOrderLine saleOrderLine : saleOrderLineList) {
                Integer deliveryState = saleOrderLine.getDeliveryState();
                if (deliveryState.equals(3) || deliveryState.equals(2)) continue;
                saleOrderLine.setEstimatedDelivDate(saleOrder.getDeliveryDate());
            }
        }
        response.setValue("saleOrderLineList", saleOrderLineList);
    }

    public void notifyStockMoveCreated(ActionRequest request, ActionResponse response) {
        SaleOrder saleOrder = (SaleOrder)((Object)request.getContext().asType(SaleOrder.class));
        StockMoveRepository stockMoveRepo = (StockMoveRepository)((Object)Beans.get(StockMoveRepository.class));
        StockMove stockMove = (StockMove)((Object)stockMoveRepo.all().filter("self.originTypeSelect = ?1 AND self.originId = ?2 AND self.statusSelect = ?3", new Object[]{"com.axelor.apps.sale.db.SaleOrder", saleOrder.getId(), 2}).fetchOne());
        if (stockMove != null) {
            response.setNotify(String.format(I18n.get((String)"Stock move %s has been created for this sale order"), stockMove.getStockMoveSeq()));
        }
    }

    public void allocateAll(ActionRequest request, ActionResponse response) {
        try {
            SaleOrder saleOrder = (SaleOrder)((Object)request.getContext().asType(SaleOrder.class));
            saleOrder = (SaleOrder)((Object)((SaleOrderRepository)((Object)Beans.get(SaleOrderRepository.class))).find(saleOrder.getId()));
            ((SaleOrderReservedQtyService)Beans.get(SaleOrderReservedQtyService.class)).allocateAll(saleOrder);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void deallocateAll(ActionRequest request, ActionResponse response) {
        try {
            SaleOrder saleOrder = (SaleOrder)((Object)request.getContext().asType(SaleOrder.class));
            saleOrder = (SaleOrder)((Object)((SaleOrderRepository)((Object)Beans.get(SaleOrderRepository.class))).find(saleOrder.getId()));
            ((SaleOrderReservedQtyService)Beans.get(SaleOrderReservedQtyService.class)).deallocateAll(saleOrder);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void reserveAll(ActionRequest request, ActionResponse response) {
        try {
            SaleOrder saleOrder = (SaleOrder)((Object)request.getContext().asType(SaleOrder.class));
            saleOrder = (SaleOrder)((Object)((SaleOrderRepository)((Object)Beans.get(SaleOrderRepository.class))).find(saleOrder.getId()));
            ((SaleOrderReservedQtyService)Beans.get(SaleOrderReservedQtyService.class)).reserveAll(saleOrder);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void cancelReservation(ActionRequest request, ActionResponse response) {
        try {
            SaleOrder saleOrder = (SaleOrder)((Object)request.getContext().asType(SaleOrder.class));
            saleOrder = (SaleOrder)((Object)((SaleOrderRepository)((Object)Beans.get(SaleOrderRepository.class))).find(saleOrder.getId()));
            ((SaleOrderReservedQtyService)Beans.get(SaleOrderReservedQtyService.class)).cancelReservation(saleOrder);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void showPopUpInvoicingWizard(ActionRequest request, ActionResponse response) {
        try {
            SaleOrder saleOrder = (SaleOrder)((Object)request.getContext().asType(SaleOrder.class));
            saleOrder = (SaleOrder)((Object)((SaleOrderRepository)((Object)Beans.get(SaleOrderRepository.class))).find(saleOrder.getId()));
            ((SaleOrderInvoiceService)Beans.get(SaleOrderInvoiceService.class)).displayErrorMessageBtnGenerateInvoice(saleOrder);
            response.setView(ActionView.define((String)"Invoicing").model(SaleOrder.class.getName()).add("form", "sale-order-invoicing-wizard-form").param("popup", "reload").param("show-toolbar", "false").param("show-confirm", "false").param("popup-save", "false").param("forceEdit", "true").context("_showRecord", (Object)String.valueOf(saleOrder.getId())).map());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void checkSaleOrderAnalyticDistributionTemplate(ActionRequest request, ActionResponse response) {
        try {
            SaleOrder saleOrder = (SaleOrder)((Object)request.getContext().asType(SaleOrder.class));
            ArrayList<String> productList = new ArrayList<String>();
            for (SaleOrderLine saleOrderLine : saleOrder.getSaleOrderLineList()) {
                if (saleOrderLine.getAnalyticDistributionTemplate() != null) continue;
                productList.add(saleOrderLine.getProductName());
            }
            if (!productList.isEmpty()) {
                throw new AxelorException(1, I18n.get((String)"There is no analytic distribution on %s sale order line"), new Object[]{productList});
            }
        }
        catch (AxelorException e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e, (ResponseMessageType)ResponseMessageType.ERROR);
        }
    }

    public void generateAdvancePaymentInvoice(ActionRequest request, ActionResponse response) {
        Context context = request.getContext();
        try {
            SaleOrder saleOrder = (SaleOrder)((Object)context.asType(SaleOrder.class));
            ((SaleOrderInvoiceService)Beans.get(SaleOrderInvoiceService.class)).displayErrorMessageBtnGenerateInvoice(saleOrder);
            Boolean isPercent = (Boolean)context.getOrDefault((Object)"isPercent", (Object)false);
            BigDecimal amountToInvoice = new BigDecimal(context.getOrDefault((Object)"amountToInvoice", (Object)"0").toString());
            saleOrder = (SaleOrder)((Object)((SaleOrderRepository)((Object)Beans.get(SaleOrderRepository.class))).find(saleOrder.getId()));
            Invoice invoice = ((SaleOrderInvoiceService)Beans.get(SaleOrderInvoiceService.class)).generateInvoice(saleOrder, 3, amountToInvoice, isPercent, null, null);
            if (invoice != null) {
                response.setCanClose(true);
                response.setView(ActionView.define((String)I18n.get((String)"Invoice generated")).model(Invoice.class.getName()).add("form", "invoice-form").add("grid", "invoice-grid").param("search-filters", "customer-invoices-filters").context("_showRecord", (Object)String.valueOf(invoice.getId())).map());
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e, (ResponseMessageType)ResponseMessageType.ERROR);
        }
    }

    public void backToConfirmedStatus(ActionRequest request, ActionResponse response) {
        try {
            SaleOrder saleOrder = (SaleOrder)((Object)request.getContext().asType(SaleOrder.class));
            saleOrder = (SaleOrder)((Object)((SaleOrderRepository)((Object)Beans.get(SaleOrderRepository.class))).find(saleOrder.getId()));
            ((SaleOrderSupplychainService)Beans.get(SaleOrderSupplychainService.class)).updateToConfirmedStatus(saleOrder);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }
}

