/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.web;

import com.axelor.apps.account.service.app.AppAccountService;
import com.axelor.apps.base.db.Blocking;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.Unit;
import com.axelor.apps.base.service.BlockingService;
import com.axelor.apps.base.service.UnitConversionService;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.apps.sale.db.repo.SaleOrderLineRepository;
import com.axelor.apps.stock.service.StockLocationLineService;
import com.axelor.apps.supplychain.service.ReservedQtyService;
import com.axelor.apps.supplychain.service.SaleOrderLineServiceSupplyChain;
import com.axelor.apps.supplychain.service.SaleOrderLineServiceSupplyChainImpl;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.rpc.Context;
import com.google.common.base.Strings;
import com.google.inject.Singleton;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;

@Singleton
public class SaleOrderLineController {
    public void computeAnalyticDistribution(ActionRequest request, ActionResponse response) throws AxelorException {
        SaleOrderLine saleOrderLine = (SaleOrderLine)((Object)request.getContext().asType(SaleOrderLine.class));
        if (((AppAccountService)Beans.get(AppAccountService.class)).getAppAccount().getManageAnalyticAccounting().booleanValue()) {
            saleOrderLine = ((SaleOrderLineServiceSupplyChain)Beans.get(SaleOrderLineServiceSupplyChain.class)).computeAnalyticDistribution(saleOrderLine);
            response.setValue("analyticDistributionTemplate", (Object)saleOrderLine.getAnalyticDistributionTemplate());
            response.setValue("analyticMoveLineList", saleOrderLine.getAnalyticMoveLineList());
        }
    }

    public void createAnalyticDistributionWithTemplate(ActionRequest request, ActionResponse response) throws AxelorException {
        SaleOrderLine saleOrderLine = (SaleOrderLine)((Object)request.getContext().asType(SaleOrderLine.class));
        saleOrderLine = ((SaleOrderLineServiceSupplyChain)Beans.get(SaleOrderLineServiceSupplyChain.class)).createAnalyticDistributionWithTemplate(saleOrderLine);
        response.setValue("analyticMoveLineList", saleOrderLine.getAnalyticMoveLineList());
    }

    public void checkStocks(ActionRequest request, ActionResponse response) {
        SaleOrderLine saleOrderLine = (SaleOrderLine)((Object)request.getContext().asType(SaleOrderLine.class));
        SaleOrder saleOrder = ((SaleOrderLineServiceSupplyChainImpl)Beans.get(SaleOrderLineServiceSupplyChainImpl.class)).getSaleOrder(request.getContext());
        if (saleOrder.getStockLocation() == null) {
            return;
        }
        try {
            if (saleOrderLine.getSaleSupplySelect() != 1) {
                return;
            }
            Unit unit = null;
            if (saleOrderLine.getProduct() != null) {
                unit = saleOrderLine.getProduct().getUnit();
            }
            BigDecimal qty = saleOrderLine.getQty();
            if (unit != null && !unit.equals((Object)saleOrderLine.getUnit())) {
                qty = ((UnitConversionService)Beans.get(UnitConversionService.class)).convert(saleOrderLine.getUnit(), unit, qty, qty.scale(), saleOrderLine.getProduct());
            }
            ((StockLocationLineService)Beans.get(StockLocationLineService.class)).checkIfEnoughStock(saleOrder.getStockLocation(), saleOrderLine.getProduct(), qty);
        }
        catch (Exception e) {
            response.setAlert(e.getLocalizedMessage());
        }
    }

    public void fillAvailableAndAllocatedStock(ActionRequest request, ActionResponse response) {
        Context context = request.getContext();
        SaleOrderLineServiceSupplyChainImpl saleOrderLineServiceSupplyChainImpl = (SaleOrderLineServiceSupplyChainImpl)Beans.get(SaleOrderLineServiceSupplyChainImpl.class);
        SaleOrderLine saleOrderLine = (SaleOrderLine)((Object)context.asType(SaleOrderLine.class));
        SaleOrder saleOrder = saleOrderLineServiceSupplyChainImpl.getSaleOrder(context);
        if (saleOrder != null && saleOrderLine.getProduct() != null && saleOrder.getStockLocation() != null) {
            BigDecimal availableStock = saleOrderLineServiceSupplyChainImpl.getAvailableStock(saleOrder, saleOrderLine);
            BigDecimal allocatedStock = saleOrderLineServiceSupplyChainImpl.getAllocatedStock(saleOrder, saleOrderLine);
            response.setValue("$availableStock", (Object)availableStock);
            response.setValue("$allocatedStock", (Object)allocatedStock);
            response.setValue("$totalStock", (Object)availableStock.add(allocatedStock));
        }
    }

    public void changeReservedQty(ActionRequest request, ActionResponse response) {
        SaleOrderLine saleOrderLine = (SaleOrderLine)((Object)request.getContext().asType(SaleOrderLine.class));
        BigDecimal newReservedQty = saleOrderLine.getReservedQty();
        try {
            saleOrderLine = (SaleOrderLine)((Object)((SaleOrderLineRepository)((Object)Beans.get(SaleOrderLineRepository.class))).find(saleOrderLine.getId()));
            Product product = saleOrderLine.getProduct();
            if (product == null || !product.getStockManaged().booleanValue()) {
                throw new AxelorException(5, I18n.get((String)"This product is not stock managed."));
            }
            ((ReservedQtyService)Beans.get(ReservedQtyService.class)).updateReservedQty(saleOrderLine, newReservedQty);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void changeRequestedReservedQty(ActionRequest request, ActionResponse response) {
        SaleOrderLine saleOrderLine = (SaleOrderLine)((Object)request.getContext().asType(SaleOrderLine.class));
        BigDecimal newReservedQty = saleOrderLine.getRequestedReservedQty();
        try {
            saleOrderLine = (SaleOrderLine)((Object)((SaleOrderLineRepository)((Object)Beans.get(SaleOrderLineRepository.class))).find(saleOrderLine.getId()));
            ((ReservedQtyService)Beans.get(ReservedQtyService.class)).updateRequestedReservedQty(saleOrderLine, newReservedQty);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void requestQty(ActionRequest request, ActionResponse response) {
        try {
            SaleOrderLine saleOrderLine = (SaleOrderLine)((Object)request.getContext().asType(SaleOrderLine.class));
            saleOrderLine = (SaleOrderLine)((Object)((SaleOrderLineRepository)((Object)Beans.get(SaleOrderLineRepository.class))).find(saleOrderLine.getId()));
            Product product = saleOrderLine.getProduct();
            if (product == null || !product.getStockManaged().booleanValue()) {
                throw new AxelorException(5, I18n.get((String)"This product is not stock managed."));
            }
            ((ReservedQtyService)Beans.get(ReservedQtyService.class)).requestQty(saleOrderLine);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void cancelReservation(ActionRequest request, ActionResponse response) {
        try {
            SaleOrderLine saleOrderLine = (SaleOrderLine)((Object)request.getContext().asType(SaleOrderLine.class));
            saleOrderLine = (SaleOrderLine)((Object)((SaleOrderLineRepository)((Object)Beans.get(SaleOrderLineRepository.class))).find(saleOrderLine.getId()));
            Product product = saleOrderLine.getProduct();
            if (product == null || !product.getStockManaged().booleanValue()) {
                throw new AxelorException(5, I18n.get((String)"This product is not stock managed."));
            }
            ((ReservedQtyService)Beans.get(ReservedQtyService.class)).cancelReservation(saleOrderLine);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void supplierPartnerDomain(ActionRequest request, ActionResponse response) {
        String blockedPartnerQuery;
        SaleOrder saleOrder;
        SaleOrderLine saleOrderLine = (SaleOrderLine)((Object)request.getContext().asType(SaleOrderLine.class));
        String domain = "self.isContact = false AND self.isSupplier = true";
        Product product = saleOrderLine.getProduct();
        if (product != null) {
            List<Long> authorizedPartnerIdsList = ((SaleOrderLineServiceSupplyChain)Beans.get(SaleOrderLineServiceSupplyChain.class)).getSupplierPartnerList(saleOrderLine);
            if (authorizedPartnerIdsList.isEmpty()) {
                response.setAttr("supplierPartner", "domain", (Object)"self.id IN (0)");
                return;
            }
            domain = domain + String.format(" AND self.id IN (%s)", authorizedPartnerIdsList.stream().map(Object::toString).collect(Collectors.joining(",")));
        }
        if ((saleOrder = saleOrderLine.getSaleOrder()) == null) {
            Context parentContext = request.getContext().getParent();
            if (parentContext == null) {
                response.setAttr("supplierPartner", "domain", (Object)domain);
                return;
            }
            saleOrder = (SaleOrder)((Object)parentContext.asType(SaleOrder.class));
            if (saleOrder == null) {
                response.setAttr("supplierPartner", "domain", (Object)domain);
                return;
            }
        }
        if (!Strings.isNullOrEmpty((String)(blockedPartnerQuery = ((BlockingService)Beans.get(BlockingService.class)).listOfBlockedPartner(saleOrder.getCompany(), 6)))) {
            domain = domain + String.format(" AND self.id NOT in (%s)", blockedPartnerQuery);
        }
        if (saleOrder.getCompany() != null) {
            domain = domain + " AND " + saleOrder.getCompany().getId() + " in (SELECT id FROM self.companySet)";
        }
        response.setAttr("supplierPartner", "domain", (Object)domain);
    }

    public void supplierPartnerDefault(ActionRequest request, ActionResponse response) {
        Blocking blocking;
        SaleOrderLine saleOrderLine = (SaleOrderLine)((Object)request.getContext().asType(SaleOrderLine.class));
        if (saleOrderLine.getSaleSupplySelect() != 2) {
            return;
        }
        SaleOrder saleOrder = saleOrderLine.getSaleOrder();
        if (saleOrder == null) {
            Context parentContext = request.getContext().getParent();
            if (parentContext == null) {
                return;
            }
            saleOrder = (SaleOrder)((Object)parentContext.asType(SaleOrder.class));
        }
        if (saleOrder == null) {
            return;
        }
        Partner supplierPartner = null;
        if (saleOrderLine.getProduct() != null) {
            supplierPartner = saleOrderLine.getProduct().getDefaultSupplierPartner();
        }
        if (supplierPartner != null && (blocking = ((BlockingService)Beans.get(BlockingService.class)).getBlocking(supplierPartner, saleOrder.getCompany(), 6)) != null) {
            supplierPartner = null;
        }
        response.setValue("supplierPartner", (Object)supplierPartner);
    }

    public void allocateAll(ActionRequest request, ActionResponse response) {
        try {
            SaleOrderLine saleOrderLine = (SaleOrderLine)((Object)request.getContext().asType(SaleOrderLine.class));
            saleOrderLine = (SaleOrderLine)((Object)((SaleOrderLineRepository)((Object)Beans.get(SaleOrderLineRepository.class))).find(saleOrderLine.getId()));
            Product product = saleOrderLine.getProduct();
            if (product == null || !product.getStockManaged().booleanValue()) {
                throw new AxelorException(5, I18n.get((String)"This product is not stock managed."));
            }
            ((ReservedQtyService)Beans.get(ReservedQtyService.class)).allocateAll(saleOrderLine);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void deallocateAll(ActionRequest request, ActionResponse response) {
        try {
            SaleOrderLine saleOrderLine = (SaleOrderLine)((Object)request.getContext().asType(SaleOrderLine.class));
            saleOrderLine = (SaleOrderLine)((Object)((SaleOrderLineRepository)((Object)Beans.get(SaleOrderLineRepository.class))).find(saleOrderLine.getId()));
            ((ReservedQtyService)Beans.get(ReservedQtyService.class)).updateReservedQty(saleOrderLine, BigDecimal.ZERO);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void checkInvoicedOrDeliveredOrderQty(ActionRequest request, ActionResponse response) {
        SaleOrderLine saleOrderLine = (SaleOrderLine)((Object)request.getContext().asType(SaleOrderLine.class));
        BigDecimal qty = ((SaleOrderLineServiceSupplyChain)Beans.get(SaleOrderLineServiceSupplyChain.class)).checkInvoicedOrDeliveredOrderQty(saleOrderLine);
        response.setValue("qty", (Object)qty);
    }
}

