/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.web;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.PaymentCondition;
import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.apps.stock.db.repo.StockMoveRepository;
import com.axelor.apps.supplychain.db.SupplyChainConfig;
import com.axelor.apps.supplychain.service.StockMoveInvoiceService;
import com.axelor.apps.supplychain.service.StockMoveMultiInvoiceService;
import com.axelor.apps.supplychain.service.app.AppSupplychainService;
import com.axelor.apps.supplychain.service.config.SupplyChainConfigService;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.db.JPA;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.rpc.Context;
import com.google.common.base.Joiner;
import com.google.inject.Singleton;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@Singleton
public class StockMoveInvoiceController {
    public void generateInvoice(ActionRequest request, ActionResponse response) {
        try {
            Context context = request.getContext();
            if (context.containsKey((Object)"operationSelect")) {
                Integer operationSelect = Integer.parseInt(context.get((Object)"operationSelect").toString());
                List stockMoveLineListContext = null;
                if (operationSelect == 2 && context.containsKey((Object)"stockMoveLines")) {
                    stockMoveLineListContext = (List)context.get((Object)"stockMoveLines");
                }
                StockMove stockMove = (StockMove)((Object)((StockMoveRepository)((Object)Beans.get(StockMoveRepository.class))).find(Long.parseLong(request.getContext().get((Object)"_id").toString())));
                stockMove = (StockMove)((Object)((StockMoveRepository)((Object)Beans.get(StockMoveRepository.class))).find(stockMove.getId()));
                Invoice invoice = ((StockMoveInvoiceService)Beans.get(StockMoveInvoiceService.class)).createInvoice(stockMove, operationSelect, stockMoveLineListContext);
                if (invoice != null) {
                    response.setView(ActionView.define((String)I18n.get((String)"Invoice")).model(Invoice.class.getName()).add("grid", "invoice-grid").add("form", "invoice-form").param("search-filters", "customer-invoices-filters").param("forceEdit", "true").context("_showRecord", (Object)String.valueOf(invoice.getId())).context("_operationTypeSelect", (Object)invoice.getOperationTypeSelect()).context("todayDate", (Object)((AppSupplychainService)Beans.get(AppSupplychainService.class)).getTodayDate(stockMove.getCompany())).map());
                    response.setCanClose(true);
                } else {
                    response.setError(I18n.get((String)"Please fill a quantity to invoice."));
                }
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void generateInvoiceConcatOutStockMoveCheckMissingFields(ActionRequest request, ActionResponse response) {
        try {
            ArrayList<StockMove> stockMoveList = new ArrayList<StockMove>();
            ArrayList<Long> stockMoveIdList = new ArrayList<Long>();
            List stockMoveMap = (List)request.getContext().get((Object)"customerStockMoveToInvoice");
            for (Map map : stockMoveMap) {
                stockMoveIdList.add(Long.valueOf(((Integer)map.get("id")).intValue()));
            }
            for (Long stockMoveId : stockMoveIdList) {
                stockMoveList.add((StockMove)((Object)JPA.em().find(StockMove.class, (Object)stockMoveId)));
            }
            Map<String, Object> mapResult = ((StockMoveMultiInvoiceService)Beans.get(StockMoveMultiInvoiceService.class)).areFieldsConflictedToGenerateCustInvoice(stockMoveList);
            boolean paymentConditionToCheck = (Boolean)mapResult.getOrDefault("paymentConditionToCheck", false);
            boolean paymentModeToCheck = (Boolean)mapResult.getOrDefault("paymentModeToCheck", false);
            boolean contactPartnerToCheck = (Boolean)mapResult.getOrDefault("contactPartnerToCheck", false);
            StockMove stockMove = (StockMove)((Object)stockMoveList.get(0));
            Partner partner = stockMove.getPartner();
            if (paymentConditionToCheck || paymentModeToCheck || contactPartnerToCheck) {
                ActionView.ActionViewBuilder confirmView = ActionView.define((String)"StockMove").model(StockMove.class.getName()).add("form", "stock-move-supplychain-concat-cust-invoice-confirm-form").param("popup", "true").param("show-toolbar", "false").param("show-confirm", "false").param("popup-save", "false").param("forceEdit", "true");
                if (paymentConditionToCheck) {
                    confirmView.context("contextPaymentConditionToCheck", (Object)"true");
                } else {
                    confirmView.context("paymentCondition", mapResult.get("paymentCondition"));
                }
                if (paymentModeToCheck) {
                    confirmView.context("contextPaymentModeToCheck", (Object)"true");
                } else {
                    confirmView.context("paymentMode", mapResult.get("paymentMode"));
                }
                if (contactPartnerToCheck) {
                    confirmView.context("contextContactPartnerToCheck", (Object)"true");
                    confirmView.context("contextPartnerId", (Object)partner.getId().toString());
                } else {
                    confirmView.context("contactPartner", mapResult.get("contactPartner"));
                }
                confirmView.context("customerStockMoveToInvoice", (Object)Joiner.on((String)",").join(stockMoveIdList));
                response.setView(confirmView.map());
            } else {
                Optional<Invoice> invoice = ((StockMoveMultiInvoiceService)Beans.get(StockMoveMultiInvoiceService.class)).createInvoiceFromMultiOutgoingStockMove(stockMoveList);
                invoice.ifPresent(inv -> response.setView(ActionView.define((String)"Invoice").model(Invoice.class.getName()).add("grid", "invoice-grid").add("form", "invoice-form").param("search-filters", "customer-invoices-filters").param("forceEdit", "true").context("_operationTypeSelect", (Object)inv.getOperationTypeSelect()).context("todayDate", (Object)((AppSupplychainService)Beans.get(AppSupplychainService.class)).getTodayDate(stockMove.getCompany())).context("_showRecord", (Object)String.valueOf(inv.getId())).map()));
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void generateInvoiceConcatOutStockMove(ActionRequest request, ActionResponse response) {
        try {
            ArrayList<StockMove> stockMoveList = new ArrayList<StockMove>();
            String stockMoveListStr = (String)request.getContext().get((Object)"customerStockMoveToInvoice");
            for (String stockMoveId : stockMoveListStr.split(",")) {
                stockMoveList.add((StockMove)((Object)JPA.em().find(StockMove.class, (Object)new Long(stockMoveId))));
            }
            PaymentCondition paymentCondition = null;
            PaymentMode paymentMode = null;
            Partner contactPartner = null;
            if (request.getContext().get((Object)"paymentCondition") != null) {
                paymentCondition = (PaymentCondition)JPA.em().find(PaymentCondition.class, (Object)((Integer)((Map)request.getContext().get((Object)"paymentCondition")).get("id")));
            }
            if (request.getContext().get((Object)"paymentMode") != null) {
                paymentMode = (PaymentMode)((Object)JPA.em().find(PaymentMode.class, (Object)((Integer)((Map)request.getContext().get((Object)"paymentMode")).get("id"))));
            }
            if (request.getContext().get((Object)"contactPartner") != null) {
                contactPartner = (Partner)((Object)JPA.em().find(Partner.class, (Object)((Integer)((Map)request.getContext().get((Object)"contactPartner")).get("id"))));
            }
            Optional<Invoice> invoice = ((StockMoveMultiInvoiceService)Beans.get(StockMoveMultiInvoiceService.class)).createInvoiceFromMultiOutgoingStockMove(stockMoveList, paymentCondition, paymentMode, contactPartner);
            invoice.ifPresent(inv -> response.setView(ActionView.define((String)"Invoice").model(Invoice.class.getName()).add("grid", "invoice-grid").add("form", "invoice-form").param("search-filters", "customer-invoices-filters").param("forceEdit", "true").context("_showRecord", (Object)String.valueOf(inv.getId())).context("_operationTypeSelect", (Object)inv.getOperationTypeSelect()).context("todayDate", (Object)((AppSupplychainService)Beans.get(AppSupplychainService.class)).getTodayDate(inv.getCompany())).map()));
            response.setCanClose(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void generateInvoiceConcatInStockMoveCheckMissingFields(ActionRequest request, ActionResponse response) {
        try {
            ArrayList<StockMove> stockMoveList = new ArrayList<StockMove>();
            ArrayList<Long> stockMoveIdList = new ArrayList<Long>();
            List stockMoveMap = (List)request.getContext().get((Object)"supplierStockMoveToInvoice");
            for (Map map : stockMoveMap) {
                stockMoveIdList.add(Long.valueOf(((Integer)map.get("id")).intValue()));
            }
            for (Long stockMoveId : stockMoveIdList) {
                stockMoveList.add((StockMove)((Object)JPA.em().find(StockMove.class, (Object)stockMoveId)));
            }
            Map<String, Object> mapResult = ((StockMoveMultiInvoiceService)Beans.get(StockMoveMultiInvoiceService.class)).areFieldsConflictedToGenerateSupplierInvoice(stockMoveList);
            boolean paymentConditionToCheck = (Boolean)mapResult.getOrDefault("paymentConditionToCheck", false);
            boolean paymentModeToCheck = (Boolean)mapResult.getOrDefault("paymentModeToCheck", false);
            boolean contactPartnerToCheck = (Boolean)mapResult.getOrDefault("contactPartnerToCheck", false);
            Partner partner = ((StockMove)((Object)stockMoveList.get(0))).getPartner();
            if (paymentConditionToCheck || paymentModeToCheck || contactPartnerToCheck) {
                ActionView.ActionViewBuilder confirmView = ActionView.define((String)"StockMove").model(StockMove.class.getName()).add("form", "stock-move-supplychain-concat-suppl-invoice-confirm-form").param("popup", "true").param("show-toolbar", "false").param("show-confirm", "false").param("popup-save", "false").param("forceEdit", "true");
                if (paymentConditionToCheck) {
                    confirmView.context("contextPaymentConditionToCheck", (Object)"true");
                } else {
                    confirmView.context("paymentCondition", mapResult.get("paymentCondition"));
                }
                if (paymentModeToCheck) {
                    confirmView.context("contextPaymentModeToCheck", (Object)"true");
                } else {
                    confirmView.context("paymentMode", mapResult.get("paymentMode"));
                }
                if (contactPartnerToCheck) {
                    confirmView.context("contextContactPartnerToCheck", (Object)"true");
                    confirmView.context("contextPartnerId", (Object)partner.getId().toString());
                } else {
                    confirmView.context("contactPartner", mapResult.get("contactPartner"));
                }
                confirmView.context("supplierStockMoveToInvoice", (Object)Joiner.on((String)",").join(stockMoveIdList));
                response.setView(confirmView.map());
            } else {
                Optional<Invoice> invoice = ((StockMoveMultiInvoiceService)Beans.get(StockMoveMultiInvoiceService.class)).createInvoiceFromMultiIncomingStockMove(stockMoveList);
                invoice.ifPresent(inv -> response.setView(ActionView.define((String)"Invoice").model(Invoice.class.getName()).add("grid", "invoice-grid").add("form", "invoice-form").param("search-filters", "customer-invoices-filters").param("forceEdit", "true").context("_showRecord", (Object)String.valueOf(inv.getId())).context("_operationTypeSelect", (Object)inv.getOperationTypeSelect()).context("todayDate", (Object)((AppSupplychainService)Beans.get(AppSupplychainService.class)).getTodayDate(inv.getCompany())).map()));
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void generateInvoiceConcatInStockMove(ActionRequest request, ActionResponse response) {
        try {
            ArrayList<StockMove> stockMoveList = new ArrayList<StockMove>();
            String stockMoveListStr = (String)request.getContext().get((Object)"supplierStockMoveToInvoice");
            for (String stockMoveId : stockMoveListStr.split(",")) {
                stockMoveList.add((StockMove)((Object)JPA.em().find(StockMove.class, (Object)new Long(stockMoveId))));
            }
            PaymentCondition paymentCondition = null;
            PaymentMode paymentMode = null;
            Partner contactPartner = null;
            if (request.getContext().get((Object)"paymentCondition") != null) {
                paymentCondition = (PaymentCondition)JPA.em().find(PaymentCondition.class, (Object)((Integer)((Map)request.getContext().get((Object)"paymentCondition")).get("id")));
            }
            if (request.getContext().get((Object)"paymentMode") != null) {
                paymentMode = (PaymentMode)((Object)JPA.em().find(PaymentMode.class, (Object)((Integer)((Map)request.getContext().get((Object)"paymentMode")).get("id"))));
            }
            if (request.getContext().get((Object)"contactPartner") != null) {
                contactPartner = (Partner)((Object)JPA.em().find(Partner.class, (Object)((Integer)((Map)request.getContext().get((Object)"contactPartner")).get("id"))));
            }
            Optional<Invoice> invoice = ((StockMoveMultiInvoiceService)Beans.get(StockMoveMultiInvoiceService.class)).createInvoiceFromMultiIncomingStockMove(stockMoveList, paymentCondition, paymentMode, contactPartner);
            invoice.ifPresent(inv -> response.setView(ActionView.define((String)"Invoice").model(Invoice.class.getName()).add("grid", "invoice-grid").add("form", "invoice-form").param("search-filters", "customer-invoices-filters").param("forceEdit", "true").context("_showRecord", (Object)String.valueOf(inv.getId())).context("_operationTypeSelect", (Object)inv.getOperationTypeSelect()).context("todayDate", (Object)((AppSupplychainService)Beans.get(AppSupplychainService.class)).getTodayDate(inv.getCompany())).map()));
            response.setCanClose(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void generateMultiCustomerInvoice(ActionRequest request, ActionResponse response) {
        try {
            List stockMoveMap = (List)request.getContext().get((Object)"customerStockMoveToInvoice");
            ArrayList<Long> stockMoveIdList = new ArrayList<Long>();
            ArrayList<StockMove> stockMoveList = new ArrayList<StockMove>();
            for (Map map : stockMoveMap) {
                stockMoveIdList.add(((Number)map.get("id")).longValue());
            }
            for (Long stockMoveId : stockMoveIdList) {
                stockMoveList.add((StockMove)((Object)JPA.em().find(StockMove.class, (Object)stockMoveId)));
            }
            ((StockMoveMultiInvoiceService)Beans.get(StockMoveMultiInvoiceService.class)).checkForAlreadyInvoicedStockMove(stockMoveList);
            Map.Entry<List<Long>, String> result = ((StockMoveMultiInvoiceService)Beans.get(StockMoveMultiInvoiceService.class)).generateMultipleInvoices(stockMoveIdList);
            List<Long> invoiceIdList = result.getKey();
            String warningMessage = result.getValue();
            if (!invoiceIdList.isEmpty()) {
                ActionView.ActionViewBuilder viewBuilder = ActionView.define((String)"Cust. Invoices");
                viewBuilder.model(Invoice.class.getName()).add("grid", "invoice-grid").add("form", "invoice-form").param("search-filters", "customer-invoices-filters").domain("self.id IN (" + Joiner.on((String)",").join(invoiceIdList) + ")").context("_operationTypeSelect", (Object)3).context("todayDate", (Object)((AppSupplychainService)Beans.get(AppSupplychainService.class)).getTodayDate(Optional.ofNullable(AuthUtils.getUser()).map(User::getActiveCompany).orElse(null)));
                response.setView(viewBuilder.map());
            }
            if (warningMessage != null && !warningMessage.isEmpty()) {
                response.setFlash(warningMessage);
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void generateMultiSupplierInvoice(ActionRequest request, ActionResponse response) {
        try {
            List stockMoveMap = (List)request.getContext().get((Object)"supplierStockMoveToInvoice");
            ArrayList<Long> stockMoveIdList = new ArrayList<Long>();
            ArrayList<StockMove> stockMoveList = new ArrayList<StockMove>();
            for (Map map : stockMoveMap) {
                stockMoveIdList.add(((Number)map.get("id")).longValue());
            }
            for (Long stockMoveId : stockMoveIdList) {
                stockMoveList.add((StockMove)((Object)JPA.em().find(StockMove.class, (Object)stockMoveId)));
            }
            ((StockMoveMultiInvoiceService)Beans.get(StockMoveMultiInvoiceService.class)).checkForAlreadyInvoicedStockMove(stockMoveList);
            Map.Entry<List<Long>, String> result = ((StockMoveMultiInvoiceService)Beans.get(StockMoveMultiInvoiceService.class)).generateMultipleInvoices(stockMoveIdList);
            List<Long> invoiceIdList = result.getKey();
            String warningMessage = result.getValue();
            if (!invoiceIdList.isEmpty()) {
                ActionView.ActionViewBuilder viewBuilder = ActionView.define((String)"Suppl. Invoices");
                viewBuilder.model(Invoice.class.getName()).add("grid", "invoice-grid").add("form", "invoice-form").param("search-filters", "customer-invoices-filters").domain("self.id IN (" + Joiner.on((String)",").join(invoiceIdList) + ")").context("_operationTypeSelect", (Object)1).context("todayDate", (Object)((AppSupplychainService)Beans.get(AppSupplychainService.class)).getTodayDate(Optional.ofNullable(AuthUtils.getUser()).map(User::getActiveCompany).orElse(null)));
                response.setView(viewBuilder.map());
            }
            if (warningMessage != null && !warningMessage.isEmpty()) {
                response.setFlash(warningMessage);
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void fillDefaultValueWizard(ActionRequest request, ActionResponse response) {
        try {
            Long id = Long.parseLong(request.getContext().get((Object)"_id").toString());
            StockMove stockMove = (StockMove)((Object)((StockMoveRepository)((Object)Beans.get(StockMoveRepository.class))).find(id));
            StockMoveInvoiceService stockMoveInvoiceService = (StockMoveInvoiceService)Beans.get(StockMoveInvoiceService.class);
            BigDecimal totalInvoicedQty = stockMoveInvoiceService.computeNonCanceledInvoiceQty(stockMove);
            if (totalInvoicedQty.compareTo(BigDecimal.ZERO) == 0) {
                response.setValue("operationSelect", (Object)1);
            } else {
                response.setValue("operationSelect", (Object)2);
                response.setAttr("operationSelect", "selection-in", (Object)"[2]");
            }
            List<Map<String, Object>> stockMoveLines = ((StockMoveInvoiceService)Beans.get(StockMoveInvoiceService.class)).getStockMoveLinesToInvoice(stockMove);
            response.setValue("$stockMoveLines", stockMoveLines);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void openInvoicingWizard(ActionRequest request, ActionResponse response) {
        try {
            boolean isPartialInvoicingActivated;
            response.setReload(true);
            StockMove stockMove = (StockMove)((Object)request.getContext().asType(StockMove.class));
            stockMove = (StockMove)((Object)((StockMoveRepository)((Object)Beans.get(StockMoveRepository.class))).find(stockMove.getId()));
            StockMoveInvoiceService stockMoveInvoiceService = (StockMoveInvoiceService)Beans.get(StockMoveInvoiceService.class);
            List<Map<String, Object>> stockMoveLines = stockMoveInvoiceService.getStockMoveLinesToInvoice(stockMove);
            Company company = stockMove.getCompany();
            SupplyChainConfig supplyChainConfig = ((SupplyChainConfigService)Beans.get(SupplyChainConfigService.class)).getSupplyChainConfig(company);
            boolean bl = isPartialInvoicingActivated = stockMove.getTypeSelect() == 3 && supplyChainConfig.getActivateIncStockMovePartialInvoicing() != false || stockMove.getTypeSelect() == 2 && supplyChainConfig.getActivateOutStockMovePartialInvoicing() != false;
            if (isPartialInvoicingActivated && !stockMoveLines.isEmpty()) {
                response.setView(ActionView.define((String)I18n.get((String)"Invoicing")).model(StockMove.class.getName()).add("form", "stock-move-invoicing-wizard-form").param("popup", "reload").param("show-toolbar", "false").param("show-confirm", "false").param("width", "large").param("popup-save", "false").context("_id", (Object)stockMove.getId()).map());
            } else if (!stockMoveLines.isEmpty()) {
                Invoice invoice = stockMoveInvoiceService.createInvoice(stockMove, 1, null);
                if (invoice != null) {
                    response.setView(ActionView.define((String)I18n.get((String)"Invoice")).model(Invoice.class.getName()).add("grid", "invoice-grid").add("form", "invoice-form").param("search-filters", "customer-invoices-filters").param("forceEdit", "true").context("_showRecord", (Object)String.valueOf(invoice.getId())).context("_operationTypeSelect", (Object)invoice.getOperationTypeSelect()).context("todayDate", (Object)((AppSupplychainService)Beans.get(AppSupplychainService.class)).getTodayDate(company)).map());
                }
            } else {
                response.setAlert(I18n.get((String)"Stock move has already been totally invoiced."));
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }
}

