/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.web;

import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.stock.db.StockMoveLine;
import com.axelor.apps.stock.db.repo.StockMoveLineRepository;
import com.axelor.apps.supplychain.service.ReservedQtyService;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.inject.Inject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;

public class StockMoveLineController {
    @Inject
    AppBaseService appBaseService;

    public List<StockMoveLine> updateQty(List<StockMoveLine> moveLines, BigDecimal oldKitQty, BigDecimal newKitQty, boolean isRealQty) {
        block4: {
            BigDecimal qty = BigDecimal.ZERO;
            int scale = this.appBaseService.getNbDecimalDigitForQty();
            if (moveLines == null) break block4;
            if (newKitQty.compareTo(BigDecimal.ZERO) != 0) {
                for (StockMoveLine line : moveLines) {
                    qty = line.getQty().divide(oldKitQty, scale, RoundingMode.HALF_EVEN).multiply(newKitQty);
                    line.setQty(qty.setScale(scale, RoundingMode.HALF_EVEN));
                    line.setRealQty(qty.setScale(scale, RoundingMode.HALF_EVEN));
                }
            } else {
                for (StockMoveLine line : moveLines) {
                    line.setQty(qty.setScale(scale, RoundingMode.HALF_EVEN));
                    line.setRealQty(qty.setScale(scale, RoundingMode.HALF_EVEN));
                }
            }
        }
        return moveLines;
    }

    public List<StockMoveLine> updateRealQty(List<StockMoveLine> moveLines, BigDecimal oldKitQty, BigDecimal newKitQty, boolean isRealQty) {
        block4: {
            BigDecimal qty = BigDecimal.ZERO;
            int scale = this.appBaseService.getNbDecimalDigitForQty();
            if (moveLines == null) break block4;
            if (newKitQty.compareTo(BigDecimal.ZERO) != 0) {
                for (StockMoveLine line : moveLines) {
                    qty = line.getRealQty().divide(oldKitQty, scale, RoundingMode.HALF_EVEN).multiply(newKitQty);
                    line.setRealQty(qty.setScale(scale, RoundingMode.HALF_EVEN));
                }
            } else {
                for (StockMoveLine line : moveLines) {
                    line.setRealQty(qty.setScale(scale, RoundingMode.HALF_EVEN));
                }
            }
        }
        return moveLines;
    }

    public void allocateAll(ActionRequest request, ActionResponse response) {
        try {
            StockMoveLine stockMoveLine = (StockMoveLine)((Object)request.getContext().asType(StockMoveLine.class));
            stockMoveLine = (StockMoveLine)((Object)((StockMoveLineRepository)((Object)Beans.get(StockMoveLineRepository.class))).find(stockMoveLine.getId()));
            Product product = stockMoveLine.getProduct();
            if (product == null || !product.getStockManaged().booleanValue()) {
                throw new AxelorException(5, I18n.get((String)"This product is not stock managed."));
            }
            ((ReservedQtyService)Beans.get(ReservedQtyService.class)).allocateAll(stockMoveLine);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void deallocateAll(ActionRequest request, ActionResponse response) {
        try {
            StockMoveLine stockMoveLine = (StockMoveLine)((Object)request.getContext().asType(StockMoveLine.class));
            stockMoveLine = (StockMoveLine)((Object)((StockMoveLineRepository)((Object)Beans.get(StockMoveLineRepository.class))).find(stockMoveLine.getId()));
            ((ReservedQtyService)Beans.get(ReservedQtyService.class)).updateReservedQty(stockMoveLine, BigDecimal.ZERO);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void requestQty(ActionRequest request, ActionResponse response) {
        try {
            StockMoveLine stockMoveLine = (StockMoveLine)((Object)request.getContext().asType(StockMoveLine.class));
            stockMoveLine = (StockMoveLine)((Object)((StockMoveLineRepository)((Object)Beans.get(StockMoveLineRepository.class))).find(stockMoveLine.getId()));
            Product product = stockMoveLine.getProduct();
            if (product == null || !product.getStockManaged().booleanValue()) {
                throw new AxelorException(5, I18n.get((String)"This product is not stock managed."));
            }
            ((ReservedQtyService)Beans.get(ReservedQtyService.class)).requestQty(stockMoveLine);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void cancelReservation(ActionRequest request, ActionResponse response) {
        try {
            StockMoveLine stockMoveLine = (StockMoveLine)((Object)request.getContext().asType(StockMoveLine.class));
            stockMoveLine = (StockMoveLine)((Object)((StockMoveLineRepository)((Object)Beans.get(StockMoveLineRepository.class))).find(stockMoveLine.getId()));
            Product product = stockMoveLine.getProduct();
            if (product == null || !product.getStockManaged().booleanValue()) {
                throw new AxelorException(5, I18n.get((String)"This product is not stock managed."));
            }
            ((ReservedQtyService)Beans.get(ReservedQtyService.class)).cancelReservation(stockMoveLine);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void changeReservedQty(ActionRequest request, ActionResponse response) {
        try {
            StockMoveLine stockMoveLine = (StockMoveLine)((Object)request.getContext().asType(StockMoveLine.class));
            BigDecimal newReservedQty = stockMoveLine.getReservedQty();
            stockMoveLine = (StockMoveLine)((Object)((StockMoveLineRepository)((Object)Beans.get(StockMoveLineRepository.class))).find(stockMoveLine.getId()));
            Product product = stockMoveLine.getProduct();
            if (product == null || !product.getStockManaged().booleanValue()) {
                throw new AxelorException(5, I18n.get((String)"This product is not stock managed."));
            }
            ((ReservedQtyService)Beans.get(ReservedQtyService.class)).updateReservedQty(stockMoveLine, newReservedQty);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }
}

