/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.web;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.supplychain.db.Timetable;
import com.axelor.apps.supplychain.db.TimetableTemplate;
import com.axelor.apps.supplychain.db.repo.TimetableRepository;
import com.axelor.apps.supplychain.service.TimetableService;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.rpc.Context;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;

@Singleton
public class TimetableController {
    @Inject
    TimetableService timetableService;

    public void generateInvoice(ActionRequest request, ActionResponse response) throws AxelorException {
        PurchaseOrder purchaseOrder;
        SaleOrder saleOrder;
        Timetable timetable = (Timetable)((Object)request.getContext().asType(Timetable.class));
        timetable = (Timetable)((Object)((TimetableRepository)((Object)Beans.get(TimetableRepository.class))).find(timetable.getId()));
        Context parentContext = request.getContext().getParent();
        if (parentContext != null && parentContext.getContextClass().equals(SaleOrder.class) && (saleOrder = (SaleOrder)((Object)parentContext.asType(SaleOrder.class))).getStatusSelect() < 3) {
            response.setAlert(I18n.get((String)"Please confirm the sale order before invoicing."));
            return;
        }
        if (parentContext != null && parentContext.getContextClass().equals(PurchaseOrder.class) && (purchaseOrder = (PurchaseOrder)((Object)parentContext.asType(PurchaseOrder.class))).getStatusSelect() < 3) {
            response.setAlert(I18n.get((String)"Please validate the purchase order before invoicing."));
            return;
        }
        if (timetable.getInvoice() != null) {
            response.setAlert(I18n.get((String)"The invoice has already been generated."));
            return;
        }
        Invoice invoice = this.timetableService.generateInvoice(timetable);
        response.setReload(true);
        response.setView(ActionView.define((String)I18n.get((String)"Invoice generated")).model("com.axelor.apps.account.db.Invoice").add("form", "invoice-form").add("grid", "invoice-grid").param("search-filters", "customer-invoices-filters").param("forceEdit", "true").context("_showRecord", (Object)invoice.getId().toString()).map());
    }

    public void applyTemplate(ActionRequest request, ActionResponse response) {
        Context context = request.getContext();
        try {
            if (context.get((Object)"timetableTemplate") == null || context.get((Object)"exTaxTotal") == null || context.get((Object)"computationDate") == null) {
                return;
            }
            TimetableTemplate template = (TimetableTemplate)((Object)context.get((Object)"timetableTemplate"));
            List<Timetable> timetableList = this.timetableService.applyTemplate(template, (BigDecimal)context.get((Object)"exTaxTotal"), (LocalDate)context.get((Object)"computationDate"));
            response.setValue("timetableList", timetableList);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }
}

