/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.team.db;

import com.axelor.apps.account.db.InvoiceLine;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.db.Frequency;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.Timer;
import com.axelor.apps.base.db.Unit;
import com.axelor.apps.businesssupport.db.ProjectVersion;
import com.axelor.apps.project.db.Project;
import com.axelor.apps.project.db.ProjectPlanningTime;
import com.axelor.apps.project.db.TeamTaskCategory;
import com.axelor.apps.project.db.TeamTaskTag;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Track;
import com.axelor.db.annotations.TrackEvent;
import com.axelor.db.annotations.TrackField;
import com.axelor.db.annotations.TrackMessage;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaFile;
import com.axelor.team.db.Team;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="TEAM_TASK", indexes={@Index(columnList="team"), @Index(columnList="name"), @Index(columnList="assigned_to"), @Index(columnList="frequency"), @Index(columnList="next_team_task"), @Index(columnList="project"), @Index(columnList="fullName"), @Index(columnList="parent_task"), @Index(columnList="team_task_category"), @Index(columnList="team"), @Index(columnList="product"), @Index(columnList="unit"), @Index(columnList="meta_file"), @Index(columnList="customer_referral"), @Index(columnList="sale_order_line"), @Index(columnList="invoice_line"), @Index(columnList="target_version")})
@Track(fields={@TrackField(name="status"), @TrackField(name="teamTaskCategory"), @TrackField(name="progressSelect"), @TrackField(name="assignedTo"), @TrackField(name="invoicingType"), @TrackField(name="customerReferral"), @TrackField(name="isOrderAccepted"), @TrackField(name="assignment"), @TrackField(name="targetVersion")}, messages={@TrackMessage(message="Task updated", condition="true", on={TrackEvent.UPDATE})})
public class TeamTask
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="TEAM_TASK_SEQ")
    @SequenceGenerator(name="TEAM_TASK_SEQ", sequenceName="TEAM_TASK_SEQ", allocationSize=1)
    private Long id;
    @NotNull
    private String name;
    @Widget(selection="team.task.status")
    private String status;
    @Widget(selection="team.task.priority")
    private String priority;
    private Integer sequence = 0;
    private LocalDate taskDate;
    private Integer taskDuration = 0;
    private LocalDate taskDeadline;
    private String relatedModel;
    private String relatedName;
    private Long relatedId = 0L;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User assignedTo;
    @Widget(title="Frequency")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Frequency frequency;
    @Widget(title="Next task", readonly=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private TeamTask nextTeamTask;
    @Widget(title="First", readonly=true)
    private Boolean isFirst = Boolean.FALSE;
    @Widget(title="Apply modifications to next tasks")
    private Boolean doApplyToAllNextTasks = Boolean.FALSE;
    @Widget(title="Date or frequency changed", readonly=true)
    private Boolean hasDateOrFrequencyChanged = Boolean.FALSE;
    @Widget(title="Type", selection="team.task.type.select")
    private String typeSelect = "task";
    @Widget(title="Project")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Project project;
    @Widget(title="Name", search={"id", "name"})
    @NameColumn
    private String fullName;
    @Widget(title="Parent task")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private TeamTask parentTask;
    @Widget(title="Category")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private TeamTaskCategory teamTaskCategory;
    @Widget(title="Progress", selection="project.task.progress.select")
    private Integer progressSelect = 0;
    @Widget(title="Team")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Team team;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="parentTask", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<TeamTask> teamTaskList;
    @Widget(title="Followers")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<User> membersUserSet;
    @Widget(title="Description")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String description;
    @Widget(title="Product")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Product product;
    @Widget(title="Unit")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Unit unit;
    @Widget(title="Quantity")
    private BigDecimal quantity = BigDecimal.ZERO;
    @Widget(title="Unit price")
    private BigDecimal unitPrice = BigDecimal.ZERO;
    @Widget(title="Currency")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Currency currency;
    @Widget(title="Planned progress")
    private BigDecimal plannedProgress = BigDecimal.ZERO;
    @Widget(title="Predecessors tasks")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<TeamTask> finishToStartSet;
    @Widget(title="Tasks to start before start")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<TeamTask> startToStartSet;
    @Widget(title="Tasks to finish before finish")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<TeamTask> finishToFinishSet;
    @Widget(title="Duration hours")
    private BigDecimal durationHours = BigDecimal.ZERO;
    @Widget(title="Task end")
    private LocalDate taskEndDate;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private List<Timer> timerList;
    @Widget(title="Estimated time")
    private BigDecimal budgetedTime = BigDecimal.ZERO;
    @Widget(title="Signature")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaFile metaFile;
    @Widget(title="Tags")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<TeamTaskTag> teamTaskTagSet;
    @Widget(title="Total planned hours")
    private BigDecimal totalPlannedHrs = BigDecimal.ZERO;
    @Widget(title="Total real hours")
    private BigDecimal totalRealHrs = BigDecimal.ZERO;
    @Widget(title="Project planning time lines")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="task", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ProjectPlanningTime> projectPlanningTimeList;
    @Widget(title="To invoice")
    private Boolean toInvoice = Boolean.FALSE;
    @Widget(title="Invoiced")
    private Boolean invoiced = Boolean.FALSE;
    @Widget(title="teamTask.exTaxTotal")
    private BigDecimal exTaxTotal = BigDecimal.ZERO;
    @Widget(title="Discount type", selection="base.price.list.line.amount.type.select")
    private Integer discountTypeSelect = 3;
    @Widget(title="Discount amount")
    @Digits(integer=10, fraction=10)
    private BigDecimal discountAmount = BigDecimal.ZERO;
    @Widget(title="Unit price discounted")
    @Digits(integer=10, fraction=10)
    private BigDecimal priceDiscounted = BigDecimal.ZERO;
    @Widget(title="Invoicing Type", selection="business.team.task.invoicing.type.select")
    private Integer invoicingType = 3;
    @Widget(title="Paid")
    private Boolean isPaid = Boolean.FALSE;
    @Widget(title="Customer referral")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User customerReferral;
    @Widget(title="Related sale order line")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private SaleOrderLine saleOrderLine;
    @Widget(title="Related Invoice line")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private InvoiceLine invoiceLine;
    @Widget(title="Refused")
    private Boolean isTaskRefused = Boolean.FALSE;
    @Widget(title="Assignment", selection="support.assignment.select")
    private Integer assignment = 0;
    @Widget(title="Private")
    private Boolean isPrivate = Boolean.FALSE;
    @Widget(title="Order Accepted")
    private Boolean isOrderAccepted = Boolean.FALSE;
    @Widget(title="Internal Description", multiline=true)
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String internalDescription;
    @Widget(title="Target version")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ProjectVersion targetVersion;
    @Widget(title="Order Proposed")
    private Boolean isOrderProposed = Boolean.FALSE;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public TeamTask() {
    }

    public TeamTask(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getPriority() {
        return this.priority;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public Integer getSequence() {
        return this.sequence == null ? 0 : this.sequence;
    }

    public void setSequence(Integer sequence) {
        this.sequence = sequence;
    }

    public LocalDate getTaskDate() {
        return this.taskDate;
    }

    public void setTaskDate(LocalDate taskDate) {
        this.taskDate = taskDate;
    }

    public Integer getTaskDuration() {
        return this.taskDuration == null ? 0 : this.taskDuration;
    }

    public void setTaskDuration(Integer taskDuration) {
        this.taskDuration = taskDuration;
    }

    public LocalDate getTaskDeadline() {
        return this.taskDeadline;
    }

    public void setTaskDeadline(LocalDate taskDeadline) {
        this.taskDeadline = taskDeadline;
    }

    public String getRelatedModel() {
        return this.relatedModel;
    }

    public void setRelatedModel(String relatedModel) {
        this.relatedModel = relatedModel;
    }

    public String getRelatedName() {
        return this.relatedName;
    }

    public void setRelatedName(String relatedName) {
        this.relatedName = relatedName;
    }

    public Long getRelatedId() {
        return this.relatedId == null ? 0L : this.relatedId;
    }

    public void setRelatedId(Long relatedId) {
        this.relatedId = relatedId;
    }

    public User getAssignedTo() {
        return this.assignedTo;
    }

    public void setAssignedTo(User assignedTo) {
        this.assignedTo = assignedTo;
    }

    public Frequency getFrequency() {
        return this.frequency;
    }

    public void setFrequency(Frequency frequency) {
        this.frequency = frequency;
    }

    public TeamTask getNextTeamTask() {
        return this.nextTeamTask;
    }

    public void setNextTeamTask(TeamTask nextTeamTask) {
        this.nextTeamTask = nextTeamTask;
    }

    public Boolean getIsFirst() {
        return this.isFirst == null ? Boolean.FALSE : this.isFirst;
    }

    public void setIsFirst(Boolean isFirst) {
        this.isFirst = isFirst;
    }

    public Boolean getDoApplyToAllNextTasks() {
        return this.doApplyToAllNextTasks == null ? Boolean.FALSE : this.doApplyToAllNextTasks;
    }

    public void setDoApplyToAllNextTasks(Boolean doApplyToAllNextTasks) {
        this.doApplyToAllNextTasks = doApplyToAllNextTasks;
    }

    public Boolean getHasDateOrFrequencyChanged() {
        return this.hasDateOrFrequencyChanged == null ? Boolean.FALSE : this.hasDateOrFrequencyChanged;
    }

    public void setHasDateOrFrequencyChanged(Boolean hasDateOrFrequencyChanged) {
        this.hasDateOrFrequencyChanged = hasDateOrFrequencyChanged;
    }

    public String getTypeSelect() {
        return this.typeSelect;
    }

    public void setTypeSelect(String typeSelect) {
        this.typeSelect = typeSelect;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public TeamTask getParentTask() {
        return this.parentTask;
    }

    public void setParentTask(TeamTask parentTask) {
        this.parentTask = parentTask;
    }

    public TeamTaskCategory getTeamTaskCategory() {
        return this.teamTaskCategory;
    }

    public void setTeamTaskCategory(TeamTaskCategory teamTaskCategory) {
        this.teamTaskCategory = teamTaskCategory;
    }

    public Integer getProgressSelect() {
        return this.progressSelect == null ? 0 : this.progressSelect;
    }

    public void setProgressSelect(Integer progressSelect) {
        this.progressSelect = progressSelect;
    }

    public Team getTeam() {
        return this.team;
    }

    public void setTeam(Team team) {
        this.team = team;
    }

    public List<TeamTask> getTeamTaskList() {
        return this.teamTaskList;
    }

    public void setTeamTaskList(List<TeamTask> teamTaskList) {
        this.teamTaskList = teamTaskList;
    }

    public void addTeamTaskListItem(TeamTask item) {
        if (this.getTeamTaskList() == null) {
            this.setTeamTaskList(new ArrayList());
        }
        this.getTeamTaskList().add(item);
        item.setParentTask(this);
    }

    public void removeTeamTaskListItem(TeamTask item) {
        if (this.getTeamTaskList() == null) {
            return;
        }
        this.getTeamTaskList().remove(item);
    }

    public void clearTeamTaskList() {
        if (this.getTeamTaskList() != null) {
            this.getTeamTaskList().clear();
        }
    }

    public Set<User> getMembersUserSet() {
        return this.membersUserSet;
    }

    public void setMembersUserSet(Set<User> membersUserSet) {
        this.membersUserSet = membersUserSet;
    }

    public void addMembersUserSetItem(User item) {
        if (this.getMembersUserSet() == null) {
            this.setMembersUserSet(new HashSet());
        }
        this.getMembersUserSet().add(item);
    }

    public void removeMembersUserSetItem(User item) {
        if (this.getMembersUserSet() == null) {
            return;
        }
        this.getMembersUserSet().remove(item);
    }

    public void clearMembersUserSet() {
        if (this.getMembersUserSet() != null) {
            this.getMembersUserSet().clear();
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    public BigDecimal getQuantity() {
        return this.quantity == null ? BigDecimal.ZERO : this.quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    public BigDecimal getUnitPrice() {
        return this.unitPrice == null ? BigDecimal.ZERO : this.unitPrice;
    }

    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public BigDecimal getPlannedProgress() {
        return this.plannedProgress == null ? BigDecimal.ZERO : this.plannedProgress;
    }

    public void setPlannedProgress(BigDecimal plannedProgress) {
        this.plannedProgress = plannedProgress;
    }

    public Set<TeamTask> getFinishToStartSet() {
        return this.finishToStartSet;
    }

    public void setFinishToStartSet(Set<TeamTask> finishToStartSet) {
        this.finishToStartSet = finishToStartSet;
    }

    public void addFinishToStartSetItem(TeamTask item) {
        if (this.getFinishToStartSet() == null) {
            this.setFinishToStartSet(new HashSet());
        }
        this.getFinishToStartSet().add(item);
    }

    public void removeFinishToStartSetItem(TeamTask item) {
        if (this.getFinishToStartSet() == null) {
            return;
        }
        this.getFinishToStartSet().remove(item);
    }

    public void clearFinishToStartSet() {
        if (this.getFinishToStartSet() != null) {
            this.getFinishToStartSet().clear();
        }
    }

    public Set<TeamTask> getStartToStartSet() {
        return this.startToStartSet;
    }

    public void setStartToStartSet(Set<TeamTask> startToStartSet) {
        this.startToStartSet = startToStartSet;
    }

    public void addStartToStartSetItem(TeamTask item) {
        if (this.getStartToStartSet() == null) {
            this.setStartToStartSet(new HashSet());
        }
        this.getStartToStartSet().add(item);
    }

    public void removeStartToStartSetItem(TeamTask item) {
        if (this.getStartToStartSet() == null) {
            return;
        }
        this.getStartToStartSet().remove(item);
    }

    public void clearStartToStartSet() {
        if (this.getStartToStartSet() != null) {
            this.getStartToStartSet().clear();
        }
    }

    public Set<TeamTask> getFinishToFinishSet() {
        return this.finishToFinishSet;
    }

    public void setFinishToFinishSet(Set<TeamTask> finishToFinishSet) {
        this.finishToFinishSet = finishToFinishSet;
    }

    public void addFinishToFinishSetItem(TeamTask item) {
        if (this.getFinishToFinishSet() == null) {
            this.setFinishToFinishSet(new HashSet());
        }
        this.getFinishToFinishSet().add(item);
    }

    public void removeFinishToFinishSetItem(TeamTask item) {
        if (this.getFinishToFinishSet() == null) {
            return;
        }
        this.getFinishToFinishSet().remove(item);
    }

    public void clearFinishToFinishSet() {
        if (this.getFinishToFinishSet() != null) {
            this.getFinishToFinishSet().clear();
        }
    }

    public BigDecimal getDurationHours() {
        return this.durationHours == null ? BigDecimal.ZERO : this.durationHours;
    }

    public void setDurationHours(BigDecimal durationHours) {
        this.durationHours = durationHours;
    }

    public LocalDate getTaskEndDate() {
        return this.taskEndDate;
    }

    public void setTaskEndDate(LocalDate taskEndDate) {
        this.taskEndDate = taskEndDate;
    }

    public List<Timer> getTimerList() {
        return this.timerList;
    }

    public void setTimerList(List<Timer> timerList) {
        this.timerList = timerList;
    }

    public void addTimerListItem(Timer item) {
        if (this.getTimerList() == null) {
            this.setTimerList(new ArrayList());
        }
        this.getTimerList().add(item);
    }

    public void removeTimerListItem(Timer item) {
        if (this.getTimerList() == null) {
            return;
        }
        this.getTimerList().remove(item);
    }

    public void clearTimerList() {
        if (this.getTimerList() != null) {
            this.getTimerList().clear();
        }
    }

    public BigDecimal getBudgetedTime() {
        return this.budgetedTime == null ? BigDecimal.ZERO : this.budgetedTime;
    }

    public void setBudgetedTime(BigDecimal budgetedTime) {
        this.budgetedTime = budgetedTime;
    }

    public MetaFile getMetaFile() {
        return this.metaFile;
    }

    public void setMetaFile(MetaFile metaFile) {
        this.metaFile = metaFile;
    }

    public Set<TeamTaskTag> getTeamTaskTagSet() {
        return this.teamTaskTagSet;
    }

    public void setTeamTaskTagSet(Set<TeamTaskTag> teamTaskTagSet) {
        this.teamTaskTagSet = teamTaskTagSet;
    }

    public void addTeamTaskTagSetItem(TeamTaskTag item) {
        if (this.getTeamTaskTagSet() == null) {
            this.setTeamTaskTagSet(new HashSet());
        }
        this.getTeamTaskTagSet().add(item);
    }

    public void removeTeamTaskTagSetItem(TeamTaskTag item) {
        if (this.getTeamTaskTagSet() == null) {
            return;
        }
        this.getTeamTaskTagSet().remove(item);
    }

    public void clearTeamTaskTagSet() {
        if (this.getTeamTaskTagSet() != null) {
            this.getTeamTaskTagSet().clear();
        }
    }

    public BigDecimal getTotalPlannedHrs() {
        return this.totalPlannedHrs == null ? BigDecimal.ZERO : this.totalPlannedHrs;
    }

    public void setTotalPlannedHrs(BigDecimal totalPlannedHrs) {
        this.totalPlannedHrs = totalPlannedHrs;
    }

    public BigDecimal getTotalRealHrs() {
        return this.totalRealHrs == null ? BigDecimal.ZERO : this.totalRealHrs;
    }

    public void setTotalRealHrs(BigDecimal totalRealHrs) {
        this.totalRealHrs = totalRealHrs;
    }

    public List<ProjectPlanningTime> getProjectPlanningTimeList() {
        return this.projectPlanningTimeList;
    }

    public void setProjectPlanningTimeList(List<ProjectPlanningTime> projectPlanningTimeList) {
        this.projectPlanningTimeList = projectPlanningTimeList;
    }

    public void addProjectPlanningTimeListItem(ProjectPlanningTime item) {
        if (this.getProjectPlanningTimeList() == null) {
            this.setProjectPlanningTimeList(new ArrayList());
        }
        this.getProjectPlanningTimeList().add(item);
        item.setTask(this);
    }

    public void removeProjectPlanningTimeListItem(ProjectPlanningTime item) {
        if (this.getProjectPlanningTimeList() == null) {
            return;
        }
        this.getProjectPlanningTimeList().remove(item);
    }

    public void clearProjectPlanningTimeList() {
        if (this.getProjectPlanningTimeList() != null) {
            this.getProjectPlanningTimeList().clear();
        }
    }

    public Boolean getToInvoice() {
        return this.toInvoice == null ? Boolean.FALSE : this.toInvoice;
    }

    public void setToInvoice(Boolean toInvoice) {
        this.toInvoice = toInvoice;
    }

    public Boolean getInvoiced() {
        return this.invoiced == null ? Boolean.FALSE : this.invoiced;
    }

    public void setInvoiced(Boolean invoiced) {
        this.invoiced = invoiced;
    }

    public BigDecimal getExTaxTotal() {
        return this.exTaxTotal == null ? BigDecimal.ZERO : this.exTaxTotal;
    }

    public void setExTaxTotal(BigDecimal exTaxTotal) {
        this.exTaxTotal = exTaxTotal;
    }

    public Integer getDiscountTypeSelect() {
        return this.discountTypeSelect == null ? 0 : this.discountTypeSelect;
    }

    public void setDiscountTypeSelect(Integer discountTypeSelect) {
        this.discountTypeSelect = discountTypeSelect;
    }

    public BigDecimal getDiscountAmount() {
        return this.discountAmount == null ? BigDecimal.ZERO : this.discountAmount;
    }

    public void setDiscountAmount(BigDecimal discountAmount) {
        this.discountAmount = discountAmount;
    }

    public BigDecimal getPriceDiscounted() {
        return this.priceDiscounted == null ? BigDecimal.ZERO : this.priceDiscounted;
    }

    public void setPriceDiscounted(BigDecimal priceDiscounted) {
        this.priceDiscounted = priceDiscounted;
    }

    public Integer getInvoicingType() {
        return this.invoicingType == null ? 0 : this.invoicingType;
    }

    public void setInvoicingType(Integer invoicingType) {
        this.invoicingType = invoicingType;
    }

    public Boolean getIsPaid() {
        return this.isPaid == null ? Boolean.FALSE : this.isPaid;
    }

    public void setIsPaid(Boolean isPaid) {
        this.isPaid = isPaid;
    }

    public User getCustomerReferral() {
        return this.customerReferral;
    }

    public void setCustomerReferral(User customerReferral) {
        this.customerReferral = customerReferral;
    }

    public SaleOrderLine getSaleOrderLine() {
        return this.saleOrderLine;
    }

    public void setSaleOrderLine(SaleOrderLine saleOrderLine) {
        this.saleOrderLine = saleOrderLine;
    }

    public InvoiceLine getInvoiceLine() {
        return this.invoiceLine;
    }

    public void setInvoiceLine(InvoiceLine invoiceLine) {
        this.invoiceLine = invoiceLine;
    }

    public Boolean getIsTaskRefused() {
        return this.isTaskRefused == null ? Boolean.FALSE : this.isTaskRefused;
    }

    public void setIsTaskRefused(Boolean isTaskRefused) {
        this.isTaskRefused = isTaskRefused;
    }

    public Integer getAssignment() {
        return this.assignment == null ? 0 : this.assignment;
    }

    public void setAssignment(Integer assignment) {
        this.assignment = assignment;
    }

    public Boolean getIsPrivate() {
        return this.isPrivate == null ? Boolean.FALSE : this.isPrivate;
    }

    public void setIsPrivate(Boolean isPrivate) {
        this.isPrivate = isPrivate;
    }

    public Boolean getIsOrderAccepted() {
        return this.isOrderAccepted == null ? Boolean.FALSE : this.isOrderAccepted;
    }

    public void setIsOrderAccepted(Boolean isOrderAccepted) {
        this.isOrderAccepted = isOrderAccepted;
    }

    public String getInternalDescription() {
        return this.internalDescription;
    }

    public void setInternalDescription(String internalDescription) {
        this.internalDescription = internalDescription;
    }

    public ProjectVersion getTargetVersion() {
        return this.targetVersion;
    }

    public void setTargetVersion(ProjectVersion targetVersion) {
        this.targetVersion = targetVersion;
    }

    public Boolean getIsOrderProposed() {
        return this.isOrderProposed == null ? Boolean.FALSE : this.isOrderProposed;
    }

    public void setIsOrderProposed(Boolean isOrderProposed) {
        this.isOrderProposed = isOrderProposed;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TeamTask)) {
            return false;
        }
        TeamTask other = (TeamTask)obj;
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("status", (Object)this.getStatus()).add("priority", (Object)this.getPriority()).add("sequence", (Object)this.getSequence()).add("taskDate", (Object)this.getTaskDate()).add("taskDuration", (Object)this.getTaskDuration()).add("taskDeadline", (Object)this.getTaskDeadline()).add("relatedModel", (Object)this.getRelatedModel()).add("relatedName", (Object)this.getRelatedName()).add("relatedId", (Object)this.getRelatedId()).add("isFirst", (Object)this.getIsFirst()).omitNullValues().toString();
    }
}

