/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.apps.account.db.AccountingReport;
import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.Journal;
import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.account.db.PaymentVoucher;
import com.axelor.apps.base.db.Batch;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.Period;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Track;
import com.axelor.db.annotations.TrackEvent;
import com.axelor.db.annotations.TrackField;
import com.axelor.db.annotations.TrackMessage;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="ACCOUNT_MOVE", uniqueConstraints={@UniqueConstraint(columnNames={"reference", "company"})}, indexes={@Index(columnList="journal"), @Index(columnList="period"), @Index(columnList="reference"), @Index(columnList="partner"), @Index(columnList="company"), @Index(columnList="payment_mode"), @Index(columnList="invoice"), @Index(columnList="accounting_report"), @Index(columnList="payment_voucher"), @Index(columnList="company_currency"), @Index(columnList="currency"), @Index(columnList="stock_move")})
@Track(fields={@TrackField(name="statusSelect"), @TrackField(name="journal"), @TrackField(name="reference"), @TrackField(name="period"), @TrackField(name="partner"), @TrackField(name="currency"), @TrackField(name="companyCurrency"), @TrackField(name="ignoreInAccountingOk"), @TrackField(name="ignoreInDebtRecoveryOk")}, messages={@TrackMessage(message="Move created", condition="true", on={TrackEvent.CREATE}), @TrackMessage(message="New move", condition="statusSelect == 1", tag="important"), @TrackMessage(message="Daybook move", condition="statusSelect == 2", tag="info"), @TrackMessage(message="Move validated", condition="statusSelect == 3", tag="success"), @TrackMessage(message="Move canceled", condition="statusSelect == 4", tag="warning")})
public class Move
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_MOVE_SEQ")
    @SequenceGenerator(name="ACCOUNT_MOVE_SEQ", sequenceName="ACCOUNT_MOVE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Journal")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Journal journal;
    @Widget(title="Period", readonly=true)
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Period period;
    @Widget(title="Date")
    @Column(name="date_val")
    private LocalDate date;
    @Widget(title="Reference", readonly=true)
    @NameColumn
    private String reference;
    @Widget(title="Move lines")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="move", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<MoveLine> moveLineList;
    @Widget(title="Partner")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner partner;
    @Widget(title="Company")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Payment Mode")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PaymentMode paymentMode;
    @Widget(title="Invoice")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Invoice invoice;
    @Widget(title="Status", readonly=true, selection="iaccount.move.status.select")
    private Integer statusSelect = 1;
    @Widget(title="Rejection")
    private Boolean rejectOk = Boolean.FALSE;
    @Widget(title="Get information from 1st Move line")
    private Boolean getInfoFromFirstMoveLineOk = Boolean.TRUE;
    @Widget(title="Accounting Export N\u00b0")
    private String exportNumber;
    @Widget(title="Export Date")
    private LocalDate exportDate;
    @Widget(title="Exported")
    private Boolean accountingOk = Boolean.FALSE;
    @Widget(title="Accounting Export")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AccountingReport accountingReport;
    @Widget(title="Payment voucher")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PaymentVoucher paymentVoucher;
    @Widget(title="Company currency")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Currency companyCurrency;
    @Widget(title="Company currency code")
    private String companyCurrencyCode;
    @Widget(title="Currency")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Currency currency;
    @Widget(title="Currency code")
    private String currencyCode;
    @Widget(title="Ignore in accounting")
    private Boolean ignoreInAccountingOk = Boolean.FALSE;
    @Widget(title="Ignore in debt recovery process")
    private Boolean ignoreInDebtRecoveryOk = Boolean.FALSE;
    @Widget(title="Validation date")
    private LocalDate validationDate;
    @Widget(title="Technical origin", readonly=true, selection="iaccount.move.technical.origin.select")
    @NotNull
    private Integer technicalOriginSelect = 0;
    @Widget(title="Adjusting Move")
    private Boolean adjustingMove = Boolean.FALSE;
    @Widget(title="Year closure move")
    private Boolean autoYearClosureMove = Boolean.FALSE;
    @Widget(title="Batchs")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Batch> batchSet;
    @Widget(title="Functional origin", readonly=true, selection="iaccount.move.functional.origin.select")
    private Integer functionalOriginSelect = 0;
    @Widget(title="Stock move")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private StockMove stockMove;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Journal getJournal() {
        return this.journal;
    }

    public void setJournal(Journal journal) {
        this.journal = journal;
    }

    public Period getPeriod() {
        return this.period;
    }

    public void setPeriod(Period period) {
        this.period = period;
    }

    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public List<MoveLine> getMoveLineList() {
        return this.moveLineList;
    }

    public void setMoveLineList(List<MoveLine> moveLineList) {
        this.moveLineList = moveLineList;
    }

    public void addMoveLineListItem(MoveLine item) {
        if (this.getMoveLineList() == null) {
            this.setMoveLineList(new ArrayList());
        }
        this.getMoveLineList().add(item);
        item.setMove(this);
    }

    public void removeMoveLineListItem(MoveLine item) {
        if (this.getMoveLineList() == null) {
            return;
        }
        this.getMoveLineList().remove(item);
    }

    public void clearMoveLineList() {
        if (this.getMoveLineList() != null) {
            this.getMoveLineList().clear();
        }
    }

    public Partner getPartner() {
        return this.partner;
    }

    public void setPartner(Partner partner) {
        this.partner = partner;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public PaymentMode getPaymentMode() {
        return this.paymentMode;
    }

    public void setPaymentMode(PaymentMode paymentMode) {
        this.paymentMode = paymentMode;
    }

    public Invoice getInvoice() {
        return this.invoice;
    }

    public void setInvoice(Invoice invoice) {
        this.invoice = invoice;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public Boolean getRejectOk() {
        return this.rejectOk == null ? Boolean.FALSE : this.rejectOk;
    }

    public void setRejectOk(Boolean rejectOk) {
        this.rejectOk = rejectOk;
    }

    public Boolean getGetInfoFromFirstMoveLineOk() {
        return this.getInfoFromFirstMoveLineOk == null ? Boolean.FALSE : this.getInfoFromFirstMoveLineOk;
    }

    public void setGetInfoFromFirstMoveLineOk(Boolean getInfoFromFirstMoveLineOk) {
        this.getInfoFromFirstMoveLineOk = getInfoFromFirstMoveLineOk;
    }

    public String getExportNumber() {
        return this.exportNumber;
    }

    public void setExportNumber(String exportNumber) {
        this.exportNumber = exportNumber;
    }

    public LocalDate getExportDate() {
        return this.exportDate;
    }

    public void setExportDate(LocalDate exportDate) {
        this.exportDate = exportDate;
    }

    public Boolean getAccountingOk() {
        return this.accountingOk == null ? Boolean.FALSE : this.accountingOk;
    }

    public void setAccountingOk(Boolean accountingOk) {
        this.accountingOk = accountingOk;
    }

    public AccountingReport getAccountingReport() {
        return this.accountingReport;
    }

    public void setAccountingReport(AccountingReport accountingReport) {
        this.accountingReport = accountingReport;
    }

    public PaymentVoucher getPaymentVoucher() {
        return this.paymentVoucher;
    }

    public void setPaymentVoucher(PaymentVoucher paymentVoucher) {
        this.paymentVoucher = paymentVoucher;
    }

    public Currency getCompanyCurrency() {
        return this.companyCurrency;
    }

    public void setCompanyCurrency(Currency companyCurrency) {
        this.companyCurrency = companyCurrency;
    }

    public String getCompanyCurrencyCode() {
        return this.companyCurrencyCode;
    }

    public void setCompanyCurrencyCode(String companyCurrencyCode) {
        this.companyCurrencyCode = companyCurrencyCode;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public Boolean getIgnoreInAccountingOk() {
        return this.ignoreInAccountingOk == null ? Boolean.FALSE : this.ignoreInAccountingOk;
    }

    public void setIgnoreInAccountingOk(Boolean ignoreInAccountingOk) {
        this.ignoreInAccountingOk = ignoreInAccountingOk;
    }

    public Boolean getIgnoreInDebtRecoveryOk() {
        return this.ignoreInDebtRecoveryOk == null ? Boolean.FALSE : this.ignoreInDebtRecoveryOk;
    }

    public void setIgnoreInDebtRecoveryOk(Boolean ignoreInDebtRecoveryOk) {
        this.ignoreInDebtRecoveryOk = ignoreInDebtRecoveryOk;
    }

    public LocalDate getValidationDate() {
        return this.validationDate;
    }

    public void setValidationDate(LocalDate validationDate) {
        this.validationDate = validationDate;
    }

    public Integer getTechnicalOriginSelect() {
        return this.technicalOriginSelect == null ? 0 : this.technicalOriginSelect;
    }

    public void setTechnicalOriginSelect(Integer technicalOriginSelect) {
        this.technicalOriginSelect = technicalOriginSelect;
    }

    public Boolean getAdjustingMove() {
        return this.adjustingMove == null ? Boolean.FALSE : this.adjustingMove;
    }

    public void setAdjustingMove(Boolean adjustingMove) {
        this.adjustingMove = adjustingMove;
    }

    public Boolean getAutoYearClosureMove() {
        return this.autoYearClosureMove == null ? Boolean.FALSE : this.autoYearClosureMove;
    }

    public void setAutoYearClosureMove(Boolean autoYearClosureMove) {
        this.autoYearClosureMove = autoYearClosureMove;
    }

    public Set<Batch> getBatchSet() {
        return this.batchSet;
    }

    public void setBatchSet(Set<Batch> batchSet) {
        this.batchSet = batchSet;
    }

    public void addBatchSetItem(Batch item) {
        if (this.getBatchSet() == null) {
            this.setBatchSet(new HashSet());
        }
        this.getBatchSet().add(item);
    }

    public void removeBatchSetItem(Batch item) {
        if (this.getBatchSet() == null) {
            return;
        }
        this.getBatchSet().remove(item);
    }

    public void clearBatchSet() {
        if (this.getBatchSet() != null) {
            this.getBatchSet().clear();
        }
    }

    public Integer getFunctionalOriginSelect() {
        return this.functionalOriginSelect == null ? 0 : this.functionalOriginSelect;
    }

    public void setFunctionalOriginSelect(Integer functionalOriginSelect) {
        this.functionalOriginSelect = functionalOriginSelect;
    }

    public StockMove getStockMove() {
        return this.stockMove;
    }

    public void setStockMove(StockMove stockMove) {
        this.stockMove = stockMove;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Move)) {
            return false;
        }
        Move other = (Move)obj;
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("date", (Object)this.getDate()).add("reference", (Object)this.getReference()).add("statusSelect", (Object)this.getStatusSelect()).add("rejectOk", (Object)this.getRejectOk()).add("getInfoFromFirstMoveLineOk", (Object)this.getGetInfoFromFirstMoveLineOk()).add("exportNumber", (Object)this.getExportNumber()).add("exportDate", (Object)this.getExportDate()).add("accountingOk", (Object)this.getAccountingOk()).add("companyCurrencyCode", (Object)this.getCompanyCurrencyCode()).add("currencyCode", (Object)this.getCurrencyCode()).add("ignoreInAccountingOk", (Object)this.getIgnoreInAccountingOk()).omitNullValues().toString();
    }
}

