/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.sale.db;

import com.axelor.apps.production.db.ConfiguratorBOM;
import com.axelor.apps.sale.db.ConfiguratorProductFormula;
import com.axelor.apps.sale.db.ConfiguratorSOLineFormula;
import com.axelor.apps.sale.db.repo.ConfiguratorCreatorListener;
import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.Group;
import com.axelor.auth.db.User;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaJsonField;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="SALE_CONFIGURATOR_CREATOR", indexes={@Index(columnList="name"), @Index(columnList="configurator_bom")})
@EntityListeners(value={ConfiguratorCreatorListener.class})
public class ConfiguratorCreator
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="SALE_CONFIGURATOR_CREATOR_SEQ")
    @SequenceGenerator(name="SALE_CONFIGURATOR_CREATOR_SEQ", sequenceName="SALE_CONFIGURATOR_CREATOR_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Name")
    @NotNull
    private String name;
    @Widget(title="Attributes")
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private List<MetaJsonField> attributes;
    @Widget(title="Indicators")
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private List<MetaJsonField> indicators;
    @Widget(title="Configurator formula list")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="productCreator", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ConfiguratorProductFormula> configuratorProductFormulaList;
    @Widget(title="Configurator formula list")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="soLineCreator", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ConfiguratorSOLineFormula> configuratorSOLineFormulaList;
    @Widget(title="Authorized users")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<User> authorizedUserSet;
    @Widget(title="Authorized groups")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Group> authorizedGroupSet;
    @Widget(title="Generate product")
    private Boolean generateProduct = Boolean.TRUE;
    @Widget(title="Quantity", help="Quantity in generated sale order line, 1 if left empty.")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String qtyFormula;
    @Widget(title="Is Active")
    private Boolean isActive = Boolean.FALSE;
    @Widget(title="Configurator BoM")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ConfiguratorBOM configuratorBom;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public ConfiguratorCreator() {
    }

    public ConfiguratorCreator(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<MetaJsonField> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<MetaJsonField> attributes) {
        this.attributes = attributes;
    }

    public void addAttribute(MetaJsonField item) {
        if (this.getAttributes() == null) {
            this.setAttributes(new ArrayList());
        }
        this.getAttributes().add(item);
    }

    public void removeAttribute(MetaJsonField item) {
        if (this.getAttributes() == null) {
            return;
        }
        this.getAttributes().remove(item);
    }

    public void clearAttributes() {
        if (this.getAttributes() != null) {
            this.getAttributes().clear();
        }
    }

    public List<MetaJsonField> getIndicators() {
        return this.indicators;
    }

    public void setIndicators(List<MetaJsonField> indicators) {
        this.indicators = indicators;
    }

    public void addIndicator(MetaJsonField item) {
        if (this.getIndicators() == null) {
            this.setIndicators(new ArrayList());
        }
        this.getIndicators().add(item);
    }

    public void removeIndicator(MetaJsonField item) {
        if (this.getIndicators() == null) {
            return;
        }
        this.getIndicators().remove(item);
    }

    public void clearIndicators() {
        if (this.getIndicators() != null) {
            this.getIndicators().clear();
        }
    }

    public List<ConfiguratorProductFormula> getConfiguratorProductFormulaList() {
        return this.configuratorProductFormulaList;
    }

    public void setConfiguratorProductFormulaList(List<ConfiguratorProductFormula> configuratorProductFormulaList) {
        this.configuratorProductFormulaList = configuratorProductFormulaList;
    }

    public void addConfiguratorProductFormulaListItem(ConfiguratorProductFormula item) {
        if (this.getConfiguratorProductFormulaList() == null) {
            this.setConfiguratorProductFormulaList(new ArrayList());
        }
        this.getConfiguratorProductFormulaList().add(item);
        item.setProductCreator(this);
    }

    public void removeConfiguratorProductFormulaListItem(ConfiguratorProductFormula item) {
        if (this.getConfiguratorProductFormulaList() == null) {
            return;
        }
        this.getConfiguratorProductFormulaList().remove(item);
    }

    public void clearConfiguratorProductFormulaList() {
        if (this.getConfiguratorProductFormulaList() != null) {
            this.getConfiguratorProductFormulaList().clear();
        }
    }

    public List<ConfiguratorSOLineFormula> getConfiguratorSOLineFormulaList() {
        return this.configuratorSOLineFormulaList;
    }

    public void setConfiguratorSOLineFormulaList(List<ConfiguratorSOLineFormula> configuratorSOLineFormulaList) {
        this.configuratorSOLineFormulaList = configuratorSOLineFormulaList;
    }

    public void addConfiguratorSOLineFormulaListItem(ConfiguratorSOLineFormula item) {
        if (this.getConfiguratorSOLineFormulaList() == null) {
            this.setConfiguratorSOLineFormulaList(new ArrayList());
        }
        this.getConfiguratorSOLineFormulaList().add(item);
        item.setSoLineCreator(this);
    }

    public void removeConfiguratorSOLineFormulaListItem(ConfiguratorSOLineFormula item) {
        if (this.getConfiguratorSOLineFormulaList() == null) {
            return;
        }
        this.getConfiguratorSOLineFormulaList().remove(item);
    }

    public void clearConfiguratorSOLineFormulaList() {
        if (this.getConfiguratorSOLineFormulaList() != null) {
            this.getConfiguratorSOLineFormulaList().clear();
        }
    }

    public Set<User> getAuthorizedUserSet() {
        return this.authorizedUserSet;
    }

    public void setAuthorizedUserSet(Set<User> authorizedUserSet) {
        this.authorizedUserSet = authorizedUserSet;
    }

    public void addAuthorizedUserSetItem(User item) {
        if (this.getAuthorizedUserSet() == null) {
            this.setAuthorizedUserSet(new HashSet());
        }
        this.getAuthorizedUserSet().add(item);
    }

    public void removeAuthorizedUserSetItem(User item) {
        if (this.getAuthorizedUserSet() == null) {
            return;
        }
        this.getAuthorizedUserSet().remove(item);
    }

    public void clearAuthorizedUserSet() {
        if (this.getAuthorizedUserSet() != null) {
            this.getAuthorizedUserSet().clear();
        }
    }

    public Set<Group> getAuthorizedGroupSet() {
        return this.authorizedGroupSet;
    }

    public void setAuthorizedGroupSet(Set<Group> authorizedGroupSet) {
        this.authorizedGroupSet = authorizedGroupSet;
    }

    public void addAuthorizedGroupSetItem(Group item) {
        if (this.getAuthorizedGroupSet() == null) {
            this.setAuthorizedGroupSet(new HashSet());
        }
        this.getAuthorizedGroupSet().add(item);
    }

    public void removeAuthorizedGroupSetItem(Group item) {
        if (this.getAuthorizedGroupSet() == null) {
            return;
        }
        this.getAuthorizedGroupSet().remove(item);
    }

    public void clearAuthorizedGroupSet() {
        if (this.getAuthorizedGroupSet() != null) {
            this.getAuthorizedGroupSet().clear();
        }
    }

    public Boolean getGenerateProduct() {
        return this.generateProduct == null ? Boolean.FALSE : this.generateProduct;
    }

    public void setGenerateProduct(Boolean generateProduct) {
        this.generateProduct = generateProduct;
    }

    public String getQtyFormula() {
        return this.qtyFormula;
    }

    public void setQtyFormula(String qtyFormula) {
        this.qtyFormula = qtyFormula;
    }

    public Boolean getIsActive() {
        return this.isActive == null ? Boolean.FALSE : this.isActive;
    }

    public void setIsActive(Boolean isActive) {
        this.isActive = isActive;
    }

    public ConfiguratorBOM getConfiguratorBom() {
        return this.configuratorBom;
    }

    public void setConfiguratorBom(ConfiguratorBOM configuratorBom) {
        this.configuratorBom = configuratorBom;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ConfiguratorCreator)) {
            return false;
        }
        ConfiguratorCreator other = (ConfiguratorCreator)obj;
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("generateProduct", (Object)this.getGenerateProduct()).add("isActive", (Object)this.getIsActive()).omitNullValues().toString();
    }
}

