/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.dms.db;

import com.axelor.apps.project.db.Project;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.EqualsInclude;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="DMS_FILE_TAG")
public class DMSFileTag
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="DMS_FILE_TAG_SEQ")
    @SequenceGenerator(name="DMS_FILE_TAG_SEQ", sequenceName="DMS_FILE_TAG_SEQ", allocationSize=1)
    private Long id;
    @EqualsInclude
    @NotNull
    @Size(min=2)
    @Column(unique=true)
    private String code;
    @EqualsInclude
    @NameColumn
    @NotNull
    @Size(min=2)
    @Column(unique=true)
    private String name;
    @Widget(selection="dms.tag.style.selection")
    private String style;
    @Widget(title="Tags")
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private List<DMSFileTag> tagList;
    @Widget(title="Projects")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Project> projectSet;

    public DMSFileTag() {
    }

    public DMSFileTag(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public List<DMSFileTag> getTagList() {
        return this.tagList;
    }

    public void setTagList(List<DMSFileTag> tagList) {
        this.tagList = tagList;
    }

    public void addTagListItem(DMSFileTag item) {
        if (this.getTagList() == null) {
            this.setTagList(new ArrayList());
        }
        this.getTagList().add(item);
    }

    public void removeTagListItem(DMSFileTag item) {
        if (this.getTagList() == null) {
            return;
        }
        this.getTagList().remove(item);
    }

    public void clearTagList() {
        if (this.getTagList() != null) {
            this.getTagList().clear();
        }
    }

    public Set<Project> getProjectSet() {
        return this.projectSet;
    }

    public void setProjectSet(Set<Project> projectSet) {
        this.projectSet = projectSet;
    }

    public void addProjectSetItem(Project item) {
        if (this.getProjectSet() == null) {
            this.setProjectSet(new HashSet());
        }
        this.getProjectSet().add(item);
    }

    public void removeProjectSetItem(Project item) {
        if (this.getProjectSet() == null) {
            return;
        }
        this.getProjectSet().remove(item);
    }

    public void clearProjectSet() {
        if (this.getProjectSet() != null) {
            this.getProjectSet().clear();
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DMSFileTag)) {
            return false;
        }
        DMSFileTag other = (DMSFileTag)obj;
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return Objects.equals(this.getCode(), other.getCode()) && Objects.equals(this.getName(), other.getName()) && (this.getCode() != null || this.getName() != null);
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("code", (Object)this.getCode()).add("name", (Object)this.getName()).add("style", (Object)this.getStyle()).omitNullValues().toString();
    }
}

