/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.stock.db.StockLocation;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaFile;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BASE_TRADING_NAME", indexes={@Index(columnList="name"), @Index(columnList="logo"), @Index(columnList="partner"), @Index(columnList="workshop_default_stock_location"), @Index(columnList="receipt_default_stock_location"), @Index(columnList="waste_default_stock_location"), @Index(columnList="shipping_default_stock_location"), @Index(columnList="quality_control_default_stock_location")})
public class TradingName
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_TRADING_NAME_SEQ")
    @SequenceGenerator(name="BASE_TRADING_NAME_SEQ", sequenceName="BASE_TRADING_NAME_SEQ", allocationSize=1)
    private Long id;
    private String name;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaFile logo;
    @Widget(title="Companies")
    @ManyToMany(fetch=FetchType.LAZY, mappedBy="tradingNameSet", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Company> companySet;
    @Widget(title="Partner")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner partner;
    @Widget(title="Stock locations")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="tradingName", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<StockLocation> stockLocationList;
    @Widget(title="Workshop default stock location")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private StockLocation workshopDefaultStockLocation;
    @Widget(title="Receipt default stock location")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private StockLocation receiptDefaultStockLocation;
    @Widget(title="Waste default stock location")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private StockLocation wasteDefaultStockLocation;
    @Widget(title="Shipping default stock location")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private StockLocation shippingDefaultStockLocation;
    @Widget(title="Quality control default stock location")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private StockLocation qualityControlDefaultStockLocation;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public TradingName() {
    }

    public TradingName(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MetaFile getLogo() {
        return this.logo;
    }

    public void setLogo(MetaFile logo) {
        this.logo = logo;
    }

    public Set<Company> getCompanySet() {
        return this.companySet;
    }

    public void setCompanySet(Set<Company> companySet) {
        this.companySet = companySet;
    }

    public void addCompanySetItem(Company item) {
        if (this.getCompanySet() == null) {
            this.setCompanySet(new HashSet());
        }
        this.getCompanySet().add(item);
    }

    public void removeCompanySetItem(Company item) {
        if (this.getCompanySet() == null) {
            return;
        }
        this.getCompanySet().remove(item);
    }

    public void clearCompanySet() {
        if (this.getCompanySet() != null) {
            this.getCompanySet().clear();
        }
    }

    public Partner getPartner() {
        return this.partner;
    }

    public void setPartner(Partner partner) {
        this.partner = partner;
    }

    public List<StockLocation> getStockLocationList() {
        return this.stockLocationList;
    }

    public void setStockLocationList(List<StockLocation> stockLocationList) {
        this.stockLocationList = stockLocationList;
    }

    public void addStockLocationListItem(StockLocation item) {
        if (this.getStockLocationList() == null) {
            this.setStockLocationList(new ArrayList());
        }
        this.getStockLocationList().add(item);
        item.setTradingName(this);
    }

    public void removeStockLocationListItem(StockLocation item) {
        if (this.getStockLocationList() == null) {
            return;
        }
        this.getStockLocationList().remove(item);
    }

    public void clearStockLocationList() {
        if (this.getStockLocationList() != null) {
            this.getStockLocationList().clear();
        }
    }

    public StockLocation getWorkshopDefaultStockLocation() {
        return this.workshopDefaultStockLocation;
    }

    public void setWorkshopDefaultStockLocation(StockLocation workshopDefaultStockLocation) {
        this.workshopDefaultStockLocation = workshopDefaultStockLocation;
    }

    public StockLocation getReceiptDefaultStockLocation() {
        return this.receiptDefaultStockLocation;
    }

    public void setReceiptDefaultStockLocation(StockLocation receiptDefaultStockLocation) {
        this.receiptDefaultStockLocation = receiptDefaultStockLocation;
    }

    public StockLocation getWasteDefaultStockLocation() {
        return this.wasteDefaultStockLocation;
    }

    public void setWasteDefaultStockLocation(StockLocation wasteDefaultStockLocation) {
        this.wasteDefaultStockLocation = wasteDefaultStockLocation;
    }

    public StockLocation getShippingDefaultStockLocation() {
        return this.shippingDefaultStockLocation;
    }

    public void setShippingDefaultStockLocation(StockLocation shippingDefaultStockLocation) {
        this.shippingDefaultStockLocation = shippingDefaultStockLocation;
    }

    public StockLocation getQualityControlDefaultStockLocation() {
        return this.qualityControlDefaultStockLocation;
    }

    public void setQualityControlDefaultStockLocation(StockLocation qualityControlDefaultStockLocation) {
        this.qualityControlDefaultStockLocation = qualityControlDefaultStockLocation;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TradingName)) {
            return false;
        }
        TradingName other = (TradingName)obj;
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("name", (Object)this.getName()).omitNullValues().toString();
    }
}

