/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.sale.db;

import com.axelor.apps.account.db.PaymentCondition;
import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.base.db.Address;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.Batch;
import com.axelor.apps.base.db.CancelReason;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.db.Duration;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.PriceList;
import com.axelor.apps.base.db.PrintingSettings;
import com.axelor.apps.base.db.TradingName;
import com.axelor.apps.crm.db.Opportunity;
import com.axelor.apps.project.db.Project;
import com.axelor.apps.sale.db.AdvancePayment;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.apps.sale.db.SaleOrderLineTax;
import com.axelor.apps.sale.db.SaleOrderScheduleLine;
import com.axelor.apps.stock.db.FreightCarrierMode;
import com.axelor.apps.stock.db.Incoterm;
import com.axelor.apps.stock.db.ShipmentMode;
import com.axelor.apps.stock.db.StockLocation;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.apps.supplychain.db.Timetable;
import com.axelor.apps.supplychain.db.TimetableTemplate;
import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Track;
import com.axelor.db.annotations.TrackEvent;
import com.axelor.db.annotations.TrackField;
import com.axelor.db.annotations.TrackMessage;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaFile;
import com.axelor.team.db.Team;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="SALE_SALE_ORDER", uniqueConstraints={@UniqueConstraint(columnNames={"saleOrderSeq", "company"})}, indexes={@Index(columnList="company"), @Index(columnList="fullName"), @Index(columnList="currency"), @Index(columnList="client_partner"), @Index(columnList="contact_partner"), @Index(columnList="main_invoicing_address"), @Index(columnList="price_list"), @Index(columnList="delivery_address"), @Index(columnList="duration"), @Index(columnList="salesperson_user"), @Index(columnList="team"), @Index(columnList="confirmed_by_user"), @Index(columnList="cancel_reason"), @Index(columnList="template_user"), @Index(columnList="company_bank_details"), @Index(columnList="opportunity"), @Index(columnList="trading_name"), @Index(columnList="printing_settings"), @Index(columnList="payment_mode"), @Index(columnList="payment_condition"), @Index(columnList="stock_location"), @Index(columnList="to_stock_location"), @Index(columnList="timetable_template"), @Index(columnList="shipment_mode"), @Index(columnList="freight_carrier_mode"), @Index(columnList="carrier_partner"), @Index(columnList="forwarder_partner"), @Index(columnList="incoterm"), @Index(columnList="invoiced_partner"), @Index(columnList="delivered_partner"), @Index(columnList="project"), @Index(columnList="electronic_signature")})
@Track(fields={@TrackField(name="saleOrderSeq"), @TrackField(name="clientPartner"), @TrackField(name="statusSelect"), @TrackField(name="creationDate", on={TrackEvent.CREATE}), @TrackField(name="confirmationDateTime", on={TrackEvent.UPDATE}), @TrackField(name="inTaxTotal")}, messages={@TrackMessage(message="Quotation/sale order created", condition="true", on={TrackEvent.CREATE}), @TrackMessage(message="Draft quotation", condition="statusSelect == 1", tag="important"), @TrackMessage(message="Finalized quotation", condition="statusSelect == 2", tag="info"), @TrackMessage(message="Order confirmed", condition="statusSelect == 3", tag="success"), @TrackMessage(message="Order completed", condition="statusSelect == 4", tag="success"), @TrackMessage(message="Canceled", condition="statusSelect == 5", tag="warning")})
public class SaleOrder
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="SALE_SALE_ORDER_SEQ")
    @SequenceGenerator(name="SALE_SALE_ORDER_SEQ", sequenceName="SALE_SALE_ORDER_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Company")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @NameColumn
    private String fullName;
    @Widget(title="Internal Number", readonly=true)
    private String saleOrderSeq;
    @Widget(title="Currency", massUpdate=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Currency currency;
    @Widget(title="Customer reference")
    private String externalReference;
    @Widget(title="Creation date", readonly=true)
    @NotNull
    private LocalDate creationDate;
    @Widget(title="Confirmation date", readonly=true)
    private LocalDateTime confirmationDateTime;
    @Widget(title="Batchs")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Batch> batchSet;
    @Widget(title="Blocked")
    private Boolean blockedOnCustCreditExceed = Boolean.FALSE;
    @Widget(title="Manual Unblock")
    private Boolean manualUnblock = Boolean.FALSE;
    @Widget(title="Title")
    private String title;
    @Widget(title="Customer", massUpdate=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner clientPartner;
    @Widget(title="Customer contact")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner contactPartner;
    @Widget(title="Main/Invoicing address")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Address mainInvoicingAddress;
    @Widget(title="Main/Invoicing address", multiline=true)
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String mainInvoicingAddressStr;
    @Widget(title="Price list")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PriceList priceList;
    @Widget(title="Delivery address")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Address deliveryAddress;
    @Widget(title="Delivery address", multiline=true)
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String deliveryAddressStr;
    @Widget(title="Print subtotal per line")
    private Boolean isToPrintLineSubTotal = Boolean.FALSE;
    @Widget(title="In ATI")
    private Boolean inAti = Boolean.FALSE;
    @Widget(title="Validity duration")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Duration duration;
    @Widget(title="End of validity")
    private LocalDate endOfValidityDate;
    @Widget(title="Sale order lines")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="saleOrder", cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderBy(value="sequence")
    private List<SaleOrderLine> saleOrderLineList;
    @Widget(title="Tax Lines", readonly=true)
    @OneToMany(fetch=FetchType.LAZY, mappedBy="saleOrder", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<SaleOrderLineTax> saleOrderLineTaxList;
    @Widget(title="Total W.T.", readonly=true)
    @Digits(integer=18, fraction=2)
    private BigDecimal exTaxTotal = BigDecimal.ZERO;
    @Widget(title="Total tax", readonly=true)
    @Digits(integer=18, fraction=2)
    private BigDecimal taxTotal = BigDecimal.ZERO;
    @Widget(title="Total A.T.I.", readonly=true)
    @Digits(integer=18, fraction=2)
    private BigDecimal inTaxTotal = BigDecimal.ZERO;
    @Widget(title="Advance payment total", readonly=true)
    @Digits(integer=18, fraction=2)
    private BigDecimal advanceTotal = BigDecimal.ZERO;
    @Widget(title="Amount to be spread over the timetable", readonly=true, copyable=false)
    @Digits(integer=18, fraction=2)
    private BigDecimal amountToBeSpreadOverTheTimetable = BigDecimal.ZERO;
    @Widget(title="Total W.T.", readonly=true)
    @Digits(integer=18, fraction=2)
    private BigDecimal companyExTaxTotal = BigDecimal.ZERO;
    @Widget(title="Total cost in company currency", hidden=true)
    private BigDecimal companyCostTotal = BigDecimal.ZERO;
    @Widget(title="Status", readonly=true, selection="sale.order.status.select")
    private Integer statusSelect = 0;
    @Widget(title="Accounted Revenue")
    private BigDecimal accountedRevenue = BigDecimal.ZERO;
    @Widget(title="Total cost price")
    private BigDecimal totalCostPrice = BigDecimal.ZERO;
    @Widget(title="Gross Profit")
    private BigDecimal totalGrossMargin = BigDecimal.ZERO;
    @Widget(title="Margin (%)")
    private BigDecimal marginRate = BigDecimal.ZERO;
    @Widget(title="Markup (%)")
    private BigDecimal markup = BigDecimal.ZERO;
    @Widget(title="Salesperson", massUpdate=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User salespersonUser;
    @Widget(title="Team", massUpdate=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Team team;
    @Widget(title="Comment to display")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String description;
    @Widget(title="Internal note")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String internalNote;
    @Widget(title="Order Date")
    private LocalDate orderDate;
    @Widget(title="Order Number")
    private String orderNumber;
    @Widget(title="Invoiced first date")
    private LocalDate invoicedFirstDate;
    @Widget(title="Next invoiced period start date", readonly=true)
    private LocalDate nextInvPeriodStartDate;
    @Widget(title="Confirmed by", readonly=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User confirmedByUser;
    @Widget(title="Template", hidden=true)
    private Boolean template = Boolean.FALSE;
    @Widget(title="Version Number", readonly=true)
    private Integer versionNumber = 1;
    @Widget(title="Cancel reason")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private CancelReason cancelReason;
    @Widget(title="Cancel Reason")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String cancelReasonStr;
    @Widget(title="Template created by", readonly=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User templateUser;
    @Widget(title="Hide Discount on prints")
    private Boolean hideDiscount = Boolean.FALSE;
    @Widget(title="Estimated shipping date")
    private LocalDate deliveryDate;
    @Widget(title="Delivery conditions", multiline=true)
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String deliveryCondition;
    @Widget(title="Specific package", multiline=true)
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String specificPackage;
    @Widget(title="Advance Payments")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="saleOrder", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<AdvancePayment> advancePaymentList;
    @Widget(title="Advance payment needed")
    private Boolean advancePaymentNeeded = Boolean.FALSE;
    @Widget(title="Advance payment amount needed")
    private BigDecimal advancePaymentAmountNeeded = BigDecimal.ZERO;
    @Widget(title="Company bank")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private BankDetails companyBankDetails;
    @Widget(title="Specific notes")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String specificNotes;
    private Boolean orderBeingEdited = Boolean.FALSE;
    @Widget(copyable=false)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Opportunity opportunity;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private TradingName tradingName;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PrintingSettings printingSettings;
    @Widget(title="Group products on printings")
    private Boolean groupProductsOnPrintings = Boolean.FALSE;
    @Widget(title="Periodicity type", selection="sale.subscription.periodicity.type.select")
    private Integer periodicityTypeSelect = 2;
    @Widget(title="Period duration")
    @Min(value=1L)
    private Integer numberOfPeriods = 1;
    @Widget(title="Contract start date")
    private LocalDate contractStartDate;
    @Widget(title="Contract period in months")
    private Integer contractPeriodInMonths = 0;
    @Widget(title="End of current contract period")
    private LocalDate currentContractPeriodEndDate;
    @Widget(title="Contract end date")
    private LocalDate contractEndDate;
    @Widget(title="Tacit agreement")
    private Boolean isTacitAgreement = Boolean.FALSE;
    @Widget(title="Notice period in days")
    private Integer noticePeriodInDays = 0;
    @Widget(title="Next invoicing date")
    private LocalDate nextInvoicingDate;
    @Widget(title="Next invoicing start period date")
    private LocalDate nextInvoicingStartPeriodDate;
    @Widget(title="Next invoicing end period date")
    private LocalDate nextInvoicingEndPeriodDate;
    @Widget(title="Comment")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String subscriptionComment;
    @Widget(title="Subscription text to display")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String subscriptionText;
    @Widget(title="Comment to display on invoice")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String invoiceComments;
    @Widget(title="Comment to display on delivery")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String deliveryComments;
    @Widget(title="Comment to display on picking order")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String pickingOrderComments;
    @Widget(title="Comment to display on proforma")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String proformaComments;
    @Widget(title="Payment mode")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PaymentMode paymentMode;
    @Widget(title="Payment condition")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PaymentCondition paymentCondition;
    @Widget(title="Delivery State", readonly=true, selection="sale.order.delivery.state")
    private Integer deliveryState = 1;
    @Widget(title="Stock location")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private StockLocation stockLocation;
    @Widget(title="To stock location")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private StockLocation toStockLocation;
    @Widget(title="Date of shipment")
    private LocalDate shipmentDate;
    @Widget(title="Amount invoiced W.T.", readonly=true)
    private BigDecimal amountInvoiced = BigDecimal.ZERO;
    @Widget(title="Type", selection="supplychain.sale.order.type.select")
    @NotNull
    private Integer saleOrderTypeSelect = 1;
    @Widget(title="Schedule line list")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="saleOrder", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<SaleOrderScheduleLine> saleOrderScheduleLineList;
    @Widget(title="Timetable", copyable=false)
    @OneToMany(fetch=FetchType.LAZY, mappedBy="saleOrder", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<Timetable> timetableList;
    @Widget(title="Interco")
    private Boolean interco = Boolean.FALSE;
    private Boolean createdByInterco = Boolean.FALSE;
    @Widget(title="Expected realisation date", copyable=false)
    private LocalDate expectedRealisationDate;
    @Widget(title="Timetable computation date", copyable=false)
    private LocalDate computationDate;
    @Widget(title="Timetable template", copyable=false)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private TimetableTemplate timetableTemplate;
    @Widget(title="Standard delay (days)")
    private Integer standardDelay = 0;
    @Widget(title="Stock moves")
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private List<StockMove> stockMoveList;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ShipmentMode shipmentMode;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private FreightCarrierMode freightCarrierMode;
    @Widget(title="Carrier")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner carrierPartner;
    @Widget(title="Forwarder")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner forwarderPartner;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Incoterm incoterm;
    @Widget(title="Is certificate of conformity required")
    private Boolean isNeedingConformityCertificate = Boolean.FALSE;
    @Widget(title="Is ISPM 15 required")
    private Boolean isIspmRequired = Boolean.FALSE;
    @Widget(title="Direct order")
    private Boolean directOrderLocation = Boolean.FALSE;
    @Widget(title="Invoiced partner")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner invoicedPartner;
    @Widget(title="Delivery partner")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner deliveredPartner;
    @Widget(title="Project")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Project project;
    @Widget(title="To invoice via task")
    private Boolean toInvoiceViaTask = Boolean.FALSE;
    @Widget(title="Electronic signature")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaFile electronicSignature;
    @Widget(title="Production note")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String productionNote;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getSaleOrderSeq() {
        return this.saleOrderSeq;
    }

    public void setSaleOrderSeq(String saleOrderSeq) {
        this.saleOrderSeq = saleOrderSeq;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public String getExternalReference() {
        return this.externalReference;
    }

    public void setExternalReference(String externalReference) {
        this.externalReference = externalReference;
    }

    public LocalDate getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(LocalDate creationDate) {
        this.creationDate = creationDate;
    }

    public LocalDateTime getConfirmationDateTime() {
        return this.confirmationDateTime;
    }

    public void setConfirmationDateTime(LocalDateTime confirmationDateTime) {
        this.confirmationDateTime = confirmationDateTime;
    }

    public Set<Batch> getBatchSet() {
        return this.batchSet;
    }

    public void setBatchSet(Set<Batch> batchSet) {
        this.batchSet = batchSet;
    }

    public void addBatchSetItem(Batch item) {
        if (this.getBatchSet() == null) {
            this.setBatchSet(new HashSet());
        }
        this.getBatchSet().add(item);
    }

    public void removeBatchSetItem(Batch item) {
        if (this.getBatchSet() == null) {
            return;
        }
        this.getBatchSet().remove(item);
    }

    public void clearBatchSet() {
        if (this.getBatchSet() != null) {
            this.getBatchSet().clear();
        }
    }

    public Boolean getBlockedOnCustCreditExceed() {
        return this.blockedOnCustCreditExceed == null ? Boolean.FALSE : this.blockedOnCustCreditExceed;
    }

    public void setBlockedOnCustCreditExceed(Boolean blockedOnCustCreditExceed) {
        this.blockedOnCustCreditExceed = blockedOnCustCreditExceed;
    }

    public Boolean getManualUnblock() {
        return this.manualUnblock == null ? Boolean.FALSE : this.manualUnblock;
    }

    public void setManualUnblock(Boolean manualUnblock) {
        this.manualUnblock = manualUnblock;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Partner getClientPartner() {
        return this.clientPartner;
    }

    public void setClientPartner(Partner clientPartner) {
        this.clientPartner = clientPartner;
    }

    public Partner getContactPartner() {
        return this.contactPartner;
    }

    public void setContactPartner(Partner contactPartner) {
        this.contactPartner = contactPartner;
    }

    public Address getMainInvoicingAddress() {
        return this.mainInvoicingAddress;
    }

    public void setMainInvoicingAddress(Address mainInvoicingAddress) {
        this.mainInvoicingAddress = mainInvoicingAddress;
    }

    public String getMainInvoicingAddressStr() {
        return this.mainInvoicingAddressStr;
    }

    public void setMainInvoicingAddressStr(String mainInvoicingAddressStr) {
        this.mainInvoicingAddressStr = mainInvoicingAddressStr;
    }

    public PriceList getPriceList() {
        return this.priceList;
    }

    public void setPriceList(PriceList priceList) {
        this.priceList = priceList;
    }

    public Address getDeliveryAddress() {
        return this.deliveryAddress;
    }

    public void setDeliveryAddress(Address deliveryAddress) {
        this.deliveryAddress = deliveryAddress;
    }

    public String getDeliveryAddressStr() {
        return this.deliveryAddressStr;
    }

    public void setDeliveryAddressStr(String deliveryAddressStr) {
        this.deliveryAddressStr = deliveryAddressStr;
    }

    public Boolean getIsToPrintLineSubTotal() {
        return this.isToPrintLineSubTotal == null ? Boolean.FALSE : this.isToPrintLineSubTotal;
    }

    public void setIsToPrintLineSubTotal(Boolean isToPrintLineSubTotal) {
        this.isToPrintLineSubTotal = isToPrintLineSubTotal;
    }

    public Boolean getInAti() {
        return this.inAti == null ? Boolean.FALSE : this.inAti;
    }

    public void setInAti(Boolean inAti) {
        this.inAti = inAti;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public void setDuration(Duration duration) {
        this.duration = duration;
    }

    public LocalDate getEndOfValidityDate() {
        return this.endOfValidityDate;
    }

    public void setEndOfValidityDate(LocalDate endOfValidityDate) {
        this.endOfValidityDate = endOfValidityDate;
    }

    public List<SaleOrderLine> getSaleOrderLineList() {
        return this.saleOrderLineList;
    }

    public void setSaleOrderLineList(List<SaleOrderLine> saleOrderLineList) {
        this.saleOrderLineList = saleOrderLineList;
    }

    public void addSaleOrderLineListItem(SaleOrderLine item) {
        if (this.getSaleOrderLineList() == null) {
            this.setSaleOrderLineList(new ArrayList());
        }
        this.getSaleOrderLineList().add(item);
        item.setSaleOrder(this);
    }

    public void removeSaleOrderLineListItem(SaleOrderLine item) {
        if (this.getSaleOrderLineList() == null) {
            return;
        }
        this.getSaleOrderLineList().remove(item);
    }

    public void clearSaleOrderLineList() {
        if (this.getSaleOrderLineList() != null) {
            this.getSaleOrderLineList().clear();
        }
    }

    public List<SaleOrderLineTax> getSaleOrderLineTaxList() {
        return this.saleOrderLineTaxList;
    }

    public void setSaleOrderLineTaxList(List<SaleOrderLineTax> saleOrderLineTaxList) {
        this.saleOrderLineTaxList = saleOrderLineTaxList;
    }

    public void addSaleOrderLineTaxListItem(SaleOrderLineTax item) {
        if (this.getSaleOrderLineTaxList() == null) {
            this.setSaleOrderLineTaxList(new ArrayList());
        }
        this.getSaleOrderLineTaxList().add(item);
        item.setSaleOrder(this);
    }

    public void removeSaleOrderLineTaxListItem(SaleOrderLineTax item) {
        if (this.getSaleOrderLineTaxList() == null) {
            return;
        }
        this.getSaleOrderLineTaxList().remove(item);
    }

    public void clearSaleOrderLineTaxList() {
        if (this.getSaleOrderLineTaxList() != null) {
            this.getSaleOrderLineTaxList().clear();
        }
    }

    public BigDecimal getExTaxTotal() {
        return this.exTaxTotal == null ? BigDecimal.ZERO : this.exTaxTotal;
    }

    public void setExTaxTotal(BigDecimal exTaxTotal) {
        this.exTaxTotal = exTaxTotal;
    }

    public BigDecimal getTaxTotal() {
        return this.taxTotal == null ? BigDecimal.ZERO : this.taxTotal;
    }

    public void setTaxTotal(BigDecimal taxTotal) {
        this.taxTotal = taxTotal;
    }

    public BigDecimal getInTaxTotal() {
        return this.inTaxTotal == null ? BigDecimal.ZERO : this.inTaxTotal;
    }

    public void setInTaxTotal(BigDecimal inTaxTotal) {
        this.inTaxTotal = inTaxTotal;
    }

    public BigDecimal getAdvanceTotal() {
        return this.advanceTotal == null ? BigDecimal.ZERO : this.advanceTotal;
    }

    public void setAdvanceTotal(BigDecimal advanceTotal) {
        this.advanceTotal = advanceTotal;
    }

    public BigDecimal getAmountToBeSpreadOverTheTimetable() {
        return this.amountToBeSpreadOverTheTimetable == null ? BigDecimal.ZERO : this.amountToBeSpreadOverTheTimetable;
    }

    public void setAmountToBeSpreadOverTheTimetable(BigDecimal amountToBeSpreadOverTheTimetable) {
        this.amountToBeSpreadOverTheTimetable = amountToBeSpreadOverTheTimetable;
    }

    public BigDecimal getCompanyExTaxTotal() {
        return this.companyExTaxTotal == null ? BigDecimal.ZERO : this.companyExTaxTotal;
    }

    public void setCompanyExTaxTotal(BigDecimal companyExTaxTotal) {
        this.companyExTaxTotal = companyExTaxTotal;
    }

    public BigDecimal getCompanyCostTotal() {
        return this.companyCostTotal == null ? BigDecimal.ZERO : this.companyCostTotal;
    }

    public void setCompanyCostTotal(BigDecimal companyCostTotal) {
        this.companyCostTotal = companyCostTotal;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public BigDecimal getAccountedRevenue() {
        return this.accountedRevenue == null ? BigDecimal.ZERO : this.accountedRevenue;
    }

    public void setAccountedRevenue(BigDecimal accountedRevenue) {
        this.accountedRevenue = accountedRevenue;
    }

    public BigDecimal getTotalCostPrice() {
        return this.totalCostPrice == null ? BigDecimal.ZERO : this.totalCostPrice;
    }

    public void setTotalCostPrice(BigDecimal totalCostPrice) {
        this.totalCostPrice = totalCostPrice;
    }

    public BigDecimal getTotalGrossMargin() {
        return this.totalGrossMargin == null ? BigDecimal.ZERO : this.totalGrossMargin;
    }

    public void setTotalGrossMargin(BigDecimal totalGrossMargin) {
        this.totalGrossMargin = totalGrossMargin;
    }

    public BigDecimal getMarginRate() {
        return this.marginRate == null ? BigDecimal.ZERO : this.marginRate;
    }

    public void setMarginRate(BigDecimal marginRate) {
        this.marginRate = marginRate;
    }

    public BigDecimal getMarkup() {
        return this.markup == null ? BigDecimal.ZERO : this.markup;
    }

    public void setMarkup(BigDecimal markup) {
        this.markup = markup;
    }

    public User getSalespersonUser() {
        return this.salespersonUser;
    }

    public void setSalespersonUser(User salespersonUser) {
        this.salespersonUser = salespersonUser;
    }

    public Team getTeam() {
        return this.team;
    }

    public void setTeam(Team team) {
        this.team = team;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getInternalNote() {
        return this.internalNote;
    }

    public void setInternalNote(String internalNote) {
        this.internalNote = internalNote;
    }

    public LocalDate getOrderDate() {
        return this.orderDate;
    }

    public void setOrderDate(LocalDate orderDate) {
        this.orderDate = orderDate;
    }

    public String getOrderNumber() {
        return this.orderNumber;
    }

    public void setOrderNumber(String orderNumber) {
        this.orderNumber = orderNumber;
    }

    public LocalDate getInvoicedFirstDate() {
        return this.invoicedFirstDate;
    }

    public void setInvoicedFirstDate(LocalDate invoicedFirstDate) {
        this.invoicedFirstDate = invoicedFirstDate;
    }

    public LocalDate getNextInvPeriodStartDate() {
        return this.nextInvPeriodStartDate;
    }

    public void setNextInvPeriodStartDate(LocalDate nextInvPeriodStartDate) {
        this.nextInvPeriodStartDate = nextInvPeriodStartDate;
    }

    public User getConfirmedByUser() {
        return this.confirmedByUser;
    }

    public void setConfirmedByUser(User confirmedByUser) {
        this.confirmedByUser = confirmedByUser;
    }

    public Boolean getTemplate() {
        return this.template == null ? Boolean.FALSE : this.template;
    }

    public void setTemplate(Boolean template) {
        this.template = template;
    }

    public Integer getVersionNumber() {
        return this.versionNumber == null ? 0 : this.versionNumber;
    }

    public void setVersionNumber(Integer versionNumber) {
        this.versionNumber = versionNumber;
    }

    public CancelReason getCancelReason() {
        return this.cancelReason;
    }

    public void setCancelReason(CancelReason cancelReason) {
        this.cancelReason = cancelReason;
    }

    public String getCancelReasonStr() {
        return this.cancelReasonStr;
    }

    public void setCancelReasonStr(String cancelReasonStr) {
        this.cancelReasonStr = cancelReasonStr;
    }

    public User getTemplateUser() {
        return this.templateUser;
    }

    public void setTemplateUser(User templateUser) {
        this.templateUser = templateUser;
    }

    public Boolean getHideDiscount() {
        return this.hideDiscount == null ? Boolean.FALSE : this.hideDiscount;
    }

    public void setHideDiscount(Boolean hideDiscount) {
        this.hideDiscount = hideDiscount;
    }

    public LocalDate getDeliveryDate() {
        return this.deliveryDate;
    }

    public void setDeliveryDate(LocalDate deliveryDate) {
        this.deliveryDate = deliveryDate;
    }

    public String getDeliveryCondition() {
        return this.deliveryCondition;
    }

    public void setDeliveryCondition(String deliveryCondition) {
        this.deliveryCondition = deliveryCondition;
    }

    public String getSpecificPackage() {
        return this.specificPackage;
    }

    public void setSpecificPackage(String specificPackage) {
        this.specificPackage = specificPackage;
    }

    public List<AdvancePayment> getAdvancePaymentList() {
        return this.advancePaymentList;
    }

    public void setAdvancePaymentList(List<AdvancePayment> advancePaymentList) {
        this.advancePaymentList = advancePaymentList;
    }

    public void addAdvancePaymentListItem(AdvancePayment item) {
        if (this.getAdvancePaymentList() == null) {
            this.setAdvancePaymentList(new ArrayList());
        }
        this.getAdvancePaymentList().add(item);
        item.setSaleOrder(this);
    }

    public void removeAdvancePaymentListItem(AdvancePayment item) {
        if (this.getAdvancePaymentList() == null) {
            return;
        }
        this.getAdvancePaymentList().remove(item);
    }

    public void clearAdvancePaymentList() {
        if (this.getAdvancePaymentList() != null) {
            this.getAdvancePaymentList().clear();
        }
    }

    public Boolean getAdvancePaymentNeeded() {
        return this.advancePaymentNeeded == null ? Boolean.FALSE : this.advancePaymentNeeded;
    }

    public void setAdvancePaymentNeeded(Boolean advancePaymentNeeded) {
        this.advancePaymentNeeded = advancePaymentNeeded;
    }

    public BigDecimal getAdvancePaymentAmountNeeded() {
        return this.advancePaymentAmountNeeded == null ? BigDecimal.ZERO : this.advancePaymentAmountNeeded;
    }

    public void setAdvancePaymentAmountNeeded(BigDecimal advancePaymentAmountNeeded) {
        this.advancePaymentAmountNeeded = advancePaymentAmountNeeded;
    }

    public BankDetails getCompanyBankDetails() {
        return this.companyBankDetails;
    }

    public void setCompanyBankDetails(BankDetails companyBankDetails) {
        this.companyBankDetails = companyBankDetails;
    }

    public String getSpecificNotes() {
        return this.specificNotes;
    }

    public void setSpecificNotes(String specificNotes) {
        this.specificNotes = specificNotes;
    }

    public Boolean getOrderBeingEdited() {
        return this.orderBeingEdited == null ? Boolean.FALSE : this.orderBeingEdited;
    }

    public void setOrderBeingEdited(Boolean orderBeingEdited) {
        this.orderBeingEdited = orderBeingEdited;
    }

    public Opportunity getOpportunity() {
        return this.opportunity;
    }

    public void setOpportunity(Opportunity opportunity) {
        this.opportunity = opportunity;
    }

    public TradingName getTradingName() {
        return this.tradingName;
    }

    public void setTradingName(TradingName tradingName) {
        this.tradingName = tradingName;
    }

    public PrintingSettings getPrintingSettings() {
        return this.printingSettings;
    }

    public void setPrintingSettings(PrintingSettings printingSettings) {
        this.printingSettings = printingSettings;
    }

    public Boolean getGroupProductsOnPrintings() {
        return this.groupProductsOnPrintings == null ? Boolean.FALSE : this.groupProductsOnPrintings;
    }

    public void setGroupProductsOnPrintings(Boolean groupProductsOnPrintings) {
        this.groupProductsOnPrintings = groupProductsOnPrintings;
    }

    public Integer getPeriodicityTypeSelect() {
        return this.periodicityTypeSelect == null ? 0 : this.periodicityTypeSelect;
    }

    public void setPeriodicityTypeSelect(Integer periodicityTypeSelect) {
        this.periodicityTypeSelect = periodicityTypeSelect;
    }

    public Integer getNumberOfPeriods() {
        return this.numberOfPeriods == null ? 0 : this.numberOfPeriods;
    }

    public void setNumberOfPeriods(Integer numberOfPeriods) {
        this.numberOfPeriods = numberOfPeriods;
    }

    public LocalDate getContractStartDate() {
        return this.contractStartDate;
    }

    public void setContractStartDate(LocalDate contractStartDate) {
        this.contractStartDate = contractStartDate;
    }

    public Integer getContractPeriodInMonths() {
        return this.contractPeriodInMonths == null ? 0 : this.contractPeriodInMonths;
    }

    public void setContractPeriodInMonths(Integer contractPeriodInMonths) {
        this.contractPeriodInMonths = contractPeriodInMonths;
    }

    public LocalDate getCurrentContractPeriodEndDate() {
        return this.currentContractPeriodEndDate;
    }

    public void setCurrentContractPeriodEndDate(LocalDate currentContractPeriodEndDate) {
        this.currentContractPeriodEndDate = currentContractPeriodEndDate;
    }

    public LocalDate getContractEndDate() {
        return this.contractEndDate;
    }

    public void setContractEndDate(LocalDate contractEndDate) {
        this.contractEndDate = contractEndDate;
    }

    public Boolean getIsTacitAgreement() {
        return this.isTacitAgreement == null ? Boolean.FALSE : this.isTacitAgreement;
    }

    public void setIsTacitAgreement(Boolean isTacitAgreement) {
        this.isTacitAgreement = isTacitAgreement;
    }

    public Integer getNoticePeriodInDays() {
        return this.noticePeriodInDays == null ? 0 : this.noticePeriodInDays;
    }

    public void setNoticePeriodInDays(Integer noticePeriodInDays) {
        this.noticePeriodInDays = noticePeriodInDays;
    }

    public LocalDate getNextInvoicingDate() {
        return this.nextInvoicingDate;
    }

    public void setNextInvoicingDate(LocalDate nextInvoicingDate) {
        this.nextInvoicingDate = nextInvoicingDate;
    }

    public LocalDate getNextInvoicingStartPeriodDate() {
        return this.nextInvoicingStartPeriodDate;
    }

    public void setNextInvoicingStartPeriodDate(LocalDate nextInvoicingStartPeriodDate) {
        this.nextInvoicingStartPeriodDate = nextInvoicingStartPeriodDate;
    }

    public LocalDate getNextInvoicingEndPeriodDate() {
        return this.nextInvoicingEndPeriodDate;
    }

    public void setNextInvoicingEndPeriodDate(LocalDate nextInvoicingEndPeriodDate) {
        this.nextInvoicingEndPeriodDate = nextInvoicingEndPeriodDate;
    }

    public String getSubscriptionComment() {
        return this.subscriptionComment;
    }

    public void setSubscriptionComment(String subscriptionComment) {
        this.subscriptionComment = subscriptionComment;
    }

    public String getSubscriptionText() {
        return this.subscriptionText;
    }

    public void setSubscriptionText(String subscriptionText) {
        this.subscriptionText = subscriptionText;
    }

    public String getInvoiceComments() {
        return this.invoiceComments;
    }

    public void setInvoiceComments(String invoiceComments) {
        this.invoiceComments = invoiceComments;
    }

    public String getDeliveryComments() {
        return this.deliveryComments;
    }

    public void setDeliveryComments(String deliveryComments) {
        this.deliveryComments = deliveryComments;
    }

    public String getPickingOrderComments() {
        return this.pickingOrderComments;
    }

    public void setPickingOrderComments(String pickingOrderComments) {
        this.pickingOrderComments = pickingOrderComments;
    }

    public String getProformaComments() {
        return this.proformaComments;
    }

    public void setProformaComments(String proformaComments) {
        this.proformaComments = proformaComments;
    }

    public PaymentMode getPaymentMode() {
        return this.paymentMode;
    }

    public void setPaymentMode(PaymentMode paymentMode) {
        this.paymentMode = paymentMode;
    }

    public PaymentCondition getPaymentCondition() {
        return this.paymentCondition;
    }

    public void setPaymentCondition(PaymentCondition paymentCondition) {
        this.paymentCondition = paymentCondition;
    }

    public Integer getDeliveryState() {
        return this.deliveryState == null ? 0 : this.deliveryState;
    }

    public void setDeliveryState(Integer deliveryState) {
        this.deliveryState = deliveryState;
    }

    public StockLocation getStockLocation() {
        return this.stockLocation;
    }

    public void setStockLocation(StockLocation stockLocation) {
        this.stockLocation = stockLocation;
    }

    public StockLocation getToStockLocation() {
        return this.toStockLocation;
    }

    public void setToStockLocation(StockLocation toStockLocation) {
        this.toStockLocation = toStockLocation;
    }

    public LocalDate getShipmentDate() {
        return this.shipmentDate;
    }

    public void setShipmentDate(LocalDate shipmentDate) {
        this.shipmentDate = shipmentDate;
    }

    public BigDecimal getAmountInvoiced() {
        return this.amountInvoiced == null ? BigDecimal.ZERO : this.amountInvoiced;
    }

    public void setAmountInvoiced(BigDecimal amountInvoiced) {
        this.amountInvoiced = amountInvoiced;
    }

    public Integer getSaleOrderTypeSelect() {
        return this.saleOrderTypeSelect == null ? 0 : this.saleOrderTypeSelect;
    }

    public void setSaleOrderTypeSelect(Integer saleOrderTypeSelect) {
        this.saleOrderTypeSelect = saleOrderTypeSelect;
    }

    public List<SaleOrderScheduleLine> getSaleOrderScheduleLineList() {
        return this.saleOrderScheduleLineList;
    }

    public void setSaleOrderScheduleLineList(List<SaleOrderScheduleLine> saleOrderScheduleLineList) {
        this.saleOrderScheduleLineList = saleOrderScheduleLineList;
    }

    public void addSaleOrderScheduleLineListItem(SaleOrderScheduleLine item) {
        if (this.getSaleOrderScheduleLineList() == null) {
            this.setSaleOrderScheduleLineList(new ArrayList());
        }
        this.getSaleOrderScheduleLineList().add(item);
        item.setSaleOrder(this);
    }

    public void removeSaleOrderScheduleLineListItem(SaleOrderScheduleLine item) {
        if (this.getSaleOrderScheduleLineList() == null) {
            return;
        }
        this.getSaleOrderScheduleLineList().remove(item);
    }

    public void clearSaleOrderScheduleLineList() {
        if (this.getSaleOrderScheduleLineList() != null) {
            this.getSaleOrderScheduleLineList().clear();
        }
    }

    public List<Timetable> getTimetableList() {
        return this.timetableList;
    }

    public void setTimetableList(List<Timetable> timetableList) {
        this.timetableList = timetableList;
    }

    public void addTimetableListItem(Timetable item) {
        if (this.getTimetableList() == null) {
            this.setTimetableList(new ArrayList());
        }
        this.getTimetableList().add(item);
        item.setSaleOrder(this);
    }

    public void removeTimetableListItem(Timetable item) {
        if (this.getTimetableList() == null) {
            return;
        }
        this.getTimetableList().remove(item);
    }

    public void clearTimetableList() {
        if (this.getTimetableList() != null) {
            this.getTimetableList().clear();
        }
    }

    public Boolean getInterco() {
        return this.interco == null ? Boolean.FALSE : this.interco;
    }

    public void setInterco(Boolean interco) {
        this.interco = interco;
    }

    public Boolean getCreatedByInterco() {
        return this.createdByInterco == null ? Boolean.FALSE : this.createdByInterco;
    }

    public void setCreatedByInterco(Boolean createdByInterco) {
        this.createdByInterco = createdByInterco;
    }

    public LocalDate getExpectedRealisationDate() {
        return this.expectedRealisationDate;
    }

    public void setExpectedRealisationDate(LocalDate expectedRealisationDate) {
        this.expectedRealisationDate = expectedRealisationDate;
    }

    public LocalDate getComputationDate() {
        return this.computationDate;
    }

    public void setComputationDate(LocalDate computationDate) {
        this.computationDate = computationDate;
    }

    public TimetableTemplate getTimetableTemplate() {
        return this.timetableTemplate;
    }

    public void setTimetableTemplate(TimetableTemplate timetableTemplate) {
        this.timetableTemplate = timetableTemplate;
    }

    public Integer getStandardDelay() {
        return this.standardDelay == null ? 0 : this.standardDelay;
    }

    public void setStandardDelay(Integer standardDelay) {
        this.standardDelay = standardDelay;
    }

    public List<StockMove> getStockMoveList() {
        return this.stockMoveList;
    }

    public void setStockMoveList(List<StockMove> stockMoveList) {
        this.stockMoveList = stockMoveList;
    }

    public void addStockMoveListItem(StockMove item) {
        if (this.getStockMoveList() == null) {
            this.setStockMoveList(new ArrayList());
        }
        this.getStockMoveList().add(item);
    }

    public void removeStockMoveListItem(StockMove item) {
        if (this.getStockMoveList() == null) {
            return;
        }
        this.getStockMoveList().remove(item);
    }

    public void clearStockMoveList() {
        if (this.getStockMoveList() != null) {
            this.getStockMoveList().clear();
        }
    }

    public ShipmentMode getShipmentMode() {
        return this.shipmentMode;
    }

    public void setShipmentMode(ShipmentMode shipmentMode) {
        this.shipmentMode = shipmentMode;
    }

    public FreightCarrierMode getFreightCarrierMode() {
        return this.freightCarrierMode;
    }

    public void setFreightCarrierMode(FreightCarrierMode freightCarrierMode) {
        this.freightCarrierMode = freightCarrierMode;
    }

    public Partner getCarrierPartner() {
        return this.carrierPartner;
    }

    public void setCarrierPartner(Partner carrierPartner) {
        this.carrierPartner = carrierPartner;
    }

    public Partner getForwarderPartner() {
        return this.forwarderPartner;
    }

    public void setForwarderPartner(Partner forwarderPartner) {
        this.forwarderPartner = forwarderPartner;
    }

    public Incoterm getIncoterm() {
        return this.incoterm;
    }

    public void setIncoterm(Incoterm incoterm) {
        this.incoterm = incoterm;
    }

    public Boolean getIsNeedingConformityCertificate() {
        return this.isNeedingConformityCertificate == null ? Boolean.FALSE : this.isNeedingConformityCertificate;
    }

    public void setIsNeedingConformityCertificate(Boolean isNeedingConformityCertificate) {
        this.isNeedingConformityCertificate = isNeedingConformityCertificate;
    }

    public Boolean getIsIspmRequired() {
        return this.isIspmRequired == null ? Boolean.FALSE : this.isIspmRequired;
    }

    public void setIsIspmRequired(Boolean isIspmRequired) {
        this.isIspmRequired = isIspmRequired;
    }

    public Boolean getDirectOrderLocation() {
        return this.directOrderLocation == null ? Boolean.FALSE : this.directOrderLocation;
    }

    public void setDirectOrderLocation(Boolean directOrderLocation) {
        this.directOrderLocation = directOrderLocation;
    }

    public Partner getInvoicedPartner() {
        return this.invoicedPartner;
    }

    public void setInvoicedPartner(Partner invoicedPartner) {
        this.invoicedPartner = invoicedPartner;
    }

    public Partner getDeliveredPartner() {
        return this.deliveredPartner;
    }

    public void setDeliveredPartner(Partner deliveredPartner) {
        this.deliveredPartner = deliveredPartner;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public Boolean getToInvoiceViaTask() {
        return this.toInvoiceViaTask == null ? Boolean.FALSE : this.toInvoiceViaTask;
    }

    public void setToInvoiceViaTask(Boolean toInvoiceViaTask) {
        this.toInvoiceViaTask = toInvoiceViaTask;
    }

    public MetaFile getElectronicSignature() {
        return this.electronicSignature;
    }

    public void setElectronicSignature(MetaFile electronicSignature) {
        this.electronicSignature = electronicSignature;
    }

    public String getProductionNote() {
        return this.productionNote;
    }

    public void setProductionNote(String productionNote) {
        this.productionNote = productionNote;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SaleOrder)) {
            return false;
        }
        SaleOrder other = (SaleOrder)obj;
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("fullName", (Object)this.getFullName()).add("saleOrderSeq", (Object)this.getSaleOrderSeq()).add("externalReference", (Object)this.getExternalReference()).add("creationDate", (Object)this.getCreationDate()).add("confirmationDateTime", (Object)this.getConfirmationDateTime()).add("blockedOnCustCreditExceed", (Object)this.getBlockedOnCustCreditExceed()).add("manualUnblock", (Object)this.getManualUnblock()).add("title", (Object)this.getTitle()).add("isToPrintLineSubTotal", (Object)this.getIsToPrintLineSubTotal()).add("inAti", (Object)this.getInAti()).add("endOfValidityDate", (Object)this.getEndOfValidityDate()).omitNullValues().toString();
    }
}

