/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.db;

import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.Role;
import com.axelor.db.annotations.Track;
import com.axelor.db.annotations.TrackField;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaJsonModel;
import com.axelor.meta.db.MetaSelect;
import com.axelor.studio.db.AppBuilder;
import com.google.common.base.MoreObjects;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;

@Entity
@Table(name="META_JSON_FIELD", indexes={@Index(columnList="name"), @Index(columnList="json_model"), @Index(columnList="target_json_model"), @Index(columnList="app_builder"), @Index(columnList="meta_select")})
@Track(fields={@TrackField(name="name"), @TrackField(name="title"), @TrackField(name="type"), @TrackField(name="defaultValue"), @TrackField(name="model"), @TrackField(name="modelField"), @TrackField(name="jsonModel"), @TrackField(name="selection"), @TrackField(name="widget"), @TrackField(name="help"), @TrackField(name="showIf"), @TrackField(name="hideIf"), @TrackField(name="requiredIf"), @TrackField(name="readonlyIf"), @TrackField(name="includeIf"), @TrackField(name="contextField"), @TrackField(name="contextFieldTarget"), @TrackField(name="contextFieldTargetName"), @TrackField(name="contextFieldValue"), @TrackField(name="contextFieldTitle"), @TrackField(name="hidden"), @TrackField(name="required"), @TrackField(name="readonly"), @TrackField(name="nameField"), @TrackField(name="visibleInGrid"), @TrackField(name="minSize"), @TrackField(name="maxSize"), @TrackField(name="precision"), @TrackField(name="scale"), @TrackField(name="sequence"), @TrackField(name="columnSequence"), @TrackField(name="regex"), @TrackField(name="valueExpr"), @TrackField(name="targetModel"), @TrackField(name="enumType"), @TrackField(name="formView"), @TrackField(name="gridView"), @TrackField(name="domain"), @TrackField(name="targetJsonModel"), @TrackField(name="onChange"), @TrackField(name="onClick"), @TrackField(name="widgetAttrs")})
public class MetaJsonField
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="META_JSON_FIELD_SEQ")
    @SequenceGenerator(name="META_JSON_FIELD_SEQ", sequenceName="META_JSON_FIELD_SEQ", allocationSize=1)
    private Long id;
    @NotNull
    private String name;
    private String title;
    @Widget(selection="json.field.type")
    @NotNull
    @Column(name="type_name")
    private String type;
    private String defaultValue;
    @NotNull
    @Column(name="model_name")
    private String model;
    @NotNull
    @Column(name="model_field")
    private String modelField;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaJsonModel jsonModel;
    private String selection;
    private String widget;
    private String help;
    @Size(max=512)
    private String showIf;
    @Size(max=512)
    private String hideIf;
    @Size(max=512)
    private String requiredIf;
    @Size(max=512)
    private String readonlyIf;
    @Size(max=512)
    private String includeIf;
    private String contextField;
    private String contextFieldTarget;
    private String contextFieldTargetName;
    private String contextFieldValue;
    private String contextFieldTitle;
    @Column(name="is_hidden")
    private Boolean hidden = Boolean.FALSE;
    @Column(name="is_required")
    private Boolean required = Boolean.FALSE;
    @Column(name="is_readonly")
    private Boolean readonly = Boolean.FALSE;
    private Boolean nameField = Boolean.FALSE;
    private Boolean visibleInGrid = Boolean.FALSE;
    @Column(name="min_size")
    private Integer minSize = 0;
    @Column(name="max_size")
    private Integer maxSize = 0;
    @Column(name="decimal_precision")
    private Integer precision = 6;
    @Column(name="decimal_scale")
    private Integer scale = 2;
    private Integer sequence = 0;
    private Integer columnSequence = 0;
    private String regex;
    @Widget(title="Value Expression")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String valueExpr;
    private String targetModel;
    private String enumType;
    private String formView;
    private String gridView;
    private String domain;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaJsonModel targetJsonModel;
    private String onChange;
    private String onClick;
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String widgetAttrs;
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Role> roles;
    @Widget(title="App builder")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AppBuilder appBuilder;
    @Widget(title="Existing select")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaSelect metaSelect;
    @Widget(title="Selection")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String selectionText;
    private Boolean isSelectionField = Boolean.FALSE;

    public MetaJsonField() {
    }

    public MetaJsonField(String name, Boolean nameField) {
        this.name = name;
        this.nameField = nameField;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getModelField() {
        return this.modelField;
    }

    public void setModelField(String modelField) {
        this.modelField = modelField;
    }

    public MetaJsonModel getJsonModel() {
        return this.jsonModel;
    }

    public void setJsonModel(MetaJsonModel jsonModel) {
        this.jsonModel = jsonModel;
    }

    public String getSelection() {
        return this.selection;
    }

    public void setSelection(String selection) {
        this.selection = selection;
    }

    public String getWidget() {
        return this.widget;
    }

    public void setWidget(String widget) {
        this.widget = widget;
    }

    public String getHelp() {
        return this.help;
    }

    public void setHelp(String help) {
        this.help = help;
    }

    public String getShowIf() {
        return this.showIf;
    }

    public void setShowIf(String showIf) {
        this.showIf = showIf;
    }

    public String getHideIf() {
        return this.hideIf;
    }

    public void setHideIf(String hideIf) {
        this.hideIf = hideIf;
    }

    public String getRequiredIf() {
        return this.requiredIf;
    }

    public void setRequiredIf(String requiredIf) {
        this.requiredIf = requiredIf;
    }

    public String getReadonlyIf() {
        return this.readonlyIf;
    }

    public void setReadonlyIf(String readonlyIf) {
        this.readonlyIf = readonlyIf;
    }

    public String getIncludeIf() {
        return this.includeIf;
    }

    public void setIncludeIf(String includeIf) {
        this.includeIf = includeIf;
    }

    public String getContextField() {
        return this.contextField;
    }

    public void setContextField(String contextField) {
        this.contextField = contextField;
    }

    public String getContextFieldTarget() {
        return this.contextFieldTarget;
    }

    public void setContextFieldTarget(String contextFieldTarget) {
        this.contextFieldTarget = contextFieldTarget;
    }

    public String getContextFieldTargetName() {
        return this.contextFieldTargetName;
    }

    public void setContextFieldTargetName(String contextFieldTargetName) {
        this.contextFieldTargetName = contextFieldTargetName;
    }

    public String getContextFieldValue() {
        return this.contextFieldValue;
    }

    public void setContextFieldValue(String contextFieldValue) {
        this.contextFieldValue = contextFieldValue;
    }

    public String getContextFieldTitle() {
        return this.contextFieldTitle;
    }

    public void setContextFieldTitle(String contextFieldTitle) {
        this.contextFieldTitle = contextFieldTitle;
    }

    public Boolean getHidden() {
        return this.hidden == null ? Boolean.FALSE : this.hidden;
    }

    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    public Boolean getRequired() {
        return this.required == null ? Boolean.FALSE : this.required;
    }

    public void setRequired(Boolean required) {
        this.required = required;
    }

    public Boolean getReadonly() {
        return this.readonly == null ? Boolean.FALSE : this.readonly;
    }

    public void setReadonly(Boolean readonly) {
        this.readonly = readonly;
    }

    public Boolean getNameField() {
        return this.nameField == null ? Boolean.FALSE : this.nameField;
    }

    public void setNameField(Boolean nameField) {
        this.nameField = nameField;
    }

    public Boolean getVisibleInGrid() {
        return this.visibleInGrid == null ? Boolean.FALSE : this.visibleInGrid;
    }

    public void setVisibleInGrid(Boolean visibleInGrid) {
        this.visibleInGrid = visibleInGrid;
    }

    public Integer getMinSize() {
        return this.minSize == null ? 0 : this.minSize;
    }

    public void setMinSize(Integer minSize) {
        this.minSize = minSize;
    }

    public Integer getMaxSize() {
        return this.maxSize == null ? 0 : this.maxSize;
    }

    public void setMaxSize(Integer maxSize) {
        this.maxSize = maxSize;
    }

    public Integer getPrecision() {
        return this.precision == null ? 0 : this.precision;
    }

    public void setPrecision(Integer precision) {
        this.precision = precision;
    }

    public Integer getScale() {
        return this.scale == null ? 0 : this.scale;
    }

    public void setScale(Integer scale) {
        this.scale = scale;
    }

    public Integer getSequence() {
        return this.sequence == null ? 0 : this.sequence;
    }

    public void setSequence(Integer sequence) {
        this.sequence = sequence;
    }

    public Integer getColumnSequence() {
        return this.columnSequence == null ? 0 : this.columnSequence;
    }

    public void setColumnSequence(Integer columnSequence) {
        this.columnSequence = columnSequence;
    }

    public String getRegex() {
        return this.regex;
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }

    public String getValueExpr() {
        return this.valueExpr;
    }

    public void setValueExpr(String valueExpr) {
        this.valueExpr = valueExpr;
    }

    public String getTargetModel() {
        return this.targetModel;
    }

    public void setTargetModel(String targetModel) {
        this.targetModel = targetModel;
    }

    public String getEnumType() {
        return this.enumType;
    }

    public void setEnumType(String enumType) {
        this.enumType = enumType;
    }

    public String getFormView() {
        return this.formView;
    }

    public void setFormView(String formView) {
        this.formView = formView;
    }

    public String getGridView() {
        return this.gridView;
    }

    public void setGridView(String gridView) {
        this.gridView = gridView;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public MetaJsonModel getTargetJsonModel() {
        return this.targetJsonModel;
    }

    public void setTargetJsonModel(MetaJsonModel targetJsonModel) {
        this.targetJsonModel = targetJsonModel;
    }

    public String getOnChange() {
        return this.onChange;
    }

    public void setOnChange(String onChange) {
        this.onChange = onChange;
    }

    public String getOnClick() {
        return this.onClick;
    }

    public void setOnClick(String onClick) {
        this.onClick = onClick;
    }

    public String getWidgetAttrs() {
        return this.widgetAttrs;
    }

    public void setWidgetAttrs(String widgetAttrs) {
        this.widgetAttrs = widgetAttrs;
    }

    public Set<Role> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<Role> roles) {
        this.roles = roles;
    }

    public void addRole(Role item) {
        if (this.getRoles() == null) {
            this.setRoles(new HashSet());
        }
        this.getRoles().add(item);
    }

    public void removeRole(Role item) {
        if (this.getRoles() == null) {
            return;
        }
        this.getRoles().remove(item);
    }

    public void clearRoles() {
        if (this.getRoles() != null) {
            this.getRoles().clear();
        }
    }

    public AppBuilder getAppBuilder() {
        return this.appBuilder;
    }

    public void setAppBuilder(AppBuilder appBuilder) {
        this.appBuilder = appBuilder;
    }

    public MetaSelect getMetaSelect() {
        return this.metaSelect;
    }

    public void setMetaSelect(MetaSelect metaSelect) {
        this.metaSelect = metaSelect;
    }

    public String getSelectionText() {
        return this.selectionText;
    }

    public void setSelectionText(String selectionText) {
        this.selectionText = selectionText;
    }

    public Boolean getIsSelectionField() {
        return this.isSelectionField == null ? Boolean.FALSE : this.isSelectionField;
    }

    public void setIsSelectionField(Boolean isSelectionField) {
        this.isSelectionField = isSelectionField;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MetaJsonField)) {
            return false;
        }
        MetaJsonField other = (MetaJsonField)obj;
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("title", (Object)this.getTitle()).add("type", (Object)this.getType()).add("defaultValue", (Object)this.getDefaultValue()).add("model", (Object)this.getModel()).add("modelField", (Object)this.getModelField()).add("selection", (Object)this.getSelection()).add("widget", (Object)this.getWidget()).add("help", (Object)this.getHelp()).add("showIf", (Object)this.getShowIf()).add("hideIf", (Object)this.getHideIf()).omitNullValues().toString();
    }
}

