/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.apps.account.db.Account;
import com.axelor.apps.account.db.AnalyticDistributionTemplate;
import com.axelor.apps.account.db.AssetDisposalReason;
import com.axelor.apps.account.db.FixedAssetCategory;
import com.axelor.apps.account.db.FixedAssetDerogatoryLine;
import com.axelor.apps.account.db.FixedAssetLine;
import com.axelor.apps.account.db.InvoiceLine;
import com.axelor.apps.account.db.Journal;
import com.axelor.apps.account.db.Move;
import com.axelor.apps.base.db.BarcodeTypeConfig;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.stock.db.StockLocation;
import com.axelor.apps.stock.db.TrackingNumber;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Track;
import com.axelor.db.annotations.TrackField;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaFile;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="ACCOUNT_FIXED_ASSET", indexes={@Index(columnList="name"), @Index(columnList="company"), @Index(columnList="journal"), @Index(columnList="partner"), @Index(columnList="invoice_line"), @Index(columnList="purchase_account"), @Index(columnList="fixed_asset_category"), @Index(columnList="disposal_move"), @Index(columnList="analytic_distribution_template"), @Index(columnList="purchase_account_move"), @Index(columnList="sale_account_move"), @Index(columnList="barcode"), @Index(columnList="barcode_type_config"), @Index(columnList="asset_disposal_reason"), @Index(columnList="stock_location"), @Index(columnList="tracking_number")})
@Track(fields={@TrackField(name="name"), @TrackField(name="statusSelect"), @TrackField(name="qty"), @TrackField(name="fixedAssetCategory"), @TrackField(name="depreciationPlanSelect"), @TrackField(name="isEqualToFiscalDepreciation"), @TrackField(name="numberOfDepreciation"), @TrackField(name="periodicityTypeSelect"), @TrackField(name="durationInMonth"), @TrackField(name="acquisitionDate"), @TrackField(name="firstServiceDate"), @TrackField(name="firstDepreciationDate"), @TrackField(name="grossValue"), @TrackField(name="residualValue"), @TrackField(name="accountingValue"), @TrackField(name="correctedAccountingValue"), @TrackField(name="transferredReasonSelect"), @TrackField(name="comments"), @TrackField(name="serialNumber"), @TrackField(name="assetDisposalReason")})
public class FixedAsset
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_FIXED_ASSET_SEQ")
    @SequenceGenerator(name="ACCOUNT_FIXED_ASSET_SEQ", sequenceName="ACCOUNT_FIXED_ASSET_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Reference", readonly=true)
    private String reference;
    @Widget(title="Name")
    @NotNull
    private String name;
    @Widget(title="Status", selection="account.fixed.asset.status.select")
    private Integer statusSelect = 0;
    @Widget(title="Company")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Journal")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Journal journal;
    @Widget(title="Supplier")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner partner;
    @Widget(title="Invoice line")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private InvoiceLine invoiceLine;
    @Widget(title="Purchase account")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Account purchaseAccount;
    @Widget(title="Fixed asset category")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private FixedAssetCategory fixedAssetCategory;
    @Widget(title="Computation method", selection="account.fixed.type.category.computation.method.select")
    private String computationMethodSelect;
    @Widget(title="Degressive coef")
    private BigDecimal degressiveCoef = BigDecimal.ZERO;
    @Widget(title="Periodicity in month")
    private Integer periodicityInMonth = 12;
    @Widget(title="Number of depreciation")
    private Integer numberOfDepreciation = 1;
    @Widget(title="Duration in month")
    private Integer durationInMonth = 0;
    @Widget(title="Nbr of past depreciations")
    private Integer nbrOfPastDepreciations = 0;
    @Widget(title="Already Depreciated Amount")
    private BigDecimal alreadyDepreciatedAmount = BigDecimal.ZERO;
    @Widget(title="Reference Date for first depreciation", selection="account.fixed.asset.first.depreciation.date.ref.select", massUpdate=true)
    private Integer firstDepreciationDateInitSelect = 1;
    @Widget(title="First depreciation date")
    private LocalDate firstDepreciationDate;
    @Widget(title="Date of acquisition")
    private LocalDate acquisitionDate;
    @Widget(title="Gross value")
    private BigDecimal grossValue = BigDecimal.ZERO;
    @Widget(title="Residual value")
    private BigDecimal residualValue = BigDecimal.ZERO;
    @Widget(title="Fixed asset Disposal date")
    private LocalDate disposalDate;
    @Widget(title="Disposal value")
    private BigDecimal disposalValue = BigDecimal.ZERO;
    @Widget(title="Depreciation board")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="fixedAsset", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<FixedAssetLine> fixedAssetLineList;
    @Widget(title="Fixed asset Disposal Move")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Move disposalMove;
    @Widget(title="Analytic distribution template")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AnalyticDistributionTemplate analyticDistributionTemplate;
    @Widget(title="Transferred Reason", selection="account.fixed.asset.transfer.reason")
    private Integer transferredReasonSelect = 0;
    @Widget(title="Fixed Asset Sequence")
    private String fixedAssetSeq;
    @Widget(title="Purchase Account Move")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Move purchaseAccountMove;
    @Widget(title="Sale Account Move")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Move saleAccountMove;
    @Widget(title="Depreciation Plan", selection="account.fixed.asset.depreciation.plan")
    private String depreciationPlanSelect;
    @Widget(title="Origin", selection="account.fixed.asset.origin")
    private Integer originSelect = 0;
    @Widget(title="First Service Date")
    private LocalDate firstServiceDate;
    @Widget(title="Failover Date")
    private LocalDate failoverDate;
    @Widget(title="Past Depreciation")
    private BigDecimal pastDepreciation = BigDecimal.ZERO;
    @Widget(title="Accounting value")
    private BigDecimal accountingValue = BigDecimal.ZERO;
    @Widget(title="Corrected Accounting Value")
    private BigDecimal correctedAccountingValue = BigDecimal.ZERO;
    @Widget(title="Is Equal To Fiscal Depreciation")
    private Boolean isEqualToFiscalDepreciation = Boolean.FALSE;
    @Widget(title="Periodicity Type", selection="account.fixed.asset.periodicity.type")
    private Integer periodicityTypeSelect = 12;
    @Widget(title="Fiscal Computation Method Select", selection="account.fixed.type.category.fiscal.computation.method.select")
    private String fiscalComputationMethodSelect;
    @Widget(title="Fiscal Degressive Coef")
    private BigDecimal fiscalDegressiveCoef = BigDecimal.ZERO;
    @Widget(title="Fiscal Number Of Depreciation")
    private Integer fiscalNumberOfDepreciation = 0;
    @Widget(title="Fiscal Periodicity Type", selection="account.fixed.asset.fiscal.periodicity.type")
    private Integer fiscalPeriodicityTypeSelect = 12;
    @Widget(title="Fiscal Periodicity In Month")
    private Integer fiscalPeriodicityInMonth = 12;
    @Widget(title="Fiscal Duration In Month")
    private Integer fiscalDurationInMonth = 0;
    @Widget(title="Nbr of past depreciations")
    private Integer fiscalNbrOfPastDepreciations = 0;
    @Widget(title="Already Depreciated Amount")
    private BigDecimal fiscalAlreadyDepreciatedAmount = BigDecimal.ZERO;
    @Widget(title="Fiscal Fixed Asset Line List")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="fiscalFixedAsset", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<FixedAssetLine> fiscalFixedAssetLineList;
    @Widget(title="Depreciation end date")
    private LocalDate depreciationEndDate;
    @Widget(title="Reference Date for first depreciation", selection="account.fixed.asset.first.depreciation.date.ref.select", massUpdate=true)
    private Integer fiscalFirstDepreciationDateInitSelect = 1;
    @Widget(title="Fiscal first depreciation date")
    private LocalDate fiscalFirstDepreciationDate;
    @Widget(title="Is Equal To Fiscal Depreciation")
    private Boolean isIfrsEqualToFiscalDepreciation = Boolean.FALSE;
    @Widget(title="IFRS Computation Method Select", selection="account.fixed.type.category.fiscal.computation.method.select")
    private String ifrsComputationMethodSelect;
    @Widget(title="IFRS Degressive Coef")
    private BigDecimal ifrsDegressiveCoef = BigDecimal.ZERO;
    @Widget(title="IFRS Number Of Depreciation")
    private Integer ifrsNumberOfDepreciation = 0;
    @Widget(title="IFRS Periodicity Type", selection="account.fixed.asset.fiscal.periodicity.type")
    private Integer ifrsPeriodicityTypeSelect = 12;
    @Widget(title="IFRS Periodicity In Month")
    private Integer ifrsPeriodicityInMonth = 12;
    @Widget(title="IFRS Duration In Month")
    private Integer ifrsDurationInMonth = 0;
    @Widget(title="Nbr of past depreciations")
    private Integer ifrsNbrOfPastDepreciations = 0;
    @Widget(title="Already Depreciated Amount")
    private BigDecimal ifrsAlreadyDepreciatedAmount = BigDecimal.ZERO;
    @Widget(title="IFRS Fixed Asset Line List")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="ifrsFixedAsset", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<FixedAssetLine> ifrsFixedAssetLineList;
    @Widget(title="Reference Date for first depreciation", selection="account.fixed.asset.first.depreciation.date.ref.select", massUpdate=true)
    private Integer ifrsFirstDepreciationDateInitSelect = 1;
    @Widget(title="IFRS first depreciation date")
    private LocalDate ifrsFirstDepreciationDate;
    @Widget(title="Associated Fixed Assets Set")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<FixedAsset> associatedFixedAssetsSet;
    @Widget(title="Comments", multiline=true)
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String comments;
    @Widget(title="Disposal Type", selection="account.fixed.asset.disposal.type.select")
    private Integer disposalTypeSelect = 1;
    @Widget(title="Disposal Quantity select", selection="account.fixed.asset.disposal.quantity.select")
    private Integer disposalQtySelect = 1;
    @Widget(title="Disposal Quantity")
    private BigDecimal qty = BigDecimal.ZERO;
    @Widget(title="Fiscal Fixed Asset Line List")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="fixedAsset", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<FixedAssetDerogatoryLine> fixedAssetDerogatoryLineList;
    @Widget(title="Fail over depreciation end date")
    private LocalDate failOverDepreciationEndDate;
    @Widget(title="FailOver Fiscal depreciation end date")
    private LocalDate fiscalFailOverDepreciationEndDate;
    @Widget(title="FailOver Ifrs depreciation end date")
    private LocalDate ifrsFailOverDepreciationEndDate;
    @Widget(title="Depreciated amount current Year")
    private BigDecimal depreciatedAmountCurrentYear = BigDecimal.ZERO;
    @Widget(title="Depreciated amount current Year")
    private BigDecimal fiscalDepreciatedAmountCurrentYear = BigDecimal.ZERO;
    @Widget(title="Depreciated amount current Year")
    private BigDecimal ifrsDepreciatedAmountCurrentYear = BigDecimal.ZERO;
    @Widget(title="Serial Nbr")
    private String serialNumber;
    @Widget(title="Barcode")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaFile barcode;
    @Widget(title="Barcode Type")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private BarcodeTypeConfig barcodeTypeConfig;
    @Widget(title="Disposal Reason")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AssetDisposalReason assetDisposalReason;
    @Widget(title="Initial periodicity in month")
    private Integer initialPeriodicityInMonth = 0;
    @Widget(title="FixedAsset.Location")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private StockLocation stockLocation;
    @Widget(title="Tracking Number")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private TrackingNumber trackingNumber;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public FixedAsset() {
    }

    public FixedAsset(String name, MetaFile barcode, BarcodeTypeConfig barcodeTypeConfig) {
        this.name = name;
        this.barcode = barcode;
        this.barcodeTypeConfig = barcodeTypeConfig;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public Journal getJournal() {
        return this.journal;
    }

    public void setJournal(Journal journal) {
        this.journal = journal;
    }

    public Partner getPartner() {
        return this.partner;
    }

    public void setPartner(Partner partner) {
        this.partner = partner;
    }

    public InvoiceLine getInvoiceLine() {
        return this.invoiceLine;
    }

    public void setInvoiceLine(InvoiceLine invoiceLine) {
        this.invoiceLine = invoiceLine;
    }

    public Account getPurchaseAccount() {
        return this.purchaseAccount;
    }

    public void setPurchaseAccount(Account purchaseAccount) {
        this.purchaseAccount = purchaseAccount;
    }

    public FixedAssetCategory getFixedAssetCategory() {
        return this.fixedAssetCategory;
    }

    public void setFixedAssetCategory(FixedAssetCategory fixedAssetCategory) {
        this.fixedAssetCategory = fixedAssetCategory;
    }

    public String getComputationMethodSelect() {
        return this.computationMethodSelect;
    }

    public void setComputationMethodSelect(String computationMethodSelect) {
        this.computationMethodSelect = computationMethodSelect;
    }

    public BigDecimal getDegressiveCoef() {
        return this.degressiveCoef == null ? BigDecimal.ZERO : this.degressiveCoef;
    }

    public void setDegressiveCoef(BigDecimal degressiveCoef) {
        this.degressiveCoef = degressiveCoef;
    }

    public Integer getPeriodicityInMonth() {
        return this.periodicityInMonth == null ? 0 : this.periodicityInMonth;
    }

    public void setPeriodicityInMonth(Integer periodicityInMonth) {
        this.periodicityInMonth = periodicityInMonth;
    }

    public Integer getNumberOfDepreciation() {
        return this.numberOfDepreciation == null ? 0 : this.numberOfDepreciation;
    }

    public void setNumberOfDepreciation(Integer numberOfDepreciation) {
        this.numberOfDepreciation = numberOfDepreciation;
    }

    public Integer getDurationInMonth() {
        return this.durationInMonth == null ? 0 : this.durationInMonth;
    }

    public void setDurationInMonth(Integer durationInMonth) {
        this.durationInMonth = durationInMonth;
    }

    public Integer getNbrOfPastDepreciations() {
        return this.nbrOfPastDepreciations == null ? 0 : this.nbrOfPastDepreciations;
    }

    public void setNbrOfPastDepreciations(Integer nbrOfPastDepreciations) {
        this.nbrOfPastDepreciations = nbrOfPastDepreciations;
    }

    public BigDecimal getAlreadyDepreciatedAmount() {
        return this.alreadyDepreciatedAmount == null ? BigDecimal.ZERO : this.alreadyDepreciatedAmount;
    }

    public void setAlreadyDepreciatedAmount(BigDecimal alreadyDepreciatedAmount) {
        this.alreadyDepreciatedAmount = alreadyDepreciatedAmount;
    }

    public Integer getFirstDepreciationDateInitSelect() {
        return this.firstDepreciationDateInitSelect == null ? 0 : this.firstDepreciationDateInitSelect;
    }

    public void setFirstDepreciationDateInitSelect(Integer firstDepreciationDateInitSelect) {
        this.firstDepreciationDateInitSelect = firstDepreciationDateInitSelect;
    }

    public LocalDate getFirstDepreciationDate() {
        return this.firstDepreciationDate;
    }

    public void setFirstDepreciationDate(LocalDate firstDepreciationDate) {
        this.firstDepreciationDate = firstDepreciationDate;
    }

    public LocalDate getAcquisitionDate() {
        return this.acquisitionDate;
    }

    public void setAcquisitionDate(LocalDate acquisitionDate) {
        this.acquisitionDate = acquisitionDate;
    }

    public BigDecimal getGrossValue() {
        return this.grossValue == null ? BigDecimal.ZERO : this.grossValue;
    }

    public void setGrossValue(BigDecimal grossValue) {
        this.grossValue = grossValue;
    }

    public BigDecimal getResidualValue() {
        return this.residualValue == null ? BigDecimal.ZERO : this.residualValue;
    }

    public void setResidualValue(BigDecimal residualValue) {
        this.residualValue = residualValue;
    }

    public LocalDate getDisposalDate() {
        return this.disposalDate;
    }

    public void setDisposalDate(LocalDate disposalDate) {
        this.disposalDate = disposalDate;
    }

    public BigDecimal getDisposalValue() {
        return this.disposalValue == null ? BigDecimal.ZERO : this.disposalValue;
    }

    public void setDisposalValue(BigDecimal disposalValue) {
        this.disposalValue = disposalValue;
    }

    public List<FixedAssetLine> getFixedAssetLineList() {
        return this.fixedAssetLineList;
    }

    public void setFixedAssetLineList(List<FixedAssetLine> fixedAssetLineList) {
        this.fixedAssetLineList = fixedAssetLineList;
    }

    public void addFixedAssetLineListItem(FixedAssetLine item) {
        if (this.getFixedAssetLineList() == null) {
            this.setFixedAssetLineList(new ArrayList());
        }
        this.getFixedAssetLineList().add(item);
        item.setFixedAsset(this);
    }

    public void removeFixedAssetLineListItem(FixedAssetLine item) {
        if (this.getFixedAssetLineList() == null) {
            return;
        }
        this.getFixedAssetLineList().remove(item);
    }

    public void clearFixedAssetLineList() {
        if (this.getFixedAssetLineList() != null) {
            this.getFixedAssetLineList().clear();
        }
    }

    public Move getDisposalMove() {
        return this.disposalMove;
    }

    public void setDisposalMove(Move disposalMove) {
        this.disposalMove = disposalMove;
    }

    public AnalyticDistributionTemplate getAnalyticDistributionTemplate() {
        return this.analyticDistributionTemplate;
    }

    public void setAnalyticDistributionTemplate(AnalyticDistributionTemplate analyticDistributionTemplate) {
        this.analyticDistributionTemplate = analyticDistributionTemplate;
    }

    public Integer getTransferredReasonSelect() {
        return this.transferredReasonSelect == null ? 0 : this.transferredReasonSelect;
    }

    public void setTransferredReasonSelect(Integer transferredReasonSelect) {
        this.transferredReasonSelect = transferredReasonSelect;
    }

    public String getFixedAssetSeq() {
        return this.fixedAssetSeq;
    }

    public void setFixedAssetSeq(String fixedAssetSeq) {
        this.fixedAssetSeq = fixedAssetSeq;
    }

    public Move getPurchaseAccountMove() {
        return this.purchaseAccountMove;
    }

    public void setPurchaseAccountMove(Move purchaseAccountMove) {
        this.purchaseAccountMove = purchaseAccountMove;
    }

    public Move getSaleAccountMove() {
        return this.saleAccountMove;
    }

    public void setSaleAccountMove(Move saleAccountMove) {
        this.saleAccountMove = saleAccountMove;
    }

    public String getDepreciationPlanSelect() {
        return this.depreciationPlanSelect;
    }

    public void setDepreciationPlanSelect(String depreciationPlanSelect) {
        this.depreciationPlanSelect = depreciationPlanSelect;
    }

    public Integer getOriginSelect() {
        return this.originSelect == null ? 0 : this.originSelect;
    }

    public void setOriginSelect(Integer originSelect) {
        this.originSelect = originSelect;
    }

    public LocalDate getFirstServiceDate() {
        return this.firstServiceDate;
    }

    public void setFirstServiceDate(LocalDate firstServiceDate) {
        this.firstServiceDate = firstServiceDate;
    }

    public LocalDate getFailoverDate() {
        return this.failoverDate;
    }

    public void setFailoverDate(LocalDate failoverDate) {
        this.failoverDate = failoverDate;
    }

    public BigDecimal getPastDepreciation() {
        return this.pastDepreciation == null ? BigDecimal.ZERO : this.pastDepreciation;
    }

    public void setPastDepreciation(BigDecimal pastDepreciation) {
        this.pastDepreciation = pastDepreciation;
    }

    public BigDecimal getAccountingValue() {
        return this.accountingValue == null ? BigDecimal.ZERO : this.accountingValue;
    }

    public void setAccountingValue(BigDecimal accountingValue) {
        this.accountingValue = accountingValue;
    }

    public BigDecimal getCorrectedAccountingValue() {
        return this.correctedAccountingValue == null ? BigDecimal.ZERO : this.correctedAccountingValue;
    }

    public void setCorrectedAccountingValue(BigDecimal correctedAccountingValue) {
        this.correctedAccountingValue = correctedAccountingValue;
    }

    public Boolean getIsEqualToFiscalDepreciation() {
        return this.isEqualToFiscalDepreciation == null ? Boolean.FALSE : this.isEqualToFiscalDepreciation;
    }

    public void setIsEqualToFiscalDepreciation(Boolean isEqualToFiscalDepreciation) {
        this.isEqualToFiscalDepreciation = isEqualToFiscalDepreciation;
    }

    public Integer getPeriodicityTypeSelect() {
        return this.periodicityTypeSelect == null ? 0 : this.periodicityTypeSelect;
    }

    public void setPeriodicityTypeSelect(Integer periodicityTypeSelect) {
        this.periodicityTypeSelect = periodicityTypeSelect;
    }

    public String getFiscalComputationMethodSelect() {
        return this.fiscalComputationMethodSelect;
    }

    public void setFiscalComputationMethodSelect(String fiscalComputationMethodSelect) {
        this.fiscalComputationMethodSelect = fiscalComputationMethodSelect;
    }

    public BigDecimal getFiscalDegressiveCoef() {
        return this.fiscalDegressiveCoef == null ? BigDecimal.ZERO : this.fiscalDegressiveCoef;
    }

    public void setFiscalDegressiveCoef(BigDecimal fiscalDegressiveCoef) {
        this.fiscalDegressiveCoef = fiscalDegressiveCoef;
    }

    public Integer getFiscalNumberOfDepreciation() {
        return this.fiscalNumberOfDepreciation == null ? 0 : this.fiscalNumberOfDepreciation;
    }

    public void setFiscalNumberOfDepreciation(Integer fiscalNumberOfDepreciation) {
        this.fiscalNumberOfDepreciation = fiscalNumberOfDepreciation;
    }

    public Integer getFiscalPeriodicityTypeSelect() {
        return this.fiscalPeriodicityTypeSelect == null ? 0 : this.fiscalPeriodicityTypeSelect;
    }

    public void setFiscalPeriodicityTypeSelect(Integer fiscalPeriodicityTypeSelect) {
        this.fiscalPeriodicityTypeSelect = fiscalPeriodicityTypeSelect;
    }

    public Integer getFiscalPeriodicityInMonth() {
        return this.fiscalPeriodicityInMonth == null ? 0 : this.fiscalPeriodicityInMonth;
    }

    public void setFiscalPeriodicityInMonth(Integer fiscalPeriodicityInMonth) {
        this.fiscalPeriodicityInMonth = fiscalPeriodicityInMonth;
    }

    public Integer getFiscalDurationInMonth() {
        return this.fiscalDurationInMonth == null ? 0 : this.fiscalDurationInMonth;
    }

    public void setFiscalDurationInMonth(Integer fiscalDurationInMonth) {
        this.fiscalDurationInMonth = fiscalDurationInMonth;
    }

    public Integer getFiscalNbrOfPastDepreciations() {
        return this.fiscalNbrOfPastDepreciations == null ? 0 : this.fiscalNbrOfPastDepreciations;
    }

    public void setFiscalNbrOfPastDepreciations(Integer fiscalNbrOfPastDepreciations) {
        this.fiscalNbrOfPastDepreciations = fiscalNbrOfPastDepreciations;
    }

    public BigDecimal getFiscalAlreadyDepreciatedAmount() {
        return this.fiscalAlreadyDepreciatedAmount == null ? BigDecimal.ZERO : this.fiscalAlreadyDepreciatedAmount;
    }

    public void setFiscalAlreadyDepreciatedAmount(BigDecimal fiscalAlreadyDepreciatedAmount) {
        this.fiscalAlreadyDepreciatedAmount = fiscalAlreadyDepreciatedAmount;
    }

    public List<FixedAssetLine> getFiscalFixedAssetLineList() {
        return this.fiscalFixedAssetLineList;
    }

    public void setFiscalFixedAssetLineList(List<FixedAssetLine> fiscalFixedAssetLineList) {
        this.fiscalFixedAssetLineList = fiscalFixedAssetLineList;
    }

    public void addFiscalFixedAssetLineListItem(FixedAssetLine item) {
        if (this.getFiscalFixedAssetLineList() == null) {
            this.setFiscalFixedAssetLineList(new ArrayList());
        }
        this.getFiscalFixedAssetLineList().add(item);
        item.setFiscalFixedAsset(this);
    }

    public void removeFiscalFixedAssetLineListItem(FixedAssetLine item) {
        if (this.getFiscalFixedAssetLineList() == null) {
            return;
        }
        this.getFiscalFixedAssetLineList().remove(item);
    }

    public void clearFiscalFixedAssetLineList() {
        if (this.getFiscalFixedAssetLineList() != null) {
            this.getFiscalFixedAssetLineList().clear();
        }
    }

    public LocalDate getDepreciationEndDate() {
        return this.depreciationEndDate;
    }

    public void setDepreciationEndDate(LocalDate depreciationEndDate) {
        this.depreciationEndDate = depreciationEndDate;
    }

    public Integer getFiscalFirstDepreciationDateInitSelect() {
        return this.fiscalFirstDepreciationDateInitSelect == null ? 0 : this.fiscalFirstDepreciationDateInitSelect;
    }

    public void setFiscalFirstDepreciationDateInitSelect(Integer fiscalFirstDepreciationDateInitSelect) {
        this.fiscalFirstDepreciationDateInitSelect = fiscalFirstDepreciationDateInitSelect;
    }

    public LocalDate getFiscalFirstDepreciationDate() {
        return this.fiscalFirstDepreciationDate;
    }

    public void setFiscalFirstDepreciationDate(LocalDate fiscalFirstDepreciationDate) {
        this.fiscalFirstDepreciationDate = fiscalFirstDepreciationDate;
    }

    public Boolean getIsIfrsEqualToFiscalDepreciation() {
        return this.isIfrsEqualToFiscalDepreciation == null ? Boolean.FALSE : this.isIfrsEqualToFiscalDepreciation;
    }

    public void setIsIfrsEqualToFiscalDepreciation(Boolean isIfrsEqualToFiscalDepreciation) {
        this.isIfrsEqualToFiscalDepreciation = isIfrsEqualToFiscalDepreciation;
    }

    public String getIfrsComputationMethodSelect() {
        return this.ifrsComputationMethodSelect;
    }

    public void setIfrsComputationMethodSelect(String ifrsComputationMethodSelect) {
        this.ifrsComputationMethodSelect = ifrsComputationMethodSelect;
    }

    public BigDecimal getIfrsDegressiveCoef() {
        return this.ifrsDegressiveCoef == null ? BigDecimal.ZERO : this.ifrsDegressiveCoef;
    }

    public void setIfrsDegressiveCoef(BigDecimal ifrsDegressiveCoef) {
        this.ifrsDegressiveCoef = ifrsDegressiveCoef;
    }

    public Integer getIfrsNumberOfDepreciation() {
        return this.ifrsNumberOfDepreciation == null ? 0 : this.ifrsNumberOfDepreciation;
    }

    public void setIfrsNumberOfDepreciation(Integer ifrsNumberOfDepreciation) {
        this.ifrsNumberOfDepreciation = ifrsNumberOfDepreciation;
    }

    public Integer getIfrsPeriodicityTypeSelect() {
        return this.ifrsPeriodicityTypeSelect == null ? 0 : this.ifrsPeriodicityTypeSelect;
    }

    public void setIfrsPeriodicityTypeSelect(Integer ifrsPeriodicityTypeSelect) {
        this.ifrsPeriodicityTypeSelect = ifrsPeriodicityTypeSelect;
    }

    public Integer getIfrsPeriodicityInMonth() {
        return this.ifrsPeriodicityInMonth == null ? 0 : this.ifrsPeriodicityInMonth;
    }

    public void setIfrsPeriodicityInMonth(Integer ifrsPeriodicityInMonth) {
        this.ifrsPeriodicityInMonth = ifrsPeriodicityInMonth;
    }

    public Integer getIfrsDurationInMonth() {
        return this.ifrsDurationInMonth == null ? 0 : this.ifrsDurationInMonth;
    }

    public void setIfrsDurationInMonth(Integer ifrsDurationInMonth) {
        this.ifrsDurationInMonth = ifrsDurationInMonth;
    }

    public Integer getIfrsNbrOfPastDepreciations() {
        return this.ifrsNbrOfPastDepreciations == null ? 0 : this.ifrsNbrOfPastDepreciations;
    }

    public void setIfrsNbrOfPastDepreciations(Integer ifrsNbrOfPastDepreciations) {
        this.ifrsNbrOfPastDepreciations = ifrsNbrOfPastDepreciations;
    }

    public BigDecimal getIfrsAlreadyDepreciatedAmount() {
        return this.ifrsAlreadyDepreciatedAmount == null ? BigDecimal.ZERO : this.ifrsAlreadyDepreciatedAmount;
    }

    public void setIfrsAlreadyDepreciatedAmount(BigDecimal ifrsAlreadyDepreciatedAmount) {
        this.ifrsAlreadyDepreciatedAmount = ifrsAlreadyDepreciatedAmount;
    }

    public List<FixedAssetLine> getIfrsFixedAssetLineList() {
        return this.ifrsFixedAssetLineList;
    }

    public void setIfrsFixedAssetLineList(List<FixedAssetLine> ifrsFixedAssetLineList) {
        this.ifrsFixedAssetLineList = ifrsFixedAssetLineList;
    }

    public void addIfrsFixedAssetLineListItem(FixedAssetLine item) {
        if (this.getIfrsFixedAssetLineList() == null) {
            this.setIfrsFixedAssetLineList(new ArrayList());
        }
        this.getIfrsFixedAssetLineList().add(item);
        item.setIfrsFixedAsset(this);
    }

    public void removeIfrsFixedAssetLineListItem(FixedAssetLine item) {
        if (this.getIfrsFixedAssetLineList() == null) {
            return;
        }
        this.getIfrsFixedAssetLineList().remove(item);
    }

    public void clearIfrsFixedAssetLineList() {
        if (this.getIfrsFixedAssetLineList() != null) {
            this.getIfrsFixedAssetLineList().clear();
        }
    }

    public Integer getIfrsFirstDepreciationDateInitSelect() {
        return this.ifrsFirstDepreciationDateInitSelect == null ? 0 : this.ifrsFirstDepreciationDateInitSelect;
    }

    public void setIfrsFirstDepreciationDateInitSelect(Integer ifrsFirstDepreciationDateInitSelect) {
        this.ifrsFirstDepreciationDateInitSelect = ifrsFirstDepreciationDateInitSelect;
    }

    public LocalDate getIfrsFirstDepreciationDate() {
        return this.ifrsFirstDepreciationDate;
    }

    public void setIfrsFirstDepreciationDate(LocalDate ifrsFirstDepreciationDate) {
        this.ifrsFirstDepreciationDate = ifrsFirstDepreciationDate;
    }

    public Set<FixedAsset> getAssociatedFixedAssetsSet() {
        return this.associatedFixedAssetsSet;
    }

    public void setAssociatedFixedAssetsSet(Set<FixedAsset> associatedFixedAssetsSet) {
        this.associatedFixedAssetsSet = associatedFixedAssetsSet;
    }

    public void addAssociatedFixedAssetsSetItem(FixedAsset item) {
        if (this.getAssociatedFixedAssetsSet() == null) {
            this.setAssociatedFixedAssetsSet(new HashSet());
        }
        this.getAssociatedFixedAssetsSet().add(item);
    }

    public void removeAssociatedFixedAssetsSetItem(FixedAsset item) {
        if (this.getAssociatedFixedAssetsSet() == null) {
            return;
        }
        this.getAssociatedFixedAssetsSet().remove(item);
    }

    public void clearAssociatedFixedAssetsSet() {
        if (this.getAssociatedFixedAssetsSet() != null) {
            this.getAssociatedFixedAssetsSet().clear();
        }
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public Integer getDisposalTypeSelect() {
        return this.disposalTypeSelect == null ? 0 : this.disposalTypeSelect;
    }

    public void setDisposalTypeSelect(Integer disposalTypeSelect) {
        this.disposalTypeSelect = disposalTypeSelect;
    }

    public Integer getDisposalQtySelect() {
        return this.disposalQtySelect == null ? 0 : this.disposalQtySelect;
    }

    public void setDisposalQtySelect(Integer disposalQtySelect) {
        this.disposalQtySelect = disposalQtySelect;
    }

    public BigDecimal getQty() {
        return this.qty == null ? BigDecimal.ZERO : this.qty;
    }

    public void setQty(BigDecimal qty) {
        this.qty = qty;
    }

    public List<FixedAssetDerogatoryLine> getFixedAssetDerogatoryLineList() {
        return this.fixedAssetDerogatoryLineList;
    }

    public void setFixedAssetDerogatoryLineList(List<FixedAssetDerogatoryLine> fixedAssetDerogatoryLineList) {
        this.fixedAssetDerogatoryLineList = fixedAssetDerogatoryLineList;
    }

    public void addFixedAssetDerogatoryLineListItem(FixedAssetDerogatoryLine item) {
        if (this.getFixedAssetDerogatoryLineList() == null) {
            this.setFixedAssetDerogatoryLineList(new ArrayList());
        }
        this.getFixedAssetDerogatoryLineList().add(item);
        item.setFixedAsset(this);
    }

    public void removeFixedAssetDerogatoryLineListItem(FixedAssetDerogatoryLine item) {
        if (this.getFixedAssetDerogatoryLineList() == null) {
            return;
        }
        this.getFixedAssetDerogatoryLineList().remove(item);
    }

    public void clearFixedAssetDerogatoryLineList() {
        if (this.getFixedAssetDerogatoryLineList() != null) {
            this.getFixedAssetDerogatoryLineList().clear();
        }
    }

    public LocalDate getFailOverDepreciationEndDate() {
        return this.failOverDepreciationEndDate;
    }

    public void setFailOverDepreciationEndDate(LocalDate failOverDepreciationEndDate) {
        this.failOverDepreciationEndDate = failOverDepreciationEndDate;
    }

    public LocalDate getFiscalFailOverDepreciationEndDate() {
        return this.fiscalFailOverDepreciationEndDate;
    }

    public void setFiscalFailOverDepreciationEndDate(LocalDate fiscalFailOverDepreciationEndDate) {
        this.fiscalFailOverDepreciationEndDate = fiscalFailOverDepreciationEndDate;
    }

    public LocalDate getIfrsFailOverDepreciationEndDate() {
        return this.ifrsFailOverDepreciationEndDate;
    }

    public void setIfrsFailOverDepreciationEndDate(LocalDate ifrsFailOverDepreciationEndDate) {
        this.ifrsFailOverDepreciationEndDate = ifrsFailOverDepreciationEndDate;
    }

    public BigDecimal getDepreciatedAmountCurrentYear() {
        return this.depreciatedAmountCurrentYear == null ? BigDecimal.ZERO : this.depreciatedAmountCurrentYear;
    }

    public void setDepreciatedAmountCurrentYear(BigDecimal depreciatedAmountCurrentYear) {
        this.depreciatedAmountCurrentYear = depreciatedAmountCurrentYear;
    }

    public BigDecimal getFiscalDepreciatedAmountCurrentYear() {
        return this.fiscalDepreciatedAmountCurrentYear == null ? BigDecimal.ZERO : this.fiscalDepreciatedAmountCurrentYear;
    }

    public void setFiscalDepreciatedAmountCurrentYear(BigDecimal fiscalDepreciatedAmountCurrentYear) {
        this.fiscalDepreciatedAmountCurrentYear = fiscalDepreciatedAmountCurrentYear;
    }

    public BigDecimal getIfrsDepreciatedAmountCurrentYear() {
        return this.ifrsDepreciatedAmountCurrentYear == null ? BigDecimal.ZERO : this.ifrsDepreciatedAmountCurrentYear;
    }

    public void setIfrsDepreciatedAmountCurrentYear(BigDecimal ifrsDepreciatedAmountCurrentYear) {
        this.ifrsDepreciatedAmountCurrentYear = ifrsDepreciatedAmountCurrentYear;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public MetaFile getBarcode() {
        return this.barcode;
    }

    public void setBarcode(MetaFile barcode) {
        this.barcode = barcode;
    }

    public BarcodeTypeConfig getBarcodeTypeConfig() {
        return this.barcodeTypeConfig;
    }

    public void setBarcodeTypeConfig(BarcodeTypeConfig barcodeTypeConfig) {
        this.barcodeTypeConfig = barcodeTypeConfig;
    }

    public AssetDisposalReason getAssetDisposalReason() {
        return this.assetDisposalReason;
    }

    public void setAssetDisposalReason(AssetDisposalReason assetDisposalReason) {
        this.assetDisposalReason = assetDisposalReason;
    }

    public Integer getInitialPeriodicityInMonth() {
        return this.initialPeriodicityInMonth == null ? 0 : this.initialPeriodicityInMonth;
    }

    public void setInitialPeriodicityInMonth(Integer initialPeriodicityInMonth) {
        this.initialPeriodicityInMonth = initialPeriodicityInMonth;
    }

    public StockLocation getStockLocation() {
        return this.stockLocation;
    }

    public void setStockLocation(StockLocation stockLocation) {
        this.stockLocation = stockLocation;
    }

    public TrackingNumber getTrackingNumber() {
        return this.trackingNumber;
    }

    public void setTrackingNumber(TrackingNumber trackingNumber) {
        this.trackingNumber = trackingNumber;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FixedAsset)) {
            return false;
        }
        FixedAsset other = (FixedAsset)obj;
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("reference", (Object)this.getReference()).add("name", (Object)this.getName()).add("statusSelect", (Object)this.getStatusSelect()).add("computationMethodSelect", (Object)this.getComputationMethodSelect()).add("degressiveCoef", (Object)this.getDegressiveCoef()).add("periodicityInMonth", (Object)this.getPeriodicityInMonth()).add("numberOfDepreciation", (Object)this.getNumberOfDepreciation()).add("durationInMonth", (Object)this.getDurationInMonth()).add("nbrOfPastDepreciations", (Object)this.getNbrOfPastDepreciations()).add("alreadyDepreciatedAmount", (Object)this.getAlreadyDepreciatedAmount()).add("firstDepreciationDateInitSelect", (Object)this.getFirstDepreciationDateInitSelect()).omitNullValues().toString();
    }
}

