/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.message.db;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.crm.db.Event;
import com.axelor.apps.message.db.EmailAccount;
import com.axelor.apps.message.db.EmailAddress;
import com.axelor.apps.message.db.MultiRelated;
import com.axelor.apps.message.db.Template;
import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Table(name="MESSAGE_MESSAGE", indexes={@Index(columnList="subject"), @Index(columnList="from_email_address"), @Index(columnList="mail_account"), @Index(columnList="sender_user"), @Index(columnList="recipient_user"), @Index(columnList="template"), @Index(columnList="company"), @Index(columnList="event")})
public class Message
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="MESSAGE_MESSAGE_SEQ")
    @SequenceGenerator(name="MESSAGE_MESSAGE_SEQ", sequenceName="MESSAGE_MESSAGE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Type", readonly=true, selection="message.type.select")
    private Integer typeSelect = 2;
    @Widget(title="Subject")
    @NameColumn
    private String subject;
    @Widget(title="Content")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String content;
    @Widget(title="Sent date", readonly=true)
    private LocalDateTime sentDateT;
    @Widget(title="Forecasted Sent Date")
    private LocalDate sendScheduleDate;
    @Widget(title="Status", readonly=true, selection="message.status.select")
    private Integer statusSelect = 1;
    @Widget(title="Media Type", selection="message.media.type.select")
    private Integer mediaTypeSelect = 0;
    @Widget(title="Address Block", multiline=true)
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String addressBlock;
    @Widget(title="From")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private EmailAddress fromEmailAddress;
    @Widget(title="Reply to")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<EmailAddress> replyToEmailAddressSet;
    @Widget(title="To")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<EmailAddress> toEmailAddressSet;
    @Widget(title="Cc")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<EmailAddress> ccEmailAddressSet;
    @Widget(title="Bcc")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<EmailAddress> bccEmailAddressSet;
    @Widget(title="Sent by email")
    private Boolean sentByEmail = Boolean.FALSE;
    @Widget(title="Mail account")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private EmailAccount mailAccount;
    @Widget(title="Related to")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="message", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<MultiRelated> multiRelatedList;
    @Widget(title="Sender (User)", readonly=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User senderUser;
    @Widget(title="Recipient")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User recipientUser;
    @Widget(readonly=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Template template;
    @Widget(title="Thread ID", hidden=true)
    private String emailThreadId;
    @Widget(title="Mobile phone")
    private String toMobilePhone;
    @Widget(title="Company")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Event")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Event event;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Message() {
    }

    public Message(Integer typeSelect, String subject, String content, Integer statusSelect, Integer mediaTypeSelect, String addressBlock, EmailAddress fromEmailAddress, Set<EmailAddress> replyToEmailAddressSet, Set<EmailAddress> toEmailAddressSet, Set<EmailAddress> ccEmailAddressSet, Set<EmailAddress> bccEmailAddressSet, Boolean sentByEmail, EmailAccount mailAccount) {
        this.typeSelect = typeSelect;
        this.subject = subject;
        this.content = content;
        this.statusSelect = statusSelect;
        this.mediaTypeSelect = mediaTypeSelect;
        this.addressBlock = addressBlock;
        this.fromEmailAddress = fromEmailAddress;
        this.replyToEmailAddressSet = replyToEmailAddressSet;
        this.toEmailAddressSet = toEmailAddressSet;
        this.ccEmailAddressSet = ccEmailAddressSet;
        this.bccEmailAddressSet = bccEmailAddressSet;
        this.sentByEmail = sentByEmail;
        this.mailAccount = mailAccount;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getTypeSelect() {
        return this.typeSelect == null ? 0 : this.typeSelect;
    }

    public void setTypeSelect(Integer typeSelect) {
        this.typeSelect = typeSelect;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public LocalDateTime getSentDateT() {
        return this.sentDateT;
    }

    public void setSentDateT(LocalDateTime sentDateT) {
        this.sentDateT = sentDateT;
    }

    public LocalDate getSendScheduleDate() {
        return this.sendScheduleDate;
    }

    public void setSendScheduleDate(LocalDate sendScheduleDate) {
        this.sendScheduleDate = sendScheduleDate;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public Integer getMediaTypeSelect() {
        return this.mediaTypeSelect == null ? 0 : this.mediaTypeSelect;
    }

    public void setMediaTypeSelect(Integer mediaTypeSelect) {
        this.mediaTypeSelect = mediaTypeSelect;
    }

    public String getAddressBlock() {
        return this.addressBlock;
    }

    public void setAddressBlock(String addressBlock) {
        this.addressBlock = addressBlock;
    }

    public EmailAddress getFromEmailAddress() {
        return this.fromEmailAddress;
    }

    public void setFromEmailAddress(EmailAddress fromEmailAddress) {
        this.fromEmailAddress = fromEmailAddress;
    }

    public Set<EmailAddress> getReplyToEmailAddressSet() {
        return this.replyToEmailAddressSet;
    }

    public void setReplyToEmailAddressSet(Set<EmailAddress> replyToEmailAddressSet) {
        this.replyToEmailAddressSet = replyToEmailAddressSet;
    }

    public void addReplyToEmailAddressSetItem(EmailAddress item) {
        if (this.getReplyToEmailAddressSet() == null) {
            this.setReplyToEmailAddressSet(new HashSet());
        }
        this.getReplyToEmailAddressSet().add(item);
    }

    public void removeReplyToEmailAddressSetItem(EmailAddress item) {
        if (this.getReplyToEmailAddressSet() == null) {
            return;
        }
        this.getReplyToEmailAddressSet().remove(item);
    }

    public void clearReplyToEmailAddressSet() {
        if (this.getReplyToEmailAddressSet() != null) {
            this.getReplyToEmailAddressSet().clear();
        }
    }

    public Set<EmailAddress> getToEmailAddressSet() {
        return this.toEmailAddressSet;
    }

    public void setToEmailAddressSet(Set<EmailAddress> toEmailAddressSet) {
        this.toEmailAddressSet = toEmailAddressSet;
    }

    public void addToEmailAddressSetItem(EmailAddress item) {
        if (this.getToEmailAddressSet() == null) {
            this.setToEmailAddressSet(new HashSet());
        }
        this.getToEmailAddressSet().add(item);
    }

    public void removeToEmailAddressSetItem(EmailAddress item) {
        if (this.getToEmailAddressSet() == null) {
            return;
        }
        this.getToEmailAddressSet().remove(item);
    }

    public void clearToEmailAddressSet() {
        if (this.getToEmailAddressSet() != null) {
            this.getToEmailAddressSet().clear();
        }
    }

    public Set<EmailAddress> getCcEmailAddressSet() {
        return this.ccEmailAddressSet;
    }

    public void setCcEmailAddressSet(Set<EmailAddress> ccEmailAddressSet) {
        this.ccEmailAddressSet = ccEmailAddressSet;
    }

    public void addCcEmailAddressSetItem(EmailAddress item) {
        if (this.getCcEmailAddressSet() == null) {
            this.setCcEmailAddressSet(new HashSet());
        }
        this.getCcEmailAddressSet().add(item);
    }

    public void removeCcEmailAddressSetItem(EmailAddress item) {
        if (this.getCcEmailAddressSet() == null) {
            return;
        }
        this.getCcEmailAddressSet().remove(item);
    }

    public void clearCcEmailAddressSet() {
        if (this.getCcEmailAddressSet() != null) {
            this.getCcEmailAddressSet().clear();
        }
    }

    public Set<EmailAddress> getBccEmailAddressSet() {
        return this.bccEmailAddressSet;
    }

    public void setBccEmailAddressSet(Set<EmailAddress> bccEmailAddressSet) {
        this.bccEmailAddressSet = bccEmailAddressSet;
    }

    public void addBccEmailAddressSetItem(EmailAddress item) {
        if (this.getBccEmailAddressSet() == null) {
            this.setBccEmailAddressSet(new HashSet());
        }
        this.getBccEmailAddressSet().add(item);
    }

    public void removeBccEmailAddressSetItem(EmailAddress item) {
        if (this.getBccEmailAddressSet() == null) {
            return;
        }
        this.getBccEmailAddressSet().remove(item);
    }

    public void clearBccEmailAddressSet() {
        if (this.getBccEmailAddressSet() != null) {
            this.getBccEmailAddressSet().clear();
        }
    }

    public Boolean getSentByEmail() {
        return this.sentByEmail == null ? Boolean.FALSE : this.sentByEmail;
    }

    public void setSentByEmail(Boolean sentByEmail) {
        this.sentByEmail = sentByEmail;
    }

    public EmailAccount getMailAccount() {
        return this.mailAccount;
    }

    public void setMailAccount(EmailAccount mailAccount) {
        this.mailAccount = mailAccount;
    }

    public List<MultiRelated> getMultiRelatedList() {
        return this.multiRelatedList;
    }

    public void setMultiRelatedList(List<MultiRelated> multiRelatedList) {
        this.multiRelatedList = multiRelatedList;
    }

    public void addMultiRelatedListItem(MultiRelated item) {
        if (this.getMultiRelatedList() == null) {
            this.setMultiRelatedList(new ArrayList());
        }
        this.getMultiRelatedList().add(item);
        item.setMessage(this);
    }

    public void removeMultiRelatedListItem(MultiRelated item) {
        if (this.getMultiRelatedList() == null) {
            return;
        }
        this.getMultiRelatedList().remove(item);
    }

    public void clearMultiRelatedList() {
        if (this.getMultiRelatedList() != null) {
            this.getMultiRelatedList().clear();
        }
    }

    public User getSenderUser() {
        return this.senderUser;
    }

    public void setSenderUser(User senderUser) {
        this.senderUser = senderUser;
    }

    public User getRecipientUser() {
        return this.recipientUser;
    }

    public void setRecipientUser(User recipientUser) {
        this.recipientUser = recipientUser;
    }

    public Template getTemplate() {
        return this.template;
    }

    public void setTemplate(Template template) {
        this.template = template;
    }

    public String getEmailThreadId() {
        return this.emailThreadId;
    }

    public void setEmailThreadId(String emailThreadId) {
        this.emailThreadId = emailThreadId;
    }

    public String getToMobilePhone() {
        return this.toMobilePhone;
    }

    public void setToMobilePhone(String toMobilePhone) {
        this.toMobilePhone = toMobilePhone;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public Event getEvent() {
        return this.event;
    }

    public void setEvent(Event event) {
        this.event = event;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Message)) {
            return false;
        }
        Message other = (Message)obj;
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("typeSelect", (Object)this.getTypeSelect()).add("subject", (Object)this.getSubject()).add("sentDateT", (Object)this.getSentDateT()).add("sendScheduleDate", (Object)this.getSendScheduleDate()).add("statusSelect", (Object)this.getStatusSelect()).add("mediaTypeSelect", (Object)this.getMediaTypeSelect()).add("sentByEmail", (Object)this.getSentByEmail()).add("emailThreadId", (Object)this.getEmailThreadId()).add("toMobilePhone", (Object)this.getToMobilePhone()).omitNullValues().toString();
    }
}

