/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.base.db.AccessConfig;
import com.axelor.apps.base.db.AppAccount;
import com.axelor.apps.base.db.AppAppraisal;
import com.axelor.apps.base.db.AppBankPayment;
import com.axelor.apps.base.db.AppBase;
import com.axelor.apps.base.db.AppBpm;
import com.axelor.apps.base.db.AppBudget;
import com.axelor.apps.base.db.AppBusinessProject;
import com.axelor.apps.base.db.AppBusinessSupport;
import com.axelor.apps.base.db.AppCashManagement;
import com.axelor.apps.base.db.AppContract;
import com.axelor.apps.base.db.AppCrm;
import com.axelor.apps.base.db.AppEmployee;
import com.axelor.apps.base.db.AppExpense;
import com.axelor.apps.base.db.AppExtraHours;
import com.axelor.apps.base.db.AppFleet;
import com.axelor.apps.base.db.AppHelpdesk;
import com.axelor.apps.base.db.AppInvoice;
import com.axelor.apps.base.db.AppLeave;
import com.axelor.apps.base.db.AppMaintenance;
import com.axelor.apps.base.db.AppMarketing;
import com.axelor.apps.base.db.AppMobile;
import com.axelor.apps.base.db.AppPortal;
import com.axelor.apps.base.db.AppProduction;
import com.axelor.apps.base.db.AppProject;
import com.axelor.apps.base.db.AppPurchase;
import com.axelor.apps.base.db.AppPurchaseRequest;
import com.axelor.apps.base.db.AppQuality;
import com.axelor.apps.base.db.AppRecruitment;
import com.axelor.apps.base.db.AppSale;
import com.axelor.apps.base.db.AppStock;
import com.axelor.apps.base.db.AppSupplierPortal;
import com.axelor.apps.base.db.AppSupplychain;
import com.axelor.apps.base.db.AppTimesheet;
import com.axelor.apps.base.db.AppTraining;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.EqualsInclude;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaFile;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="BASE_APP", indexes={@Index(columnList="name"), @Index(columnList="image")})
public class App
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_APP_SEQ")
    @SequenceGenerator(name="BASE_APP_SEQ", sequenceName="BASE_APP_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Name", translatable=true)
    @NotNull
    private String name;
    @EqualsInclude
    @Widget(title="Code")
    @NotNull
    @Column(unique=true)
    private String code;
    @Widget(title="Description", translatable=true)
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String description;
    @Widget(title="Modules contains in the app")
    private String modules;
    @Widget(title="Depends on")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<App> dependsOnSet;
    @Widget(title="Image")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaFile image;
    @Widget(title="Init data loaded")
    private Boolean initDataLoaded = Boolean.FALSE;
    @Widget(title="Demo data loaded")
    private Boolean demoDataLoaded = Boolean.FALSE;
    @Widget(title="Roles imported")
    private Boolean isRolesImported = Boolean.FALSE;
    @Widget(title="Installed")
    private Boolean active = Boolean.FALSE;
    @Widget(title="Sequence")
    private Integer sequence = 0;
    @Widget(title="Install order")
    private Integer installOrder = 0;
    @Widget(title="Language", selection="select.language")
    private String languageSelect;
    @Widget(title="Access config")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="app", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<AccessConfig> accessConfigList;
    @Widget(title="Custom")
    private Boolean isCustom = Boolean.FALSE;
    @OneToOne(fetch=FetchType.LAZY, mappedBy="app", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AppBase appBase;
    @OneToOne(fetch=FetchType.LAZY, mappedBy="app", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AppAccount appAccount;
    @OneToOne(fetch=FetchType.LAZY, mappedBy="app", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AppInvoice appInvoice;
    @OneToOne(fetch=FetchType.LAZY, mappedBy="app", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AppBudget appBudget;
    @OneToOne(fetch=FetchType.LAZY, mappedBy="app", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AppBankPayment appBankPayment;
    @OneToOne(fetch=FetchType.LAZY, mappedBy="app", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AppProject appProject;
    @OneToOne(fetch=FetchType.LAZY, mappedBy="app", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AppEmployee appEmployee;
    @OneToOne(fetch=FetchType.LAZY, mappedBy="app", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AppExpense appExpense;
    @OneToOne(fetch=FetchType.LAZY, mappedBy="app", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AppExtraHours appExthrs;
    @OneToOne(fetch=FetchType.LAZY, mappedBy="app", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AppLeave appLeave;
    @OneToOne(fetch=FetchType.LAZY, mappedBy="app", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AppTimesheet appTimesheet;
    @OneToOne(fetch=FetchType.LAZY, mappedBy="app", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AppCrm appCrm;
    @OneToOne(fetch=FetchType.LAZY, mappedBy="app", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AppSale appSale;
    @OneToOne(fetch=FetchType.LAZY, mappedBy="app", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AppMobile appMobile;
    @OneToOne(fetch=FetchType.LAZY, mappedBy="app", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AppPurchase appPurchase;
    @OneToOne(fetch=FetchType.LAZY, mappedBy="app", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AppPurchaseRequest appPurchaseRequest;
    @OneToOne(fetch=FetchType.LAZY, mappedBy="app", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AppStock appStock;
    @OneToOne(fetch=FetchType.LAZY, mappedBy="app", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AppSupplychain appSupplychain;
    @OneToOne(fetch=FetchType.LAZY, mappedBy="app", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AppContract appContract;
    @OneToOne(fetch=FetchType.LAZY, mappedBy="app", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AppBusinessProject appBusinessProject;
    @OneToOne(fetch=FetchType.LAZY, mappedBy="app", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AppCashManagement appCashManagement;
    @OneToOne(fetch=FetchType.LAZY, mappedBy="app", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AppAppraisal appAppraisal;
    @OneToOne(fetch=FetchType.LAZY, mappedBy="app", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AppRecruitment appRecruitment;
    @OneToOne(fetch=FetchType.LAZY, mappedBy="app", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AppTraining appTraining;
    @OneToOne(fetch=FetchType.LAZY, mappedBy="app", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AppProduction appProduction;
    @OneToOne(fetch=FetchType.LAZY, mappedBy="app", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AppQuality appQuality;
    @OneToOne(fetch=FetchType.LAZY, mappedBy="app", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AppBpm appBpm;
    @Widget(title="Add the application to the App Management")
    private Boolean isInAppView = Boolean.FALSE;
    @OneToOne(fetch=FetchType.LAZY, mappedBy="app", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AppMarketing appMarketing;
    @OneToOne(fetch=FetchType.LAZY, mappedBy="app", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AppSupplierPortal appSupplierPortal;
    @OneToOne(fetch=FetchType.LAZY, mappedBy="app", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AppBusinessSupport appBusinessSupport;
    @OneToOne(fetch=FetchType.LAZY, mappedBy="app", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AppFleet appFleet;
    @OneToOne(fetch=FetchType.LAZY, mappedBy="app", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AppHelpdesk appHelpdesk;
    @OneToOne(fetch=FetchType.LAZY, mappedBy="app", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AppPortal appPortal;
    @OneToOne(fetch=FetchType.LAZY, mappedBy="app", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AppMaintenance appMaintenance;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public App() {
    }

    public App(String name, String code) {
        this.name = name;
        this.code = code;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getModules() {
        return this.modules;
    }

    public void setModules(String modules) {
        this.modules = modules;
    }

    public Set<App> getDependsOnSet() {
        return this.dependsOnSet;
    }

    public void setDependsOnSet(Set<App> dependsOnSet) {
        this.dependsOnSet = dependsOnSet;
    }

    public void addDependsOnSetItem(App item) {
        if (this.getDependsOnSet() == null) {
            this.setDependsOnSet(new HashSet());
        }
        this.getDependsOnSet().add(item);
    }

    public void removeDependsOnSetItem(App item) {
        if (this.getDependsOnSet() == null) {
            return;
        }
        this.getDependsOnSet().remove(item);
    }

    public void clearDependsOnSet() {
        if (this.getDependsOnSet() != null) {
            this.getDependsOnSet().clear();
        }
    }

    public MetaFile getImage() {
        return this.image;
    }

    public void setImage(MetaFile image) {
        this.image = image;
    }

    public Boolean getInitDataLoaded() {
        return this.initDataLoaded == null ? Boolean.FALSE : this.initDataLoaded;
    }

    public void setInitDataLoaded(Boolean initDataLoaded) {
        this.initDataLoaded = initDataLoaded;
    }

    public Boolean getDemoDataLoaded() {
        return this.demoDataLoaded == null ? Boolean.FALSE : this.demoDataLoaded;
    }

    public void setDemoDataLoaded(Boolean demoDataLoaded) {
        this.demoDataLoaded = demoDataLoaded;
    }

    public Boolean getIsRolesImported() {
        return this.isRolesImported == null ? Boolean.FALSE : this.isRolesImported;
    }

    public void setIsRolesImported(Boolean isRolesImported) {
        this.isRolesImported = isRolesImported;
    }

    public Boolean getActive() {
        return this.active == null ? Boolean.FALSE : this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public Integer getSequence() {
        return this.sequence == null ? 0 : this.sequence;
    }

    public void setSequence(Integer sequence) {
        this.sequence = sequence;
    }

    public Integer getInstallOrder() {
        return this.installOrder == null ? 0 : this.installOrder;
    }

    public void setInstallOrder(Integer installOrder) {
        this.installOrder = installOrder;
    }

    public String getLanguageSelect() {
        return this.languageSelect;
    }

    public void setLanguageSelect(String languageSelect) {
        this.languageSelect = languageSelect;
    }

    public List<AccessConfig> getAccessConfigList() {
        return this.accessConfigList;
    }

    public void setAccessConfigList(List<AccessConfig> accessConfigList) {
        this.accessConfigList = accessConfigList;
    }

    public void addAccessConfigListItem(AccessConfig item) {
        if (this.getAccessConfigList() == null) {
            this.setAccessConfigList(new ArrayList());
        }
        this.getAccessConfigList().add(item);
        item.setApp(this);
    }

    public void removeAccessConfigListItem(AccessConfig item) {
        if (this.getAccessConfigList() == null) {
            return;
        }
        this.getAccessConfigList().remove(item);
    }

    public void clearAccessConfigList() {
        if (this.getAccessConfigList() != null) {
            this.getAccessConfigList().clear();
        }
    }

    public Boolean getIsCustom() {
        return this.isCustom == null ? Boolean.FALSE : this.isCustom;
    }

    public void setIsCustom(Boolean isCustom) {
        this.isCustom = isCustom;
    }

    public AppBase getAppBase() {
        return this.appBase;
    }

    public void setAppBase(AppBase appBase) {
        if (this.getAppBase() != null) {
            this.getAppBase().setApp(null);
        }
        if (appBase != null) {
            appBase.setApp(this);
        }
        this.appBase = appBase;
    }

    public AppAccount getAppAccount() {
        return this.appAccount;
    }

    public void setAppAccount(AppAccount appAccount) {
        if (this.getAppAccount() != null) {
            this.getAppAccount().setApp(null);
        }
        if (appAccount != null) {
            appAccount.setApp(this);
        }
        this.appAccount = appAccount;
    }

    public AppInvoice getAppInvoice() {
        return this.appInvoice;
    }

    public void setAppInvoice(AppInvoice appInvoice) {
        if (this.getAppInvoice() != null) {
            this.getAppInvoice().setApp(null);
        }
        if (appInvoice != null) {
            appInvoice.setApp(this);
        }
        this.appInvoice = appInvoice;
    }

    public AppBudget getAppBudget() {
        return this.appBudget;
    }

    public void setAppBudget(AppBudget appBudget) {
        if (this.getAppBudget() != null) {
            this.getAppBudget().setApp(null);
        }
        if (appBudget != null) {
            appBudget.setApp(this);
        }
        this.appBudget = appBudget;
    }

    public AppBankPayment getAppBankPayment() {
        return this.appBankPayment;
    }

    public void setAppBankPayment(AppBankPayment appBankPayment) {
        if (this.getAppBankPayment() != null) {
            this.getAppBankPayment().setApp(null);
        }
        if (appBankPayment != null) {
            appBankPayment.setApp(this);
        }
        this.appBankPayment = appBankPayment;
    }

    public AppProject getAppProject() {
        return this.appProject;
    }

    public void setAppProject(AppProject appProject) {
        if (this.getAppProject() != null) {
            this.getAppProject().setApp(null);
        }
        if (appProject != null) {
            appProject.setApp(this);
        }
        this.appProject = appProject;
    }

    public AppEmployee getAppEmployee() {
        return this.appEmployee;
    }

    public void setAppEmployee(AppEmployee appEmployee) {
        if (this.getAppEmployee() != null) {
            this.getAppEmployee().setApp(null);
        }
        if (appEmployee != null) {
            appEmployee.setApp(this);
        }
        this.appEmployee = appEmployee;
    }

    public AppExpense getAppExpense() {
        return this.appExpense;
    }

    public void setAppExpense(AppExpense appExpense) {
        if (this.getAppExpense() != null) {
            this.getAppExpense().setApp(null);
        }
        if (appExpense != null) {
            appExpense.setApp(this);
        }
        this.appExpense = appExpense;
    }

    public AppExtraHours getAppExthrs() {
        return this.appExthrs;
    }

    public void setAppExthrs(AppExtraHours appExthrs) {
        if (this.getAppExthrs() != null) {
            this.getAppExthrs().setApp(null);
        }
        if (appExthrs != null) {
            appExthrs.setApp(this);
        }
        this.appExthrs = appExthrs;
    }

    public AppLeave getAppLeave() {
        return this.appLeave;
    }

    public void setAppLeave(AppLeave appLeave) {
        if (this.getAppLeave() != null) {
            this.getAppLeave().setApp(null);
        }
        if (appLeave != null) {
            appLeave.setApp(this);
        }
        this.appLeave = appLeave;
    }

    public AppTimesheet getAppTimesheet() {
        return this.appTimesheet;
    }

    public void setAppTimesheet(AppTimesheet appTimesheet) {
        if (this.getAppTimesheet() != null) {
            this.getAppTimesheet().setApp(null);
        }
        if (appTimesheet != null) {
            appTimesheet.setApp(this);
        }
        this.appTimesheet = appTimesheet;
    }

    public AppCrm getAppCrm() {
        return this.appCrm;
    }

    public void setAppCrm(AppCrm appCrm) {
        if (this.getAppCrm() != null) {
            this.getAppCrm().setApp(null);
        }
        if (appCrm != null) {
            appCrm.setApp(this);
        }
        this.appCrm = appCrm;
    }

    public AppSale getAppSale() {
        return this.appSale;
    }

    public void setAppSale(AppSale appSale) {
        if (this.getAppSale() != null) {
            this.getAppSale().setApp(null);
        }
        if (appSale != null) {
            appSale.setApp(this);
        }
        this.appSale = appSale;
    }

    public AppMobile getAppMobile() {
        return this.appMobile;
    }

    public void setAppMobile(AppMobile appMobile) {
        if (this.getAppMobile() != null) {
            this.getAppMobile().setApp(null);
        }
        if (appMobile != null) {
            appMobile.setApp(this);
        }
        this.appMobile = appMobile;
    }

    public AppPurchase getAppPurchase() {
        return this.appPurchase;
    }

    public void setAppPurchase(AppPurchase appPurchase) {
        if (this.getAppPurchase() != null) {
            this.getAppPurchase().setApp(null);
        }
        if (appPurchase != null) {
            appPurchase.setApp(this);
        }
        this.appPurchase = appPurchase;
    }

    public AppPurchaseRequest getAppPurchaseRequest() {
        return this.appPurchaseRequest;
    }

    public void setAppPurchaseRequest(AppPurchaseRequest appPurchaseRequest) {
        if (this.getAppPurchaseRequest() != null) {
            this.getAppPurchaseRequest().setApp(null);
        }
        if (appPurchaseRequest != null) {
            appPurchaseRequest.setApp(this);
        }
        this.appPurchaseRequest = appPurchaseRequest;
    }

    public AppStock getAppStock() {
        return this.appStock;
    }

    public void setAppStock(AppStock appStock) {
        if (this.getAppStock() != null) {
            this.getAppStock().setApp(null);
        }
        if (appStock != null) {
            appStock.setApp(this);
        }
        this.appStock = appStock;
    }

    public AppSupplychain getAppSupplychain() {
        return this.appSupplychain;
    }

    public void setAppSupplychain(AppSupplychain appSupplychain) {
        if (this.getAppSupplychain() != null) {
            this.getAppSupplychain().setApp(null);
        }
        if (appSupplychain != null) {
            appSupplychain.setApp(this);
        }
        this.appSupplychain = appSupplychain;
    }

    public AppContract getAppContract() {
        return this.appContract;
    }

    public void setAppContract(AppContract appContract) {
        if (this.getAppContract() != null) {
            this.getAppContract().setApp(null);
        }
        if (appContract != null) {
            appContract.setApp(this);
        }
        this.appContract = appContract;
    }

    public AppBusinessProject getAppBusinessProject() {
        return this.appBusinessProject;
    }

    public void setAppBusinessProject(AppBusinessProject appBusinessProject) {
        if (this.getAppBusinessProject() != null) {
            this.getAppBusinessProject().setApp(null);
        }
        if (appBusinessProject != null) {
            appBusinessProject.setApp(this);
        }
        this.appBusinessProject = appBusinessProject;
    }

    public AppCashManagement getAppCashManagement() {
        return this.appCashManagement;
    }

    public void setAppCashManagement(AppCashManagement appCashManagement) {
        if (this.getAppCashManagement() != null) {
            this.getAppCashManagement().setApp(null);
        }
        if (appCashManagement != null) {
            appCashManagement.setApp(this);
        }
        this.appCashManagement = appCashManagement;
    }

    public AppAppraisal getAppAppraisal() {
        return this.appAppraisal;
    }

    public void setAppAppraisal(AppAppraisal appAppraisal) {
        if (this.getAppAppraisal() != null) {
            this.getAppAppraisal().setApp(null);
        }
        if (appAppraisal != null) {
            appAppraisal.setApp(this);
        }
        this.appAppraisal = appAppraisal;
    }

    public AppRecruitment getAppRecruitment() {
        return this.appRecruitment;
    }

    public void setAppRecruitment(AppRecruitment appRecruitment) {
        if (this.getAppRecruitment() != null) {
            this.getAppRecruitment().setApp(null);
        }
        if (appRecruitment != null) {
            appRecruitment.setApp(this);
        }
        this.appRecruitment = appRecruitment;
    }

    public AppTraining getAppTraining() {
        return this.appTraining;
    }

    public void setAppTraining(AppTraining appTraining) {
        if (this.getAppTraining() != null) {
            this.getAppTraining().setApp(null);
        }
        if (appTraining != null) {
            appTraining.setApp(this);
        }
        this.appTraining = appTraining;
    }

    public AppProduction getAppProduction() {
        return this.appProduction;
    }

    public void setAppProduction(AppProduction appProduction) {
        if (this.getAppProduction() != null) {
            this.getAppProduction().setApp(null);
        }
        if (appProduction != null) {
            appProduction.setApp(this);
        }
        this.appProduction = appProduction;
    }

    public AppQuality getAppQuality() {
        return this.appQuality;
    }

    public void setAppQuality(AppQuality appQuality) {
        if (this.getAppQuality() != null) {
            this.getAppQuality().setApp(null);
        }
        if (appQuality != null) {
            appQuality.setApp(this);
        }
        this.appQuality = appQuality;
    }

    public AppBpm getAppBpm() {
        return this.appBpm;
    }

    public void setAppBpm(AppBpm appBpm) {
        if (this.getAppBpm() != null) {
            this.getAppBpm().setApp(null);
        }
        if (appBpm != null) {
            appBpm.setApp(this);
        }
        this.appBpm = appBpm;
    }

    public Boolean getIsInAppView() {
        return this.isInAppView == null ? Boolean.FALSE : this.isInAppView;
    }

    public void setIsInAppView(Boolean isInAppView) {
        this.isInAppView = isInAppView;
    }

    public AppMarketing getAppMarketing() {
        return this.appMarketing;
    }

    public void setAppMarketing(AppMarketing appMarketing) {
        if (this.getAppMarketing() != null) {
            this.getAppMarketing().setApp(null);
        }
        if (appMarketing != null) {
            appMarketing.setApp(this);
        }
        this.appMarketing = appMarketing;
    }

    public AppSupplierPortal getAppSupplierPortal() {
        return this.appSupplierPortal;
    }

    public void setAppSupplierPortal(AppSupplierPortal appSupplierPortal) {
        if (this.getAppSupplierPortal() != null) {
            this.getAppSupplierPortal().setApp(null);
        }
        if (appSupplierPortal != null) {
            appSupplierPortal.setApp(this);
        }
        this.appSupplierPortal = appSupplierPortal;
    }

    public AppBusinessSupport getAppBusinessSupport() {
        return this.appBusinessSupport;
    }

    public void setAppBusinessSupport(AppBusinessSupport appBusinessSupport) {
        if (this.getAppBusinessSupport() != null) {
            this.getAppBusinessSupport().setApp(null);
        }
        if (appBusinessSupport != null) {
            appBusinessSupport.setApp(this);
        }
        this.appBusinessSupport = appBusinessSupport;
    }

    public AppFleet getAppFleet() {
        return this.appFleet;
    }

    public void setAppFleet(AppFleet appFleet) {
        if (this.getAppFleet() != null) {
            this.getAppFleet().setApp(null);
        }
        if (appFleet != null) {
            appFleet.setApp(this);
        }
        this.appFleet = appFleet;
    }

    public AppHelpdesk getAppHelpdesk() {
        return this.appHelpdesk;
    }

    public void setAppHelpdesk(AppHelpdesk appHelpdesk) {
        if (this.getAppHelpdesk() != null) {
            this.getAppHelpdesk().setApp(null);
        }
        if (appHelpdesk != null) {
            appHelpdesk.setApp(this);
        }
        this.appHelpdesk = appHelpdesk;
    }

    public AppPortal getAppPortal() {
        return this.appPortal;
    }

    public void setAppPortal(AppPortal appPortal) {
        if (this.getAppPortal() != null) {
            this.getAppPortal().setApp(null);
        }
        if (appPortal != null) {
            appPortal.setApp(this);
        }
        this.appPortal = appPortal;
    }

    public AppMaintenance getAppMaintenance() {
        return this.appMaintenance;
    }

    public void setAppMaintenance(AppMaintenance appMaintenance) {
        if (this.getAppMaintenance() != null) {
            this.getAppMaintenance().setApp(null);
        }
        if (appMaintenance != null) {
            appMaintenance.setApp(this);
        }
        this.appMaintenance = appMaintenance;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof App)) {
            return false;
        }
        App other = (App)obj;
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return Objects.equals(this.getCode(), other.getCode()) && this.getCode() != null;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("code", (Object)this.getCode()).add("modules", (Object)this.getModules()).add("initDataLoaded", (Object)this.getInitDataLoaded()).add("demoDataLoaded", (Object)this.getDemoDataLoaded()).add("isRolesImported", (Object)this.getIsRolesImported()).add("active", (Object)this.getActive()).add("sequence", (Object)this.getSequence()).add("installOrder", (Object)this.getInstallOrder()).add("languageSelect", (Object)this.getLanguageSelect()).add("isCustom", (Object)this.getIsCustom()).omitNullValues().toString();
    }
}

