/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.apps.account.db.Account;
import com.axelor.apps.account.db.AnalyticDistributionTemplate;
import com.axelor.apps.account.db.FixedAssetCategory;
import com.axelor.apps.account.db.InterbankCodeLine;
import com.axelor.apps.account.db.Journal;
import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.account.db.Tax;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.ProductFamily;
import com.axelor.apps.base.db.Sequence;
import com.axelor.apps.message.db.Template;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.VirtualColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Table(name="ACCOUNT_ACCOUNT_MANAGEMENT", uniqueConstraints={@UniqueConstraint(columnNames={"interbank_code_line", "bank_details", "payment_mode"}), @UniqueConstraint(columnNames={"payment_mode", "bank_details", "company"})}, indexes={@Index(columnList="company"), @Index(columnList="purchase_tax"), @Index(columnList="sale_tax"), @Index(columnList="tax"), @Index(columnList="product"), @Index(columnList="product_family"), @Index(columnList="purchase_account"), @Index(columnList="sale_account"), @Index(columnList="cash_account"), @Index(columnList="purch_fixed_assets_account"), @Index(columnList="payment_mode"), @Index(columnList="journal"), @Index(columnList="sequence"), @Index(columnList="bank_details"), @Index(columnList="analytic_distribution_template"), @Index(columnList="fixed_asset_category"), @Index(columnList="interbank_code_line"), @Index(columnList="global_accounting_cash_account"), @Index(columnList="cheque_deposit_journal"), @Index(columnList="pmt_notification_template"), @Index(columnList="purch_vat_regulation_account"), @Index(columnList="sale_vat_regulation_account"), @Index(columnList="purchase_tax_vat_system1account"), @Index(columnList="purchase_tax_vat_system2account"), @Index(columnList="purch_fixed_assets_tax_vat_system1account"), @Index(columnList="purch_fixed_assets_tax_vat_system2account"), @Index(columnList="sale_tax_vat_system1account"), @Index(columnList="sale_tax_vat_system2account"), @Index(columnList="allowed_fin_discount_tax_vat_system1account"), @Index(columnList="allowed_fin_discount_tax_vat_system2account"), @Index(columnList="obtained_fin_discount_tax_vat_system1account"), @Index(columnList="obtained_fin_discount_tax_vat_system2account"), @Index(columnList="name")})
public class AccountManagement
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_ACCOUNT_MANAGEMENT_SEQ")
    @SequenceGenerator(name="ACCOUNT_ACCOUNT_MANAGEMENT_SEQ", sequenceName="ACCOUNT_ACCOUNT_MANAGEMENT_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Type", selection="account.management.type.select")
    @NotNull
    private Integer typeSelect = 0;
    @Widget(title="Company")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Purchase Tax")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Tax purchaseTax;
    @Widget(title="Sale Tax")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Tax saleTax;
    @Widget(title="Tax")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Tax tax;
    @Widget(title="Product")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Product product;
    @Widget(title="Accounting family")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ProductFamily productFamily;
    @Widget(title="Purchase account")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Account purchaseAccount;
    @Widget(title="Sale account")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Account saleAccount;
    @Widget(title="Payment account")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Account cashAccount;
    @Widget(title="Account of purchase fixed assets")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Account purchFixedAssetsAccount;
    @Widget(title="Payment mode")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PaymentMode paymentMode;
    @Widget(title="Journal")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Journal journal;
    @Widget(title="Sequence")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Sequence sequence;
    @Widget(title="Bank details")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private BankDetails bankDetails;
    @Widget(title="Analytic distribution template")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AnalyticDistributionTemplate analyticDistributionTemplate;
    @Widget(title="Fixed asset category")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private FixedAssetCategory fixedAssetCategory;
    @Widget(title="Interbank code")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private InterbankCodeLine interbankCodeLine;
    @Widget(title="Global Accounting account")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Account globalAccountingCashAccount;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Journal chequeDepositJournal;
    @Widget(title="Email model for payment notice")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Template pmtNotificationTemplate;
    @Widget(title="VAT Regularization account on purchase")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Account purchVatRegulationAccount;
    @Widget(title="VAT Regularization account on sale")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Account saleVatRegulationAccount;
    @Widget(title="Purchase account on deliveries/invoice", help="Account settings which will be used when generating accounting tax move lines depending on the VAT System accounting setting on the financial account and the partner VAT System in the accountingSituation by company.")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Account purchaseTaxVatSystem1Account;
    @Widget(title="Purchase account on payments", help="Account settings which will be used when generating accounting tax move lines depending on the VAT System accounting setting on the financial account and the partner VAT System in the accountingSituation by company.")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Account purchaseTaxVatSystem2Account;
    @Widget(title="Purchase account for fixed assets on deliveries/invoice", help="Account settings which will be used when generating accounting tax move lines depending on the VAT System accounting setting on the financial account and the partner VAT System in the accountingSituation by company.")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Account purchFixedAssetsTaxVatSystem1Account;
    @Widget(title="Purchase account for fixed assets on payments", help="Account settings which will be used when generating accounting tax move lines depending on the VAT System accounting setting on the financial account and the partner VAT System in the accountingSituation by company.")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Account purchFixedAssetsTaxVatSystem2Account;
    @Widget(title="Sale account on deliveries/invoice", help="Account settings which will be used when generating accounting tax move lines depending on the VAT System accounting setting on the financial account and the partner VAT System in the accountingSituation by company.")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Account saleTaxVatSystem1Account;
    @Widget(title="Sale account on payments", help="Account settings which will be used when generating accounting tax move lines depending on the VAT System accounting setting on the financial account and the partner VAT System in the accountingSituation by company.")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Account saleTaxVatSystem2Account;
    @Widget(title="Allowed Financial discount account on deliveries/invoice", help="Account settings which will be used when generating accounting tax move lines depending on the VAT System accounting setting on the financial account and the partner VAT System in the accountingSituation by company.")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Account allowedFinDiscountTaxVatSystem1Account;
    @Widget(title="Allowed Financial discount account on payments", help="Account settings which will be used when generating accounting tax move lines depending on the VAT System accounting setting on the financial account and the partner VAT System in the accountingSituation by company.")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Account allowedFinDiscountTaxVatSystem2Account;
    @Widget(title="Obtained Financial discount account on deliveries/invoice", help="Account settings which will be used when generating accounting tax move lines depending on the VAT System accounting setting on the financial account and the partner VAT System in the accountingSituation by company.")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Account obtainedFinDiscountTaxVatSystem1Account;
    @Widget(title="Obtained financial discount account on payments", help="Account settings which will be used when generating accounting tax move lines depending on the VAT System accounting setting on the financial account and the partner VAT System in the accountingSituation by company.")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Account obtainedFinDiscountTaxVatSystem2Account;
    @VirtualColumn
    @Access(value=AccessType.PROPERTY)
    private String name;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public AccountManagement() {
    }

    public AccountManagement(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getTypeSelect() {
        return this.typeSelect == null ? 0 : this.typeSelect;
    }

    public void setTypeSelect(Integer typeSelect) {
        this.typeSelect = typeSelect;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public Tax getPurchaseTax() {
        return this.purchaseTax;
    }

    public void setPurchaseTax(Tax purchaseTax) {
        this.purchaseTax = purchaseTax;
    }

    public Tax getSaleTax() {
        return this.saleTax;
    }

    public void setSaleTax(Tax saleTax) {
        this.saleTax = saleTax;
    }

    public Tax getTax() {
        return this.tax;
    }

    public void setTax(Tax tax) {
        this.tax = tax;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public ProductFamily getProductFamily() {
        return this.productFamily;
    }

    public void setProductFamily(ProductFamily productFamily) {
        this.productFamily = productFamily;
    }

    public Account getPurchaseAccount() {
        return this.purchaseAccount;
    }

    public void setPurchaseAccount(Account purchaseAccount) {
        this.purchaseAccount = purchaseAccount;
    }

    public Account getSaleAccount() {
        return this.saleAccount;
    }

    public void setSaleAccount(Account saleAccount) {
        this.saleAccount = saleAccount;
    }

    public Account getCashAccount() {
        return this.cashAccount;
    }

    public void setCashAccount(Account cashAccount) {
        this.cashAccount = cashAccount;
    }

    public Account getPurchFixedAssetsAccount() {
        return this.purchFixedAssetsAccount;
    }

    public void setPurchFixedAssetsAccount(Account purchFixedAssetsAccount) {
        this.purchFixedAssetsAccount = purchFixedAssetsAccount;
    }

    public PaymentMode getPaymentMode() {
        return this.paymentMode;
    }

    public void setPaymentMode(PaymentMode paymentMode) {
        this.paymentMode = paymentMode;
    }

    public Journal getJournal() {
        return this.journal;
    }

    public void setJournal(Journal journal) {
        this.journal = journal;
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    public void setSequence(Sequence sequence) {
        this.sequence = sequence;
    }

    public BankDetails getBankDetails() {
        return this.bankDetails;
    }

    public void setBankDetails(BankDetails bankDetails) {
        this.bankDetails = bankDetails;
    }

    public AnalyticDistributionTemplate getAnalyticDistributionTemplate() {
        return this.analyticDistributionTemplate;
    }

    public void setAnalyticDistributionTemplate(AnalyticDistributionTemplate analyticDistributionTemplate) {
        this.analyticDistributionTemplate = analyticDistributionTemplate;
    }

    public FixedAssetCategory getFixedAssetCategory() {
        return this.fixedAssetCategory;
    }

    public void setFixedAssetCategory(FixedAssetCategory fixedAssetCategory) {
        this.fixedAssetCategory = fixedAssetCategory;
    }

    public InterbankCodeLine getInterbankCodeLine() {
        return this.interbankCodeLine;
    }

    public void setInterbankCodeLine(InterbankCodeLine interbankCodeLine) {
        this.interbankCodeLine = interbankCodeLine;
    }

    public Account getGlobalAccountingCashAccount() {
        return this.globalAccountingCashAccount;
    }

    public void setGlobalAccountingCashAccount(Account globalAccountingCashAccount) {
        this.globalAccountingCashAccount = globalAccountingCashAccount;
    }

    public Journal getChequeDepositJournal() {
        return this.chequeDepositJournal;
    }

    public void setChequeDepositJournal(Journal chequeDepositJournal) {
        this.chequeDepositJournal = chequeDepositJournal;
    }

    public Template getPmtNotificationTemplate() {
        return this.pmtNotificationTemplate;
    }

    public void setPmtNotificationTemplate(Template pmtNotificationTemplate) {
        this.pmtNotificationTemplate = pmtNotificationTemplate;
    }

    public Account getPurchVatRegulationAccount() {
        return this.purchVatRegulationAccount;
    }

    public void setPurchVatRegulationAccount(Account purchVatRegulationAccount) {
        this.purchVatRegulationAccount = purchVatRegulationAccount;
    }

    public Account getSaleVatRegulationAccount() {
        return this.saleVatRegulationAccount;
    }

    public void setSaleVatRegulationAccount(Account saleVatRegulationAccount) {
        this.saleVatRegulationAccount = saleVatRegulationAccount;
    }

    public Account getPurchaseTaxVatSystem1Account() {
        return this.purchaseTaxVatSystem1Account;
    }

    public void setPurchaseTaxVatSystem1Account(Account purchaseTaxVatSystem1Account) {
        this.purchaseTaxVatSystem1Account = purchaseTaxVatSystem1Account;
    }

    public Account getPurchaseTaxVatSystem2Account() {
        return this.purchaseTaxVatSystem2Account;
    }

    public void setPurchaseTaxVatSystem2Account(Account purchaseTaxVatSystem2Account) {
        this.purchaseTaxVatSystem2Account = purchaseTaxVatSystem2Account;
    }

    public Account getPurchFixedAssetsTaxVatSystem1Account() {
        return this.purchFixedAssetsTaxVatSystem1Account;
    }

    public void setPurchFixedAssetsTaxVatSystem1Account(Account purchFixedAssetsTaxVatSystem1Account) {
        this.purchFixedAssetsTaxVatSystem1Account = purchFixedAssetsTaxVatSystem1Account;
    }

    public Account getPurchFixedAssetsTaxVatSystem2Account() {
        return this.purchFixedAssetsTaxVatSystem2Account;
    }

    public void setPurchFixedAssetsTaxVatSystem2Account(Account purchFixedAssetsTaxVatSystem2Account) {
        this.purchFixedAssetsTaxVatSystem2Account = purchFixedAssetsTaxVatSystem2Account;
    }

    public Account getSaleTaxVatSystem1Account() {
        return this.saleTaxVatSystem1Account;
    }

    public void setSaleTaxVatSystem1Account(Account saleTaxVatSystem1Account) {
        this.saleTaxVatSystem1Account = saleTaxVatSystem1Account;
    }

    public Account getSaleTaxVatSystem2Account() {
        return this.saleTaxVatSystem2Account;
    }

    public void setSaleTaxVatSystem2Account(Account saleTaxVatSystem2Account) {
        this.saleTaxVatSystem2Account = saleTaxVatSystem2Account;
    }

    public Account getAllowedFinDiscountTaxVatSystem1Account() {
        return this.allowedFinDiscountTaxVatSystem1Account;
    }

    public void setAllowedFinDiscountTaxVatSystem1Account(Account allowedFinDiscountTaxVatSystem1Account) {
        this.allowedFinDiscountTaxVatSystem1Account = allowedFinDiscountTaxVatSystem1Account;
    }

    public Account getAllowedFinDiscountTaxVatSystem2Account() {
        return this.allowedFinDiscountTaxVatSystem2Account;
    }

    public void setAllowedFinDiscountTaxVatSystem2Account(Account allowedFinDiscountTaxVatSystem2Account) {
        this.allowedFinDiscountTaxVatSystem2Account = allowedFinDiscountTaxVatSystem2Account;
    }

    public Account getObtainedFinDiscountTaxVatSystem1Account() {
        return this.obtainedFinDiscountTaxVatSystem1Account;
    }

    public void setObtainedFinDiscountTaxVatSystem1Account(Account obtainedFinDiscountTaxVatSystem1Account) {
        this.obtainedFinDiscountTaxVatSystem1Account = obtainedFinDiscountTaxVatSystem1Account;
    }

    public Account getObtainedFinDiscountTaxVatSystem2Account() {
        return this.obtainedFinDiscountTaxVatSystem2Account;
    }

    public void setObtainedFinDiscountTaxVatSystem2Account(Account obtainedFinDiscountTaxVatSystem2Account) {
        this.obtainedFinDiscountTaxVatSystem2Account = obtainedFinDiscountTaxVatSystem2Account;
    }

    public String getName() {
        try {
            this.name = this.computeName();
        }
        catch (NullPointerException e) {
            Logger logger = LoggerFactory.getLogger(this.getClass());
            logger.error("NPE in function field: getName()", (Throwable)e);
        }
        return this.name;
    }

    protected String computeName() {
        String name = "";
        if (this.company != null) {
            name = name + (name.isEmpty() ? "" : "-") + this.company.getName();
        }
        if (this.paymentMode != null) {
            name = name + (name.isEmpty() ? "" : "-") + this.paymentMode.getName();
        }
        if (this.interbankCodeLine != null) {
            name = name + (name.isEmpty() ? "" : "-") + this.interbankCodeLine.getName();
        }
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AccountManagement)) {
            return false;
        }
        AccountManagement other = (AccountManagement)obj;
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("typeSelect", (Object)this.getTypeSelect()).omitNullValues().toString();
    }
}

