/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.apps.account.db.FinancialDiscount;
import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoiceTermPayment;
import com.axelor.apps.account.db.Move;
import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.account.db.PaymentSession;
import com.axelor.apps.account.db.Reconcile;
import com.axelor.apps.bankpayment.db.BankOrder;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.Currency;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="ACCOUNT_INVOICE_PAYMENT", indexes={@Index(columnList="currency"), @Index(columnList="payment_mode"), @Index(name="idx_account_inv_payment_move", columnList="move"), @Index(columnList="invoice"), @Index(columnList="company_bank_details"), @Index(columnList="payment_session"), @Index(columnList="imputed_by"), @Index(columnList="financial_discount"), @Index(columnList="bank_order")})
public class InvoicePayment
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_INVOICE_PAYMENT_SEQ")
    @SequenceGenerator(name="ACCOUNT_INVOICE_PAYMENT_SEQ", sequenceName="ACCOUNT_INVOICE_PAYMENT_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Paid amount")
    @NotNull
    @DecimalMin(value="0")
    private BigDecimal amount = new BigDecimal("0");
    @Widget(title="Date")
    @NotNull
    private LocalDate paymentDate;
    @Widget(title="Delay reason")
    private String delayReason;
    @Widget(title="Currency")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Currency currency;
    @Widget(title="Payment mode")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PaymentMode paymentMode;
    @Widget(title="Date of bank deposit")
    private LocalDate bankDepositDate;
    @Widget(title="Cheque number")
    private String chequeNumber;
    @Widget(title="Move", readonly=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Move move;
    @Widget(title="Reconciliations", readonly=true)
    @OneToMany(fetch=FetchType.LAZY, mappedBy="invoicePayment", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<Reconcile> reconcileList;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Invoice invoice;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private BankDetails companyBankDetails;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PaymentSession paymentSession;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private InvoicePayment imputedBy;
    @Widget(title="Type", selection="invoice.payment.type.select")
    private Integer typeSelect = 0;
    @Widget(title="Status", readonly=true, selection="invoice.payment.status.select")
    private Integer statusSelect = 0;
    @Widget(title="Reference")
    private String invoicePaymentRef;
    @Widget(title="Description")
    private String description;
    private Boolean manualChange = Boolean.FALSE;
    @Widget(title="Apply Financial Discount ?", readonly=true)
    private Boolean applyFinancialDiscount = Boolean.FALSE;
    @Widget(title="Financial discount")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private FinancialDiscount financialDiscount;
    @Widget(title="Fin. Discount Deadline Date")
    private LocalDate financialDiscountDeadlineDate;
    @Widget(title="Fin. Discount Amount")
    private BigDecimal financialDiscountAmount = BigDecimal.ZERO;
    @Widget(title="Fin. Discount Tax")
    private BigDecimal financialDiscountTaxAmount = BigDecimal.ZERO;
    @Widget(title="Fin. Discount Total Amount")
    private BigDecimal financialDiscountTotalAmount = BigDecimal.ZERO;
    @Widget(title="Total amount with financial discount")
    private BigDecimal totalAmountWithFinancialDiscount = BigDecimal.ZERO;
    @Widget(title="Invoice term payments")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="invoicePayment", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<InvoiceTermPayment> invoiceTermPaymentList;
    @Widget(title="Bank Order", readonly=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private BankOrder bankOrder;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public InvoicePayment() {
    }

    public InvoicePayment(BigDecimal amount, LocalDate paymentDate, Currency currency, PaymentMode paymentMode, Invoice invoice, Integer typeSelect, Integer statusSelect) {
        this.amount = amount;
        this.paymentDate = paymentDate;
        this.currency = currency;
        this.paymentMode = paymentMode;
        this.invoice = invoice;
        this.typeSelect = typeSelect;
        this.statusSelect = statusSelect;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public BigDecimal getAmount() {
        return this.amount == null ? BigDecimal.ZERO : this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public LocalDate getPaymentDate() {
        return this.paymentDate;
    }

    public void setPaymentDate(LocalDate paymentDate) {
        this.paymentDate = paymentDate;
    }

    public String getDelayReason() {
        return this.delayReason;
    }

    public void setDelayReason(String delayReason) {
        this.delayReason = delayReason;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public PaymentMode getPaymentMode() {
        return this.paymentMode;
    }

    public void setPaymentMode(PaymentMode paymentMode) {
        this.paymentMode = paymentMode;
    }

    public LocalDate getBankDepositDate() {
        return this.bankDepositDate;
    }

    public void setBankDepositDate(LocalDate bankDepositDate) {
        this.bankDepositDate = bankDepositDate;
    }

    public String getChequeNumber() {
        return this.chequeNumber;
    }

    public void setChequeNumber(String chequeNumber) {
        this.chequeNumber = chequeNumber;
    }

    public Move getMove() {
        return this.move;
    }

    public void setMove(Move move) {
        this.move = move;
    }

    public List<Reconcile> getReconcileList() {
        return this.reconcileList;
    }

    public void setReconcileList(List<Reconcile> reconcileList) {
        this.reconcileList = reconcileList;
    }

    public void addReconcileListItem(Reconcile item) {
        if (this.getReconcileList() == null) {
            this.setReconcileList(new ArrayList());
        }
        this.getReconcileList().add(item);
        item.setInvoicePayment(this);
    }

    public void removeReconcileListItem(Reconcile item) {
        if (this.getReconcileList() == null) {
            return;
        }
        this.getReconcileList().remove(item);
    }

    public void clearReconcileList() {
        if (this.getReconcileList() != null) {
            this.getReconcileList().clear();
        }
    }

    public Invoice getInvoice() {
        return this.invoice;
    }

    public void setInvoice(Invoice invoice) {
        this.invoice = invoice;
    }

    public BankDetails getCompanyBankDetails() {
        return this.companyBankDetails;
    }

    public void setCompanyBankDetails(BankDetails companyBankDetails) {
        this.companyBankDetails = companyBankDetails;
    }

    public PaymentSession getPaymentSession() {
        return this.paymentSession;
    }

    public void setPaymentSession(PaymentSession paymentSession) {
        this.paymentSession = paymentSession;
    }

    public InvoicePayment getImputedBy() {
        return this.imputedBy;
    }

    public void setImputedBy(InvoicePayment imputedBy) {
        this.imputedBy = imputedBy;
    }

    public Integer getTypeSelect() {
        return this.typeSelect == null ? 0 : this.typeSelect;
    }

    public void setTypeSelect(Integer typeSelect) {
        this.typeSelect = typeSelect;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public String getInvoicePaymentRef() {
        return this.invoicePaymentRef;
    }

    public void setInvoicePaymentRef(String invoicePaymentRef) {
        this.invoicePaymentRef = invoicePaymentRef;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Boolean getManualChange() {
        return this.manualChange == null ? Boolean.FALSE : this.manualChange;
    }

    public void setManualChange(Boolean manualChange) {
        this.manualChange = manualChange;
    }

    public Boolean getApplyFinancialDiscount() {
        return this.applyFinancialDiscount == null ? Boolean.FALSE : this.applyFinancialDiscount;
    }

    public void setApplyFinancialDiscount(Boolean applyFinancialDiscount) {
        this.applyFinancialDiscount = applyFinancialDiscount;
    }

    public FinancialDiscount getFinancialDiscount() {
        return this.financialDiscount;
    }

    public void setFinancialDiscount(FinancialDiscount financialDiscount) {
        this.financialDiscount = financialDiscount;
    }

    public LocalDate getFinancialDiscountDeadlineDate() {
        return this.financialDiscountDeadlineDate;
    }

    public void setFinancialDiscountDeadlineDate(LocalDate financialDiscountDeadlineDate) {
        this.financialDiscountDeadlineDate = financialDiscountDeadlineDate;
    }

    public BigDecimal getFinancialDiscountAmount() {
        return this.financialDiscountAmount == null ? BigDecimal.ZERO : this.financialDiscountAmount;
    }

    public void setFinancialDiscountAmount(BigDecimal financialDiscountAmount) {
        this.financialDiscountAmount = financialDiscountAmount;
    }

    public BigDecimal getFinancialDiscountTaxAmount() {
        return this.financialDiscountTaxAmount == null ? BigDecimal.ZERO : this.financialDiscountTaxAmount;
    }

    public void setFinancialDiscountTaxAmount(BigDecimal financialDiscountTaxAmount) {
        this.financialDiscountTaxAmount = financialDiscountTaxAmount;
    }

    public BigDecimal getFinancialDiscountTotalAmount() {
        return this.financialDiscountTotalAmount == null ? BigDecimal.ZERO : this.financialDiscountTotalAmount;
    }

    public void setFinancialDiscountTotalAmount(BigDecimal financialDiscountTotalAmount) {
        this.financialDiscountTotalAmount = financialDiscountTotalAmount;
    }

    public BigDecimal getTotalAmountWithFinancialDiscount() {
        return this.totalAmountWithFinancialDiscount == null ? BigDecimal.ZERO : this.totalAmountWithFinancialDiscount;
    }

    public void setTotalAmountWithFinancialDiscount(BigDecimal totalAmountWithFinancialDiscount) {
        this.totalAmountWithFinancialDiscount = totalAmountWithFinancialDiscount;
    }

    public List<InvoiceTermPayment> getInvoiceTermPaymentList() {
        return this.invoiceTermPaymentList;
    }

    public void setInvoiceTermPaymentList(List<InvoiceTermPayment> invoiceTermPaymentList) {
        this.invoiceTermPaymentList = invoiceTermPaymentList;
    }

    public void addInvoiceTermPaymentListItem(InvoiceTermPayment item) {
        if (this.getInvoiceTermPaymentList() == null) {
            this.setInvoiceTermPaymentList(new ArrayList());
        }
        this.getInvoiceTermPaymentList().add(item);
        item.setInvoicePayment(this);
    }

    public void removeInvoiceTermPaymentListItem(InvoiceTermPayment item) {
        if (this.getInvoiceTermPaymentList() == null) {
            return;
        }
        this.getInvoiceTermPaymentList().remove(item);
    }

    public void clearInvoiceTermPaymentList() {
        if (this.getInvoiceTermPaymentList() != null) {
            this.getInvoiceTermPaymentList().clear();
        }
    }

    public BankOrder getBankOrder() {
        return this.bankOrder;
    }

    public void setBankOrder(BankOrder bankOrder) {
        this.bankOrder = bankOrder;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof InvoicePayment)) {
            return false;
        }
        InvoicePayment other = (InvoicePayment)obj;
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("amount", (Object)this.getAmount()).add("paymentDate", (Object)this.getPaymentDate()).add("delayReason", (Object)this.getDelayReason()).add("bankDepositDate", (Object)this.getBankDepositDate()).add("chequeNumber", (Object)this.getChequeNumber()).add("typeSelect", (Object)this.getTypeSelect()).add("statusSelect", (Object)this.getStatusSelect()).add("invoicePaymentRef", (Object)this.getInvoicePaymentRef()).add("description", (Object)this.getDescription()).add("manualChange", (Object)this.getManualChange()).add("applyFinancialDiscount", (Object)this.getApplyFinancialDiscount()).omitNullValues().toString();
    }
}

