/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.apps.account.db.AccountManagement;
import com.axelor.apps.account.db.TaxLine;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.EqualsInclude;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="ACCOUNT_TAX", uniqueConstraints={@UniqueConstraint(columnNames={"code", "name"})}, indexes={@Index(columnList="name"), @Index(columnList="active_tax_line")})
public class Tax
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_TAX_SEQ")
    @SequenceGenerator(name="ACCOUNT_TAX_SEQ", sequenceName="ACCOUNT_TAX_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Name")
    @NotNull
    private String name;
    @EqualsInclude
    @Widget(title="Code")
    @NotNull
    @Column(unique=true)
    private String code;
    @Widget(title="Tax active version")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private TaxLine activeTaxLine;
    @Widget(title="Tax versions history")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="tax", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<TaxLine> taxLineList;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="tax", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<AccountManagement> accountManagementList;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Tax() {
    }

    public Tax(String name, String code) {
        this.name = name;
        this.code = code;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public TaxLine getActiveTaxLine() {
        return this.activeTaxLine;
    }

    public void setActiveTaxLine(TaxLine activeTaxLine) {
        this.activeTaxLine = activeTaxLine;
    }

    public List<TaxLine> getTaxLineList() {
        return this.taxLineList;
    }

    public void setTaxLineList(List<TaxLine> taxLineList) {
        this.taxLineList = taxLineList;
    }

    public void addTaxLineListItem(TaxLine item) {
        if (this.getTaxLineList() == null) {
            this.setTaxLineList(new ArrayList());
        }
        this.getTaxLineList().add(item);
        item.setTax(this);
    }

    public void removeTaxLineListItem(TaxLine item) {
        if (this.getTaxLineList() == null) {
            return;
        }
        this.getTaxLineList().remove(item);
    }

    public void clearTaxLineList() {
        if (this.getTaxLineList() != null) {
            this.getTaxLineList().clear();
        }
    }

    public List<AccountManagement> getAccountManagementList() {
        return this.accountManagementList;
    }

    public void setAccountManagementList(List<AccountManagement> accountManagementList) {
        this.accountManagementList = accountManagementList;
    }

    public void addAccountManagementListItem(AccountManagement item) {
        if (this.getAccountManagementList() == null) {
            this.setAccountManagementList(new ArrayList());
        }
        this.getAccountManagementList().add(item);
        item.setTax(this);
    }

    public void removeAccountManagementListItem(AccountManagement item) {
        if (this.getAccountManagementList() == null) {
            return;
        }
        this.getAccountManagementList().remove(item);
    }

    public void clearAccountManagementList() {
        if (this.getAccountManagementList() != null) {
            this.getAccountManagementList().clear();
        }
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Tax)) {
            return false;
        }
        Tax other = (Tax)obj;
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return Objects.equals(this.getCode(), other.getCode()) && this.getCode() != null;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("code", (Object)this.getCode()).omitNullValues().toString();
    }
}

