/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.stock.db;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Period;
import com.axelor.apps.base.db.Product;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.Digits;
import org.hibernate.annotations.Type;

@Entity
@Table(name="STOCK_STOCK_HISTORY_LINE", uniqueConstraints={@UniqueConstraint(columnNames={"product", "company", "label"})}, indexes={@Index(columnList="product"), @Index(columnList="company"), @Index(columnList="period")})
public class StockHistoryLine
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="STOCK_STOCK_HISTORY_LINE_SEQ")
    @SequenceGenerator(name="STOCK_STOCK_HISTORY_LINE_SEQ", sequenceName="STOCK_STOCK_HISTORY_LINE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Nbr of incoming moves", readonly=true)
    private Integer countIncMvtStockPeriod = 0;
    @Widget(title="Incoming quantity", readonly=true)
    @Digits(integer=10, fraction=10)
    private BigDecimal sumIncQtyPeriod = BigDecimal.ZERO;
    @Widget(title="Incoming amount", readonly=true)
    private BigDecimal priceIncStockMovePeriod = BigDecimal.ZERO;
    @Widget(title="Nbr of outgoing moves", readonly=true)
    private Integer countOutMvtStockPeriod = 0;
    @Widget(title="Outgoing amount", readonly=true)
    private BigDecimal priceOutStockMovePeriod = BigDecimal.ZERO;
    @Widget(readonly=true)
    private String label;
    @Widget(title="Product")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Product product;
    @Widget(title="Avg outgoing quantity on 12 past months (One-off sale excluded)")
    private BigDecimal avgOutQtyOn12PastMonth = BigDecimal.ZERO;
    @Widget(title="Company")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Period")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Period period;
    @Widget(title="One-off sale outgoing quantity", readonly=true)
    @Digits(integer=10, fraction=10)
    private BigDecimal sumOneoffSaleOutQtyPeriod = BigDecimal.ZERO;
    @Widget(title="Outgoing quantity (One-off sale excluded)", readonly=true)
    @Digits(integer=10, fraction=10)
    private BigDecimal sumOutQtyPeriod = BigDecimal.ZERO;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getCountIncMvtStockPeriod() {
        return this.countIncMvtStockPeriod == null ? 0 : this.countIncMvtStockPeriod;
    }

    public void setCountIncMvtStockPeriod(Integer countIncMvtStockPeriod) {
        this.countIncMvtStockPeriod = countIncMvtStockPeriod;
    }

    public BigDecimal getSumIncQtyPeriod() {
        return this.sumIncQtyPeriod == null ? BigDecimal.ZERO : this.sumIncQtyPeriod;
    }

    public void setSumIncQtyPeriod(BigDecimal sumIncQtyPeriod) {
        this.sumIncQtyPeriod = sumIncQtyPeriod;
    }

    public BigDecimal getPriceIncStockMovePeriod() {
        return this.priceIncStockMovePeriod == null ? BigDecimal.ZERO : this.priceIncStockMovePeriod;
    }

    public void setPriceIncStockMovePeriod(BigDecimal priceIncStockMovePeriod) {
        this.priceIncStockMovePeriod = priceIncStockMovePeriod;
    }

    public Integer getCountOutMvtStockPeriod() {
        return this.countOutMvtStockPeriod == null ? 0 : this.countOutMvtStockPeriod;
    }

    public void setCountOutMvtStockPeriod(Integer countOutMvtStockPeriod) {
        this.countOutMvtStockPeriod = countOutMvtStockPeriod;
    }

    public BigDecimal getPriceOutStockMovePeriod() {
        return this.priceOutStockMovePeriod == null ? BigDecimal.ZERO : this.priceOutStockMovePeriod;
    }

    public void setPriceOutStockMovePeriod(BigDecimal priceOutStockMovePeriod) {
        this.priceOutStockMovePeriod = priceOutStockMovePeriod;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public BigDecimal getAvgOutQtyOn12PastMonth() {
        return this.avgOutQtyOn12PastMonth == null ? BigDecimal.ZERO : this.avgOutQtyOn12PastMonth;
    }

    public void setAvgOutQtyOn12PastMonth(BigDecimal avgOutQtyOn12PastMonth) {
        this.avgOutQtyOn12PastMonth = avgOutQtyOn12PastMonth;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public Period getPeriod() {
        return this.period;
    }

    public void setPeriod(Period period) {
        this.period = period;
    }

    public BigDecimal getSumOneoffSaleOutQtyPeriod() {
        return this.sumOneoffSaleOutQtyPeriod == null ? BigDecimal.ZERO : this.sumOneoffSaleOutQtyPeriod;
    }

    public void setSumOneoffSaleOutQtyPeriod(BigDecimal sumOneoffSaleOutQtyPeriod) {
        this.sumOneoffSaleOutQtyPeriod = sumOneoffSaleOutQtyPeriod;
    }

    public BigDecimal getSumOutQtyPeriod() {
        return this.sumOutQtyPeriod == null ? BigDecimal.ZERO : this.sumOutQtyPeriod;
    }

    public void setSumOutQtyPeriod(BigDecimal sumOutQtyPeriod) {
        this.sumOutQtyPeriod = sumOutQtyPeriod;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StockHistoryLine)) {
            return false;
        }
        StockHistoryLine other = (StockHistoryLine)obj;
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("countIncMvtStockPeriod", (Object)this.getCountIncMvtStockPeriod()).add("sumIncQtyPeriod", (Object)this.getSumIncQtyPeriod()).add("priceIncStockMovePeriod", (Object)this.getPriceIncStockMovePeriod()).add("countOutMvtStockPeriod", (Object)this.getCountOutMvtStockPeriod()).add("priceOutStockMovePeriod", (Object)this.getPriceOutStockMovePeriod()).add("label", (Object)this.getLabel()).add("avgOutQtyOn12PastMonth", (Object)this.getAvgOutQtyOn12PastMonth()).add("sumOneoffSaleOutQtyPeriod", (Object)this.getSumOneoffSaleOutQtyPeriod()).add("sumOutQtyPeriod", (Object)this.getSumOutQtyPeriod()).omitNullValues().toString();
    }
}

