/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.apps.account.db.BudgetLine;
import com.axelor.apps.base.db.Company;
import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Digits;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="ACCOUNT_BUDGET", indexes={@Index(columnList="name"), @Index(columnList="code"), @Index(columnList="company"), @Index(columnList="in_charge_user")})
public class Budget
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_BUDGET_SEQ")
    @SequenceGenerator(name="ACCOUNT_BUDGET_SEQ", sequenceName="ACCOUNT_BUDGET_SEQ", allocationSize=1)
    private Long id;
    @Widget(selection="account.budget.status.select")
    private Integer statusSelect = 1;
    @Widget(title="Name")
    private String name;
    @Widget(title="Code")
    private String code;
    @Widget(title="From")
    private LocalDate fromDate;
    @Widget(title="To")
    private LocalDate toDate;
    @Widget(title="Company")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Person in charge")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User inChargeUser;
    @Widget(title="Expected amount", help="Expected amount allocated on the budget. This amount is automatically computed by adding up expected amounts of bellowed levels.")
    @Digits(integer=18, fraction=2)
    private BigDecimal totalAmountExpected = BigDecimal.ZERO;
    @Widget(title="Realized total amount")
    @Digits(integer=18, fraction=2)
    private BigDecimal totalAmountRealized = BigDecimal.ZERO;
    @Widget(title="Budget Lines")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="budget", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<BudgetLine> budgetLineList;
    @Widget(title="Period duration", selection="account.year.period.duration.select")
    private Integer periodDurationSelect = 0;
    @Widget(title="Amount for each line")
    private BigDecimal amountForGeneration = BigDecimal.ZERO;
    @Widget(title="Committed amount", help="Represents the sum of purchase orders of status requested, validated or finished and that don't have a invoiced invoice.")
    @Digits(integer=18, fraction=2)
    private BigDecimal totalAmountCommitted = BigDecimal.ZERO;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Budget() {
    }

    public Budget(String name, String code) {
        this.name = name;
        this.code = code;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public LocalDate getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(LocalDate fromDate) {
        this.fromDate = fromDate;
    }

    public LocalDate getToDate() {
        return this.toDate;
    }

    public void setToDate(LocalDate toDate) {
        this.toDate = toDate;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public User getInChargeUser() {
        return this.inChargeUser;
    }

    public void setInChargeUser(User inChargeUser) {
        this.inChargeUser = inChargeUser;
    }

    public BigDecimal getTotalAmountExpected() {
        return this.totalAmountExpected == null ? BigDecimal.ZERO : this.totalAmountExpected;
    }

    public void setTotalAmountExpected(BigDecimal totalAmountExpected) {
        this.totalAmountExpected = totalAmountExpected;
    }

    public BigDecimal getTotalAmountRealized() {
        return this.totalAmountRealized == null ? BigDecimal.ZERO : this.totalAmountRealized;
    }

    public void setTotalAmountRealized(BigDecimal totalAmountRealized) {
        this.totalAmountRealized = totalAmountRealized;
    }

    public List<BudgetLine> getBudgetLineList() {
        return this.budgetLineList;
    }

    public void setBudgetLineList(List<BudgetLine> budgetLineList) {
        this.budgetLineList = budgetLineList;
    }

    public void addBudgetLineListItem(BudgetLine item) {
        if (this.getBudgetLineList() == null) {
            this.setBudgetLineList(new ArrayList());
        }
        this.getBudgetLineList().add(item);
        item.setBudget(this);
    }

    public void removeBudgetLineListItem(BudgetLine item) {
        if (this.getBudgetLineList() == null) {
            return;
        }
        this.getBudgetLineList().remove(item);
    }

    public void clearBudgetLineList() {
        if (this.getBudgetLineList() != null) {
            this.getBudgetLineList().clear();
        }
    }

    public Integer getPeriodDurationSelect() {
        return this.periodDurationSelect == null ? 0 : this.periodDurationSelect;
    }

    public void setPeriodDurationSelect(Integer periodDurationSelect) {
        this.periodDurationSelect = periodDurationSelect;
    }

    public BigDecimal getAmountForGeneration() {
        return this.amountForGeneration == null ? BigDecimal.ZERO : this.amountForGeneration;
    }

    public void setAmountForGeneration(BigDecimal amountForGeneration) {
        this.amountForGeneration = amountForGeneration;
    }

    public BigDecimal getTotalAmountCommitted() {
        return this.totalAmountCommitted == null ? BigDecimal.ZERO : this.totalAmountCommitted;
    }

    public void setTotalAmountCommitted(BigDecimal totalAmountCommitted) {
        this.totalAmountCommitted = totalAmountCommitted;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Budget)) {
            return false;
        }
        Budget other = (Budget)obj;
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("statusSelect", (Object)this.getStatusSelect()).add("name", (Object)this.getName()).add("code", (Object)this.getCode()).add("fromDate", (Object)this.getFromDate()).add("toDate", (Object)this.getToDate()).add("totalAmountExpected", (Object)this.getTotalAmountExpected()).add("totalAmountRealized", (Object)this.getTotalAmountRealized()).add("periodDurationSelect", (Object)this.getPeriodDurationSelect()).add("amountForGeneration", (Object)this.getAmountForGeneration()).add("totalAmountCommitted", (Object)this.getTotalAmountCommitted()).omitNullValues().toString();
    }
}

