/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.base.db.App;
import com.axelor.apps.project.db.ProjectPriority;
import com.axelor.apps.project.db.ProjectStatus;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Track;
import com.axelor.db.annotations.TrackEvent;
import com.axelor.db.annotations.TrackField;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaJsonField;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BASE_APP_PROJECT", indexes={@Index(columnList="app")})
@Track(fields={@TrackField(name="projectLabel", on={TrackEvent.UPDATE}), @TrackField(name="resourceManagement", on={TrackEvent.UPDATE})})
public class AppProject
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_APP_PROJECT_SEQ")
    @SequenceGenerator(name="BASE_APP_PROJECT_SEQ", sequenceName="BASE_APP_PROJECT_SEQ", allocationSize=1)
    private Long id;
    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private App app;
    @Widget(title="Project Label")
    private String projectLabel;
    @Widget(title="Resource management")
    private Boolean resourceManagement = Boolean.FALSE;
    @Widget(title="Check availability of resources")
    private Boolean checkResourceAvailibility = Boolean.FALSE;
    @Widget(title="Enable task signature")
    private Boolean isEnableSignature = Boolean.FALSE;
    @Widget(title="Enable per project task sequence")
    private Boolean isEnablePerProjectTaskSequence = Boolean.FALSE;
    @Widget(title="Task fields")
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<MetaJsonField> taskCustomFieldsList;
    @Widget(title="Project fields")
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<MetaJsonField> projectCustomFieldsList;
    @Widget(title="Default task status")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<ProjectStatus> defaultTaskStatusSet;
    @Widget(title="Default priorities")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<ProjectPriority> defaultPrioritySet;
    @Widget(title="Default increment")
    private BigDecimal defaultIncrement = BigDecimal.ZERO;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public App getApp() {
        return this.app;
    }

    public void setApp(App app) {
        this.app = app;
    }

    public String getProjectLabel() {
        return this.projectLabel;
    }

    public void setProjectLabel(String projectLabel) {
        this.projectLabel = projectLabel;
    }

    public Boolean getResourceManagement() {
        return this.resourceManagement == null ? Boolean.FALSE : this.resourceManagement;
    }

    public void setResourceManagement(Boolean resourceManagement) {
        this.resourceManagement = resourceManagement;
    }

    public Boolean getCheckResourceAvailibility() {
        return this.checkResourceAvailibility == null ? Boolean.FALSE : this.checkResourceAvailibility;
    }

    public void setCheckResourceAvailibility(Boolean checkResourceAvailibility) {
        this.checkResourceAvailibility = checkResourceAvailibility;
    }

    public Boolean getIsEnableSignature() {
        return this.isEnableSignature == null ? Boolean.FALSE : this.isEnableSignature;
    }

    public void setIsEnableSignature(Boolean isEnableSignature) {
        this.isEnableSignature = isEnableSignature;
    }

    public Boolean getIsEnablePerProjectTaskSequence() {
        return this.isEnablePerProjectTaskSequence == null ? Boolean.FALSE : this.isEnablePerProjectTaskSequence;
    }

    public void setIsEnablePerProjectTaskSequence(Boolean isEnablePerProjectTaskSequence) {
        this.isEnablePerProjectTaskSequence = isEnablePerProjectTaskSequence;
    }

    public List<MetaJsonField> getTaskCustomFieldsList() {
        return this.taskCustomFieldsList;
    }

    public void setTaskCustomFieldsList(List<MetaJsonField> taskCustomFieldsList) {
        this.taskCustomFieldsList = taskCustomFieldsList;
    }

    public void addTaskCustomFieldsListItem(MetaJsonField item) {
        if (this.getTaskCustomFieldsList() == null) {
            this.setTaskCustomFieldsList(new ArrayList());
        }
        this.getTaskCustomFieldsList().add(item);
    }

    public void removeTaskCustomFieldsListItem(MetaJsonField item) {
        if (this.getTaskCustomFieldsList() == null) {
            return;
        }
        this.getTaskCustomFieldsList().remove(item);
    }

    public void clearTaskCustomFieldsList() {
        if (this.getTaskCustomFieldsList() != null) {
            this.getTaskCustomFieldsList().clear();
        }
    }

    public List<MetaJsonField> getProjectCustomFieldsList() {
        return this.projectCustomFieldsList;
    }

    public void setProjectCustomFieldsList(List<MetaJsonField> projectCustomFieldsList) {
        this.projectCustomFieldsList = projectCustomFieldsList;
    }

    public void addProjectCustomFieldsListItem(MetaJsonField item) {
        if (this.getProjectCustomFieldsList() == null) {
            this.setProjectCustomFieldsList(new ArrayList());
        }
        this.getProjectCustomFieldsList().add(item);
    }

    public void removeProjectCustomFieldsListItem(MetaJsonField item) {
        if (this.getProjectCustomFieldsList() == null) {
            return;
        }
        this.getProjectCustomFieldsList().remove(item);
    }

    public void clearProjectCustomFieldsList() {
        if (this.getProjectCustomFieldsList() != null) {
            this.getProjectCustomFieldsList().clear();
        }
    }

    public Set<ProjectStatus> getDefaultTaskStatusSet() {
        return this.defaultTaskStatusSet;
    }

    public void setDefaultTaskStatusSet(Set<ProjectStatus> defaultTaskStatusSet) {
        this.defaultTaskStatusSet = defaultTaskStatusSet;
    }

    public void addDefaultTaskStatusSetItem(ProjectStatus item) {
        if (this.getDefaultTaskStatusSet() == null) {
            this.setDefaultTaskStatusSet(new HashSet());
        }
        this.getDefaultTaskStatusSet().add(item);
    }

    public void removeDefaultTaskStatusSetItem(ProjectStatus item) {
        if (this.getDefaultTaskStatusSet() == null) {
            return;
        }
        this.getDefaultTaskStatusSet().remove(item);
    }

    public void clearDefaultTaskStatusSet() {
        if (this.getDefaultTaskStatusSet() != null) {
            this.getDefaultTaskStatusSet().clear();
        }
    }

    public Set<ProjectPriority> getDefaultPrioritySet() {
        return this.defaultPrioritySet;
    }

    public void setDefaultPrioritySet(Set<ProjectPriority> defaultPrioritySet) {
        this.defaultPrioritySet = defaultPrioritySet;
    }

    public void addDefaultPrioritySetItem(ProjectPriority item) {
        if (this.getDefaultPrioritySet() == null) {
            this.setDefaultPrioritySet(new HashSet());
        }
        this.getDefaultPrioritySet().add(item);
    }

    public void removeDefaultPrioritySetItem(ProjectPriority item) {
        if (this.getDefaultPrioritySet() == null) {
            return;
        }
        this.getDefaultPrioritySet().remove(item);
    }

    public void clearDefaultPrioritySet() {
        if (this.getDefaultPrioritySet() != null) {
            this.getDefaultPrioritySet().clear();
        }
    }

    public BigDecimal getDefaultIncrement() {
        return this.defaultIncrement == null ? BigDecimal.ZERO : this.defaultIncrement;
    }

    public void setDefaultIncrement(BigDecimal defaultIncrement) {
        this.defaultIncrement = defaultIncrement;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AppProject)) {
            return false;
        }
        AppProject other = (AppProject)obj;
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("projectLabel", (Object)this.getProjectLabel()).add("resourceManagement", (Object)this.getResourceManagement()).add("checkResourceAvailibility", (Object)this.getCheckResourceAvailibility()).add("isEnableSignature", (Object)this.getIsEnableSignature()).add("isEnablePerProjectTaskSequence", (Object)this.getIsEnablePerProjectTaskSequence()).add("defaultIncrement", (Object)this.getDefaultIncrement()).omitNullValues().toString();
    }
}

