/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.businessproject.db;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.hr.db.ExpenseLine;
import com.axelor.apps.hr.db.TimesheetLine;
import com.axelor.apps.production.db.ManufOrder;
import com.axelor.apps.project.db.Project;
import com.axelor.apps.project.db.ProjectTask;
import com.axelor.apps.purchase.db.PurchaseOrderLine;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.time.LocalDate;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="BUSINESSPROJECT_INVOICING_PROJECT", indexes={@Index(columnList="project"), @Index(columnList="invoice")})
public class InvoicingProject
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BUSINESSPROJECT_INVOICING_PROJECT_SEQ")
    @SequenceGenerator(name="BUSINESSPROJECT_INVOICING_PROJECT_SEQ", sequenceName="BUSINESSPROJECT_INVOICING_PROJECT_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Business project")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Project project;
    @Widget(title="Log Times")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<TimesheetLine> logTimesSet;
    @Widget(title="Sale order lines")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<SaleOrderLine> saleOrderLineSet;
    @Widget(title="Purchase order lines")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<PurchaseOrderLine> purchaseOrderLineSet;
    @Widget(title="Expense Lines")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<ExpenseLine> expenseLineSet;
    @Widget(title="Tasks")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<ProjectTask> projectTaskSet;
    @Widget(title="Log Times Priority", selection="invoicing.project.priority.select")
    private Integer logTimesSetPrioritySelect = 3;
    @Widget(title="Sale order lines Priority", selection="invoicing.project.priority.select")
    private Integer saleOrderLineSetPrioritySelect = 1;
    @Widget(title="Purchase order lines Priority", selection="invoicing.project.priority.select")
    private Integer purchaseOrderLineSetPrioritySelect = 2;
    @Widget(title="Expense Lines Priority", selection="invoicing.project.priority.select")
    private Integer expenseLineSetPrioritySelect = 4;
    @Widget(title="Project Priority", selection="invoicing.project.priority.select")
    private Integer projectSetPrioritySelect = 5;
    @Widget(title="Task Priority", selection="invoicing.project.priority.select")
    private Integer projectTaskSetPrioritySelect = 6;
    @Widget(title="Invoice generated")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Invoice invoice;
    @Widget(title="Deadline")
    private LocalDate deadlineDate;
    @Widget(title="Comments")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String comments;
    @Widget(title="Attach the Annex to the invoice")
    private Boolean attachAnnexToInvoice = Boolean.FALSE;
    @Widget(title="Status", selection="business.project.invoicing.project.status.select")
    private Integer statusSelect = 1;
    @Widget(title="Consolidate phase invoicing")
    private Boolean consolidatePhaseWhenInvoicing = Boolean.FALSE;
    @Widget(title="Manuf. Orders Selection")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<ManufOrder> manufOrderSet;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public Set<TimesheetLine> getLogTimesSet() {
        return this.logTimesSet;
    }

    public void setLogTimesSet(Set<TimesheetLine> logTimesSet) {
        this.logTimesSet = logTimesSet;
    }

    public void addLogTimesSetItem(TimesheetLine item) {
        if (this.getLogTimesSet() == null) {
            this.setLogTimesSet(new HashSet());
        }
        this.getLogTimesSet().add(item);
    }

    public void removeLogTimesSetItem(TimesheetLine item) {
        if (this.getLogTimesSet() == null) {
            return;
        }
        this.getLogTimesSet().remove(item);
    }

    public void clearLogTimesSet() {
        if (this.getLogTimesSet() != null) {
            this.getLogTimesSet().clear();
        }
    }

    public Set<SaleOrderLine> getSaleOrderLineSet() {
        return this.saleOrderLineSet;
    }

    public void setSaleOrderLineSet(Set<SaleOrderLine> saleOrderLineSet) {
        this.saleOrderLineSet = saleOrderLineSet;
    }

    public void addSaleOrderLineSetItem(SaleOrderLine item) {
        if (this.getSaleOrderLineSet() == null) {
            this.setSaleOrderLineSet(new HashSet());
        }
        this.getSaleOrderLineSet().add(item);
    }

    public void removeSaleOrderLineSetItem(SaleOrderLine item) {
        if (this.getSaleOrderLineSet() == null) {
            return;
        }
        this.getSaleOrderLineSet().remove(item);
    }

    public void clearSaleOrderLineSet() {
        if (this.getSaleOrderLineSet() != null) {
            this.getSaleOrderLineSet().clear();
        }
    }

    public Set<PurchaseOrderLine> getPurchaseOrderLineSet() {
        return this.purchaseOrderLineSet;
    }

    public void setPurchaseOrderLineSet(Set<PurchaseOrderLine> purchaseOrderLineSet) {
        this.purchaseOrderLineSet = purchaseOrderLineSet;
    }

    public void addPurchaseOrderLineSetItem(PurchaseOrderLine item) {
        if (this.getPurchaseOrderLineSet() == null) {
            this.setPurchaseOrderLineSet(new HashSet());
        }
        this.getPurchaseOrderLineSet().add(item);
    }

    public void removePurchaseOrderLineSetItem(PurchaseOrderLine item) {
        if (this.getPurchaseOrderLineSet() == null) {
            return;
        }
        this.getPurchaseOrderLineSet().remove(item);
    }

    public void clearPurchaseOrderLineSet() {
        if (this.getPurchaseOrderLineSet() != null) {
            this.getPurchaseOrderLineSet().clear();
        }
    }

    public Set<ExpenseLine> getExpenseLineSet() {
        return this.expenseLineSet;
    }

    public void setExpenseLineSet(Set<ExpenseLine> expenseLineSet) {
        this.expenseLineSet = expenseLineSet;
    }

    public void addExpenseLineSetItem(ExpenseLine item) {
        if (this.getExpenseLineSet() == null) {
            this.setExpenseLineSet(new HashSet());
        }
        this.getExpenseLineSet().add(item);
    }

    public void removeExpenseLineSetItem(ExpenseLine item) {
        if (this.getExpenseLineSet() == null) {
            return;
        }
        this.getExpenseLineSet().remove(item);
    }

    public void clearExpenseLineSet() {
        if (this.getExpenseLineSet() != null) {
            this.getExpenseLineSet().clear();
        }
    }

    public Set<ProjectTask> getProjectTaskSet() {
        return this.projectTaskSet;
    }

    public void setProjectTaskSet(Set<ProjectTask> projectTaskSet) {
        this.projectTaskSet = projectTaskSet;
    }

    public void addProjectTaskSetItem(ProjectTask item) {
        if (this.getProjectTaskSet() == null) {
            this.setProjectTaskSet(new HashSet());
        }
        this.getProjectTaskSet().add(item);
    }

    public void removeProjectTaskSetItem(ProjectTask item) {
        if (this.getProjectTaskSet() == null) {
            return;
        }
        this.getProjectTaskSet().remove(item);
    }

    public void clearProjectTaskSet() {
        if (this.getProjectTaskSet() != null) {
            this.getProjectTaskSet().clear();
        }
    }

    public Integer getLogTimesSetPrioritySelect() {
        return this.logTimesSetPrioritySelect == null ? 0 : this.logTimesSetPrioritySelect;
    }

    public void setLogTimesSetPrioritySelect(Integer logTimesSetPrioritySelect) {
        this.logTimesSetPrioritySelect = logTimesSetPrioritySelect;
    }

    public Integer getSaleOrderLineSetPrioritySelect() {
        return this.saleOrderLineSetPrioritySelect == null ? 0 : this.saleOrderLineSetPrioritySelect;
    }

    public void setSaleOrderLineSetPrioritySelect(Integer saleOrderLineSetPrioritySelect) {
        this.saleOrderLineSetPrioritySelect = saleOrderLineSetPrioritySelect;
    }

    public Integer getPurchaseOrderLineSetPrioritySelect() {
        return this.purchaseOrderLineSetPrioritySelect == null ? 0 : this.purchaseOrderLineSetPrioritySelect;
    }

    public void setPurchaseOrderLineSetPrioritySelect(Integer purchaseOrderLineSetPrioritySelect) {
        this.purchaseOrderLineSetPrioritySelect = purchaseOrderLineSetPrioritySelect;
    }

    public Integer getExpenseLineSetPrioritySelect() {
        return this.expenseLineSetPrioritySelect == null ? 0 : this.expenseLineSetPrioritySelect;
    }

    public void setExpenseLineSetPrioritySelect(Integer expenseLineSetPrioritySelect) {
        this.expenseLineSetPrioritySelect = expenseLineSetPrioritySelect;
    }

    public Integer getProjectSetPrioritySelect() {
        return this.projectSetPrioritySelect == null ? 0 : this.projectSetPrioritySelect;
    }

    public void setProjectSetPrioritySelect(Integer projectSetPrioritySelect) {
        this.projectSetPrioritySelect = projectSetPrioritySelect;
    }

    public Integer getProjectTaskSetPrioritySelect() {
        return this.projectTaskSetPrioritySelect == null ? 0 : this.projectTaskSetPrioritySelect;
    }

    public void setProjectTaskSetPrioritySelect(Integer projectTaskSetPrioritySelect) {
        this.projectTaskSetPrioritySelect = projectTaskSetPrioritySelect;
    }

    public Invoice getInvoice() {
        return this.invoice;
    }

    public void setInvoice(Invoice invoice) {
        this.invoice = invoice;
    }

    public LocalDate getDeadlineDate() {
        return this.deadlineDate;
    }

    public void setDeadlineDate(LocalDate deadlineDate) {
        this.deadlineDate = deadlineDate;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public Boolean getAttachAnnexToInvoice() {
        return this.attachAnnexToInvoice == null ? Boolean.FALSE : this.attachAnnexToInvoice;
    }

    public void setAttachAnnexToInvoice(Boolean attachAnnexToInvoice) {
        this.attachAnnexToInvoice = attachAnnexToInvoice;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public Boolean getConsolidatePhaseWhenInvoicing() {
        return this.consolidatePhaseWhenInvoicing == null ? Boolean.FALSE : this.consolidatePhaseWhenInvoicing;
    }

    public void setConsolidatePhaseWhenInvoicing(Boolean consolidatePhaseWhenInvoicing) {
        this.consolidatePhaseWhenInvoicing = consolidatePhaseWhenInvoicing;
    }

    public Set<ManufOrder> getManufOrderSet() {
        return this.manufOrderSet;
    }

    public void setManufOrderSet(Set<ManufOrder> manufOrderSet) {
        this.manufOrderSet = manufOrderSet;
    }

    public void addManufOrderSetItem(ManufOrder item) {
        if (this.getManufOrderSet() == null) {
            this.setManufOrderSet(new HashSet());
        }
        this.getManufOrderSet().add(item);
    }

    public void removeManufOrderSetItem(ManufOrder item) {
        if (this.getManufOrderSet() == null) {
            return;
        }
        this.getManufOrderSet().remove(item);
    }

    public void clearManufOrderSet() {
        if (this.getManufOrderSet() != null) {
            this.getManufOrderSet().clear();
        }
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof InvoicingProject)) {
            return false;
        }
        InvoicingProject other = (InvoicingProject)obj;
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("logTimesSetPrioritySelect", (Object)this.getLogTimesSetPrioritySelect()).add("saleOrderLineSetPrioritySelect", (Object)this.getSaleOrderLineSetPrioritySelect()).add("purchaseOrderLineSetPrioritySelect", (Object)this.getPurchaseOrderLineSetPrioritySelect()).add("expenseLineSetPrioritySelect", (Object)this.getExpenseLineSetPrioritySelect()).add("projectSetPrioritySelect", (Object)this.getProjectSetPrioritySelect()).add("projectTaskSetPrioritySelect", (Object)this.getProjectTaskSetPrioritySelect()).add("deadlineDate", (Object)this.getDeadlineDate()).add("attachAnnexToInvoice", (Object)this.getAttachAnnexToInvoice()).add("statusSelect", (Object)this.getStatusSelect()).add("consolidatePhaseWhenInvoicing", (Object)this.getConsolidatePhaseWhenInvoicing()).omitNullValues().toString();
    }
}

