/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.crm.db;

import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.Source;
import com.axelor.apps.base.db.TradingName;
import com.axelor.apps.crm.db.LostReason;
import com.axelor.apps.crm.db.OpportunityStatus;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.db.annotations.EqualsInclude;
import com.axelor.db.annotations.Track;
import com.axelor.db.annotations.TrackEvent;
import com.axelor.db.annotations.TrackField;
import com.axelor.db.annotations.TrackMessage;
import com.axelor.db.annotations.Widget;
import com.axelor.team.db.Team;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="CRM_OPPORTUNITY", indexes={@Index(columnList="name"), @Index(columnList="partner"), @Index(columnList="contact"), @Index(columnList="currency"), @Index(columnList="opportunity_status"), @Index(columnList="source"), @Index(columnList="company"), @Index(columnList="user_id"), @Index(columnList="team"), @Index(columnList="lost_reason"), @Index(columnList="trading_name"), @Index(columnList="bank_details")})
@Track(fields={@TrackField(name="name"), @TrackField(name="opportunityStatus")}, messages={@TrackMessage(message="Opportunity created", condition="true", on={TrackEvent.CREATE}), @TrackMessage(message="Opportunity won", condition="opportunityStatus.id == __config__.app.getApp('crm')?.closedWinOpportunityStatus?.id", tag="success", fields={"opportunityStatus"}), @TrackMessage(message="Opportunity lost", condition="opportunityStatus.id == __config__.app.getApp('crm')?.closedLostOpportunityStatus?.id", tag="warning", fields={"opportunityStatus"})})
public class Opportunity
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="CRM_OPPORTUNITY_SEQ")
    @SequenceGenerator(name="CRM_OPPORTUNITY_SEQ", sequenceName="CRM_OPPORTUNITY_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Name")
    @NotNull
    private String name;
    @Widget(title="Customer / Prospect")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner partner;
    @Widget(title="Contact")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner contact;
    @Widget(title="Currency")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Currency currency;
    @Widget(title="Expected close date")
    private LocalDate expectedCloseDate;
    @Widget(title="Amount")
    private BigDecimal amount = BigDecimal.ZERO;
    @Widget(title="Type of need")
    private String opportunityType;
    @Widget(title="Best case")
    private BigDecimal bestCase = BigDecimal.ZERO;
    @Widget(title="Worst case")
    private BigDecimal worstCase = BigDecimal.ZERO;
    @Widget(title="Sales stage")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private OpportunityStatus opportunityStatus;
    @Widget(title="Probability (%)")
    private BigDecimal probability = BigDecimal.ZERO;
    @Widget(title="Description")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String description;
    @Widget(title="Customer Description")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String customerDescription;
    @Widget(title="Source")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Source source;
    @Widget(title="Company")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    private Integer orderByState = 0;
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String memo;
    @Widget(title="Assigned to")
    @JoinColumn(name="user_id")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User user;
    @Widget(title="Team")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Team team;
    @Widget(title="Lost reason")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private LostReason lostReason;
    @Widget(title="Lost reason")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String lostReasonStr;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private TradingName tradingName;
    @EqualsInclude
    @Widget(title="Reference", readonly=true)
    @Column(unique=true)
    private String opportunitySeq;
    @Widget(title="Recurrent amount")
    private BigDecimal recurrentAmount = BigDecimal.ZERO;
    @Widget(title="Expected duration of recurring revenue (in months)")
    private Integer expectedDurationOfRecurringRevenue = 0;
    @Widget(title="Recurring start date")
    private LocalDate recurringStartDate;
    @Widget(title="Recurring end date")
    private LocalDate recurringEndDate;
    @Widget(title="Opportunity scoring", selection="gold.rating.icon.select")
    private Integer opportunityRating = 0;
    @Widget(title="Sale orders")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="opportunity", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<SaleOrder> saleOrderList;
    @Widget(title="Bank")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private BankDetails bankDetails;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Opportunity() {
    }

    public Opportunity(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Partner getPartner() {
        return this.partner;
    }

    public void setPartner(Partner partner) {
        this.partner = partner;
    }

    public Partner getContact() {
        return this.contact;
    }

    public void setContact(Partner contact) {
        this.contact = contact;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public LocalDate getExpectedCloseDate() {
        return this.expectedCloseDate;
    }

    public void setExpectedCloseDate(LocalDate expectedCloseDate) {
        this.expectedCloseDate = expectedCloseDate;
    }

    public BigDecimal getAmount() {
        return this.amount == null ? BigDecimal.ZERO : this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public String getOpportunityType() {
        return this.opportunityType;
    }

    public void setOpportunityType(String opportunityType) {
        this.opportunityType = opportunityType;
    }

    public BigDecimal getBestCase() {
        return this.bestCase == null ? BigDecimal.ZERO : this.bestCase;
    }

    public void setBestCase(BigDecimal bestCase) {
        this.bestCase = bestCase;
    }

    public BigDecimal getWorstCase() {
        return this.worstCase == null ? BigDecimal.ZERO : this.worstCase;
    }

    public void setWorstCase(BigDecimal worstCase) {
        this.worstCase = worstCase;
    }

    public OpportunityStatus getOpportunityStatus() {
        return this.opportunityStatus;
    }

    public void setOpportunityStatus(OpportunityStatus opportunityStatus) {
        this.opportunityStatus = opportunityStatus;
    }

    public BigDecimal getProbability() {
        return this.probability == null ? BigDecimal.ZERO : this.probability;
    }

    public void setProbability(BigDecimal probability) {
        this.probability = probability;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCustomerDescription() {
        return this.customerDescription;
    }

    public void setCustomerDescription(String customerDescription) {
        this.customerDescription = customerDescription;
    }

    public Source getSource() {
        return this.source;
    }

    public void setSource(Source source) {
        this.source = source;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public Integer getOrderByState() {
        return this.orderByState == null ? 0 : this.orderByState;
    }

    public void setOrderByState(Integer orderByState) {
        this.orderByState = orderByState;
    }

    public String getMemo() {
        return this.memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Team getTeam() {
        return this.team;
    }

    public void setTeam(Team team) {
        this.team = team;
    }

    public LostReason getLostReason() {
        return this.lostReason;
    }

    public void setLostReason(LostReason lostReason) {
        this.lostReason = lostReason;
    }

    public String getLostReasonStr() {
        return this.lostReasonStr;
    }

    public void setLostReasonStr(String lostReasonStr) {
        this.lostReasonStr = lostReasonStr;
    }

    public TradingName getTradingName() {
        return this.tradingName;
    }

    public void setTradingName(TradingName tradingName) {
        this.tradingName = tradingName;
    }

    public String getOpportunitySeq() {
        return this.opportunitySeq;
    }

    public void setOpportunitySeq(String opportunitySeq) {
        this.opportunitySeq = opportunitySeq;
    }

    public BigDecimal getRecurrentAmount() {
        return this.recurrentAmount == null ? BigDecimal.ZERO : this.recurrentAmount;
    }

    public void setRecurrentAmount(BigDecimal recurrentAmount) {
        this.recurrentAmount = recurrentAmount;
    }

    public Integer getExpectedDurationOfRecurringRevenue() {
        return this.expectedDurationOfRecurringRevenue == null ? 0 : this.expectedDurationOfRecurringRevenue;
    }

    public void setExpectedDurationOfRecurringRevenue(Integer expectedDurationOfRecurringRevenue) {
        this.expectedDurationOfRecurringRevenue = expectedDurationOfRecurringRevenue;
    }

    public LocalDate getRecurringStartDate() {
        return this.recurringStartDate;
    }

    public void setRecurringStartDate(LocalDate recurringStartDate) {
        this.recurringStartDate = recurringStartDate;
    }

    public LocalDate getRecurringEndDate() {
        return this.recurringEndDate;
    }

    public void setRecurringEndDate(LocalDate recurringEndDate) {
        this.recurringEndDate = recurringEndDate;
    }

    public Integer getOpportunityRating() {
        return this.opportunityRating == null ? 0 : this.opportunityRating;
    }

    public void setOpportunityRating(Integer opportunityRating) {
        this.opportunityRating = opportunityRating;
    }

    public List<SaleOrder> getSaleOrderList() {
        return this.saleOrderList;
    }

    public void setSaleOrderList(List<SaleOrder> saleOrderList) {
        this.saleOrderList = saleOrderList;
    }

    public void addSaleOrderListItem(SaleOrder item) {
        if (this.getSaleOrderList() == null) {
            this.setSaleOrderList(new ArrayList());
        }
        this.getSaleOrderList().add(item);
        item.setOpportunity(this);
    }

    public void removeSaleOrderListItem(SaleOrder item) {
        if (this.getSaleOrderList() == null) {
            return;
        }
        this.getSaleOrderList().remove(item);
    }

    public void clearSaleOrderList() {
        if (this.getSaleOrderList() != null) {
            this.getSaleOrderList().clear();
        }
    }

    public BankDetails getBankDetails() {
        return this.bankDetails;
    }

    public void setBankDetails(BankDetails bankDetails) {
        this.bankDetails = bankDetails;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Opportunity)) {
            return false;
        }
        Opportunity other = (Opportunity)obj;
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return Objects.equals(this.getOpportunitySeq(), other.getOpportunitySeq()) && this.getOpportunitySeq() != null;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("expectedCloseDate", (Object)this.getExpectedCloseDate()).add("amount", (Object)this.getAmount()).add("opportunityType", (Object)this.getOpportunityType()).add("bestCase", (Object)this.getBestCase()).add("worstCase", (Object)this.getWorstCase()).add("probability", (Object)this.getProbability()).add("orderByState", (Object)this.getOrderByState()).add("opportunitySeq", (Object)this.getOpportunitySeq()).add("recurrentAmount", (Object)this.getRecurrentAmount()).add("expectedDurationOfRecurringRevenue", (Object)this.getExpectedDurationOfRecurringRevenue()).omitNullValues().toString();
    }
}

