/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.project.db;

import com.axelor.apps.account.db.InvoiceLine;
import com.axelor.apps.base.db.Address;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.PriceList;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.businessproject.db.ManualElement;
import com.axelor.apps.businessproject.db.ProjectFolder;
import com.axelor.apps.businesssupport.db.ProjectAnnouncement;
import com.axelor.apps.businesssupport.db.ProjectVersion;
import com.axelor.apps.hr.db.ExpenseLine;
import com.axelor.apps.hr.db.TimesheetLine;
import com.axelor.apps.production.db.ProductionOrder;
import com.axelor.apps.project.db.GenProjTypePerOrderLine;
import com.axelor.apps.project.db.ProjectPriority;
import com.axelor.apps.project.db.ProjectStatus;
import com.axelor.apps.project.db.ProjectTask;
import com.axelor.apps.project.db.ProjectTaskCategory;
import com.axelor.apps.project.db.ResourceBooking;
import com.axelor.apps.project.db.Wiki;
import com.axelor.apps.purchase.db.PurchaseOrderLine;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaJsonField;
import com.axelor.team.db.Team;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="PROJECT_PROJECT", indexes={@Index(columnList="name"), @Index(columnList="team"), @Index(columnList="assigned_to"), @Index(columnList="project_status"), @Index(columnList="parent_project"), @Index(columnList="client_partner"), @Index(columnList="contact_partner"), @Index(columnList="fullName"), @Index(columnList="currency"), @Index(columnList="price_list"), @Index(columnList="customer_address"), @Index(columnList="company"), @Index(columnList="name"), @Index(columnList="code"), @Index(columnList="fullName")})
public class Project
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="PROJECT_PROJECT_SEQ")
    @SequenceGenerator(name="PROJECT_PROJECT_SEQ", sequenceName="PROJECT_PROJECT_SEQ", allocationSize=1)
    private Long id;
    @Widget(multiline=true)
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String description;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Team team;
    @Widget(title="Sub-Projects")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="parentProject", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<Project> childProjectList;
    @Widget(title="Assigned to")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User assignedTo;
    @Widget(title="Status")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ProjectStatus projectStatus;
    @Widget(title="Tasks")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="project", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ProjectTask> projectTaskList;
    private Boolean synchronize = Boolean.FALSE;
    private Boolean extendsMembersFromParent = Boolean.FALSE;
    @Widget(title="Parent project")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Project parentProject;
    @Widget(title="Wiki")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="project", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<Wiki> wikiList;
    @Widget(title="Resource booking")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="project", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ResourceBooking> resourceBookingList;
    @Widget(title="Task fields")
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<MetaJsonField> taskCustomFieldsList;
    @Widget(title="Membres")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<User> membersUserSet;
    @Widget(title="Customer")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner clientPartner;
    @Widget(title="Customer Contact")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner contactPartner;
    @Widget(title="From Date")
    private LocalDateTime fromDate;
    @Widget(title="To Date")
    private LocalDateTime toDate;
    @Widget(title="Estimated time (in hours)")
    private BigDecimal estimatedTimeHrs = BigDecimal.ZERO;
    @Widget(title="Time Spent")
    private BigDecimal timeSpent = BigDecimal.ZERO;
    @Widget(title="Sequence")
    private BigDecimal sequence = BigDecimal.ZERO;
    private Integer orderByState = 0;
    @Widget(title="Imputable to HR timesheets", massUpdate=true)
    private Boolean imputable = Boolean.TRUE;
    @Widget(title="Finish tasks to start")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Project> finishToStartTaskSet;
    @Widget(title="Start tasks to start")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Project> startToStartTaskSet;
    @Widget(title="Finish tasks to finish")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Project> finishToFinishTaskSet;
    @Widget(title="Start tasks to finish")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Project> startToFinishTaskSet;
    @Widget(title="Type of authorized activities")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Product> productSet;
    @Widget(title="Show sub-projects")
    private Boolean isShowPhasesElements = Boolean.FALSE;
    @Basic
    @Type(type="com.axelor.db.hibernate.type.ValueEnumType")
    private GenProjTypePerOrderLine genProjTypePerOrderLine = GenProjTypePerOrderLine.BUSINESS_PROJECT;
    @Widget(title="Next project sequence", hidden=true)
    private Integer nextProjectTaskSequence = 1;
    @Widget(title="Status?")
    private Boolean isShowStatus = Boolean.TRUE;
    @Widget(title="Type of authorized status")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<ProjectStatus> projectTaskStatusSet;
    @Widget(title="Priorities?")
    private Boolean isShowPriority = Boolean.TRUE;
    @Widget(title="Type of authorized priorities")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<ProjectPriority> projectTaskPrioritySet;
    @Widget(title="Categories?")
    private Boolean isShowTaskCategory = Boolean.TRUE;
    @Widget(title="Type of authorized categories")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<ProjectTaskCategory> projectTaskCategorySet;
    @Widget(title="Task progress")
    private Boolean isShowProgress = Boolean.TRUE;
    @Widget(title="Task planning")
    private Boolean isShowPlanning = Boolean.TRUE;
    @Widget(title="Task recurrence")
    private Boolean isShowFrequency = Boolean.FALSE;
    @Widget(title="Time Spent?")
    private Boolean isShowTimeSpent = Boolean.FALSE;
    @Widget(title="Section?")
    private Boolean isShowSection = Boolean.TRUE;
    @Widget(title="Topic?")
    private Boolean isShowTopic = Boolean.FALSE;
    @Widget(title="Enable Gantt view")
    private Boolean isShowGantt = Boolean.FALSE;
    @Widget(title="Enable Kanban view per status")
    private Boolean isShowKanbanPerStatus = Boolean.FALSE;
    @Widget(title="Enable Kanban view per section")
    private Boolean isShowKanbanPerSection = Boolean.FALSE;
    @Widget(title="Enable calendar view per status")
    private Boolean isShowCalendarPerStatus = Boolean.FALSE;
    @Widget(title="Enable calendar view per section")
    private Boolean isShowCalendarPerSection = Boolean.FALSE;
    @Widget(title="Enable calendar view per user")
    private Boolean isShowCalendarPerUser = Boolean.FALSE;
    @Widget(title="Logged Time")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="project", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private List<TimesheetLine> timesheetLineList;
    @Widget(title="Total planned hours")
    private BigDecimal totalPlannedHrs = BigDecimal.ZERO;
    @Widget(title="Total real hours")
    private BigDecimal totalRealHrs = BigDecimal.ZERO;
    @Widget(title="Exclude timesheet editor")
    private Boolean excludeTimesheetEditor = Boolean.FALSE;
    @Widget(title="Currency", massUpdate=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Currency currency;
    @Widget(title="Invoicing sequence", selection="business.project.invoicing.sequence.select")
    private Integer invoicingSequenceSelect = 0;
    @Widget(title="Invoicing comment")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String invoicingComment;
    @Widget(title="Price list")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PriceList priceList;
    @Widget(title="Planned Times Total", readonly=true)
    private BigDecimal totalTimesPlanned = BigDecimal.ZERO;
    @Widget(title="Realised Times Total", readonly=true)
    private BigDecimal totalTimesRealised = BigDecimal.ZERO;
    @Widget(title="ExpensesTotal", readonly=true)
    private BigDecimal totalExpenses = BigDecimal.ZERO;
    @Widget(title="Estimated Costs Total", readonly=true)
    private BigDecimal totalEstimatedCosts = BigDecimal.ZERO;
    @Widget(title="Real Costs Total", readonly=true)
    private BigDecimal totalRealCosts = BigDecimal.ZERO;
    @Widget(title="Produced Turnover", readonly=true)
    private BigDecimal totalProducedTurnOver = BigDecimal.ZERO;
    @Widget(title="Estimated Margin", readonly=true)
    private BigDecimal estimatedMargin = BigDecimal.ZERO;
    @Widget(title="Real Margin (Time)", readonly=true)
    private BigDecimal realTimesMargin = BigDecimal.ZERO;
    @Widget(title="Real Margin (Invoicing)", readonly=true)
    private BigDecimal realInvoicingMargin = BigDecimal.ZERO;
    @Widget(title="Manual elements")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="project", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ManualElement> manualElementList;
    @Widget(readonly=true)
    private Boolean invoiced = Boolean.FALSE;
    @Widget(title="Invoicing unit", selection="hr.time.logging.preference.select")
    private String unitOnPrinting;
    @Widget(title="Purchase order lines")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="project", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private List<PurchaseOrderLine> purchaseOrderLineList;
    @Widget(title="Sale order lines")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="project", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private List<SaleOrderLine> saleOrderLineList;
    @Widget(title="Expense lines")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="project", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private List<ExpenseLine> expensesLineList;
    @Widget(title="Invoice lines")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="project", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private List<InvoiceLine> invoiceLineList;
    @Widget(title="Business project")
    private Boolean isBusinessProject = Boolean.FALSE;
    @Widget(title="Packaged task invoicing")
    private Boolean toInvoice = Boolean.FALSE;
    @Widget(title="Invoicing timesheet")
    private Boolean isInvoicingTimesheet = Boolean.FALSE;
    @Widget(title="Invoicing Expenses")
    private Boolean isInvoicingExpenses = Boolean.FALSE;
    @Widget(title="Invoicing Purchases")
    private Boolean isInvoicingPurchases = Boolean.FALSE;
    @Widget(title="Consolidate phase invoicing")
    private Boolean consolidatePhaseWhenInvoicing = Boolean.TRUE;
    @Widget(title="Address")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Address customerAddress;
    @Widget(title="Company")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Project Folders")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<ProjectFolder> projectFolderSet;
    @NotNull
    private String name;
    @Widget(title="Code")
    private String code;
    @Widget(title="Name")
    @NameColumn
    private String fullName;
    @Widget(title="Announcement")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="project", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ProjectAnnouncement> announcementList;
    @Widget(title="Project.version")
    @ManyToMany(fetch=FetchType.LAZY, mappedBy="projectSet", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<ProjectVersion> roadmapSet;
    @Widget(title="Production orders")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="project", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ProductionOrder> productionOrderList;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Project() {
    }

    public Project(String name, String code) {
        this.name = name;
        this.code = code;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Team getTeam() {
        return this.team;
    }

    public void setTeam(Team team) {
        this.team = team;
    }

    public List<Project> getChildProjectList() {
        return this.childProjectList;
    }

    public void setChildProjectList(List<Project> childProjectList) {
        this.childProjectList = childProjectList;
    }

    public void addChildProjectListItem(Project item) {
        if (this.getChildProjectList() == null) {
            this.setChildProjectList(new ArrayList());
        }
        this.getChildProjectList().add(item);
        item.setParentProject(this);
    }

    public void removeChildProjectListItem(Project item) {
        if (this.getChildProjectList() == null) {
            return;
        }
        this.getChildProjectList().remove(item);
    }

    public void clearChildProjectList() {
        if (this.getChildProjectList() != null) {
            this.getChildProjectList().clear();
        }
    }

    public User getAssignedTo() {
        return this.assignedTo;
    }

    public void setAssignedTo(User assignedTo) {
        this.assignedTo = assignedTo;
    }

    public ProjectStatus getProjectStatus() {
        return this.projectStatus;
    }

    public void setProjectStatus(ProjectStatus projectStatus) {
        this.projectStatus = projectStatus;
    }

    public List<ProjectTask> getProjectTaskList() {
        return this.projectTaskList;
    }

    public void setProjectTaskList(List<ProjectTask> projectTaskList) {
        this.projectTaskList = projectTaskList;
    }

    public void addProjectTaskListItem(ProjectTask item) {
        if (this.getProjectTaskList() == null) {
            this.setProjectTaskList(new ArrayList());
        }
        this.getProjectTaskList().add(item);
        item.setProject(this);
    }

    public void removeProjectTaskListItem(ProjectTask item) {
        if (this.getProjectTaskList() == null) {
            return;
        }
        this.getProjectTaskList().remove(item);
    }

    public void clearProjectTaskList() {
        if (this.getProjectTaskList() != null) {
            this.getProjectTaskList().clear();
        }
    }

    public Boolean getSynchronize() {
        return this.synchronize == null ? Boolean.FALSE : this.synchronize;
    }

    public void setSynchronize(Boolean synchronize) {
        this.synchronize = synchronize;
    }

    public Boolean getExtendsMembersFromParent() {
        return this.extendsMembersFromParent == null ? Boolean.FALSE : this.extendsMembersFromParent;
    }

    public void setExtendsMembersFromParent(Boolean extendsMembersFromParent) {
        this.extendsMembersFromParent = extendsMembersFromParent;
    }

    public Project getParentProject() {
        return this.parentProject;
    }

    public void setParentProject(Project parentProject) {
        this.parentProject = parentProject;
    }

    public List<Wiki> getWikiList() {
        return this.wikiList;
    }

    public void setWikiList(List<Wiki> wikiList) {
        this.wikiList = wikiList;
    }

    public void addWikiListItem(Wiki item) {
        if (this.getWikiList() == null) {
            this.setWikiList(new ArrayList());
        }
        this.getWikiList().add(item);
        item.setProject(this);
    }

    public void removeWikiListItem(Wiki item) {
        if (this.getWikiList() == null) {
            return;
        }
        this.getWikiList().remove(item);
    }

    public void clearWikiList() {
        if (this.getWikiList() != null) {
            this.getWikiList().clear();
        }
    }

    public List<ResourceBooking> getResourceBookingList() {
        return this.resourceBookingList;
    }

    public void setResourceBookingList(List<ResourceBooking> resourceBookingList) {
        this.resourceBookingList = resourceBookingList;
    }

    public void addResourceBookingListItem(ResourceBooking item) {
        if (this.getResourceBookingList() == null) {
            this.setResourceBookingList(new ArrayList());
        }
        this.getResourceBookingList().add(item);
        item.setProject(this);
    }

    public void removeResourceBookingListItem(ResourceBooking item) {
        if (this.getResourceBookingList() == null) {
            return;
        }
        this.getResourceBookingList().remove(item);
    }

    public void clearResourceBookingList() {
        if (this.getResourceBookingList() != null) {
            this.getResourceBookingList().clear();
        }
    }

    public List<MetaJsonField> getTaskCustomFieldsList() {
        return this.taskCustomFieldsList;
    }

    public void setTaskCustomFieldsList(List<MetaJsonField> taskCustomFieldsList) {
        this.taskCustomFieldsList = taskCustomFieldsList;
    }

    public void addTaskCustomFieldsListItem(MetaJsonField item) {
        if (this.getTaskCustomFieldsList() == null) {
            this.setTaskCustomFieldsList(new ArrayList());
        }
        this.getTaskCustomFieldsList().add(item);
    }

    public void removeTaskCustomFieldsListItem(MetaJsonField item) {
        if (this.getTaskCustomFieldsList() == null) {
            return;
        }
        this.getTaskCustomFieldsList().remove(item);
    }

    public void clearTaskCustomFieldsList() {
        if (this.getTaskCustomFieldsList() != null) {
            this.getTaskCustomFieldsList().clear();
        }
    }

    public Set<User> getMembersUserSet() {
        return this.membersUserSet;
    }

    public void setMembersUserSet(Set<User> membersUserSet) {
        this.membersUserSet = membersUserSet;
    }

    public void addMembersUserSetItem(User item) {
        if (this.getMembersUserSet() == null) {
            this.setMembersUserSet(new HashSet());
        }
        this.getMembersUserSet().add(item);
    }

    public void removeMembersUserSetItem(User item) {
        if (this.getMembersUserSet() == null) {
            return;
        }
        this.getMembersUserSet().remove(item);
    }

    public void clearMembersUserSet() {
        if (this.getMembersUserSet() != null) {
            this.getMembersUserSet().clear();
        }
    }

    public Partner getClientPartner() {
        return this.clientPartner;
    }

    public void setClientPartner(Partner clientPartner) {
        this.clientPartner = clientPartner;
    }

    public Partner getContactPartner() {
        return this.contactPartner;
    }

    public void setContactPartner(Partner contactPartner) {
        this.contactPartner = contactPartner;
    }

    public LocalDateTime getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(LocalDateTime fromDate) {
        this.fromDate = fromDate;
    }

    public LocalDateTime getToDate() {
        return this.toDate;
    }

    public void setToDate(LocalDateTime toDate) {
        this.toDate = toDate;
    }

    public BigDecimal getEstimatedTimeHrs() {
        return this.estimatedTimeHrs == null ? BigDecimal.ZERO : this.estimatedTimeHrs;
    }

    public void setEstimatedTimeHrs(BigDecimal estimatedTimeHrs) {
        this.estimatedTimeHrs = estimatedTimeHrs;
    }

    public BigDecimal getTimeSpent() {
        return this.timeSpent == null ? BigDecimal.ZERO : this.timeSpent;
    }

    public void setTimeSpent(BigDecimal timeSpent) {
        this.timeSpent = timeSpent;
    }

    public BigDecimal getSequence() {
        return this.sequence == null ? BigDecimal.ZERO : this.sequence;
    }

    public void setSequence(BigDecimal sequence) {
        this.sequence = sequence;
    }

    public Integer getOrderByState() {
        return this.orderByState == null ? 0 : this.orderByState;
    }

    public void setOrderByState(Integer orderByState) {
        this.orderByState = orderByState;
    }

    public Boolean getImputable() {
        return this.imputable == null ? Boolean.FALSE : this.imputable;
    }

    public void setImputable(Boolean imputable) {
        this.imputable = imputable;
    }

    public Set<Project> getFinishToStartTaskSet() {
        return this.finishToStartTaskSet;
    }

    public void setFinishToStartTaskSet(Set<Project> finishToStartTaskSet) {
        this.finishToStartTaskSet = finishToStartTaskSet;
    }

    public void addFinishToStartTaskSetItem(Project item) {
        if (this.getFinishToStartTaskSet() == null) {
            this.setFinishToStartTaskSet(new HashSet());
        }
        this.getFinishToStartTaskSet().add(item);
    }

    public void removeFinishToStartTaskSetItem(Project item) {
        if (this.getFinishToStartTaskSet() == null) {
            return;
        }
        this.getFinishToStartTaskSet().remove(item);
    }

    public void clearFinishToStartTaskSet() {
        if (this.getFinishToStartTaskSet() != null) {
            this.getFinishToStartTaskSet().clear();
        }
    }

    public Set<Project> getStartToStartTaskSet() {
        return this.startToStartTaskSet;
    }

    public void setStartToStartTaskSet(Set<Project> startToStartTaskSet) {
        this.startToStartTaskSet = startToStartTaskSet;
    }

    public void addStartToStartTaskSetItem(Project item) {
        if (this.getStartToStartTaskSet() == null) {
            this.setStartToStartTaskSet(new HashSet());
        }
        this.getStartToStartTaskSet().add(item);
    }

    public void removeStartToStartTaskSetItem(Project item) {
        if (this.getStartToStartTaskSet() == null) {
            return;
        }
        this.getStartToStartTaskSet().remove(item);
    }

    public void clearStartToStartTaskSet() {
        if (this.getStartToStartTaskSet() != null) {
            this.getStartToStartTaskSet().clear();
        }
    }

    public Set<Project> getFinishToFinishTaskSet() {
        return this.finishToFinishTaskSet;
    }

    public void setFinishToFinishTaskSet(Set<Project> finishToFinishTaskSet) {
        this.finishToFinishTaskSet = finishToFinishTaskSet;
    }

    public void addFinishToFinishTaskSetItem(Project item) {
        if (this.getFinishToFinishTaskSet() == null) {
            this.setFinishToFinishTaskSet(new HashSet());
        }
        this.getFinishToFinishTaskSet().add(item);
    }

    public void removeFinishToFinishTaskSetItem(Project item) {
        if (this.getFinishToFinishTaskSet() == null) {
            return;
        }
        this.getFinishToFinishTaskSet().remove(item);
    }

    public void clearFinishToFinishTaskSet() {
        if (this.getFinishToFinishTaskSet() != null) {
            this.getFinishToFinishTaskSet().clear();
        }
    }

    public Set<Project> getStartToFinishTaskSet() {
        return this.startToFinishTaskSet;
    }

    public void setStartToFinishTaskSet(Set<Project> startToFinishTaskSet) {
        this.startToFinishTaskSet = startToFinishTaskSet;
    }

    public void addStartToFinishTaskSetItem(Project item) {
        if (this.getStartToFinishTaskSet() == null) {
            this.setStartToFinishTaskSet(new HashSet());
        }
        this.getStartToFinishTaskSet().add(item);
    }

    public void removeStartToFinishTaskSetItem(Project item) {
        if (this.getStartToFinishTaskSet() == null) {
            return;
        }
        this.getStartToFinishTaskSet().remove(item);
    }

    public void clearStartToFinishTaskSet() {
        if (this.getStartToFinishTaskSet() != null) {
            this.getStartToFinishTaskSet().clear();
        }
    }

    public Set<Product> getProductSet() {
        return this.productSet;
    }

    public void setProductSet(Set<Product> productSet) {
        this.productSet = productSet;
    }

    public void addProductSetItem(Product item) {
        if (this.getProductSet() == null) {
            this.setProductSet(new HashSet());
        }
        this.getProductSet().add(item);
    }

    public void removeProductSetItem(Product item) {
        if (this.getProductSet() == null) {
            return;
        }
        this.getProductSet().remove(item);
    }

    public void clearProductSet() {
        if (this.getProductSet() != null) {
            this.getProductSet().clear();
        }
    }

    public Boolean getIsShowPhasesElements() {
        return this.isShowPhasesElements == null ? Boolean.FALSE : this.isShowPhasesElements;
    }

    public void setIsShowPhasesElements(Boolean isShowPhasesElements) {
        this.isShowPhasesElements = isShowPhasesElements;
    }

    public GenProjTypePerOrderLine getGenProjTypePerOrderLine() {
        return this.genProjTypePerOrderLine;
    }

    public void setGenProjTypePerOrderLine(GenProjTypePerOrderLine genProjTypePerOrderLine) {
        this.genProjTypePerOrderLine = genProjTypePerOrderLine;
    }

    public Integer getNextProjectTaskSequence() {
        return this.nextProjectTaskSequence == null ? 0 : this.nextProjectTaskSequence;
    }

    public void setNextProjectTaskSequence(Integer nextProjectTaskSequence) {
        this.nextProjectTaskSequence = nextProjectTaskSequence;
    }

    public Boolean getIsShowStatus() {
        return this.isShowStatus == null ? Boolean.FALSE : this.isShowStatus;
    }

    public void setIsShowStatus(Boolean isShowStatus) {
        this.isShowStatus = isShowStatus;
    }

    public Set<ProjectStatus> getProjectTaskStatusSet() {
        return this.projectTaskStatusSet;
    }

    public void setProjectTaskStatusSet(Set<ProjectStatus> projectTaskStatusSet) {
        this.projectTaskStatusSet = projectTaskStatusSet;
    }

    public void addProjectTaskStatusSetItem(ProjectStatus item) {
        if (this.getProjectTaskStatusSet() == null) {
            this.setProjectTaskStatusSet(new HashSet());
        }
        this.getProjectTaskStatusSet().add(item);
    }

    public void removeProjectTaskStatusSetItem(ProjectStatus item) {
        if (this.getProjectTaskStatusSet() == null) {
            return;
        }
        this.getProjectTaskStatusSet().remove(item);
    }

    public void clearProjectTaskStatusSet() {
        if (this.getProjectTaskStatusSet() != null) {
            this.getProjectTaskStatusSet().clear();
        }
    }

    public Boolean getIsShowPriority() {
        return this.isShowPriority == null ? Boolean.FALSE : this.isShowPriority;
    }

    public void setIsShowPriority(Boolean isShowPriority) {
        this.isShowPriority = isShowPriority;
    }

    public Set<ProjectPriority> getProjectTaskPrioritySet() {
        return this.projectTaskPrioritySet;
    }

    public void setProjectTaskPrioritySet(Set<ProjectPriority> projectTaskPrioritySet) {
        this.projectTaskPrioritySet = projectTaskPrioritySet;
    }

    public void addProjectTaskPrioritySetItem(ProjectPriority item) {
        if (this.getProjectTaskPrioritySet() == null) {
            this.setProjectTaskPrioritySet(new HashSet());
        }
        this.getProjectTaskPrioritySet().add(item);
    }

    public void removeProjectTaskPrioritySetItem(ProjectPriority item) {
        if (this.getProjectTaskPrioritySet() == null) {
            return;
        }
        this.getProjectTaskPrioritySet().remove(item);
    }

    public void clearProjectTaskPrioritySet() {
        if (this.getProjectTaskPrioritySet() != null) {
            this.getProjectTaskPrioritySet().clear();
        }
    }

    public Boolean getIsShowTaskCategory() {
        return this.isShowTaskCategory == null ? Boolean.FALSE : this.isShowTaskCategory;
    }

    public void setIsShowTaskCategory(Boolean isShowTaskCategory) {
        this.isShowTaskCategory = isShowTaskCategory;
    }

    public Set<ProjectTaskCategory> getProjectTaskCategorySet() {
        return this.projectTaskCategorySet;
    }

    public void setProjectTaskCategorySet(Set<ProjectTaskCategory> projectTaskCategorySet) {
        this.projectTaskCategorySet = projectTaskCategorySet;
    }

    public void addProjectTaskCategorySetItem(ProjectTaskCategory item) {
        if (this.getProjectTaskCategorySet() == null) {
            this.setProjectTaskCategorySet(new HashSet());
        }
        this.getProjectTaskCategorySet().add(item);
    }

    public void removeProjectTaskCategorySetItem(ProjectTaskCategory item) {
        if (this.getProjectTaskCategorySet() == null) {
            return;
        }
        this.getProjectTaskCategorySet().remove(item);
    }

    public void clearProjectTaskCategorySet() {
        if (this.getProjectTaskCategorySet() != null) {
            this.getProjectTaskCategorySet().clear();
        }
    }

    public Boolean getIsShowProgress() {
        return this.isShowProgress == null ? Boolean.FALSE : this.isShowProgress;
    }

    public void setIsShowProgress(Boolean isShowProgress) {
        this.isShowProgress = isShowProgress;
    }

    public Boolean getIsShowPlanning() {
        return this.isShowPlanning == null ? Boolean.FALSE : this.isShowPlanning;
    }

    public void setIsShowPlanning(Boolean isShowPlanning) {
        this.isShowPlanning = isShowPlanning;
    }

    public Boolean getIsShowFrequency() {
        return this.isShowFrequency == null ? Boolean.FALSE : this.isShowFrequency;
    }

    public void setIsShowFrequency(Boolean isShowFrequency) {
        this.isShowFrequency = isShowFrequency;
    }

    public Boolean getIsShowTimeSpent() {
        return this.isShowTimeSpent == null ? Boolean.FALSE : this.isShowTimeSpent;
    }

    public void setIsShowTimeSpent(Boolean isShowTimeSpent) {
        this.isShowTimeSpent = isShowTimeSpent;
    }

    public Boolean getIsShowSection() {
        return this.isShowSection == null ? Boolean.FALSE : this.isShowSection;
    }

    public void setIsShowSection(Boolean isShowSection) {
        this.isShowSection = isShowSection;
    }

    public Boolean getIsShowTopic() {
        return this.isShowTopic == null ? Boolean.FALSE : this.isShowTopic;
    }

    public void setIsShowTopic(Boolean isShowTopic) {
        this.isShowTopic = isShowTopic;
    }

    public Boolean getIsShowGantt() {
        return this.isShowGantt == null ? Boolean.FALSE : this.isShowGantt;
    }

    public void setIsShowGantt(Boolean isShowGantt) {
        this.isShowGantt = isShowGantt;
    }

    public Boolean getIsShowKanbanPerStatus() {
        return this.isShowKanbanPerStatus == null ? Boolean.FALSE : this.isShowKanbanPerStatus;
    }

    public void setIsShowKanbanPerStatus(Boolean isShowKanbanPerStatus) {
        this.isShowKanbanPerStatus = isShowKanbanPerStatus;
    }

    public Boolean getIsShowKanbanPerSection() {
        return this.isShowKanbanPerSection == null ? Boolean.FALSE : this.isShowKanbanPerSection;
    }

    public void setIsShowKanbanPerSection(Boolean isShowKanbanPerSection) {
        this.isShowKanbanPerSection = isShowKanbanPerSection;
    }

    public Boolean getIsShowCalendarPerStatus() {
        return this.isShowCalendarPerStatus == null ? Boolean.FALSE : this.isShowCalendarPerStatus;
    }

    public void setIsShowCalendarPerStatus(Boolean isShowCalendarPerStatus) {
        this.isShowCalendarPerStatus = isShowCalendarPerStatus;
    }

    public Boolean getIsShowCalendarPerSection() {
        return this.isShowCalendarPerSection == null ? Boolean.FALSE : this.isShowCalendarPerSection;
    }

    public void setIsShowCalendarPerSection(Boolean isShowCalendarPerSection) {
        this.isShowCalendarPerSection = isShowCalendarPerSection;
    }

    public Boolean getIsShowCalendarPerUser() {
        return this.isShowCalendarPerUser == null ? Boolean.FALSE : this.isShowCalendarPerUser;
    }

    public void setIsShowCalendarPerUser(Boolean isShowCalendarPerUser) {
        this.isShowCalendarPerUser = isShowCalendarPerUser;
    }

    public List<TimesheetLine> getTimesheetLineList() {
        return this.timesheetLineList;
    }

    public void setTimesheetLineList(List<TimesheetLine> timesheetLineList) {
        this.timesheetLineList = timesheetLineList;
    }

    public void addTimesheetLineListItem(TimesheetLine item) {
        if (this.getTimesheetLineList() == null) {
            this.setTimesheetLineList(new ArrayList());
        }
        this.getTimesheetLineList().add(item);
        item.setProject(this);
    }

    public void removeTimesheetLineListItem(TimesheetLine item) {
        if (this.getTimesheetLineList() == null) {
            return;
        }
        this.getTimesheetLineList().remove(item);
        item.setProject(null);
    }

    public void clearTimesheetLineList() {
        if (this.getTimesheetLineList() != null) {
            for (TimesheetLine item : this.getTimesheetLineList()) {
                item.setProject(null);
            }
            this.getTimesheetLineList().clear();
        }
    }

    public BigDecimal getTotalPlannedHrs() {
        return this.totalPlannedHrs == null ? BigDecimal.ZERO : this.totalPlannedHrs;
    }

    public void setTotalPlannedHrs(BigDecimal totalPlannedHrs) {
        this.totalPlannedHrs = totalPlannedHrs;
    }

    public BigDecimal getTotalRealHrs() {
        return this.totalRealHrs == null ? BigDecimal.ZERO : this.totalRealHrs;
    }

    public void setTotalRealHrs(BigDecimal totalRealHrs) {
        this.totalRealHrs = totalRealHrs;
    }

    public Boolean getExcludeTimesheetEditor() {
        return this.excludeTimesheetEditor == null ? Boolean.FALSE : this.excludeTimesheetEditor;
    }

    public void setExcludeTimesheetEditor(Boolean excludeTimesheetEditor) {
        this.excludeTimesheetEditor = excludeTimesheetEditor;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public Integer getInvoicingSequenceSelect() {
        return this.invoicingSequenceSelect == null ? 0 : this.invoicingSequenceSelect;
    }

    public void setInvoicingSequenceSelect(Integer invoicingSequenceSelect) {
        this.invoicingSequenceSelect = invoicingSequenceSelect;
    }

    public String getInvoicingComment() {
        return this.invoicingComment;
    }

    public void setInvoicingComment(String invoicingComment) {
        this.invoicingComment = invoicingComment;
    }

    public PriceList getPriceList() {
        return this.priceList;
    }

    public void setPriceList(PriceList priceList) {
        this.priceList = priceList;
    }

    public BigDecimal getTotalTimesPlanned() {
        return this.totalTimesPlanned == null ? BigDecimal.ZERO : this.totalTimesPlanned;
    }

    public void setTotalTimesPlanned(BigDecimal totalTimesPlanned) {
        this.totalTimesPlanned = totalTimesPlanned;
    }

    public BigDecimal getTotalTimesRealised() {
        return this.totalTimesRealised == null ? BigDecimal.ZERO : this.totalTimesRealised;
    }

    public void setTotalTimesRealised(BigDecimal totalTimesRealised) {
        this.totalTimesRealised = totalTimesRealised;
    }

    public BigDecimal getTotalExpenses() {
        return this.totalExpenses == null ? BigDecimal.ZERO : this.totalExpenses;
    }

    public void setTotalExpenses(BigDecimal totalExpenses) {
        this.totalExpenses = totalExpenses;
    }

    public BigDecimal getTotalEstimatedCosts() {
        return this.totalEstimatedCosts == null ? BigDecimal.ZERO : this.totalEstimatedCosts;
    }

    public void setTotalEstimatedCosts(BigDecimal totalEstimatedCosts) {
        this.totalEstimatedCosts = totalEstimatedCosts;
    }

    public BigDecimal getTotalRealCosts() {
        return this.totalRealCosts == null ? BigDecimal.ZERO : this.totalRealCosts;
    }

    public void setTotalRealCosts(BigDecimal totalRealCosts) {
        this.totalRealCosts = totalRealCosts;
    }

    public BigDecimal getTotalProducedTurnOver() {
        return this.totalProducedTurnOver == null ? BigDecimal.ZERO : this.totalProducedTurnOver;
    }

    public void setTotalProducedTurnOver(BigDecimal totalProducedTurnOver) {
        this.totalProducedTurnOver = totalProducedTurnOver;
    }

    public BigDecimal getEstimatedMargin() {
        return this.estimatedMargin == null ? BigDecimal.ZERO : this.estimatedMargin;
    }

    public void setEstimatedMargin(BigDecimal estimatedMargin) {
        this.estimatedMargin = estimatedMargin;
    }

    public BigDecimal getRealTimesMargin() {
        return this.realTimesMargin == null ? BigDecimal.ZERO : this.realTimesMargin;
    }

    public void setRealTimesMargin(BigDecimal realTimesMargin) {
        this.realTimesMargin = realTimesMargin;
    }

    public BigDecimal getRealInvoicingMargin() {
        return this.realInvoicingMargin == null ? BigDecimal.ZERO : this.realInvoicingMargin;
    }

    public void setRealInvoicingMargin(BigDecimal realInvoicingMargin) {
        this.realInvoicingMargin = realInvoicingMargin;
    }

    public List<ManualElement> getManualElementList() {
        return this.manualElementList;
    }

    public void setManualElementList(List<ManualElement> manualElementList) {
        this.manualElementList = manualElementList;
    }

    public void addManualElementListItem(ManualElement item) {
        if (this.getManualElementList() == null) {
            this.setManualElementList(new ArrayList());
        }
        this.getManualElementList().add(item);
        item.setProject(this);
    }

    public void removeManualElementListItem(ManualElement item) {
        if (this.getManualElementList() == null) {
            return;
        }
        this.getManualElementList().remove(item);
    }

    public void clearManualElementList() {
        if (this.getManualElementList() != null) {
            this.getManualElementList().clear();
        }
    }

    public Boolean getInvoiced() {
        return this.invoiced == null ? Boolean.FALSE : this.invoiced;
    }

    public void setInvoiced(Boolean invoiced) {
        this.invoiced = invoiced;
    }

    public String getUnitOnPrinting() {
        return this.unitOnPrinting;
    }

    public void setUnitOnPrinting(String unitOnPrinting) {
        this.unitOnPrinting = unitOnPrinting;
    }

    public List<PurchaseOrderLine> getPurchaseOrderLineList() {
        return this.purchaseOrderLineList;
    }

    public void setPurchaseOrderLineList(List<PurchaseOrderLine> purchaseOrderLineList) {
        this.purchaseOrderLineList = purchaseOrderLineList;
    }

    public void addPurchaseOrderLineListItem(PurchaseOrderLine item) {
        if (this.getPurchaseOrderLineList() == null) {
            this.setPurchaseOrderLineList(new ArrayList());
        }
        this.getPurchaseOrderLineList().add(item);
        item.setProject(this);
    }

    public void removePurchaseOrderLineListItem(PurchaseOrderLine item) {
        if (this.getPurchaseOrderLineList() == null) {
            return;
        }
        this.getPurchaseOrderLineList().remove(item);
        item.setProject(null);
    }

    public void clearPurchaseOrderLineList() {
        if (this.getPurchaseOrderLineList() != null) {
            for (PurchaseOrderLine item : this.getPurchaseOrderLineList()) {
                item.setProject(null);
            }
            this.getPurchaseOrderLineList().clear();
        }
    }

    public List<SaleOrderLine> getSaleOrderLineList() {
        return this.saleOrderLineList;
    }

    public void setSaleOrderLineList(List<SaleOrderLine> saleOrderLineList) {
        this.saleOrderLineList = saleOrderLineList;
    }

    public void addSaleOrderLineListItem(SaleOrderLine item) {
        if (this.getSaleOrderLineList() == null) {
            this.setSaleOrderLineList(new ArrayList());
        }
        this.getSaleOrderLineList().add(item);
        item.setProject(this);
    }

    public void removeSaleOrderLineListItem(SaleOrderLine item) {
        if (this.getSaleOrderLineList() == null) {
            return;
        }
        this.getSaleOrderLineList().remove(item);
        item.setProject(null);
    }

    public void clearSaleOrderLineList() {
        if (this.getSaleOrderLineList() != null) {
            for (SaleOrderLine item : this.getSaleOrderLineList()) {
                item.setProject(null);
            }
            this.getSaleOrderLineList().clear();
        }
    }

    public List<ExpenseLine> getExpensesLineList() {
        return this.expensesLineList;
    }

    public void setExpensesLineList(List<ExpenseLine> expensesLineList) {
        this.expensesLineList = expensesLineList;
    }

    public void addExpensesLineListItem(ExpenseLine item) {
        if (this.getExpensesLineList() == null) {
            this.setExpensesLineList(new ArrayList());
        }
        this.getExpensesLineList().add(item);
        item.setProject(this);
    }

    public void removeExpensesLineListItem(ExpenseLine item) {
        if (this.getExpensesLineList() == null) {
            return;
        }
        this.getExpensesLineList().remove(item);
        item.setProject(null);
    }

    public void clearExpensesLineList() {
        if (this.getExpensesLineList() != null) {
            for (ExpenseLine item : this.getExpensesLineList()) {
                item.setProject(null);
            }
            this.getExpensesLineList().clear();
        }
    }

    public List<InvoiceLine> getInvoiceLineList() {
        return this.invoiceLineList;
    }

    public void setInvoiceLineList(List<InvoiceLine> invoiceLineList) {
        this.invoiceLineList = invoiceLineList;
    }

    public void addInvoiceLineListItem(InvoiceLine item) {
        if (this.getInvoiceLineList() == null) {
            this.setInvoiceLineList(new ArrayList());
        }
        this.getInvoiceLineList().add(item);
        item.setProject(this);
    }

    public void removeInvoiceLineListItem(InvoiceLine item) {
        if (this.getInvoiceLineList() == null) {
            return;
        }
        this.getInvoiceLineList().remove(item);
        item.setProject(null);
    }

    public void clearInvoiceLineList() {
        if (this.getInvoiceLineList() != null) {
            for (InvoiceLine item : this.getInvoiceLineList()) {
                item.setProject(null);
            }
            this.getInvoiceLineList().clear();
        }
    }

    public Boolean getIsBusinessProject() {
        return this.isBusinessProject == null ? Boolean.FALSE : this.isBusinessProject;
    }

    public void setIsBusinessProject(Boolean isBusinessProject) {
        this.isBusinessProject = isBusinessProject;
    }

    public Boolean getToInvoice() {
        return this.toInvoice == null ? Boolean.FALSE : this.toInvoice;
    }

    public void setToInvoice(Boolean toInvoice) {
        this.toInvoice = toInvoice;
    }

    public Boolean getIsInvoicingTimesheet() {
        return this.isInvoicingTimesheet == null ? Boolean.FALSE : this.isInvoicingTimesheet;
    }

    public void setIsInvoicingTimesheet(Boolean isInvoicingTimesheet) {
        this.isInvoicingTimesheet = isInvoicingTimesheet;
    }

    public Boolean getIsInvoicingExpenses() {
        return this.isInvoicingExpenses == null ? Boolean.FALSE : this.isInvoicingExpenses;
    }

    public void setIsInvoicingExpenses(Boolean isInvoicingExpenses) {
        this.isInvoicingExpenses = isInvoicingExpenses;
    }

    public Boolean getIsInvoicingPurchases() {
        return this.isInvoicingPurchases == null ? Boolean.FALSE : this.isInvoicingPurchases;
    }

    public void setIsInvoicingPurchases(Boolean isInvoicingPurchases) {
        this.isInvoicingPurchases = isInvoicingPurchases;
    }

    public Boolean getConsolidatePhaseWhenInvoicing() {
        return this.consolidatePhaseWhenInvoicing == null ? Boolean.FALSE : this.consolidatePhaseWhenInvoicing;
    }

    public void setConsolidatePhaseWhenInvoicing(Boolean consolidatePhaseWhenInvoicing) {
        this.consolidatePhaseWhenInvoicing = consolidatePhaseWhenInvoicing;
    }

    public Address getCustomerAddress() {
        return this.customerAddress;
    }

    public void setCustomerAddress(Address customerAddress) {
        this.customerAddress = customerAddress;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public Set<ProjectFolder> getProjectFolderSet() {
        return this.projectFolderSet;
    }

    public void setProjectFolderSet(Set<ProjectFolder> projectFolderSet) {
        this.projectFolderSet = projectFolderSet;
    }

    public void addProjectFolderSetItem(ProjectFolder item) {
        if (this.getProjectFolderSet() == null) {
            this.setProjectFolderSet(new HashSet());
        }
        this.getProjectFolderSet().add(item);
    }

    public void removeProjectFolderSetItem(ProjectFolder item) {
        if (this.getProjectFolderSet() == null) {
            return;
        }
        this.getProjectFolderSet().remove(item);
    }

    public void clearProjectFolderSet() {
        if (this.getProjectFolderSet() != null) {
            this.getProjectFolderSet().clear();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public List<ProjectAnnouncement> getAnnouncementList() {
        return this.announcementList;
    }

    public void setAnnouncementList(List<ProjectAnnouncement> announcementList) {
        this.announcementList = announcementList;
    }

    public void addAnnouncementListItem(ProjectAnnouncement item) {
        if (this.getAnnouncementList() == null) {
            this.setAnnouncementList(new ArrayList());
        }
        this.getAnnouncementList().add(item);
        item.setProject(this);
    }

    public void removeAnnouncementListItem(ProjectAnnouncement item) {
        if (this.getAnnouncementList() == null) {
            return;
        }
        this.getAnnouncementList().remove(item);
    }

    public void clearAnnouncementList() {
        if (this.getAnnouncementList() != null) {
            this.getAnnouncementList().clear();
        }
    }

    public Set<ProjectVersion> getRoadmapSet() {
        return this.roadmapSet;
    }

    public void setRoadmapSet(Set<ProjectVersion> roadmapSet) {
        this.roadmapSet = roadmapSet;
    }

    public void addRoadmapSetItem(ProjectVersion item) {
        if (this.getRoadmapSet() == null) {
            this.setRoadmapSet(new HashSet());
        }
        this.getRoadmapSet().add(item);
    }

    public void removeRoadmapSetItem(ProjectVersion item) {
        if (this.getRoadmapSet() == null) {
            return;
        }
        this.getRoadmapSet().remove(item);
    }

    public void clearRoadmapSet() {
        if (this.getRoadmapSet() != null) {
            this.getRoadmapSet().clear();
        }
    }

    public List<ProductionOrder> getProductionOrderList() {
        return this.productionOrderList;
    }

    public void setProductionOrderList(List<ProductionOrder> productionOrderList) {
        this.productionOrderList = productionOrderList;
    }

    public void addProductionOrderListItem(ProductionOrder item) {
        if (this.getProductionOrderList() == null) {
            this.setProductionOrderList(new ArrayList());
        }
        this.getProductionOrderList().add(item);
        item.setProject(this);
    }

    public void removeProductionOrderListItem(ProductionOrder item) {
        if (this.getProductionOrderList() == null) {
            return;
        }
        this.getProductionOrderList().remove(item);
    }

    public void clearProductionOrderList() {
        if (this.getProductionOrderList() != null) {
            this.getProductionOrderList().clear();
        }
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Project)) {
            return false;
        }
        Project other = (Project)obj;
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("synchronize", (Object)this.getSynchronize()).add("extendsMembersFromParent", (Object)this.getExtendsMembersFromParent()).add("fromDate", (Object)this.getFromDate()).add("toDate", (Object)this.getToDate()).add("estimatedTimeHrs", (Object)this.getEstimatedTimeHrs()).add("timeSpent", (Object)this.getTimeSpent()).add("sequence", (Object)this.getSequence()).add("orderByState", (Object)this.getOrderByState()).add("imputable", (Object)this.getImputable()).add("isShowPhasesElements", (Object)this.getIsShowPhasesElements()).add("genProjTypePerOrderLine", (Object)this.getGenProjTypePerOrderLine()).omitNullValues().toString();
    }
}

