/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.project.db;

import com.axelor.apps.project.db.ProjectTaskCategory;
import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.axelor.team.db.Team;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Table(name="PROJECT_TASK_TEMPLATE", indexes={@Index(columnList="name"), @Index(columnList="parent_task_template"), @Index(columnList="assigned_to"), @Index(columnList="team"), @Index(columnList="project_task_category")})
public class TaskTemplate
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="PROJECT_TASK_TEMPLATE_SEQ")
    @SequenceGenerator(name="PROJECT_TASK_TEMPLATE_SEQ", sequenceName="PROJECT_TASK_TEMPLATE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Name", search={"id", "name"})
    @NameColumn
    private String name;
    @Widget(title="Delay to start (Hours)")
    private BigDecimal delayToStart = new BigDecimal("0");
    @Widget(title="Duration (Hours)")
    private BigDecimal duration = BigDecimal.ZERO;
    @Widget(title="Total planned hours")
    private BigDecimal totalPlannedHrs = BigDecimal.ZERO;
    @Widget(title="Parent task")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private TaskTemplate parentTaskTemplate;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="parentTaskTemplate", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<TaskTemplate> taskTemplateList;
    @Widget(title="Assigned to")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User assignedTo;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Team team;
    private Boolean isUniqueTaskForMultipleQuantity = Boolean.FALSE;
    @Widget(title="Description")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String description;
    @Widget(title="Project task category")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ProjectTaskCategory projectTaskCategory;
    @Widget(title="Internal Description", multiline=true)
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String internalDescription;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public TaskTemplate() {
    }

    public TaskTemplate(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BigDecimal getDelayToStart() {
        return this.delayToStart == null ? BigDecimal.ZERO : this.delayToStart;
    }

    public void setDelayToStart(BigDecimal delayToStart) {
        this.delayToStart = delayToStart;
    }

    public BigDecimal getDuration() {
        return this.duration == null ? BigDecimal.ZERO : this.duration;
    }

    public void setDuration(BigDecimal duration) {
        this.duration = duration;
    }

    public BigDecimal getTotalPlannedHrs() {
        return this.totalPlannedHrs == null ? BigDecimal.ZERO : this.totalPlannedHrs;
    }

    public void setTotalPlannedHrs(BigDecimal totalPlannedHrs) {
        this.totalPlannedHrs = totalPlannedHrs;
    }

    public TaskTemplate getParentTaskTemplate() {
        return this.parentTaskTemplate;
    }

    public void setParentTaskTemplate(TaskTemplate parentTaskTemplate) {
        this.parentTaskTemplate = parentTaskTemplate;
    }

    public List<TaskTemplate> getTaskTemplateList() {
        return this.taskTemplateList;
    }

    public void setTaskTemplateList(List<TaskTemplate> taskTemplateList) {
        this.taskTemplateList = taskTemplateList;
    }

    public void addTaskTemplateListItem(TaskTemplate item) {
        if (this.getTaskTemplateList() == null) {
            this.setTaskTemplateList(new ArrayList());
        }
        this.getTaskTemplateList().add(item);
        item.setParentTaskTemplate(this);
    }

    public void removeTaskTemplateListItem(TaskTemplate item) {
        if (this.getTaskTemplateList() == null) {
            return;
        }
        this.getTaskTemplateList().remove(item);
    }

    public void clearTaskTemplateList() {
        if (this.getTaskTemplateList() != null) {
            this.getTaskTemplateList().clear();
        }
    }

    public User getAssignedTo() {
        return this.assignedTo;
    }

    public void setAssignedTo(User assignedTo) {
        this.assignedTo = assignedTo;
    }

    public Team getTeam() {
        return this.team;
    }

    public void setTeam(Team team) {
        this.team = team;
    }

    public Boolean getIsUniqueTaskForMultipleQuantity() {
        return this.isUniqueTaskForMultipleQuantity == null ? Boolean.FALSE : this.isUniqueTaskForMultipleQuantity;
    }

    public void setIsUniqueTaskForMultipleQuantity(Boolean isUniqueTaskForMultipleQuantity) {
        this.isUniqueTaskForMultipleQuantity = isUniqueTaskForMultipleQuantity;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ProjectTaskCategory getProjectTaskCategory() {
        return this.projectTaskCategory;
    }

    public void setProjectTaskCategory(ProjectTaskCategory projectTaskCategory) {
        this.projectTaskCategory = projectTaskCategory;
    }

    public String getInternalDescription() {
        return this.internalDescription;
    }

    public void setInternalDescription(String internalDescription) {
        this.internalDescription = internalDescription;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TaskTemplate)) {
            return false;
        }
        TaskTemplate other = (TaskTemplate)obj;
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("delayToStart", (Object)this.getDelayToStart()).add("duration", (Object)this.getDuration()).add("totalPlannedHrs", (Object)this.getTotalPlannedHrs()).add("isUniqueTaskForMultipleQuantity", (Object)this.getIsUniqueTaskForMultipleQuantity()).omitNullValues().toString();
    }
}

