/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.apps.account.db.Account;
import com.axelor.apps.account.db.Journal;
import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.Batch;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.db.Period;
import com.axelor.apps.base.db.TradingName;
import com.axelor.apps.base.db.Year;
import com.axelor.apps.message.db.Template;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.EqualsInclude;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Track;
import com.axelor.db.annotations.TrackEvent;
import com.axelor.db.annotations.TrackField;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="ACCOUNT_ACCOUNTING_BATCH", indexes={@Index(columnList="company"), @Index(columnList="bank_details"), @Index(columnList="currency"), @Index(columnList="payment_mode"), @Index(columnList="period"), @Index(columnList="year"), @Index(columnList="bill_of_exchange_journal"), @Index(columnList="misc_ope_journal"), @Index(columnList="research_journal"), @Index(columnList="bill_of_exhange_mail_template"), @Index(columnList="forecasted_inv_cust_account"), @Index(columnList="forecasted_inv_supp_account")})
@Track(fields={@TrackField(name="billOfExchangeTypeSelect", on={TrackEvent.UPDATE})})
public class AccountingBatch
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_ACCOUNTING_BATCH_SEQ")
    @SequenceGenerator(name="ACCOUNT_ACCOUNTING_BATCH_SEQ", sequenceName="ACCOUNT_ACCOUNTING_BATCH_SEQ", allocationSize=1)
    private Long id;
    @EqualsInclude
    @Widget(title="Code")
    @NameColumn
    @Column(unique=true)
    private String code;
    @Widget(title="Action", selection="iaccounting.batch.action.select")
    @NotNull
    private Integer actionSelect = 0;
    @Widget(title="Company")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="BBAN/IBAN to use")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private BankDetails bankDetails;
    @Widget(title="Currency")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Currency currency;
    @Widget(title="Payment Mode")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PaymentMode paymentMode;
    private LocalDate dueDate;
    private Boolean includeOtherBankAccounts = Boolean.FALSE;
    @Widget(title="Reimbursement batch type", selection="ireimbursement.batch.type.select")
    private Integer reimbursementTypeSelect = 0;
    @Widget(title="Treatment/Operation type", selection="ireimbursement.batch.export.type.select")
    private Integer reimbursementExportTypeSelect = 0;
    @Widget(title="Debt recovery batch type", selection="idebt.recovery.batch.type.select")
    private Integer debtRecoveryTypeSelect = 0;
    @Widget(title="Manage debt recovery by trading name", help="Enable debt recoveries being handled by trading name. If enabled with no trading name selected, all trading names will be considered selected.")
    private Boolean isDebtRecoveryByTradingName = Boolean.FALSE;
    @Widget(title="Selected trading names")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<TradingName> tradingNameSet;
    @Widget(title="Customer balance")
    private Boolean updateCustAccountOk = Boolean.FALSE;
    @Widget(title="Due balance")
    private Boolean updateDueCustAccountOk = Boolean.FALSE;
    @Widget(title="Due balance recoverable")
    private Boolean updateDueDebtRecoveryCustAccountOk = Boolean.FALSE;
    @Widget(title="Export type", selection="accounting.report.type.select.export")
    private Integer moveLineExportTypeSelect = 0;
    @Widget(title="Start date")
    private LocalDate startDate;
    @Widget(title="End date")
    private LocalDate endDate;
    @Widget(title="Description")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String description;
    @Widget(title="Batchs")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="accountingBatch", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<Batch> batchList;
    @Widget(title="Credit Transfer batch type", selection="iaccount.account.batch.transfer.type.select")
    private Integer creditTransferTypeSelect = 0;
    @Widget(title="Period")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Period period;
    @Widget(title="Customer reimbursement type", selection="iaccount.account.batch.transfer.customer.reimbursement.type.select")
    @NotNull
    private Integer customerReimbursementTypeSelect = 1;
    @Widget(title="Open the year accounts")
    private Boolean openYear = Boolean.FALSE;
    @Widget(title="Close the year accounts")
    private Boolean closeYear = Boolean.FALSE;
    @Widget(title="Year")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Year year;
    @Widget(title="Closure accounts")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Account> closureAccountSet;
    @Widget(title="Opening accounts")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Account> openingAccountSet;
    @Widget(title="Generate result move")
    private Boolean generateResultMove = Boolean.FALSE;
    @Widget(title="Include special accounts")
    private Boolean includeSpecialAccounts = Boolean.FALSE;
    @Widget(title="Result move description")
    private String resultMoveDescription;
    @Widget(title="Generate simulated moves", help="Please make sure that the journal configured for annual closure and openning, does support simulated moves.")
    private Boolean simulateGeneratedMoves = Boolean.FALSE;
    @Widget(title="Generate general ledger")
    private Boolean generateGeneralLedger = Boolean.FALSE;
    @Widget(title="Allocate per partner")
    private Boolean allocatePerPartner = Boolean.FALSE;
    @Widget(title="Move description")
    private String moveDescription;
    @Widget(title="Update all realized fixed asset lines")
    private Boolean updateAllRealizedFixedAssetLines = Boolean.FALSE;
    @Widget(title="Bill of exchange type", selection="iaccount.account.batch.bill.of.exchange.type.select")
    private Integer billOfExchangeTypeSelect = 0;
    @Widget(title="Bill of exchange journal")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Journal billOfExchangeJournal;
    @Widget(title="Years")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Year> yearSet;
    @Widget(title="Type", selection="accounting.batch.accounting.cut.off.type.select")
    private Integer accountingCutOffTypeSelect = 0;
    @Widget(title="Move date")
    private LocalDate moveDate;
    @Widget(title="Reverse move date")
    private LocalDate reverseMoveDate;
    @Widget(title="Recovered tax")
    private Boolean recoveredTax = Boolean.FALSE;
    @Widget(title="A.T.I.")
    private Boolean ati = Boolean.FALSE;
    @Widget(title="Reverse move description")
    private String reverseMoveDescription;
    @Widget(title="Include not stock managed product")
    private Boolean includeNotStockManagedProduct = Boolean.FALSE;
    @Widget(title="Automatic reverse")
    private Boolean automaticReverse = Boolean.FALSE;
    @Widget(title="Automatic reconcile")
    private Boolean automaticReconcile = Boolean.FALSE;
    @Widget(title="Misc. Operation Journal")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Journal miscOpeJournal;
    @Widget(title="Research Journal")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Journal researchJournal;
    @Widget(title="Cut off moves status", selection="iaccount.move.status.select")
    private Integer cutOffMoveStatusSelect = 1;
    @Widget(title="Preview records to process")
    private Boolean previewRecordsToProcess = Boolean.FALSE;
    @Widget(title="Prefix for accounting voucher")
    private String prefixOrigin;
    @Widget(title="Direct debit data type", selection="iaccount.account.batch.direct.debit.data.type.select")
    private Integer directDebitDataTypeSelect = 1;
    @Widget(title="Batch step", selection="bankpayment.account.batch.bill.of.exchange.step.batch.select")
    private Integer billOfExchangeStepBatchSelect = 0;
    @Widget(title="Bill of exchange data type", selection="bankpayment.account.batch.bill.of.exchange.data.type.select")
    private Integer billOfExchangeDataTypeSelect = 0;
    @Widget(title="Template")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Template billOfExhangeMailTemplate;
    @Widget(title="Forecasted invoice customer account")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Account forecastedInvCustAccount;
    @Widget(title="Forecasted invoice supplier account")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Account forecastedInvSuppAccount;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public AccountingBatch() {
    }

    public AccountingBatch(String code) {
        this.code = code;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Integer getActionSelect() {
        return this.actionSelect == null ? 0 : this.actionSelect;
    }

    public void setActionSelect(Integer actionSelect) {
        this.actionSelect = actionSelect;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public BankDetails getBankDetails() {
        return this.bankDetails;
    }

    public void setBankDetails(BankDetails bankDetails) {
        this.bankDetails = bankDetails;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public PaymentMode getPaymentMode() {
        return this.paymentMode;
    }

    public void setPaymentMode(PaymentMode paymentMode) {
        this.paymentMode = paymentMode;
    }

    public LocalDate getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(LocalDate dueDate) {
        this.dueDate = dueDate;
    }

    public Boolean getIncludeOtherBankAccounts() {
        return this.includeOtherBankAccounts == null ? Boolean.FALSE : this.includeOtherBankAccounts;
    }

    public void setIncludeOtherBankAccounts(Boolean includeOtherBankAccounts) {
        this.includeOtherBankAccounts = includeOtherBankAccounts;
    }

    public Integer getReimbursementTypeSelect() {
        return this.reimbursementTypeSelect == null ? 0 : this.reimbursementTypeSelect;
    }

    public void setReimbursementTypeSelect(Integer reimbursementTypeSelect) {
        this.reimbursementTypeSelect = reimbursementTypeSelect;
    }

    public Integer getReimbursementExportTypeSelect() {
        return this.reimbursementExportTypeSelect == null ? 0 : this.reimbursementExportTypeSelect;
    }

    public void setReimbursementExportTypeSelect(Integer reimbursementExportTypeSelect) {
        this.reimbursementExportTypeSelect = reimbursementExportTypeSelect;
    }

    public Integer getDebtRecoveryTypeSelect() {
        return this.debtRecoveryTypeSelect == null ? 0 : this.debtRecoveryTypeSelect;
    }

    public void setDebtRecoveryTypeSelect(Integer debtRecoveryTypeSelect) {
        this.debtRecoveryTypeSelect = debtRecoveryTypeSelect;
    }

    public Boolean getIsDebtRecoveryByTradingName() {
        return this.isDebtRecoveryByTradingName == null ? Boolean.FALSE : this.isDebtRecoveryByTradingName;
    }

    public void setIsDebtRecoveryByTradingName(Boolean isDebtRecoveryByTradingName) {
        this.isDebtRecoveryByTradingName = isDebtRecoveryByTradingName;
    }

    public Set<TradingName> getTradingNameSet() {
        return this.tradingNameSet;
    }

    public void setTradingNameSet(Set<TradingName> tradingNameSet) {
        this.tradingNameSet = tradingNameSet;
    }

    public void addTradingNameSetItem(TradingName item) {
        if (this.getTradingNameSet() == null) {
            this.setTradingNameSet(new HashSet());
        }
        this.getTradingNameSet().add(item);
    }

    public void removeTradingNameSetItem(TradingName item) {
        if (this.getTradingNameSet() == null) {
            return;
        }
        this.getTradingNameSet().remove(item);
    }

    public void clearTradingNameSet() {
        if (this.getTradingNameSet() != null) {
            this.getTradingNameSet().clear();
        }
    }

    public Boolean getUpdateCustAccountOk() {
        return this.updateCustAccountOk == null ? Boolean.FALSE : this.updateCustAccountOk;
    }

    public void setUpdateCustAccountOk(Boolean updateCustAccountOk) {
        this.updateCustAccountOk = updateCustAccountOk;
    }

    public Boolean getUpdateDueCustAccountOk() {
        return this.updateDueCustAccountOk == null ? Boolean.FALSE : this.updateDueCustAccountOk;
    }

    public void setUpdateDueCustAccountOk(Boolean updateDueCustAccountOk) {
        this.updateDueCustAccountOk = updateDueCustAccountOk;
    }

    public Boolean getUpdateDueDebtRecoveryCustAccountOk() {
        return this.updateDueDebtRecoveryCustAccountOk == null ? Boolean.FALSE : this.updateDueDebtRecoveryCustAccountOk;
    }

    public void setUpdateDueDebtRecoveryCustAccountOk(Boolean updateDueDebtRecoveryCustAccountOk) {
        this.updateDueDebtRecoveryCustAccountOk = updateDueDebtRecoveryCustAccountOk;
    }

    public Integer getMoveLineExportTypeSelect() {
        return this.moveLineExportTypeSelect == null ? 0 : this.moveLineExportTypeSelect;
    }

    public void setMoveLineExportTypeSelect(Integer moveLineExportTypeSelect) {
        this.moveLineExportTypeSelect = moveLineExportTypeSelect;
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<Batch> getBatchList() {
        return this.batchList;
    }

    public void setBatchList(List<Batch> batchList) {
        this.batchList = batchList;
    }

    public void addBatchListItem(Batch item) {
        if (this.getBatchList() == null) {
            this.setBatchList(new ArrayList());
        }
        this.getBatchList().add(item);
        item.setAccountingBatch(this);
    }

    public void removeBatchListItem(Batch item) {
        if (this.getBatchList() == null) {
            return;
        }
        this.getBatchList().remove(item);
    }

    public void clearBatchList() {
        if (this.getBatchList() != null) {
            this.getBatchList().clear();
        }
    }

    public Integer getCreditTransferTypeSelect() {
        return this.creditTransferTypeSelect == null ? 0 : this.creditTransferTypeSelect;
    }

    public void setCreditTransferTypeSelect(Integer creditTransferTypeSelect) {
        this.creditTransferTypeSelect = creditTransferTypeSelect;
    }

    public Period getPeriod() {
        return this.period;
    }

    public void setPeriod(Period period) {
        this.period = period;
    }

    public Integer getCustomerReimbursementTypeSelect() {
        return this.customerReimbursementTypeSelect == null ? 0 : this.customerReimbursementTypeSelect;
    }

    public void setCustomerReimbursementTypeSelect(Integer customerReimbursementTypeSelect) {
        this.customerReimbursementTypeSelect = customerReimbursementTypeSelect;
    }

    public Boolean getOpenYear() {
        return this.openYear == null ? Boolean.FALSE : this.openYear;
    }

    public void setOpenYear(Boolean openYear) {
        this.openYear = openYear;
    }

    public Boolean getCloseYear() {
        return this.closeYear == null ? Boolean.FALSE : this.closeYear;
    }

    public void setCloseYear(Boolean closeYear) {
        this.closeYear = closeYear;
    }

    public Year getYear() {
        return this.year;
    }

    public void setYear(Year year) {
        this.year = year;
    }

    public Set<Account> getClosureAccountSet() {
        return this.closureAccountSet;
    }

    public void setClosureAccountSet(Set<Account> closureAccountSet) {
        this.closureAccountSet = closureAccountSet;
    }

    public void addClosureAccountSetItem(Account item) {
        if (this.getClosureAccountSet() == null) {
            this.setClosureAccountSet(new HashSet());
        }
        this.getClosureAccountSet().add(item);
    }

    public void removeClosureAccountSetItem(Account item) {
        if (this.getClosureAccountSet() == null) {
            return;
        }
        this.getClosureAccountSet().remove(item);
    }

    public void clearClosureAccountSet() {
        if (this.getClosureAccountSet() != null) {
            this.getClosureAccountSet().clear();
        }
    }

    public Set<Account> getOpeningAccountSet() {
        return this.openingAccountSet;
    }

    public void setOpeningAccountSet(Set<Account> openingAccountSet) {
        this.openingAccountSet = openingAccountSet;
    }

    public void addOpeningAccountSetItem(Account item) {
        if (this.getOpeningAccountSet() == null) {
            this.setOpeningAccountSet(new HashSet());
        }
        this.getOpeningAccountSet().add(item);
    }

    public void removeOpeningAccountSetItem(Account item) {
        if (this.getOpeningAccountSet() == null) {
            return;
        }
        this.getOpeningAccountSet().remove(item);
    }

    public void clearOpeningAccountSet() {
        if (this.getOpeningAccountSet() != null) {
            this.getOpeningAccountSet().clear();
        }
    }

    public Boolean getGenerateResultMove() {
        return this.generateResultMove == null ? Boolean.FALSE : this.generateResultMove;
    }

    public void setGenerateResultMove(Boolean generateResultMove) {
        this.generateResultMove = generateResultMove;
    }

    public Boolean getIncludeSpecialAccounts() {
        return this.includeSpecialAccounts == null ? Boolean.FALSE : this.includeSpecialAccounts;
    }

    public void setIncludeSpecialAccounts(Boolean includeSpecialAccounts) {
        this.includeSpecialAccounts = includeSpecialAccounts;
    }

    public String getResultMoveDescription() {
        return this.resultMoveDescription;
    }

    public void setResultMoveDescription(String resultMoveDescription) {
        this.resultMoveDescription = resultMoveDescription;
    }

    public Boolean getSimulateGeneratedMoves() {
        return this.simulateGeneratedMoves == null ? Boolean.FALSE : this.simulateGeneratedMoves;
    }

    public void setSimulateGeneratedMoves(Boolean simulateGeneratedMoves) {
        this.simulateGeneratedMoves = simulateGeneratedMoves;
    }

    public Boolean getGenerateGeneralLedger() {
        return this.generateGeneralLedger == null ? Boolean.FALSE : this.generateGeneralLedger;
    }

    public void setGenerateGeneralLedger(Boolean generateGeneralLedger) {
        this.generateGeneralLedger = generateGeneralLedger;
    }

    public Boolean getAllocatePerPartner() {
        return this.allocatePerPartner == null ? Boolean.FALSE : this.allocatePerPartner;
    }

    public void setAllocatePerPartner(Boolean allocatePerPartner) {
        this.allocatePerPartner = allocatePerPartner;
    }

    public String getMoveDescription() {
        return this.moveDescription;
    }

    public void setMoveDescription(String moveDescription) {
        this.moveDescription = moveDescription;
    }

    public Boolean getUpdateAllRealizedFixedAssetLines() {
        return this.updateAllRealizedFixedAssetLines == null ? Boolean.FALSE : this.updateAllRealizedFixedAssetLines;
    }

    public void setUpdateAllRealizedFixedAssetLines(Boolean updateAllRealizedFixedAssetLines) {
        this.updateAllRealizedFixedAssetLines = updateAllRealizedFixedAssetLines;
    }

    public Integer getBillOfExchangeTypeSelect() {
        return this.billOfExchangeTypeSelect == null ? 0 : this.billOfExchangeTypeSelect;
    }

    public void setBillOfExchangeTypeSelect(Integer billOfExchangeTypeSelect) {
        this.billOfExchangeTypeSelect = billOfExchangeTypeSelect;
    }

    public Journal getBillOfExchangeJournal() {
        return this.billOfExchangeJournal;
    }

    public void setBillOfExchangeJournal(Journal billOfExchangeJournal) {
        this.billOfExchangeJournal = billOfExchangeJournal;
    }

    public Set<Year> getYearSet() {
        return this.yearSet;
    }

    public void setYearSet(Set<Year> yearSet) {
        this.yearSet = yearSet;
    }

    public void addYearSetItem(Year item) {
        if (this.getYearSet() == null) {
            this.setYearSet(new HashSet());
        }
        this.getYearSet().add(item);
    }

    public void removeYearSetItem(Year item) {
        if (this.getYearSet() == null) {
            return;
        }
        this.getYearSet().remove(item);
    }

    public void clearYearSet() {
        if (this.getYearSet() != null) {
            this.getYearSet().clear();
        }
    }

    public Integer getAccountingCutOffTypeSelect() {
        return this.accountingCutOffTypeSelect == null ? 0 : this.accountingCutOffTypeSelect;
    }

    public void setAccountingCutOffTypeSelect(Integer accountingCutOffTypeSelect) {
        this.accountingCutOffTypeSelect = accountingCutOffTypeSelect;
    }

    public LocalDate getMoveDate() {
        return this.moveDate;
    }

    public void setMoveDate(LocalDate moveDate) {
        this.moveDate = moveDate;
    }

    public LocalDate getReverseMoveDate() {
        return this.reverseMoveDate;
    }

    public void setReverseMoveDate(LocalDate reverseMoveDate) {
        this.reverseMoveDate = reverseMoveDate;
    }

    public Boolean getRecoveredTax() {
        return this.recoveredTax == null ? Boolean.FALSE : this.recoveredTax;
    }

    public void setRecoveredTax(Boolean recoveredTax) {
        this.recoveredTax = recoveredTax;
    }

    public Boolean getAti() {
        return this.ati == null ? Boolean.FALSE : this.ati;
    }

    public void setAti(Boolean ati) {
        this.ati = ati;
    }

    public String getReverseMoveDescription() {
        return this.reverseMoveDescription;
    }

    public void setReverseMoveDescription(String reverseMoveDescription) {
        this.reverseMoveDescription = reverseMoveDescription;
    }

    public Boolean getIncludeNotStockManagedProduct() {
        return this.includeNotStockManagedProduct == null ? Boolean.FALSE : this.includeNotStockManagedProduct;
    }

    public void setIncludeNotStockManagedProduct(Boolean includeNotStockManagedProduct) {
        this.includeNotStockManagedProduct = includeNotStockManagedProduct;
    }

    public Boolean getAutomaticReverse() {
        return this.automaticReverse == null ? Boolean.FALSE : this.automaticReverse;
    }

    public void setAutomaticReverse(Boolean automaticReverse) {
        this.automaticReverse = automaticReverse;
    }

    public Boolean getAutomaticReconcile() {
        return this.automaticReconcile == null ? Boolean.FALSE : this.automaticReconcile;
    }

    public void setAutomaticReconcile(Boolean automaticReconcile) {
        this.automaticReconcile = automaticReconcile;
    }

    public Journal getMiscOpeJournal() {
        return this.miscOpeJournal;
    }

    public void setMiscOpeJournal(Journal miscOpeJournal) {
        this.miscOpeJournal = miscOpeJournal;
    }

    public Journal getResearchJournal() {
        return this.researchJournal;
    }

    public void setResearchJournal(Journal researchJournal) {
        this.researchJournal = researchJournal;
    }

    public Integer getCutOffMoveStatusSelect() {
        return this.cutOffMoveStatusSelect == null ? 0 : this.cutOffMoveStatusSelect;
    }

    public void setCutOffMoveStatusSelect(Integer cutOffMoveStatusSelect) {
        this.cutOffMoveStatusSelect = cutOffMoveStatusSelect;
    }

    public Boolean getPreviewRecordsToProcess() {
        return this.previewRecordsToProcess == null ? Boolean.FALSE : this.previewRecordsToProcess;
    }

    public void setPreviewRecordsToProcess(Boolean previewRecordsToProcess) {
        this.previewRecordsToProcess = previewRecordsToProcess;
    }

    public String getPrefixOrigin() {
        return this.prefixOrigin;
    }

    public void setPrefixOrigin(String prefixOrigin) {
        this.prefixOrigin = prefixOrigin;
    }

    public Integer getDirectDebitDataTypeSelect() {
        return this.directDebitDataTypeSelect == null ? 0 : this.directDebitDataTypeSelect;
    }

    public void setDirectDebitDataTypeSelect(Integer directDebitDataTypeSelect) {
        this.directDebitDataTypeSelect = directDebitDataTypeSelect;
    }

    public Integer getBillOfExchangeStepBatchSelect() {
        return this.billOfExchangeStepBatchSelect == null ? 0 : this.billOfExchangeStepBatchSelect;
    }

    public void setBillOfExchangeStepBatchSelect(Integer billOfExchangeStepBatchSelect) {
        this.billOfExchangeStepBatchSelect = billOfExchangeStepBatchSelect;
    }

    public Integer getBillOfExchangeDataTypeSelect() {
        return this.billOfExchangeDataTypeSelect == null ? 0 : this.billOfExchangeDataTypeSelect;
    }

    public void setBillOfExchangeDataTypeSelect(Integer billOfExchangeDataTypeSelect) {
        this.billOfExchangeDataTypeSelect = billOfExchangeDataTypeSelect;
    }

    public Template getBillOfExhangeMailTemplate() {
        return this.billOfExhangeMailTemplate;
    }

    public void setBillOfExhangeMailTemplate(Template billOfExhangeMailTemplate) {
        this.billOfExhangeMailTemplate = billOfExhangeMailTemplate;
    }

    public Account getForecastedInvCustAccount() {
        return this.forecastedInvCustAccount;
    }

    public void setForecastedInvCustAccount(Account forecastedInvCustAccount) {
        this.forecastedInvCustAccount = forecastedInvCustAccount;
    }

    public Account getForecastedInvSuppAccount() {
        return this.forecastedInvSuppAccount;
    }

    public void setForecastedInvSuppAccount(Account forecastedInvSuppAccount) {
        this.forecastedInvSuppAccount = forecastedInvSuppAccount;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AccountingBatch)) {
            return false;
        }
        AccountingBatch other = (AccountingBatch)obj;
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return Objects.equals(this.getCode(), other.getCode()) && this.getCode() != null;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("code", (Object)this.getCode()).add("actionSelect", (Object)this.getActionSelect()).add("dueDate", (Object)this.getDueDate()).add("includeOtherBankAccounts", (Object)this.getIncludeOtherBankAccounts()).add("reimbursementTypeSelect", (Object)this.getReimbursementTypeSelect()).add("reimbursementExportTypeSelect", (Object)this.getReimbursementExportTypeSelect()).add("debtRecoveryTypeSelect", (Object)this.getDebtRecoveryTypeSelect()).add("isDebtRecoveryByTradingName", (Object)this.getIsDebtRecoveryByTradingName()).add("updateCustAccountOk", (Object)this.getUpdateCustAccountOk()).add("updateDueCustAccountOk", (Object)this.getUpdateDueCustAccountOk()).add("updateDueDebtRecoveryCustAccountOk", (Object)this.getUpdateDueDebtRecoveryCustAccountOk()).omitNullValues().toString();
    }
}

