/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.apps.account.db.Account;
import com.axelor.apps.account.db.AccountClearance;
import com.axelor.apps.account.db.AnalyticAccount;
import com.axelor.apps.account.db.AnalyticDistributionTemplate;
import com.axelor.apps.account.db.AnalyticMoveLine;
import com.axelor.apps.account.db.FinancialDiscount;
import com.axelor.apps.account.db.FixedAssetCategory;
import com.axelor.apps.account.db.InterbankCodeLine;
import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoiceTerm;
import com.axelor.apps.account.db.ManagementObject;
import com.axelor.apps.account.db.Move;
import com.axelor.apps.account.db.PaymentScheduleLine;
import com.axelor.apps.account.db.Reconcile;
import com.axelor.apps.account.db.ReconcileGroup;
import com.axelor.apps.account.db.TaxEquiv;
import com.axelor.apps.account.db.TaxLine;
import com.axelor.apps.account.db.TaxPaymentMoveLine;
import com.axelor.apps.account.db.repo.AnalyticLine;
import com.axelor.apps.base.db.Partner;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Track;
import com.axelor.db.annotations.TrackEvent;
import com.axelor.db.annotations.TrackField;
import com.axelor.db.annotations.TrackMessage;
import com.axelor.db.annotations.VirtualColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@DynamicInsert
@DynamicUpdate
@Table(name="ACCOUNT_MOVE_LINE", indexes={@Index(columnList="move"), @Index(columnList="partner"), @Index(columnList="account"), @Index(columnList="invoice_reject"), @Index(columnList="interbank_code_line"), @Index(columnList="tax_line"), @Index(columnList="tax_line_before_reverse"), @Index(columnList="source_tax_line"), @Index(columnList="tax_equiv"), @Index(columnList="fixed_asset_category"), @Index(columnList="payment_schedule_line"), @Index(columnList="account_clearance"), @Index(columnList="management_object"), @Index(columnList="analytic_distribution_template"), @Index(columnList="reconcile_group"), @Index(columnList="name"), @Index(columnList="axis1analytic_account"), @Index(columnList="axis2analytic_account"), @Index(columnList="axis3analytic_account"), @Index(columnList="axis4analytic_account"), @Index(columnList="axis5analytic_account"), @Index(columnList="financial_discount")})
@Track(fields={@TrackField(name="date"), @TrackField(name="partner"), @TrackField(name="account"), @TrackField(name="debit"), @TrackField(name="credit"), @TrackField(name="origin"), @TrackField(name="description"), @TrackField(name="vatSystemSelect")}, messages={@TrackMessage(message="Move line created", condition="true", on={TrackEvent.CREATE})})
public class MoveLine
extends AuditableModel
implements AnalyticLine {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_MOVE_LINE_SEQ")
    @SequenceGenerator(name="ACCOUNT_MOVE_LINE_SEQ", sequenceName="ACCOUNT_MOVE_LINE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Move")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Move move;
    @Widget(title="Partner")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner partner;
    @Widget(title="Accounting.Account")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Account account;
    @Widget(title="Date")
    @Column(name="date_val")
    private LocalDate date;
    @Widget(title="Due Date")
    private LocalDate dueDate;
    @Widget(title="From date")
    private LocalDate cutOffStartDate;
    @Widget(title="To date")
    private LocalDate cutOffEndDate;
    private Boolean isCutOffGenerated = Boolean.FALSE;
    @Widget(title="Line Nbr.")
    private Integer counter = 0;
    @Widget(title="Debit")
    private BigDecimal debit = BigDecimal.ZERO;
    @Widget(title="Credit")
    private BigDecimal credit = BigDecimal.ZERO;
    @Widget(title="Description")
    private String description;
    @Widget(title="moveLine.origin")
    private String origin;
    @Widget(title="Debit Reconcile list", readonly=false)
    @OneToMany(fetch=FetchType.LAZY, mappedBy="debitMoveLine", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private List<Reconcile> debitReconcileList;
    @Widget(title="Credit Reconcile List", readonly=false)
    @OneToMany(fetch=FetchType.LAZY, mappedBy="creditMoveLine", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private List<Reconcile> creditReconcileList;
    @Widget(title="MoveLine.amountReconciled", readonly=true)
    private BigDecimal amountPaid = new BigDecimal("0.0");
    @Widget(title="Invoice rejected")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Invoice invoiceReject;
    @Widget(title="Exported Direct Debit")
    private Boolean exportedDirectDebitOk = Boolean.FALSE;
    @Widget(title="Rejection reason")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private InterbankCodeLine interbankCodeLine;
    @Widget(title="Reimbursement status", selection="move.line.reimbursement.status.select")
    private Integer reimbursementStatusSelect = 0;
    @Widget(title="Doubtful Shift Reason", readonly=true)
    private String passageReason;
    @Widget(title="Transfer(ed) to Usher")
    private Boolean usherPassageOk = Boolean.FALSE;
    @Widget(title="Tax")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private TaxLine taxLine;
    @Widget(title="Tax")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private TaxLine taxLineBeforeReverse;
    @Widget(title="Source Tax")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private TaxLine sourceTaxLine;
    @Widget(title="Tax Equiv")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private TaxEquiv taxEquiv;
    @Widget(title="Currency Rate")
    @Digits(integer=15, fraction=5)
    private BigDecimal currencyRate = BigDecimal.ZERO;
    @Widget(title="Amount in move currency")
    private BigDecimal currencyAmount = BigDecimal.ZERO;
    @Widget(title="Posted number")
    private String postedNbr;
    @Widget(title="Fixed asset category", help="If this field is filled, once the move will change from Draft to Accounted, a new fixed asset record will be generated based on this moveLine data and the selected category data")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private FixedAssetCategory fixedAssetCategory;
    @Widget(title="Max Amount to reconcile")
    private BigDecimal maxAmountToReconcile = BigDecimal.ZERO;
    @Widget(title="Payment Schedule line")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PaymentScheduleLine paymentScheduleLine;
    @Widget(title="Amount exported for direct debit")
    private BigDecimal amountExportedInDirectDebit = BigDecimal.ZERO;
    @Widget(title="Account clearance")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AccountClearance accountClearance;
    @Widget(title="Irrecoverable status", readonly=true, selection="iaccount.account.schedule.irrecoverable.status.select")
    private Integer irrecoverableStatusSelect = 0;
    @Widget(title="Irrecoverable shift reason")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ManagementObject managementObject;
    @Widget(title="Analytic distribution lines")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="moveLine", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<AnalyticMoveLine> analyticMoveLineList;
    @Widget(title="Analytic distribution template")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AnalyticDistributionTemplate analyticDistributionTemplate;
    private Boolean isOtherCurrency = Boolean.FALSE;
    @Widget(readonly=true)
    private String accountCode;
    @Widget(readonly=true)
    private String accountName;
    @Widget(readonly=true)
    private String partnerFullName;
    @Widget(readonly=true)
    private String partnerSeq;
    private Long partnerId = 0L;
    private Long accountId = 0L;
    @Widget(readonly=true)
    @Digits(integer=10, fraction=10)
    private BigDecimal taxRate = BigDecimal.ZERO;
    @Widget(readonly=true)
    private String taxCode;
    @Widget(title="Selected")
    private Boolean isSelectedBankReconciliation = Boolean.FALSE;
    @Widget(title="Tax amount", readonly=true)
    @Digits(integer=18, fraction=2)
    private BigDecimal taxAmount = BigDecimal.ZERO;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="moveLine", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<TaxPaymentMoveLine> taxPaymentMoveLineList;
    @Widget(title="Reconcile Group")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ReconcileGroup reconcileGroup;
    @Widget(title="Origin date")
    private LocalDate originDate;
    @Widget(title="Invoice terms")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="moveLine", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<InvoiceTerm> invoiceTermList;
    @Widget(title="Name")
    @NameColumn
    @VirtualColumn
    @Access(value=AccessType.PROPERTY)
    private String name;
    @Widget(title="To pay / To use")
    @VirtualColumn
    @Access(value=AccessType.PROPERTY)
    private BigDecimal amountRemaining = BigDecimal.ZERO;
    @VirtualColumn
    @Transient
    private BigDecimal lineAmount = BigDecimal.ZERO;
    @Widget(title="Cpte Ana. AXIS1")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AnalyticAccount axis1AnalyticAccount;
    @Widget(title="Cpte Ana. AXIS2")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AnalyticAccount axis2AnalyticAccount;
    @Widget(title="Cpte Ana. AXIS3")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AnalyticAccount axis3AnalyticAccount;
    @Widget(title="Cpte Ana. AXIS4")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AnalyticAccount axis4AnalyticAccount;
    @Widget(title="Cpte Ana. AXIS5")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AnalyticAccount axis5AnalyticAccount;
    @Widget(title="VAT System", selection="iaccount.vat.system.moveline.select")
    private Integer vatSystemSelect = 0;
    @Widget(title="Financial discount")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private FinancialDiscount financialDiscount;
    @Widget(title="Financial discount rate")
    private BigDecimal financialDiscountRate = BigDecimal.ZERO;
    @Widget(title="Financial discount total amount")
    private BigDecimal financialDiscountTotalAmount = BigDecimal.ZERO;
    @Widget(title="Remaining amount after Fin. discount")
    private BigDecimal remainingAmountAfterFinDiscount = BigDecimal.ZERO;
    private String companyCode;
    private String companyName;
    private String journalCode;
    private String journalName;
    private String currencyCode;
    private String companyCurrencyCode;
    private String fiscalYearCode;
    private LocalDate accountingDate;
    private Boolean adjustingMove = Boolean.FALSE;
    @Widget(title="Bank reconciled amount")
    private BigDecimal bankReconciledAmount = BigDecimal.ZERO;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public MoveLine() {
    }

    public MoveLine(Move move, Partner partner, Account account, LocalDate date, LocalDate dueDate, Integer counter, BigDecimal debit, BigDecimal credit, String description, String origin, BigDecimal currencyRate, BigDecimal currencyAmount, LocalDate originDate) {
        this.move = move;
        this.partner = partner;
        this.account = account;
        this.date = date;
        this.dueDate = dueDate;
        this.counter = counter;
        this.debit = debit;
        this.credit = credit;
        this.description = description;
        this.origin = origin;
        this.currencyRate = currencyRate;
        this.currencyAmount = currencyAmount;
        this.originDate = originDate;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Move getMove() {
        return this.move;
    }

    public void setMove(Move move) {
        this.move = move;
    }

    public Partner getPartner() {
        return this.partner;
    }

    public void setPartner(Partner partner) {
        this.partner = partner;
    }

    public Account getAccount() {
        return this.account;
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public LocalDate getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(LocalDate dueDate) {
        this.dueDate = dueDate;
    }

    public LocalDate getCutOffStartDate() {
        return this.cutOffStartDate;
    }

    public void setCutOffStartDate(LocalDate cutOffStartDate) {
        this.cutOffStartDate = cutOffStartDate;
    }

    public LocalDate getCutOffEndDate() {
        return this.cutOffEndDate;
    }

    public void setCutOffEndDate(LocalDate cutOffEndDate) {
        this.cutOffEndDate = cutOffEndDate;
    }

    public Boolean getIsCutOffGenerated() {
        return this.isCutOffGenerated == null ? Boolean.FALSE : this.isCutOffGenerated;
    }

    public void setIsCutOffGenerated(Boolean isCutOffGenerated) {
        this.isCutOffGenerated = isCutOffGenerated;
    }

    public Integer getCounter() {
        return this.counter == null ? 0 : this.counter;
    }

    public void setCounter(Integer counter) {
        this.counter = counter;
    }

    public BigDecimal getDebit() {
        return this.debit == null ? BigDecimal.ZERO : this.debit;
    }

    public void setDebit(BigDecimal debit) {
        this.debit = debit;
    }

    public BigDecimal getCredit() {
        return this.credit == null ? BigDecimal.ZERO : this.credit;
    }

    public void setCredit(BigDecimal credit) {
        this.credit = credit;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public List<Reconcile> getDebitReconcileList() {
        return this.debitReconcileList;
    }

    public void setDebitReconcileList(List<Reconcile> debitReconcileList) {
        this.debitReconcileList = debitReconcileList;
    }

    public void addDebitReconcileListItem(Reconcile item) {
        if (this.getDebitReconcileList() == null) {
            this.setDebitReconcileList(new ArrayList());
        }
        this.getDebitReconcileList().add(item);
        item.setDebitMoveLine(this);
    }

    public void removeDebitReconcileListItem(Reconcile item) {
        if (this.getDebitReconcileList() == null) {
            return;
        }
        this.getDebitReconcileList().remove(item);
        item.setDebitMoveLine(null);
    }

    public void clearDebitReconcileList() {
        if (this.getDebitReconcileList() != null) {
            for (Reconcile item : this.getDebitReconcileList()) {
                item.setDebitMoveLine(null);
            }
            this.getDebitReconcileList().clear();
        }
    }

    public List<Reconcile> getCreditReconcileList() {
        return this.creditReconcileList;
    }

    public void setCreditReconcileList(List<Reconcile> creditReconcileList) {
        this.creditReconcileList = creditReconcileList;
    }

    public void addCreditReconcileListItem(Reconcile item) {
        if (this.getCreditReconcileList() == null) {
            this.setCreditReconcileList(new ArrayList());
        }
        this.getCreditReconcileList().add(item);
        item.setCreditMoveLine(this);
    }

    public void removeCreditReconcileListItem(Reconcile item) {
        if (this.getCreditReconcileList() == null) {
            return;
        }
        this.getCreditReconcileList().remove(item);
        item.setCreditMoveLine(null);
    }

    public void clearCreditReconcileList() {
        if (this.getCreditReconcileList() != null) {
            for (Reconcile item : this.getCreditReconcileList()) {
                item.setCreditMoveLine(null);
            }
            this.getCreditReconcileList().clear();
        }
    }

    public BigDecimal getAmountPaid() {
        return this.amountPaid == null ? BigDecimal.ZERO : this.amountPaid;
    }

    public void setAmountPaid(BigDecimal amountPaid) {
        this.amountPaid = amountPaid;
    }

    public Invoice getInvoiceReject() {
        return this.invoiceReject;
    }

    public void setInvoiceReject(Invoice invoiceReject) {
        this.invoiceReject = invoiceReject;
    }

    public Boolean getExportedDirectDebitOk() {
        return this.exportedDirectDebitOk == null ? Boolean.FALSE : this.exportedDirectDebitOk;
    }

    public void setExportedDirectDebitOk(Boolean exportedDirectDebitOk) {
        this.exportedDirectDebitOk = exportedDirectDebitOk;
    }

    public InterbankCodeLine getInterbankCodeLine() {
        return this.interbankCodeLine;
    }

    public void setInterbankCodeLine(InterbankCodeLine interbankCodeLine) {
        this.interbankCodeLine = interbankCodeLine;
    }

    public Integer getReimbursementStatusSelect() {
        return this.reimbursementStatusSelect == null ? 0 : this.reimbursementStatusSelect;
    }

    public void setReimbursementStatusSelect(Integer reimbursementStatusSelect) {
        this.reimbursementStatusSelect = reimbursementStatusSelect;
    }

    public String getPassageReason() {
        return this.passageReason;
    }

    public void setPassageReason(String passageReason) {
        this.passageReason = passageReason;
    }

    public Boolean getUsherPassageOk() {
        return this.usherPassageOk == null ? Boolean.FALSE : this.usherPassageOk;
    }

    public void setUsherPassageOk(Boolean usherPassageOk) {
        this.usherPassageOk = usherPassageOk;
    }

    public TaxLine getTaxLine() {
        return this.taxLine;
    }

    public void setTaxLine(TaxLine taxLine) {
        this.taxLine = taxLine;
    }

    public TaxLine getTaxLineBeforeReverse() {
        return this.taxLineBeforeReverse;
    }

    public void setTaxLineBeforeReverse(TaxLine taxLineBeforeReverse) {
        this.taxLineBeforeReverse = taxLineBeforeReverse;
    }

    public TaxLine getSourceTaxLine() {
        return this.sourceTaxLine;
    }

    public void setSourceTaxLine(TaxLine sourceTaxLine) {
        this.sourceTaxLine = sourceTaxLine;
    }

    public TaxEquiv getTaxEquiv() {
        return this.taxEquiv;
    }

    public void setTaxEquiv(TaxEquiv taxEquiv) {
        this.taxEquiv = taxEquiv;
    }

    public BigDecimal getCurrencyRate() {
        return this.currencyRate == null ? BigDecimal.ZERO : this.currencyRate;
    }

    public void setCurrencyRate(BigDecimal currencyRate) {
        this.currencyRate = currencyRate;
    }

    public BigDecimal getCurrencyAmount() {
        return this.currencyAmount == null ? BigDecimal.ZERO : this.currencyAmount;
    }

    public void setCurrencyAmount(BigDecimal currencyAmount) {
        this.currencyAmount = currencyAmount;
    }

    public String getPostedNbr() {
        return this.postedNbr;
    }

    public void setPostedNbr(String postedNbr) {
        this.postedNbr = postedNbr;
    }

    public FixedAssetCategory getFixedAssetCategory() {
        return this.fixedAssetCategory;
    }

    public void setFixedAssetCategory(FixedAssetCategory fixedAssetCategory) {
        this.fixedAssetCategory = fixedAssetCategory;
    }

    public BigDecimal getMaxAmountToReconcile() {
        return this.maxAmountToReconcile == null ? BigDecimal.ZERO : this.maxAmountToReconcile;
    }

    public void setMaxAmountToReconcile(BigDecimal maxAmountToReconcile) {
        this.maxAmountToReconcile = maxAmountToReconcile;
    }

    public PaymentScheduleLine getPaymentScheduleLine() {
        return this.paymentScheduleLine;
    }

    public void setPaymentScheduleLine(PaymentScheduleLine paymentScheduleLine) {
        this.paymentScheduleLine = paymentScheduleLine;
    }

    public BigDecimal getAmountExportedInDirectDebit() {
        return this.amountExportedInDirectDebit == null ? BigDecimal.ZERO : this.amountExportedInDirectDebit;
    }

    public void setAmountExportedInDirectDebit(BigDecimal amountExportedInDirectDebit) {
        this.amountExportedInDirectDebit = amountExportedInDirectDebit;
    }

    public AccountClearance getAccountClearance() {
        return this.accountClearance;
    }

    public void setAccountClearance(AccountClearance accountClearance) {
        this.accountClearance = accountClearance;
    }

    public Integer getIrrecoverableStatusSelect() {
        return this.irrecoverableStatusSelect == null ? 0 : this.irrecoverableStatusSelect;
    }

    public void setIrrecoverableStatusSelect(Integer irrecoverableStatusSelect) {
        this.irrecoverableStatusSelect = irrecoverableStatusSelect;
    }

    public ManagementObject getManagementObject() {
        return this.managementObject;
    }

    public void setManagementObject(ManagementObject managementObject) {
        this.managementObject = managementObject;
    }

    public List<AnalyticMoveLine> getAnalyticMoveLineList() {
        return this.analyticMoveLineList;
    }

    public void setAnalyticMoveLineList(List<AnalyticMoveLine> analyticMoveLineList) {
        this.analyticMoveLineList = analyticMoveLineList;
    }

    public void addAnalyticMoveLineListItem(AnalyticMoveLine item) {
        if (this.getAnalyticMoveLineList() == null) {
            this.setAnalyticMoveLineList(new ArrayList());
        }
        this.getAnalyticMoveLineList().add(item);
        item.setMoveLine(this);
    }

    public void removeAnalyticMoveLineListItem(AnalyticMoveLine item) {
        if (this.getAnalyticMoveLineList() == null) {
            return;
        }
        this.getAnalyticMoveLineList().remove(item);
    }

    public void clearAnalyticMoveLineList() {
        if (this.getAnalyticMoveLineList() != null) {
            this.getAnalyticMoveLineList().clear();
        }
    }

    public AnalyticDistributionTemplate getAnalyticDistributionTemplate() {
        return this.analyticDistributionTemplate;
    }

    public void setAnalyticDistributionTemplate(AnalyticDistributionTemplate analyticDistributionTemplate) {
        this.analyticDistributionTemplate = analyticDistributionTemplate;
    }

    public Boolean getIsOtherCurrency() {
        return this.isOtherCurrency == null ? Boolean.FALSE : this.isOtherCurrency;
    }

    public void setIsOtherCurrency(Boolean isOtherCurrency) {
        this.isOtherCurrency = isOtherCurrency;
    }

    public String getAccountCode() {
        return this.accountCode;
    }

    public void setAccountCode(String accountCode) {
        this.accountCode = accountCode;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getPartnerFullName() {
        return this.partnerFullName;
    }

    public void setPartnerFullName(String partnerFullName) {
        this.partnerFullName = partnerFullName;
    }

    public String getPartnerSeq() {
        return this.partnerSeq;
    }

    public void setPartnerSeq(String partnerSeq) {
        this.partnerSeq = partnerSeq;
    }

    public Long getPartnerId() {
        return this.partnerId == null ? 0L : this.partnerId;
    }

    public void setPartnerId(Long partnerId) {
        this.partnerId = partnerId;
    }

    public Long getAccountId() {
        return this.accountId == null ? 0L : this.accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public BigDecimal getTaxRate() {
        return this.taxRate == null ? BigDecimal.ZERO : this.taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public String getTaxCode() {
        return this.taxCode;
    }

    public void setTaxCode(String taxCode) {
        this.taxCode = taxCode;
    }

    public Boolean getIsSelectedBankReconciliation() {
        return this.isSelectedBankReconciliation == null ? Boolean.FALSE : this.isSelectedBankReconciliation;
    }

    public void setIsSelectedBankReconciliation(Boolean isSelectedBankReconciliation) {
        this.isSelectedBankReconciliation = isSelectedBankReconciliation;
    }

    public BigDecimal getTaxAmount() {
        return this.taxAmount == null ? BigDecimal.ZERO : this.taxAmount;
    }

    public void setTaxAmount(BigDecimal taxAmount) {
        this.taxAmount = taxAmount;
    }

    public List<TaxPaymentMoveLine> getTaxPaymentMoveLineList() {
        return this.taxPaymentMoveLineList;
    }

    public void setTaxPaymentMoveLineList(List<TaxPaymentMoveLine> taxPaymentMoveLineList) {
        this.taxPaymentMoveLineList = taxPaymentMoveLineList;
    }

    public void addTaxPaymentMoveLineListItem(TaxPaymentMoveLine item) {
        if (this.getTaxPaymentMoveLineList() == null) {
            this.setTaxPaymentMoveLineList(new ArrayList());
        }
        this.getTaxPaymentMoveLineList().add(item);
        item.setMoveLine(this);
    }

    public void removeTaxPaymentMoveLineListItem(TaxPaymentMoveLine item) {
        if (this.getTaxPaymentMoveLineList() == null) {
            return;
        }
        this.getTaxPaymentMoveLineList().remove(item);
    }

    public void clearTaxPaymentMoveLineList() {
        if (this.getTaxPaymentMoveLineList() != null) {
            this.getTaxPaymentMoveLineList().clear();
        }
    }

    public ReconcileGroup getReconcileGroup() {
        return this.reconcileGroup;
    }

    public void setReconcileGroup(ReconcileGroup reconcileGroup) {
        this.reconcileGroup = reconcileGroup;
    }

    public LocalDate getOriginDate() {
        return this.originDate;
    }

    public void setOriginDate(LocalDate originDate) {
        this.originDate = originDate;
    }

    public List<InvoiceTerm> getInvoiceTermList() {
        return this.invoiceTermList;
    }

    public void setInvoiceTermList(List<InvoiceTerm> invoiceTermList) {
        this.invoiceTermList = invoiceTermList;
    }

    public void addInvoiceTermListItem(InvoiceTerm item) {
        if (this.getInvoiceTermList() == null) {
            this.setInvoiceTermList(new ArrayList());
        }
        this.getInvoiceTermList().add(item);
        item.setMoveLine(this);
    }

    public void removeInvoiceTermListItem(InvoiceTerm item) {
        if (this.getInvoiceTermList() == null) {
            return;
        }
        this.getInvoiceTermList().remove(item);
    }

    public void clearInvoiceTermList() {
        if (this.getInvoiceTermList() != null) {
            this.getInvoiceTermList().clear();
        }
    }

    public String getName() {
        try {
            this.name = this.computeName();
        }
        catch (NullPointerException e) {
            Logger logger = LoggerFactory.getLogger(this.getClass());
            logger.error("NPE in function field: getName()", (Throwable)e);
        }
        return this.name;
    }

    protected String computeName() {
        if (this.move != null && this.move.getReference() != null) {
            return this.move.getReference() + "-" + Integer.toString(this.counter);
        }
        return Integer.toString(this.counter);
    }

    public void setName(String name) {
        this.name = name;
    }

    public BigDecimal getAmountRemaining() {
        try {
            this.amountRemaining = this.computeAmountRemaining();
        }
        catch (NullPointerException e) {
            Logger logger = LoggerFactory.getLogger(this.getClass());
            logger.error("NPE in function field: getAmountRemaining()", (Throwable)e);
        }
        return this.amountRemaining;
    }

    protected BigDecimal computeAmountRemaining() {
        if (this.account != null && this.account.getReconcileOk().booleanValue()) {
            if (this.credit.signum() > 0) {
                return this.credit.subtract(this.amountPaid);
            }
            if (this.debit.signum() > 0) {
                return this.debit.subtract(this.amountPaid);
            }
        }
        return BigDecimal.ZERO;
    }

    public void setAmountRemaining(BigDecimal amountRemaining) {
        this.amountRemaining = amountRemaining;
    }

    public BigDecimal getLineAmount() {
        try {
            this.lineAmount = this.computeLineAmount();
        }
        catch (NullPointerException e) {
            Logger logger = LoggerFactory.getLogger(this.getClass());
            logger.error("NPE in function field: getLineAmount()", (Throwable)e);
        }
        return this.lineAmount;
    }

    protected BigDecimal computeLineAmount() {
        if (this.credit != null && this.credit.signum() > 0) {
            return this.credit;
        }
        if (this.debit != null && this.debit.signum() > 0) {
            return this.debit;
        }
        return BigDecimal.ZERO;
    }

    public void setLineAmount(BigDecimal lineAmount) {
        this.lineAmount = lineAmount;
    }

    public AnalyticAccount getAxis1AnalyticAccount() {
        return this.axis1AnalyticAccount;
    }

    public void setAxis1AnalyticAccount(AnalyticAccount axis1AnalyticAccount) {
        this.axis1AnalyticAccount = axis1AnalyticAccount;
    }

    public AnalyticAccount getAxis2AnalyticAccount() {
        return this.axis2AnalyticAccount;
    }

    public void setAxis2AnalyticAccount(AnalyticAccount axis2AnalyticAccount) {
        this.axis2AnalyticAccount = axis2AnalyticAccount;
    }

    public AnalyticAccount getAxis3AnalyticAccount() {
        return this.axis3AnalyticAccount;
    }

    public void setAxis3AnalyticAccount(AnalyticAccount axis3AnalyticAccount) {
        this.axis3AnalyticAccount = axis3AnalyticAccount;
    }

    public AnalyticAccount getAxis4AnalyticAccount() {
        return this.axis4AnalyticAccount;
    }

    public void setAxis4AnalyticAccount(AnalyticAccount axis4AnalyticAccount) {
        this.axis4AnalyticAccount = axis4AnalyticAccount;
    }

    public AnalyticAccount getAxis5AnalyticAccount() {
        return this.axis5AnalyticAccount;
    }

    public void setAxis5AnalyticAccount(AnalyticAccount axis5AnalyticAccount) {
        this.axis5AnalyticAccount = axis5AnalyticAccount;
    }

    public Integer getVatSystemSelect() {
        return this.vatSystemSelect == null ? 0 : this.vatSystemSelect;
    }

    public void setVatSystemSelect(Integer vatSystemSelect) {
        this.vatSystemSelect = vatSystemSelect;
    }

    public FinancialDiscount getFinancialDiscount() {
        return this.financialDiscount;
    }

    public void setFinancialDiscount(FinancialDiscount financialDiscount) {
        this.financialDiscount = financialDiscount;
    }

    public BigDecimal getFinancialDiscountRate() {
        return this.financialDiscountRate == null ? BigDecimal.ZERO : this.financialDiscountRate;
    }

    public void setFinancialDiscountRate(BigDecimal financialDiscountRate) {
        this.financialDiscountRate = financialDiscountRate;
    }

    public BigDecimal getFinancialDiscountTotalAmount() {
        return this.financialDiscountTotalAmount == null ? BigDecimal.ZERO : this.financialDiscountTotalAmount;
    }

    public void setFinancialDiscountTotalAmount(BigDecimal financialDiscountTotalAmount) {
        this.financialDiscountTotalAmount = financialDiscountTotalAmount;
    }

    public BigDecimal getRemainingAmountAfterFinDiscount() {
        return this.remainingAmountAfterFinDiscount == null ? BigDecimal.ZERO : this.remainingAmountAfterFinDiscount;
    }

    public void setRemainingAmountAfterFinDiscount(BigDecimal remainingAmountAfterFinDiscount) {
        this.remainingAmountAfterFinDiscount = remainingAmountAfterFinDiscount;
    }

    public String getCompanyCode() {
        return this.companyCode;
    }

    public void setCompanyCode(String companyCode) {
        this.companyCode = companyCode;
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getJournalCode() {
        return this.journalCode;
    }

    public void setJournalCode(String journalCode) {
        this.journalCode = journalCode;
    }

    public String getJournalName() {
        return this.journalName;
    }

    public void setJournalName(String journalName) {
        this.journalName = journalName;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public String getCompanyCurrencyCode() {
        return this.companyCurrencyCode;
    }

    public void setCompanyCurrencyCode(String companyCurrencyCode) {
        this.companyCurrencyCode = companyCurrencyCode;
    }

    public String getFiscalYearCode() {
        return this.fiscalYearCode;
    }

    public void setFiscalYearCode(String fiscalYearCode) {
        this.fiscalYearCode = fiscalYearCode;
    }

    public LocalDate getAccountingDate() {
        return this.accountingDate;
    }

    public void setAccountingDate(LocalDate accountingDate) {
        this.accountingDate = accountingDate;
    }

    public Boolean getAdjustingMove() {
        return this.adjustingMove == null ? Boolean.FALSE : this.adjustingMove;
    }

    public void setAdjustingMove(Boolean adjustingMove) {
        this.adjustingMove = adjustingMove;
    }

    public BigDecimal getBankReconciledAmount() {
        return this.bankReconciledAmount == null ? BigDecimal.ZERO : this.bankReconciledAmount;
    }

    public void setBankReconciledAmount(BigDecimal bankReconciledAmount) {
        this.bankReconciledAmount = bankReconciledAmount;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MoveLine)) {
            return false;
        }
        MoveLine other = (MoveLine)obj;
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("date", (Object)this.getDate()).add("dueDate", (Object)this.getDueDate()).add("cutOffStartDate", (Object)this.getCutOffStartDate()).add("cutOffEndDate", (Object)this.getCutOffEndDate()).add("isCutOffGenerated", (Object)this.getIsCutOffGenerated()).add("counter", (Object)this.getCounter()).add("debit", (Object)this.getDebit()).add("credit", (Object)this.getCredit()).add("description", (Object)this.getDescription()).add("origin", (Object)this.getOrigin()).add("amountPaid", (Object)this.getAmountPaid()).omitNullValues().toString();
    }
}

